/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.model.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.pojo.NumberTipTypeEnum;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class DimMemberNumberUtil {
    public static String getCodeNumber(IModelCacheHelper modelCacheHelper, String dimnumber, DynamicObject parent, boolean onlyRead) {
        Dimension dimension = modelCacheHelper.getDimension(dimnumber);
        if (dimension == null) {
            return null;
        }
        String entityId = dimension.getMemberModel();
        if (StringUtils.isEmpty((String)entityId)) {
            return null;
        }
        DynamicObject memberDy = BusinessDataServiceHelper.newDynamicObject((String)entityId);
        DynamicObject dimensionDy = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        dimensionDy.set("number", (Object)dimnumber);
        dimensionDy.set("name", (Object)dimension.getName());
        memberDy.set("dimension", (Object)dimensionDy);
        DynamicObject modelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)modelCacheHelper.getModelobj().getId(), (String)"epm_model");
        memberDy.set("model", (Object)modelDy);
        if (parent == null) {
            memberDy.set("parent", (Object)0);
        } else {
            parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (String)entityId);
            memberDy.set("parent", (Object)parent);
        }
        DynamicObject creatorDy = BusinessDataServiceHelper.loadSingleFromCache((Object)UserUtils.getUserId(), (String)"bos_user");
        memberDy.set("creator", (Object)creatorDy);
        String number = null;
        if (onlyRead) {
            number = CodeRuleServiceHelper.readNumber((String)entityId, (DynamicObject)memberDy, null);
        } else {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)modelCacheHelper.getModelobj().getId());
            builder.add("dimension", "=", (Object)dimension.getId());
            DynamicObjectCollection members = QueryServiceHelper.query((String)entityId, (String)"id,number", (QFilter[])builder.toArray());
            for (int count = 0; !(number != null && DimMemberNumberUtil.checkNumberOnly(members, number) || count >= 10000 || (number = CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)memberDy, null)) == null); ++count) {
            }
        }
        return number;
    }

    private static boolean checkNumberOnly(DynamicObjectCollection members, String newNumber) {
        for (DynamicObject dy : members) {
            if (!newNumber.equalsIgnoreCase(dy.getString("number"))) continue;
            return false;
        }
        return true;
    }

    public static String doCheck(String newnumber) {
        if (!NumberCheckUtils.checkNumber((String)newnumber) || newnumber.equalsIgnoreCase("other") || newnumber.equalsIgnoreCase("all") || newnumber.equalsIgnoreCase("none") || newnumber.equalsIgnoreCase("null")) {
            StringBuilder msgSb = new StringBuilder();
            msgSb.append(newnumber);
            msgSb.append(":");
            msgSb.append(NumberCheckUtils.getNumberTipString((NumberTipTypeEnum)NumberTipTypeEnum.CODE, (Boolean)false, (Boolean)false));
            return msgSb.toString();
        }
        return null;
    }
}

