/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.model.utils;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.enums.FyEnum;
import kd.epm.eb.common.enums.OrgBizChangeTypeEnum;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.model.serviceHelper.TreeStructureServiceHelper;

public class EntityVersioningUtil {
    private static int FROM_COMMON = 1;
    private static int FROM_REPORT = 2;
    private static int FROM_CHECK = 3;
    private static int FROM_TASK = 4;

    private static DynamicObjectCollection queryFYFirstDay(long modelId) {
        String selectFields = "startfy,beginyearofmonth,beginperiod";
        QFilter filter1 = new QFilter("id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_model", (String)selectFields, (QFilter[])filters, (String)"");
        return dcs;
    }

    public static String checkModelDate(long modelId, Date date) {
        DynamicObjectCollection dcs = EntityVersioningUtil.queryFYFirstDay(modelId);
        if (dcs != null && dcs.size() == 1) {
            String startfy = ((DynamicObject)dcs.get(0)).getString("startfy");
            String beginyearofmonth = ((DynamicObject)dcs.get(0)).getString("beginyearofmonth");
            String beginperiod = ((DynamicObject)dcs.get(0)).getString("beginperiod");
            int fyyear = Integer.parseInt(startfy) + 1996;
            int fymonth = Integer.parseInt(beginperiod);
            if (FyEnum.PRE.getIndex().equals(beginyearofmonth)) {
                --fyyear;
            }
            LocalDate ld = LocalDate.of(fyyear, fymonth, 1);
            ZoneId zd = ZoneId.systemDefault();
            ZonedDateTime zdt = ld.atStartOfDay(zd);
            Date modelEffDate = Date.from(zdt.toInstant());
            if (date == null || date.compareTo(modelEffDate) < 0) {
                String strfymonth = "";
                strfymonth = fymonth < 10 ? "0" + fymonth : String.valueOf(fymonth);
                return ResManager.loadResFormat((String)"\u751f\u6548\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u4e0d\u53ef\u65e9\u4e8e%1-%2-01\u3002", (String)"EntityVersioningUtil_0", (String)"epm-eb-business", (Object[])new Object[]{fyyear, strfymonth});
            }
        }
        return "";
    }

    public static Date getModelBeginDate(Object modelId) {
        QFilter qModel = new QFilter("id", "=", (Object)Long.valueOf(modelId.toString()));
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"number,startfy,beginperiod,beginyearofmonth", (QFilter[])new QFilter[]{qModel});
        return EntityVersioningUtil.getModelBeginDate(model);
    }

    private static Date getModelBeginDate(DynamicObject model) {
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u4f53\u7cfb\u3002", (String)"EntityVersioningUtil_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        int firstYear = model.getInt("startfy") + 1997 - 1;
        int firstMonth = model.getInt("beginperiod");
        String beginYearType = model.getString("beginyearofmonth");
        if (FyEnum.PRE.getIndex().equals(beginYearType)) {
            --firstYear;
        }
        String dateStr = String.valueOf(firstYear).concat("-").concat(String.valueOf(firstMonth)).concat("-01");
        Date date = null;
        try {
            date = new CalendarHelper().parseDate(dateStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static void filterVersionOrgTree(DynamicObjectCollection orgTree, Long modelId, String yearNum, Long periodId) {
        EntityVersioningUtil.filterOrgsByVersion((List<DynamicObject>)orgTree, modelId, yearNum, periodId, EntityVersioningUtil.getOrgChangeRecords((List<DynamicObject>)orgTree, FROM_COMMON), FROM_COMMON);
    }

    private static DynamicObjectCollection getOrgChangeRecords(List<DynamicObject> orgs, int from) {
        HashSet<Long> set = new HashSet<Long>();
        for (int i = 0; i < orgs.size(); ++i) {
            if (from == FROM_COMMON) {
                set.add(orgs.get(i).getLong("id"));
                continue;
            }
            if (from == FROM_REPORT) {
                set.add(orgs.get(i).getLong("entity.id"));
                continue;
            }
            if (from == FROM_CHECK) {
                set.add(orgs.get(i).getLong("org.id"));
                continue;
            }
            if (from != FROM_TASK) continue;
            set.add(orgs.get(i).getLong("entity"));
        }
        QFilter qcs = new QFilter("id", "in", (Object)set.toArray());
        DynamicObjectCollection allData = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,name,number,isleaf,longNumber,bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate, namechangerds.namerds,namechangerds.nameeffdate,namechangerds.nameexpdate", (QFilter[])new QFilter[]{qcs}, (String)"dseq, bizchangerds.seq, namechangerds.seq");
        return allData;
    }

    private static void filterOrgsByVersion(List<DynamicObject> doc, Long modelId, String yearNum, Long periodId, DynamicObjectCollection allData, int from) {
        DynamicObject modelDo = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id, beginyearofmonth", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        DynamicObject periodDo = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (String)"id, effmonth, effday, expmonth, expday", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)});
        Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, yearNum, periodDo);
        Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo);
        if (firstDate == null || lastDate == null) {
            return;
        }
        HashMap<Long, String> map = new HashMap<Long, String>();
        HashSet<Long> exist = new HashSet<Long>();
        HashSet<Long> toDel = new HashSet<Long>();
        CalendarHelper cal = new CalendarHelper();
        for (DynamicObject tmp2 : allData) {
            String name = tmp2.getString("namechangerds.namerds");
            Date bizeffdate = tmp2.getDate("bizchangerds.bizeffdate");
            if (bizeffdate == null || name == null) {
                exist.add(tmp2.getLong("id"));
                continue;
            }
            if (exist.contains(tmp2.getLong("id")) || toDel.contains(tmp2.getLong("id"))) continue;
            Date bizexpdate = tmp2.getDate("bizchangerds.bizexpdate");
            Date nameeffdate = tmp2.getDate("namechangerds.nameeffdate");
            Date nameexpdate = tmp2.getDate("namechangerds.nameexpdate");
            if (bizeffdate.compareTo(lastDate) > 0 || bizexpdate != null && bizexpdate.compareTo(lastDate) < 0) continue;
            if ((tmp2.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || tmp2.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue())) && cal.getCurrentlyYear(firstDate) - cal.getCurrentlyYear(bizeffdate) > 0) {
                toDel.add(tmp2.getLong("id"));
                continue;
            }
            if (nameeffdate.compareTo(lastDate) > 0 || nameexpdate != null && nameexpdate.compareTo(lastDate) < 0) continue;
            exist.add(tmp2.getLong("id"));
            map.put(tmp2.getLong("id"), name);
        }
        HashSet toDelInNotLeafLongNumbers = new HashSet(16);
        Map<Long, IDNumberTreeNode> nodeMap = TreeStructureServiceHelper.getAllNode("epm_entitymembertree", modelId);
        allData.forEach(tmp -> {
            Long orgId = tmp.getLong("id");
            String longNumber = tmp.getString("longNumber");
            if (!(!toDel.contains(orgId) && exist.contains(orgId) || tmp.getBoolean("isleaf"))) {
                toDelInNotLeafLongNumbers.add(longNumber);
                IDNumberTreeNode node = (IDNumberTreeNode)nodeMap.get(tmp.getLong("id"));
                if (node != null) {
                    toDel.addAll(TreeStructureServiceHelper.getIds(node.getAllChildren()));
                }
            }
        });
        doc.removeIf(o -> {
            Long orgId = null;
            if (from == FROM_COMMON) {
                orgId = o.getLong("id");
            } else if (from == FROM_REPORT) {
                orgId = o.getLong("entity.id");
            } else if (from == FROM_CHECK) {
                orgId = o.getLong("org.id");
            } else if (from == FROM_TASK) {
                orgId = o.getLong("entity");
            }
            return toDel.contains(orgId) || !exist.contains(orgId);
        });
        if (doc.size() == 0) {
            return;
        }
        DataEntityPropertyCollection properties = doc.get(0).getDataEntityType().getProperties();
        if (!(properties.containsKey((Object)"name") || properties.containsKey((Object)"entity") || properties.containsKey((Object)"org"))) {
            return;
        }
        doc.forEach(o -> {
            if (from == FROM_COMMON) {
                if (!"Entity".equals(o.getString("number")) && map.get(o.getLong("id")) != null) {
                    o.set("name", map.get(o.getLong("id")));
                }
            } else if (from == FROM_REPORT) {
                if (map.get(o.getLong("entity.id")) != null) {
                    o.set("entity.name", map.get(o.getLong("entity.id")));
                }
            } else if (from == FROM_CHECK) {
                if (map.get(o.getLong("org.id")) != null) {
                    o.set("org.name", map.get(o.getLong("org.id")));
                }
            } else if (from == FROM_TASK && map.get(o.getLong("entity")) != null) {
                o.set("entity.name", map.get(o.getLong("entity")));
            }
        });
    }

    private static Date getFilterDay(boolean isFirst, DynamicObject modelDo, String yearNum, DynamicObject periodDo) {
        int year = 0;
        try {
            year = Integer.parseInt(yearNum.substring(2));
        }
        catch (Exception e) {
            return null;
        }
        String beginyearofmonth = modelDo.getString("beginyearofmonth");
        if (FyEnum.PRE.getIndex().equals(beginyearofmonth)) {
            --year;
        }
        int month = 0;
        int day = 0;
        try {
            if (isFirst) {
                month = periodDo.getInt("effmonth");
                day = periodDo.getInt("effday");
            } else {
                month = periodDo.getInt("expmonth");
                day = periodDo.getInt("expday");
            }
        }
        catch (Exception e) {
            return null;
        }
        String dateStr = String.valueOf(year).concat("-").concat(month < 10 ? "0" + month : String.valueOf(month)).concat("-").concat(day < 10 ? "0" + day : String.valueOf(day));
        CalendarHelper cal = new CalendarHelper();
        try {
            return cal.parseDate(dateStr);
        }
        catch (ParseException e) {
            if (day == 29) {
                dateStr = String.valueOf(year).concat("-").concat(month < 10 ? "0" + month : String.valueOf(month)).concat("-").concat(day < 10 ? "0" + day : String.valueOf(--day));
            }
            try {
                return cal.parseDate(dateStr);
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }
}

