/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.model.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.commons.collections.CollectionUtils;

public class ModelUtil {
    public static ApplicationTypeEnum queryApp(IFormView view) {
        String appnumber = view.getFormShowParameter().getAppId();
        return ApplicationTypeEnum.getEnumByNumber((String)appnumber, (IFormView)view);
    }

    public static String getOtherAppNum(IFormView view) {
        String appNum = view.getFormShowParameter().getAppId();
        if (appNum.length() > 4) {
            appNum = appNum.substring(0, 4);
        }
        return appNum;
    }

    public static List<QFilter> getModelFilter(IFormView view) {
        return ModelUtil.getModelFilter(view, false);
    }

    public static Set<Long> getModelIds(IFormView view, boolean onlyManager) {
        Set<Long> ids = Sets.newLinkedHashSet();
        if (view.getParentView() != null && "epm_user_assignperm".equals(view.getParentView().getEntityId())) {
            ids = ModelServiceHelper.getLimitedModelListByUser(null);
        } else {
            String source = view.getEntityId();
            if (view instanceof ListView && "bos_list".equals(source)) {
                source = ((ListView)view).getBillFormId();
            } else if (view instanceof ListView && "bos_templatetreelist".equals(source)) {
                source = ((ListView)view).getBillFormId();
            } else if (view instanceof ListView && "bos_treelist".equals(source)) {
                source = ((ListView)view).getBillFormId();
            } else if (view instanceof ListView && "bgc_recipientmapboslist".equals(source)) {
                source = ((ListView)view).getBillFormId();
            } else if (view instanceof ListView && "eb_approvebill_newlist".equals(source)) {
                source = ((ListView)view).getBillFormId();
            }
            if ("eb_adddimmaterule".equals(source)) {
                source = "eb_dimmaterulelist";
            }
            ApplicationTypeEnum application = ModelUtil.queryApp(view);
            if (onlyManager) {
                Set<Long> manageModelIds = MemberPermHelper.getLimitedModelListByUser(application);
                ids.addAll(manageModelIds);
            } else {
                ids.addAll(ModelUtil.getModelIdsWithPerm(source, application));
            }
        }
        return ids;
    }

    public static Set<Long> getModelIdsWithPerm(String entityType, ApplicationTypeEnum application) {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        Set effectives = FunPermissionHelper.getEffectiveByPermModel((String)entityType, (ApplicationTypeEnum)application);
        Set<Long> manageModelIds = MemberPermHelper.getLimitedModelListByUser(application);
        Long userId = UserUtils.getUserId();
        Set perRoleIds = FunPermissionHelper.getRoleModel((Long)userId, (String)"epm_model", (ApplicationTypeEnum)application, (String)entityType, (String)"47150e89000000ac");
        ids.addAll(effectives);
        ids.addAll(manageModelIds);
        ids.addAll(perRoleIds);
        return ids;
    }

    public static Set<Long> getModelIdsWithPermItem(String entityType, ApplicationTypeEnum application, String permItemId) {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        Set effectives = FunPermissionHelper.getEffectiveByPermItemModel((String)entityType, (ApplicationTypeEnum)application, (String)permItemId);
        Set<Long> manageModelIds = MemberPermHelper.getLimitedModelListByUser();
        Long userId = UserUtils.getUserId();
        Set perRoleIds = FunPermissionHelper.getRoleModel((Long)userId, (String)"epm_model", (ApplicationTypeEnum)application, (String)entityType, (String)permItemId);
        ids.addAll(effectives);
        ids.addAll(manageModelIds);
        ids.addAll(perRoleIds);
        return ids;
    }

    public static List<QFilter> getModelFilter(IFormView view, boolean onlyManager) {
        QFilter qf = ModelUtil.getModelQfilterByApp(view);
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        modelQFilters.add(qf);
        Set<Long> ids = ModelUtil.getModelIds(view, onlyManager);
        modelQFilters.add(new QFilter("id", "in", ids));
        return modelQFilters;
    }

    public static QFilter getModelQfilterByApp(IFormView view) {
        ApplicationTypeEnum application = ModelUtil.queryApp(view);
        QFilter qcf = new QFilter("ReportType", "=", (Object)application.getIndex());
        switch (application) {
            case BGM: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getIndex());
                break;
            }
            case EB: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getIndex());
                break;
            }
            case BG: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BG.getIndex());
                break;
            }
            case BGC: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getIndex()).or("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getIndex()).or(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BG.getIndex()));
                break;
            }
            case BGBD: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getIndex()).or("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getIndex()).or("ReportType", "=", (Object)ApplicationTypeEnum.BG.getIndex());
                break;
            }
            case BGRP: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getIndex()).or(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BG.getIndex()));
                break;
            }
        }
        return qcf;
    }

    public static boolean isBGModel(Long modelId) {
        if (modelId == 0L || modelId == null) {
            return false;
        }
        Model modelobj = ModelCacheContext.getOrCreate((Long)modelId).getModelobj();
        if (modelobj != null) {
            String reportType = modelobj.getReportType();
            return ApplicationTypeEnum.BG.getIndex().equals(reportType);
        }
        return false;
    }

    public static boolean isEbOrBgModel(Long modelId) {
        if (modelId == 0L) {
            return false;
        }
        Model modelobj = ModelCacheContext.getOrCreate((Long)modelId).getModelobj();
        if (modelobj != null) {
            String reportType = modelobj.getReportType();
            return ApplicationTypeEnum.BG.getIndex().equals(reportType) || ApplicationTypeEnum.EB.getIndex().equals(reportType);
        }
        return false;
    }

    public static boolean isEbModel(Long modelId) {
        if (modelId == 0L) {
            return false;
        }
        Model modelobj = ModelCacheContext.getOrCreate((Long)modelId).getModelobj();
        if (modelobj != null) {
            String reportType = modelobj.getReportType();
            return ApplicationTypeEnum.EB.getIndex().equals(reportType);
        }
        return false;
    }

    public static boolean isAllBGModel(List<Long> modelIds) {
        if (CollectionUtils.isEmpty(modelIds)) {
            return false;
        }
        boolean isAllBGModel = true;
        for (Long modelId : modelIds) {
            boolean bgModel = ModelUtil.isBGModel(modelId);
            if (bgModel) continue;
            isAllBGModel = false;
            break;
        }
        return isAllBGModel;
    }

    public static Long getDefaultModel(String entityId, ApplicationTypeEnum application) {
        Long modelId = 0L;
        Set modelIds = MemberPermHelper.getLimitedModelListByUser(application);
        if (modelIds.size() != 0) {
            modelId = modelIds.iterator().next();
        } else {
            modelIds = FunPermissionHelper.getEffectiveByPermModel((String)entityId, (ApplicationTypeEnum)application);
            if (modelIds.size() != 0) {
                modelId = (Long)modelIds.iterator().next();
            } else {
                modelIds = FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application, (String)entityId, (String)"47150e89000000ac");
                if (modelIds.size() != 0) {
                    modelId = (Long)modelIds.iterator().next();
                }
            }
        }
        return modelId;
    }

    public static void hideBussModelNameByEbOrBgModel(Set<String> colsToHide, Long modelId) {
        if (modelId == null || modelId == 0L) {
            return;
        }
        boolean modelByEB = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().isModelByEB();
        if (modelByEB || ModelUtil.isBGModel(modelId)) {
            colsToHide.add("bussmodel.name");
        }
    }

    public static Boolean isNewEb() {
        QFilter qFilter = new QFilter("ReportType", "=", (Object)"6");
        return QueryServiceHelper.exists((String)"epm_model", (QFilter[])new QFilter[]{qFilter});
    }
}

