/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.model.utils;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.model.UserSelectModel;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.UserSelectServiceHelperNew;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.utils.ModelUtil;

public class UserSelectUtil {
    public static final String model = "model";

    public static Long getF7SelectId(IFormView formView, String f7key) {
        Long f7SelectId = null;
        try {
            DynamicObject dynamicObject = (DynamicObject)formView.getModel().getValue(f7key);
            if (dynamicObject == null) {
                return null;
            }
            f7SelectId = dynamicObject.getLong("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f7SelectId;
    }

    public static Long getModelIdAfterCreateNewData(IFormView formView, String modelKey, boolean byForm) {
        return UserSelectUtil.saveUserSelectModel(formView, modelKey, byForm);
    }

    public static UserSelectModel getUserSelectAfterCreateNewData(IFormView formView, String modelKey, boolean byForm) {
        UserSelectModel userselect = UserSelectUtil.getUserSelectAfterCreateNewData(formView, byForm);
        if (userselect == null) {
            userselect = new UserSelectModel();
            userselect.setModel(UserSelectUtil.saveUserSelectModel(formView, modelKey, byForm));
        }
        return userselect;
    }

    private static Long saveUserSelectModel(IFormView formView, String modelKey, boolean byForm) {
        UserSelectModel userselect = UserSelectUtil.getUserSelectAfterCreateNewData(formView, byForm);
        if (userselect != null) {
            return userselect.getModel();
        }
        Long aLong = UserSelectUtil.selectUserRight(formView);
        if (aLong != 0L) {
            UserSelectUtil.saveUserSelectWhenModelChange(formView, aLong);
            return aLong;
        }
        if (formView.getModel().isInitialized()) {
            boolean modelFlag = formView.getModel().getDataEntity().getDynamicObjectType().getProperties().containsKey((Object)modelKey);
            if (!modelFlag) {
                return null;
            }
            Object obj = formView.getModel().getValue(modelKey);
            if (obj instanceof DynamicObject) {
                return UserSelectUtil.getF7SelectId(formView, modelKey);
            }
        }
        return null;
    }

    private static UserSelectModel getUserSelectAfterCreateNewData(IFormView formView, boolean byForm) {
        UserSelectModel userSelect = null;
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        if (!byForm) {
            userSelect = UserSelectServiceHelperNew.getUserSelect((Long)UserUtils.getUserId(), (String)"id,model,application,entity,period,currency,modifier,onlymodel,formid,date,version,bizmodel,modeltype", (ApplicationTypeEnum)application, (IFormView)formView);
        }
        return userSelect;
    }

    public static void saveUserSelectWhenBizModelChange(IFormView formView, Long modelId, Long bizModelId) {
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        UserSelectUtil.savetUserSelect(modelId, bizModelId, application, formView.getEntityId());
    }

    public static void saveUserSelectWhenModelChange(IFormView formView, Long modelId) {
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        UserSelectUtil.savetUserSelectOnlyModel(modelId, application, formView.getEntityId());
    }

    private static void savetUserSelect(Long modelId, Long bizModelId, ApplicationTypeEnum application, String entityId) {
        if (modelId == null || modelId == 0L) {
            return;
        }
        UserSelectModel userSelectModel = new UserSelectModel();
        userSelectModel.setModel(modelId);
        userSelectModel.setBizModelId(bizModelId);
        userSelectModel.setModifier(UserUtils.getUserId());
        userSelectModel.setApplication(application);
        userSelectModel.setFormid(entityId);
        userSelectModel.setDate(TimeServiceHelper.now());
        userSelectModel.setModelType(UserSelectUtil.getModelType(modelId));
        UserSelectServiceHelperNew.saveUserSelect((UserSelectModel)userSelectModel);
    }

    private static void savetUserSelectOnlyModel(Long modelId, ApplicationTypeEnum application, String entityId) {
        if (modelId == null || modelId == 0L) {
            return;
        }
        UserSelectModel userSelectModel = new UserSelectModel();
        userSelectModel.setModel(modelId);
        userSelectModel.setModifier(UserUtils.getUserId());
        userSelectModel.setApplication(application);
        userSelectModel.setOnlyModel(true);
        userSelectModel.setFormid(entityId);
        userSelectModel.setDate(TimeServiceHelper.now());
        userSelectModel.setModelType(UserSelectUtil.getModelType(modelId));
        UserSelectServiceHelperNew.saveUserSelect((UserSelectModel)userSelectModel);
    }

    private static String getModelType(Long modelId) {
        try {
            DynamicObject model_new = ModelUtils.getModel((Long)modelId);
            String reporttype = model_new.getString("reporttype");
            if (ApplicationTypeEnum.EB.getIndex().equals(reporttype)) {
                return ApplicationTypeEnum.EB.getAppnum();
            }
            return ApplicationTypeEnum.BGM.getAppnum();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Long selectUserRight(IFormView view) {
        return UserSelectServiceHelperNew.selectRight((IFormView)view);
    }

    public static UserSelectModel getUserSelect4PermForm(IFormView formView, String modelKey, boolean isDataPerm, boolean saveChanged) {
        Long bizCtrlRangeId;
        Long modelId;
        UserSelectModel selectModel = UserSelectUtil.getUserSelectAfterCreateNewData(formView, modelKey, false);
        if (selectModel == null) {
            selectModel = new UserSelectModel();
        }
        if ((modelId = selectModel.getModel()) == null) {
            modelId = 0L;
        }
        if ((bizCtrlRangeId = selectModel.getBizModelId()) == null) {
            bizCtrlRangeId = 0L;
        }
        Long _modelId = modelId;
        Long _bizCtrlRangeId = bizCtrlRangeId;
        Long currentUserId = UserUtils.getUserId();
        Set rootPermModels = ModelServiceHelper.getLimitedModelListByUser(null);
        if (!rootPermModels.contains(modelId)) {
            if (!isDataPerm) {
                modelId = rootPermModels.size() > 0 ? (Long)rootPermModels.iterator().next() : Long.valueOf(0L);
            } else {
                Set modelIdsOnGivePerm = MembPermRecordUtil.getModelIdsOnGivePerm((Long)currentUserId);
                if (!modelIdsOnGivePerm.contains(modelId)) {
                    modelId = 0L;
                    if (rootPermModels.size() > 0) {
                        modelId = (Long)rootPermModels.iterator().next();
                    } else if (modelIdsOnGivePerm.size() > 0) {
                        modelId = (Long)modelIdsOnGivePerm.iterator().next();
                    }
                }
            }
        }
        if (modelId != 0L) {
            if (rootPermModels.contains(modelId)) {
                List busModelIds = BusinessModelServiceHelper.getInstance().getBusModelIdsByModelId(modelId);
                if (busModelIds == null || busModelIds.isEmpty()) {
                    bizCtrlRangeId = 0L;
                } else if (!busModelIds.contains(bizCtrlRangeId)) {
                    bizCtrlRangeId = (Long)busModelIds.get(0);
                }
            } else {
                Set bcrIdsOnGivePerm = MembPermRecordUtil.getBCRIdsOnGivePerm((Long)modelId, (Long)currentUserId);
                if (!bcrIdsOnGivePerm.contains(bizCtrlRangeId)) {
                    bizCtrlRangeId = 0L;
                    if (bcrIdsOnGivePerm.size() > 0) {
                        bizCtrlRangeId = (Long)bcrIdsOnGivePerm.iterator().next();
                    }
                }
            }
        } else {
            bizCtrlRangeId = 0L;
        }
        boolean bcrChanged = !_bizCtrlRangeId.equals(bizCtrlRangeId);
        boolean modelChanged = !_modelId.equals(modelId);
        selectModel.setModel(modelId);
        selectModel.setBizModelId(bizCtrlRangeId);
        if (saveChanged && (modelChanged || bcrChanged)) {
            UserSelectUtil.saveUserSelectWhenBizModelChange(formView, modelId, bizCtrlRangeId);
        }
        return selectModel;
    }
}

