/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.dataintegration.DataIntegrationStart;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQCondition;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.entity.ExecuteCondition;
import kd.epm.eb.business.dataintegration.service.DataIntegrationService;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.utils.GlobalIdUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public interface DataIntegrationTaskBase {
    public static final Log log = LogFactory.getLog(DataIntegrationTaskBase.class);

    default public List<List<String>> getAllSchemeNumbers(Map<String, Object> paramMap) {
        ArrayList<List<String>> allNumbers = new ArrayList<List<String>>(16);
        Object numberInfo = paramMap.get("number");
        if (numberInfo instanceof String) {
            for (String numberPart : ((String)numberInfo).trim().split(",")) {
                allNumbers.add(Arrays.stream(numberPart.split("\\|")).collect(Collectors.toList()));
            }
        }
        return allNumbers;
    }

    default public Map<String, Long> getAllSchemeIds(List<List<String>> schemeNumbers, Map<String, Object> paramMap) {
        HashSet numbers = new HashSet(16);
        schemeNumbers.forEach(numbers::addAll);
        QFilter qFilter = new QFilter("number", "in", numbers);
        qFilter.and("type", "=", (Object)(this.isOutput() ? DataIntegrationType.OUTPUT.getVal() : DataIntegrationType.INPUT.getVal()));
        qFilter.and("status", "=", (Object)true);
        String modelNumber = MapUtils.getString(paramMap, (Object)"modelNumber");
        if (StringUtils.isNotBlank((CharSequence)modelNumber)) {
            DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray());
            if (model == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"DataIntegrationTaskBase_1", (String)"epm-eb-business", (Object[])new Object[]{modelNumber}));
            }
            qFilter.and("modelid", "=", (Object)model.getLong("id"));
        }
        HashMap<String, Long> result = new HashMap<String, Long>(numbers.size());
        DynamicObjectCollection diDy = QueryServiceHelper.query((String)this.getSchemeFormKey(), (String)"id,number", (QFilter[])qFilter.toArray());
        diDy.forEach(row -> result.put(row.getString("number"), row.getLong("id")));
        return result;
    }

    default public void execute(Map<String, Object> paramMap) {
        log.info("\u6570\u636e\u96c6\u6210\u91c7\u96c6\u5b9a\u65f6\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(paramMap));
        List<List<String>> allSchemeNumbers = this.getAllSchemeNumbers(paramMap);
        Map<String, Long> allSchemeIds = this.getAllSchemeIds(allSchemeNumbers, paramMap);
        ArrayList<Set<Long>> schemeIdsGroup = new ArrayList<Set<Long>>(16);
        Object doSynchronizedParam = paramMap.get("async");
        boolean async = "1".equals(doSynchronizedParam) || "true".equals(doSynchronizedParam) || doSynchronizedParam instanceof Boolean && (Boolean)doSynchronizedParam != false;
        allSchemeNumbers.forEach(numbers -> {
            HashSet ids = new HashSet(numbers.size());
            numbers.forEach(numb -> ids.add(allSchemeIds.get(numb)));
            if (ids.size() != numbers.size()) {
                ids.clear();
            }
            schemeIdsGroup.add(ids);
        });
        List<List<Long>> conditionIdsBySchemesGroup = EASDataIntegrationUtil.getConditionIdsBySchemesGroup(schemeIdsGroup);
        LinkedList<String> errorInfo = new LinkedList<String>();
        HashMap<Long, Map<String, Long>> schemeViewCache = new HashMap<Long, Map<String, Long>>(16);
        for (int index = 0; index < allSchemeNumbers.size(); ++index) {
            List<Long> conditionIds = conditionIdsBySchemesGroup.get(index);
            Set schemeIds = (Set)schemeIdsGroup.get(index);
            List<String> schemeNumbers = allSchemeNumbers.get(index);
            if (conditionIds.isEmpty()) {
                if (schemeIds.isEmpty()) {
                    errorInfo.add(ResManager.loadResFormat((String)"\u5206\u7ec4\u4e2d\u6709\u4e0d\u5b58\u5728\u7684\u6216\u672a\u542f\u7528\u7684\u65b9\u6848\uff1a%1", (String)"DataIntegrationTaskBase_2", (String)"epm-eb-business", (Object[])new Object[]{schemeNumbers}));
                    continue;
                }
                errorInfo.add(ResManager.loadResFormat((String)"\u672a\u5339\u914d\u4e0a\u542f\u7528\u7684\u6267\u884c\u65b9\u6848\uff1a%1", (String)"DataIntegrationTaskBase_3", (String)"epm-eb-business", (Object[])new Object[]{schemeNumbers}));
                continue;
            }
            List<DataIntegrationQCondition> dataIntegrationQueryMap = DataIntegrationService.getDataIntegrationQueryMap(conditionIds, true);
            if (dataIntegrationQueryMap.isEmpty()) {
                errorInfo.add(ResManager.loadResFormat((String)"\u672a\u5339\u914d\u4e0a\u8bbe\u7f6e\u4e3a\u5b9a\u65f6\u4efb\u52a1\u72b6\u6001\u7684\u6267\u884c\u65b9\u6848\uff1a%1", (String)"DataIntegrationTaskBase_4", (String)"epm-eb-business", (Object[])new Object[]{schemeNumbers}));
                continue;
            }
            Map<Long, Map<String, Long>> schemViewMap = DataIntegrationService.getDataIntegrationSchemeViewMap(schemeIds, schemeViewCache);
            dataIntegrationQueryMap.forEach(conditionInfo -> {
                Set<Long> viewErrorScheme;
                List<DataIntegrationQuery> queryList = conditionInfo.getQueryList();
                Map<String, Object> map = DataIntegrationService.checkAccountAndPeriod(schemeIds, queryList);
                if (!map.isEmpty()) {
                    errorInfo.add((String)map.get("errorMsg"));
                    HashSet errorScheme = (HashSet)map.get("errorScheme");
                    schemeIds.removeAll(errorScheme);
                }
                if (CollectionUtils.isNotEmpty((Collection)schemeIds) && CollectionUtils.isNotEmpty(viewErrorScheme = DataIntegrationService.getViewErrorScheme(schemeIds, schemViewMap, queryList))) {
                    ArrayList schemenumberList = new ArrayList(16);
                    for (Map.Entry schemeInfo : allSchemeIds.entrySet()) {
                        if (!viewErrorScheme.contains(schemeInfo.getValue())) continue;
                        schemenumberList.add(schemeInfo.getKey());
                    }
                    errorInfo.add(ResManager.loadResFormat((String)"\u6267\u884c\u6761\u4ef6\u4e2d\u7ef4\u5ea6\u89c6\u56fe\u548c\u65b9\u6848\u4e2d\u7ef4\u5ea6\u89c6\u56fe\u4e0d\u4e00\u81f4\u7684\u65b9\u6848\u7f16\u7801\uff1a%1", (String)"DataIntegrationTaskBase_5", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)",", schemenumberList)}));
                    schemeIds.removeAll(viewErrorScheme);
                }
                if (CollectionUtils.isNotEmpty((Collection)schemeIds)) {
                    ExecuteCondition executeCondition = new ExecuteCondition();
                    executeCondition.setDelOldData(conditionInfo.isDelOldData());
                    executeCondition.setFilters(queryList);
                    executeCondition.setTargetSchemeIds(schemeIds);
                    executeCondition.setModelId(conditionInfo.getModelId());
                    executeCondition.setBizModelId(conditionInfo.getBizModelId());
                    executeCondition.setActionId(GlobalIdUtil.genGlobalLongId());
                    executeCondition.setOut(this.isOutput());
                    DataIntegrationStart dataIntegrationStart = DataIntegrationStart.getInstance(executeCondition);
                    dataIntegrationStart.run(async);
                }
            });
        }
        if (errorInfo.size() > 0) {
            throw new KDBizException(((Object)errorInfo).toString());
        }
    }

    default public String getSchemeFormKey() {
        return this.isOutput() ? "eb_integration_out" : "eb_integration";
    }

    public boolean isOutput();
}

