/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.task.notice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.adminmode.CurrentModeEnum;
import kd.epm.eb.common.enums.adminmode.PlanStatusEnum;
import kd.epm.eb.common.enums.adminmode.PurposeTypeEnum;
import kd.epm.eb.common.message.MessageUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.base.ObjUtils;

public class NoticeScheduleTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(NoticeScheduleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\uff1a{}", map);
        Object purpose = map.get("purpose");
        if (purpose == null) {
            log.error("\u516c\u544a\u7c7b\u578b\u4e3a\u7a7a\u3001\u65e0\u6cd5\u6267\u884c\u4e1a\u52a1");
            return;
        }
        PurposeTypeEnum enumByValue = PurposeTypeEnum.getEnumByValue((String)((String)purpose));
        Long modelId = IDUtils.toLong((Object)map.get("modelId"));
        if (modelId == null || modelId == 0L) {
            log.error("\u4f53\u7cfbid\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5b9a\u65f6\u4efb\u52a1");
            return;
        }
        if (enumByValue == PurposeTypeEnum.OPERATION) {
            boolean isClose = (Boolean)map.get("isClose");
            if (!isClose) {
                QFilter qFilter;
                DynamicObject modelDyn = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)"id,currentmode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
                if (modelDyn == null) {
                    log.error("\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u5b9a\u65f6\u4efb\u52a1");
                    return;
                }
                if ("2".equals(modelDyn.getString("currentmode"))) {
                    log.error("\u4f53\u7cfb\u5f53\u524d\u4e3a\u7ba1\u7406\u5458\u6a21\u5f0f\uff0c\u4e0d\u53ef\u4ee5\u91cd\u65b0\u7f6e\u4e3a\u7ba1\u7406\u5458\u6a21\u5f0f");
                    return;
                }
                Object plantypeObj = map.get("plantype");
                String actionType = "1";
                if (plantypeObj != null && "1".equals((String)plantypeObj)) {
                    qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and(new QFilter("status", "=", (Object)PlanStatusEnum.WAIT.getIndex()));
                    qFilter.and(new QFilter("purpose", "=", (Object)enumByValue.getValue()));
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_mnt_executeplan", (String)"id,status", (QFilter[])new QFilter[]{qFilter});
                    if (dynamicObject != null) {
                        log.info("\u4fee\u6539\u6267\u884c\u8ba1\u5212\u72b6\u6001\u4e3a\u6267\u884c\u4e2d");
                        dynamicObject.set("status", (Object)PlanStatusEnum.EXECUTING.getIndex());
                        SaveServiceHelper.update((DynamicObject)dynamicObject);
                    }
                    actionType = "3";
                    this.writeOperationLog(PlanStatusEnum.EXECUTING, null, modelId, false);
                } else if (plantypeObj != null && "2".equals((String)plantypeObj)) {
                    qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and(new QFilter("status", "=", (Object)PlanStatusEnum.WAIT.getIndex()));
                    qFilter.and(new QFilter("purpose", "=", (Object)enumByValue.getValue()));
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_mnt_executeplan", (String)"id,status,announcementcontent.endtime", (QFilter[])new QFilter[]{qFilter});
                    if (dynamicObject != null) {
                        log.info("\u4fee\u6539\u6267\u884c\u8ba1\u5212\u72b6\u6001\u4e3a\u6267\u884c\u4e2d");
                        dynamicObject.set("status", (Object)PlanStatusEnum.EXECUTING.getIndex());
                        SaveServiceHelper.update((DynamicObject)dynamicObject);
                        actionType = "3";
                    }
                    this.writeOperationLog(PlanStatusEnum.EXECUTING, null, modelId, false);
                } else if (plantypeObj != null && "3".equals((String)plantypeObj)) {
                    modelDyn.set("currentmode", (Object)CurrentModeEnum.ADMIN.getIndex());
                    SaveServiceHelper.update((DynamicObject)modelDyn);
                    qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and(new QFilter("status", "=", (Object)PlanStatusEnum.WAIT.getIndex()).or(new QFilter("status", "=", (Object)PlanStatusEnum.EXECUTING.getIndex())));
                    qFilter.and(new QFilter("purpose", "=", (Object)enumByValue.getValue()));
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_mnt_executeplan", (String)"id,status,announcementcontent.endtime", (QFilter[])new QFilter[]{qFilter});
                    PlanStatusEnum needUpateStatus = PlanStatusEnum.EXECUTING;
                    if (dynamicObject != null && dynamicObject.getDate("announcementcontent.endtime") == null) {
                        if (PlanStatusEnum.WAIT.getIndex().equals(dynamicObject.getString("status"))) {
                            actionType = "3";
                        }
                        log.info("\u4fee\u6539\u6267\u884c\u8ba1\u5212\u72b6\u6001\u4e3a\u7ed3\u675f");
                        needUpateStatus = PlanStatusEnum.END;
                        dynamicObject.set("status", (Object)PlanStatusEnum.END.getIndex());
                        SaveServiceHelper.update((DynamicObject)dynamicObject);
                    } else if (dynamicObject != null && dynamicObject.getDate("announcementcontent.endtime") != null) {
                        if (PlanStatusEnum.WAIT.getIndex().equals(dynamicObject.getString("status"))) {
                            actionType = "3";
                        }
                        log.info("\u4fee\u6539\u6267\u884c\u8ba1\u5212\u72b6\u6001\u4e3a\u6267\u884c\u4e2d");
                        dynamicObject.set("status", (Object)PlanStatusEnum.EXECUTING.getIndex());
                        SaveServiceHelper.update((DynamicObject)dynamicObject);
                    }
                    this.writeOperationLog(needUpateStatus, CurrentModeEnum.ADMIN, modelId, true);
                }
                boolean pushmessagecenter = (Boolean)map.getOrDefault("pushmessagecenter", false);
                if (!"1".equals(actionType) && pushmessagecenter) {
                    this.sendMessage(map, modelId, enumByValue);
                }
                this.writeExecuteLog(map, modelId, true, actionType, "");
            } else {
                DynamicObject modelDyn = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)"id,currentmode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
                if (modelDyn == null) {
                    log.error("\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u5b9a\u65f6\u4efb\u52a1");
                    return;
                }
                modelDyn.set("currentmode", (Object)CurrentModeEnum.EMPTYMODE.getIndex());
                SaveServiceHelper.update((DynamicObject)modelDyn);
                if (map.containsKey("autoClose")) {
                    DynamicObject planDyn = BusinessDataServiceHelper.loadSingle((Object)map.get("planId"), (String)"eb_mnt_executeplan");
                    if (planDyn == null) {
                        log.info("\u81ea\u52a8\u7ed3\u675f\u88ab\u5ffd\u7565\uff0c\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u6267\u884c\u8ba1\u5212");
                    } else if (PlanStatusEnum.WAIT.getIndex().equals(planDyn.getString("status")) || PlanStatusEnum.EXECUTING.getIndex().equals(planDyn.getString("status"))) {
                        log.info("\u4fee\u6539\u6267\u884c\u8ba1\u5212\u4e3a\u5df2\u7ed3\u675f");
                        planDyn.set("status", (Object)PlanStatusEnum.END.getIndex());
                        SaveServiceHelper.update((DynamicObject)planDyn);
                        this.writeExecuteLog(map, modelId, true, "2", "");
                        boolean pushmessagecenter = (Boolean)map.getOrDefault("pushmessagecenter", false);
                        if (pushmessagecenter) {
                            this.sendMessage(map, modelId, enumByValue);
                        }
                    } else {
                        log.info("\u81ea\u52a8\u7ed3\u675f\u88ab\u5ffd\u7565\uff0c\u5173\u8054\u5f00\u59cb\u8ba1\u5212\u72b6\u6001\u4e3a\uff1a{}", (Object)planDyn.getString("status"));
                    }
                } else {
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and(new QFilter("status", "=", (Object)PlanStatusEnum.EXECUTING.getIndex()).or("status", "=", (Object)PlanStatusEnum.WAIT.getIndex()));
                    qFilter.and(new QFilter("purpose", "=", (Object)enumByValue.getValue()));
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_mnt_executeplan", (String)"id,status", (QFilter[])new QFilter[]{qFilter});
                    if (dynamicObject != null) {
                        log.info("\u4fee\u6539\u6267\u884c\u8ba1\u5212\u4e3a\u5df2\u7ed3\u675f");
                        dynamicObject.set("status", (Object)PlanStatusEnum.END.getIndex());
                        SaveServiceHelper.update((DynamicObject)dynamicObject);
                    }
                    this.sendMessage(map, modelId, enumByValue);
                    this.writeExecuteLog(map, modelId, true, "2", "");
                }
                this.writeOperationLog(PlanStatusEnum.END, CurrentModeEnum.NORMAL, modelId, true);
            }
        }
    }

    private void writeExecuteLog(Map<String, Object> map, Long modelId, boolean executeresult, String actionType, String reason) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_mnt_executelog");
        dynamicObject.set("mntscheme", map.get("mntscheme"));
        dynamicObject.set("model", (Object)modelId);
        dynamicObject.set("announcementcontent", map.get("contentId"));
        Boolean isInstantpush = (Boolean)map.getOrDefault("instantpush", true);
        dynamicObject.set("executetype", (Object)(isInstantpush != false ? "1" : "0"));
        dynamicObject.set("actiontype", (Object)actionType);
        dynamicObject.set("executeresult", (Object)(executeresult ? "0" : "1"));
        dynamicObject.set("reason", (Object)reason);
        dynamicObject.set("executeuser", map.get("createuser"));
        dynamicObject.set("executetime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void sendMessage(Map<String, Object> map, Long model, PurposeTypeEnum purposeTypeEnum) {
        Set userIds = ModelServiceHelper.getManagersByModel((Long)model);
        Set<Long> allHasPermModel = NoticeScheduleTask.getAllHasPermModel(model);
        userIds.addAll(allHasPermModel);
        log.info("userIds size:{}", (Object)userIds.size());
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            Long senderId = IDUtils.toLong((Object)map.get("senderId"));
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setTitle((String)map.get("title"));
            messageInfo.setContent((String)map.get("content"));
            messageInfo.setType("notice");
            messageInfo.setPubaccNumber(MessageUtils.PublicType.SYSTEM_PUB_ACC.getNumber());
            messageInfo.setSenderId(senderId);
            messageInfo.setUserIds(new ArrayList(userIds));
            messageInfo.setTag(purposeTypeEnum.getBridge().loadKDString());
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    public static Set<Long> getAllHasPermModel(Long model) {
        HashSet<Long> sets = new HashSet<Long>();
        Map dys = BusinessDataServiceHelper.loadFromCache((String)"perm_userperm", (String)"user", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)model)});
        if (dys != null && dys.size() > 0) {
            for (DynamicObject dy : dys.values()) {
                sets.add(dy.getLong("user_id"));
            }
        }
        return sets;
    }

    private void writeOperationLog(PlanStatusEnum planStatusEnum, CurrentModeEnum currentModeEnum, Long modelId, boolean isNeedUpdateModel) {
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u8ba1\u5212\u6267\u884c", "NoticeScheduleTask_2", "epm-eb-business");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        String firstString = ObjUtils.getString((Object)(dynamicObject != null ? dynamicObject.getString("shownumber") : modelId));
        if (isNeedUpdateModel && currentModeEnum != null) {
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4fee\u6539\u4f53\u7cfb\uff1a%1$s\u72b6\u6001\u4e3a\uff1a%2$s", "NoticeScheduleTask_0", "epm-eb-business");
            OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_mnt_executeplan", null, (String)"update", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{firstString, currentModeEnum.getDesc()});
        } else {
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4fee\u6539\u4f53\u7cfb\uff1a%1$s\u6267\u884c\u8ba1\u5212\u72b6\u6001\u4e3a\uff1a%2$s", "NoticeScheduleTask_1", "epm-eb-business");
            OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_mnt_executeplan", null, (String)"update", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{firstString, planStatusEnum.getTitle()});
        }
    }
}

