/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.task.notice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.adminmode.PlanStatusEnum;
import kd.epm.eb.common.enums.adminmode.PurposeTypeEnum;
import kd.epm.eb.common.enums.adminmode.RemindEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.task.notice.ExecutePlanJobEntry;
import kd.epm.eb.task.notice.JobCreateEntry;
import kd.epm.eb.task.notice.NoticeScheduleTask;
import kd.epm.eb.task.notice.PlanCreateEntry;
import org.jetbrains.annotations.NotNull;

public class ScheduleHelper {
    private static final Log log = LogFactory.getLog(ScheduleHelper.class);
    private static final SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd_HHmmss");

    public static void createRealtimeNotice(JobCreateEntry createEntry) {
        createEntry.setJobType(JobType.REALTIME);
        ScheduleHelper.createJob(createEntry);
    }

    public static void createBizNotice(DynamicObject dynamicObject, JobCreateEntry createEntry, Date date, Long id, Boolean isClose, PurposeTypeEnum purposeTypeEnum, Long planId) {
        ArrayList<ExecutePlanJobEntry> jobEntryList = new ArrayList<ExecutePlanJobEntry>(16);
        Date starttime = dynamicObject.getDate("starttime");
        boolean isRealtime = false;
        if (RemindEnum.BEGIN.getIndex().equals(dynamicObject.getString("remind"))) {
            Map<String, Object> customParams = createEntry.getCustomParams();
            customParams.put("plantype", "3");
            createEntry.setJobType(JobType.BIZ);
        } else {
            RemindEnum remind = RemindEnum.getRemindEnumByIndex((String)dynamicObject.getString("remind"));
            if (remind != null) {
                Date messageDate = new Date(starttime.getTime() - remind.getMillis());
                Map<String, Object> customParams = createEntry.getCustomParams();
                if (messageDate.compareTo(TimeServiceHelper.now()) <= 0) {
                    createEntry.setJobType(JobType.REALTIME);
                    customParams.put("plantype", "1");
                    isRealtime = true;
                } else {
                    createEntry.setJobType(JobType.BIZ);
                    customParams.put("plantype", "2");
                    starttime = messageDate;
                }
            }
        }
        String job = ScheduleHelper.createJob(createEntry);
        ExecutePlanJobEntry executePlanJobEntry = new ExecutePlanJobEntry();
        executePlanJobEntry.setJobId(job);
        PlanCreateEntry planCreateEntry = new PlanCreateEntry();
        planCreateEntry.setJobId(job);
        planCreateEntry.setPlanName(dynamicObject.getString("title"));
        planCreateEntry.setPlanNumber("bgm_notice_plan_" + sf.format(date));
        planCreateEntry.setRepeatModeEnum(RepeatModeEnum.NONE);
        planCreateEntry.setPeriod(1);
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(new Date(starttime.getTime()));
        planCreateEntry.setStartTime(startCalendar);
        if (isClose != null) {
            DynamicObject history;
            Calendar endCalendar;
            if (dynamicObject.getDate("endtime") != null) {
                endCalendar = Calendar.getInstance();
                endCalendar.setTime(new Date(dynamicObject.getDate("endtime").getTime()));
                planCreateEntry.setEndTime(endCalendar);
            } else {
                endCalendar = Calendar.getInstance();
                endCalendar.setTime(new Date(starttime.getTime() + 120000L));
                planCreateEntry.setEndTime(endCalendar);
            }
            if (!isRealtime) {
                String plan = ScheduleHelper.createPlan(planCreateEntry);
                executePlanJobEntry.setPlanId(plan);
                jobEntryList.add(executePlanJobEntry);
            }
            if (RemindEnum.BEGIN.getIndex().equals(dynamicObject.getString("remind"))) {
                executePlanJobEntry.setPlanType("0");
            } else {
                executePlanJobEntry.setPlanType("1");
                ScheduleHelper.createUpdateModelStatusNotice(dynamicObject, createEntry, date, purposeTypeEnum, id, jobEntryList);
            }
            DynamicObject executePlan = BusinessDataServiceHelper.newDynamicObject((String)"eb_mnt_executeplan");
            if (planId != null && planId != 0L && (history = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"eb_mnt_executeplan")) != null) {
                executePlan = history;
            }
            executePlan.set("mntscheme", dynamicObject.get("mntscheme"));
            executePlan.set("announcementcontent", (Object)id);
            executePlan.set("model", dynamicObject.get("model"));
            executePlan.set("purpose", (Object)purposeTypeEnum.getValue());
            if (isRealtime) {
                executePlan.set("status", (Object)PlanStatusEnum.EXECUTING.getIndex());
            } else {
                executePlan.set("status", (Object)PlanStatusEnum.WAIT.getIndex());
            }
            executePlan.set("createuser", dynamicObject.get("createrfield"));
            executePlan.set("createtime", dynamicObject.get("createdatefield"));
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{executePlan});
            if (dynamicObject.getDate("endtime") != null) {
                ScheduleHelper.createEndNotice(dynamicObject, createEntry, date, ((DynamicObject)save[0]).getLong("id"), purposeTypeEnum, id, jobEntryList);
            }
            if (CollectionUtils.isNotEmpty(jobEntryList)) {
                DynamicObjectCollection plan_entry = executePlan.getDynamicObjectCollection("job_entry");
                for (ExecutePlanJobEntry entry : jobEntryList) {
                    DynamicObject temp = new DynamicObject(plan_entry.getDynamicObjectType());
                    temp.set("job", (Object)entry.getJobId());
                    temp.set("plan", (Object)entry.getPlanId());
                    temp.set("plantype", (Object)entry.getPlanType());
                    plan_entry.add((Object)temp);
                }
                executePlan.set("job_entry", (Object)plan_entry);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{executePlan});
            }
        }
    }

    private static void createUpdateModelStatusNotice(DynamicObject dynamicObject, JobCreateEntry createEntry, Date date, PurposeTypeEnum purposeTypeEnum, Long contentId, List<ExecutePlanJobEntry> jobEntryList) {
        JobCreateEntry endJobEntry = new JobCreateEntry();
        endJobEntry.setAppId(createEntry.getAppId());
        endJobEntry.setJobName(dynamicObject.getString("title"));
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        endJobEntry.setJobNumber("bgm_notice_update_" + sf.format(date));
        endJobEntry.setTaskClassName("kd.epm.eb.task.notice.NoticeScheduleTask");
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("modelId", dynamicObject.getLong("model"));
        customParams.put("time", 1);
        customParams.put("purpose", purposeTypeEnum.getValue());
        customParams.put("title", dynamicObject.getString("title"));
        customParams.put("content", dynamicObject.getString("content"));
        customParams.put("contentId", contentId);
        customParams.put("mntscheme", dynamicObject.getLong("mntscheme"));
        customParams.put("instantpush", false);
        customParams.put("createuser", dynamicObject.get("createrfield"));
        customParams.put("isClose", false);
        customParams.put("plantype", "3");
        if (dynamicObject.containsProperty("pushmessagecenter")) {
            customParams.put("pushmessagecenter", dynamicObject.get("pushmessagecenter"));
        }
        endJobEntry.setCustomParams(customParams);
        endJobEntry.setJobType(JobType.BIZ);
        String endJobId = ScheduleHelper.createJob(endJobEntry);
        ExecutePlanJobEntry executePlanJobEntry = new ExecutePlanJobEntry();
        executePlanJobEntry.setJobId(endJobId);
        PlanCreateEntry endPlanCreateEntry = new PlanCreateEntry();
        endPlanCreateEntry.setJobId(endJobId);
        endPlanCreateEntry.setPlanName(dynamicObject.getString("title"));
        endPlanCreateEntry.setPlanNumber("bgm_notice_updateplan_" + sf.format(date));
        endPlanCreateEntry.setRepeatModeEnum(RepeatModeEnum.NONE);
        endPlanCreateEntry.setPeriod(1);
        Date startTime = dynamicObject.getDate("starttime");
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(new Date(startTime.getTime()));
        endPlanCreateEntry.setStartTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(new Date(startTime.getTime() + 600000L));
        endPlanCreateEntry.setEndTime(endCalendar);
        String plan = ScheduleHelper.createPlan(endPlanCreateEntry);
        executePlanJobEntry.setPlanId(plan);
        executePlanJobEntry.setPlanType("3");
        jobEntryList.add(executePlanJobEntry);
    }

    private static void createEndNotice(DynamicObject dynamicObject, JobCreateEntry createEntry, Date date, Long palnId, PurposeTypeEnum purposeTypeEnum, Long contentId, List<ExecutePlanJobEntry> jobEntryList) {
        JobCreateEntry endJobEntry = new JobCreateEntry();
        endJobEntry.setAppId(createEntry.getAppId());
        endJobEntry.setJobName(dynamicObject.getString("title"));
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        endJobEntry.setJobNumber("bgm_notice_close_" + sf.format(date));
        endJobEntry.setTaskClassName("kd.epm.eb.task.notice.NoticeScheduleTask");
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("modelId", dynamicObject.getLong("model"));
        customParams.put("planId", palnId);
        customParams.put("time", 1);
        customParams.put("isClose", true);
        customParams.put("purpose", purposeTypeEnum.getValue());
        customParams.put("autoClose", true);
        customParams.put("title", dynamicObject.getString("title"));
        customParams.put("content", dynamicObject.getString("content"));
        customParams.put("contentId", contentId);
        customParams.put("mntscheme", dynamicObject.getLong("mntscheme"));
        customParams.put("instantpush", false);
        customParams.put("createuser", dynamicObject.get("createrfield"));
        customParams.put("plantype", "4");
        if (dynamicObject.containsProperty("pushmessagecenter")) {
            customParams.put("pushmessagecenter", dynamicObject.get("pushmessagecenter"));
        }
        DynamicObject defaultScheme = ScheduleHelper.getDefaultScheme();
        DynamicObject model = ScheduleHelper.getModelInfo(dynamicObject.getLong("model"));
        if (defaultScheme != null && model != null) {
            DynamicObject[] dynamicObjects;
            Object[] save;
            customParams.put("title", defaultScheme.getString("title"));
            String content = defaultScheme.getString("content");
            if (content.contains("@model_number@")) {
                content = content.replace("@model_number@", model.getString("shownumber"));
            }
            if (content.contains("@model_name@")) {
                content = content.replace("@model_name@", model.getLocaleString("name").getLocaleValue());
            }
            Set managerNameSet = ModelServiceHelper.getModelManagerName((Long)dynamicObject.getLong("model"));
            if (content.contains("XXX")) {
                content = CollectionUtils.isEmpty((Collection)managerNameSet) ? content.replace("\uff1aXXX", "") : content.replace("XXX", String.join((CharSequence)",", managerNameSet));
            }
            customParams.put("content", content);
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_announcement_content");
            if (defaultScheme != null) {
                object.set("mntscheme", (Object)defaultScheme.getLong("id"));
            }
            object.set("model", (Object)dynamicObject.getLong("model"));
            object.set("title", (Object)defaultScheme.getString("title"));
            object.set("content", (Object)content);
            object.set("isclose", (Object)Boolean.TRUE);
            object.set("createrfield", dynamicObject.get("createrfield"));
            object.set("createdatefield", dynamicObject.get("createdatefield"));
            if (dynamicObject.containsProperty("pushmessagecenter")) {
                object.set("pushmessagecenter", dynamicObject.get("pushmessagecenter"));
            }
            if ((save = SaveServiceHelper.save((DynamicObject[])(dynamicObjects = new DynamicObject[]{object}))).length > 0) {
                customParams.put("contentId", ((DynamicObject)save[0]).getLong("id"));
            }
        }
        endJobEntry.setCustomParams(customParams);
        endJobEntry.setJobType(JobType.BIZ);
        String endJobId = ScheduleHelper.createJob(endJobEntry);
        ExecutePlanJobEntry executePlanJobEntry = new ExecutePlanJobEntry();
        executePlanJobEntry.setJobId(endJobId);
        PlanCreateEntry endPlanCreateEntry = new PlanCreateEntry();
        endPlanCreateEntry.setJobId(endJobId);
        endPlanCreateEntry.setPlanName(dynamicObject.getString("title"));
        endPlanCreateEntry.setPlanNumber("bgm_notice_endplan_" + sf.format(date));
        endPlanCreateEntry.setRepeatModeEnum(RepeatModeEnum.NONE);
        endPlanCreateEntry.setPeriod(1);
        Date startTime = dynamicObject.getDate("endtime");
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(new Date(startTime.getTime()));
        endPlanCreateEntry.setStartTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(new Date(startTime.getTime() + 600000L));
        endPlanCreateEntry.setEndTime(endCalendar);
        String plan = ScheduleHelper.createPlan(endPlanCreateEntry);
        executePlanJobEntry.setPlanId(plan);
        executePlanJobEntry.setPlanType("4");
        jobEntryList.add(executePlanJobEntry);
    }

    public static void createNotice(DynamicObject dynamicObject, Long id, String appId, Boolean isClose, PurposeTypeEnum purposeTypeEnum, Long planId) {
        JobCreateEntry createEntry = new JobCreateEntry();
        createEntry.setAppId(appId);
        createEntry.setJobName(dynamicObject.getString("title"));
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date();
        createEntry.setJobNumber("bgm_notice_" + sf.format(date));
        createEntry.setTaskClassName("kd.epm.eb.task.notice.NoticeScheduleTask");
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("senderId", UserUtils.getUserId());
        customParams.put("title", dynamicObject.getString("title"));
        customParams.put("content", dynamicObject.getString("content"));
        customParams.put("modelId", dynamicObject.getLong("model"));
        customParams.put("createuser", dynamicObject.get("createrfield"));
        customParams.put("mntscheme", dynamicObject.get("mntscheme"));
        customParams.put("contentId", id);
        if (dynamicObject.containsProperty("pushmessagecenter")) {
            customParams.put("pushmessagecenter", dynamicObject.get("pushmessagecenter"));
        }
        if (purposeTypeEnum == PurposeTypeEnum.OPERATION) {
            customParams.put("isClose", isClose);
            customParams.put("time", 1);
            customParams.put("purpose", purposeTypeEnum.getValue());
            if (isClose.booleanValue()) {
                customParams.put("issendmessage", dynamicObject.getBoolean("issendmessage"));
            } else {
                customParams.put("mntscheme", dynamicObject.getLong("mntscheme"));
            }
        }
        boolean isInstantpush = dynamicObject.getBoolean("instantpush");
        createEntry.setCustomParams(customParams);
        if (isInstantpush || isClose.booleanValue()) {
            customParams.put("instantpush", true);
            ScheduleHelper.createRealtimeNotice(createEntry);
        } else {
            customParams.put("instantpush", false);
            ScheduleHelper.createBizNotice(dynamicObject, createEntry, date, id, isClose, purposeTypeEnum, planId);
        }
    }

    public static String createJob(JobCreateEntry jobCreateEntry) {
        log.info("createJob:{}", (Object)jobCreateEntry);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(jobCreateEntry.getAppId());
        jobInfo.setJobType(jobCreateEntry.getJobType());
        jobInfo.setName(jobCreateEntry.getJobName());
        jobInfo.setNumber(jobCreateEntry.getJobNumber());
        String id = UUID.randomUUID().toString();
        jobInfo.setId(id);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setTaskClassname(jobCreateEntry.getTaskClassName());
        jobInfo.setParams(jobCreateEntry.getCustomParams());
        jobInfo.setCanStop(Boolean.valueOf(true));
        JobDispatcherProxy jobDispatcherProxy = new JobDispatcherProxy();
        if (JobType.REALTIME.equals((Object)jobCreateEntry.getJobType())) {
            NoticeScheduleTask noticeScheduleTask = new NoticeScheduleTask();
            noticeScheduleTask.execute(RequestContext.get(), jobCreateEntry.getCustomParams());
            return "";
        }
        String job = jobDispatcherProxy.createJob(jobInfo);
        return job;
    }

    public static String createPlan(PlanCreateEntry planCreateEntry) {
        log.info("createPlan:{}", (Object)planCreateEntry);
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(planCreateEntry.getJobId());
        planInfo.setName(planCreateEntry.getPlanName());
        planInfo.setNumber(planCreateEntry.getPlanNumber());
        planInfo.setStartTime(planCreateEntry.getStartTime());
        planInfo.setEndTime(planCreateEntry.getEndTime());
        planInfo.setRepeatMode(planCreateEntry.getRepeatModeEnum());
        planInfo.setPeriod(planCreateEntry.getPeriod());
        planInfo.setCronExpression(planCreateEntry.getCornExpression());
        JobDispatcherProxy jobDispatcherProxy = new JobDispatcherProxy();
        String plan = jobDispatcherProxy.createPlan(planInfo);
        return plan;
    }

    public static void updatePlan(DynamicObject[] dynamicObjects) {
        log.info("updatePlan:{}", (Object[])dynamicObjects);
        if (dynamicObjects.length < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u8ba1\u5212\u9519\u8bef\uff0c\u6570\u636e\u4e3a\u7a7a", (String)"ScheduleHelper_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private static DynamicObject getDefaultScheme() {
        QFilter filter = new QFilter("number", "=", (Object)"defaultclose");
        filter.and("purpose", "=", (Object)PurposeTypeEnum.OPERATION.getValue());
        filter.and("schemetype", "=", (Object)"1");
        return QueryServiceHelper.queryOne((String)"eb_mntscheme", (String)"id,title,content", (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject getModelInfo(@NotNull Long modelId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        return dynamicObject;
    }
}

