/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dataset;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;

public class DataSetSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("entryentity.id");
        fields.add("entryentity.dseq");
        fields.add("entryentity.number");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] datasets = e.getDataEntities();
        if (datasets != null) {
            IModelCacheHelper modelCacheHelper = null;
            ShrekConfig config = ShrekConfigServiceHelper.getBgMDConfig();
            for (DynamicObject _dataset : datasets) {
                Long modelId = _dataset.getDynamicObject("model").getLong("id");
                if (modelCacheHelper == null || !modelCacheHelper.getModelobj().getId().equals(modelId)) {
                    modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId, (boolean)true);
                }
                Model model = Model.of((DynamicObject)_dataset.getDynamicObject("model"));
                Dataset dataset = Dataset.of((DynamicObject)_dataset);
                if (!IDUtils.isNotNull((Long)dataset.getId())) continue;
                if (ShrekOlapServiceHelper.existCube((Model)model, (Dataset)dataset)) {
                    ShrekOlapServiceHelper.updateCube((Model)model, (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
                    continue;
                }
                ShrekOlapServiceHelper.createCube((Model)model, (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (e.getDataEntities() != null && e.getDataEntities().length > 0) {
            CubeUtils utils = CubeUtils.get();
            DynamicObject datasetObj = e.getDataEntities()[0];
            DynamicObject modelObj = datasetObj.getDynamicObject("model");
            long datasetId = datasetObj.getLong("id");
            long modelId = modelObj.getLong("id");
            utils.checkDataset(Long.valueOf(modelId), Long.valueOf(datasetId));
        }
    }
}

