/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;

public class AddDimensionOp
extends AbstractOperationServicePlugIn {
    private boolean isEdit = false;
    private static String[] num = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DimensionSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject dimension = e.getDataEntities()[0];
        long dimId = dimension.getLong("id");
        this.isEdit = QueryServiceHelper.exists((String)"epm_dimension", (Object)dimId);
        long modelId = dimension.getDynamicObject("model").getLong("id");
        String newnumber = dimension.getString("number");
        String newname = dimension.getString("name");
        String shortnumber = dimension.getString("shortnumber");
        String membermodel = dimension.getString("membermodel");
        if (!this.isEdit) {
            long memberId = GlobalIdUtil.genGlobalLongId();
            this.preSetUserDefine(modelId, dimId, newname, newnumber, shortnumber, memberId);
            DimensionServiceHelper.afterCreateDim((long)modelId, (long)dimId, (long)memberId);
        } else {
            DynamicObject[] viewMembers;
            QFilter modelIdQf = new QFilter("model", "=", (Object)modelId);
            QFilter dimensionIdQf = new QFilter("dimension", "=", (Object)dimId);
            QFilter levelQf = new QFilter("level", "=", (Object)1);
            QFilter[] filters = new QFilter[]{modelIdQf, dimensionIdQf, levelQf};
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)membermodel, (String)"name,modifytime,modifier", (QFilter[])filters);
            Date date = new Date();
            Long userId = UserUtils.getUserId();
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set("name", (Object)newname);
                    dynamicObject.set("modifytime", (Object)date);
                    dynamicObject.set("modifier", (Object)userId);
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
            if ((viewMembers = BusinessDataServiceHelper.load((String)"eb_viewmember", (String)"name,modifydate,modifier", (QFilter[])filters)) != null && viewMembers.length > 0) {
                for (DynamicObject viewMember : viewMembers) {
                    viewMember.set("name", (Object)newname);
                    viewMember.set("modifydate", (Object)date);
                    viewMember.set("modifier", (Object)userId);
                }
                SaveServiceHelper.save((DynamicObject[])viewMembers);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length > 0) {
            DynamicObject dim = e.getDataEntities()[0];
            CubeUtils.get().checkDimension(dim, null);
            long modelId = dim.getLong("model.id");
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId, (boolean)true);
            if (orCreate.getModelobj().isModelByEB()) {
                ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)orCreate.getModelobj());
                Dataset dataset = new Dataset(Long.valueOf(modelId), dim.getString("model.shownumber"));
                String dimNumber = dim.getString("number");
                if (ShrekOlapServiceHelper.existCubeDimension((Model)orCreate.getModelobj(), (Dataset)dataset, (String)dimNumber)) {
                    ShrekOlapServiceHelper.addCubeMembers((Model)orCreate.getModelobj(), Collections.singletonList(dataset), (String)dimNumber, (List)orCreate.getModelobj().getDimension(dimNumber).getAllMembers(), (ShrekConfig)config);
                } else {
                    ShrekOlapServiceHelper.addCubeDimensions((Model)orCreate.getModelobj(), (Dataset)dataset, (IModelCacheHelper)orCreate, (ShrekConfig)config);
                }
            }
        }
    }

    private void preSetUserDefine(long modelId, long dimId, String name, String number, String shortNumber, long memberId) {
        DynamicObject entityTree = BusinessDataServiceHelper.newDynamicObject((String)"epm_userdefinedmembertree");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        boolean modelByEB = modelCacheHelper.getModelobj().isModelByEB();
        ArrayList<DynamicObject> viewMemSave = new ArrayList<DynamicObject>(16);
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)entityTree);
        long memId = GlobalIdUtil.genGlobalLongId();
        entityTree.set("id", (Object)memId);
        entityTree.set("model", (Object)modelId);
        entityTree.set("dimension", (Object)dimId);
        entityTree.set("level", (Object)1);
        entityTree.set("isleaf", (Object)Boolean.FALSE);
        entityTree.set("longnumber", (Object)number);
        entityTree.set("number", (Object)number);
        entityTree.set("shownumber", (Object)number);
        entityTree.set("name", (Object)name);
        entityTree.set("membersource", (Object)MemberSourceEnum.PRESET.getIndex());
        entityTree.set("dseq", (Object)1);
        long viewMemId = GlobalIdUtil.genGlobalLongId();
        if (!modelByEB) {
            DynamicObject viewMemberRoot = BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember");
            viewMemberRoot.set("id", (Object)viewMemId);
            viewMemberRoot.set("memberid", (Object)memId);
            viewMemberRoot.set("model", (Object)modelId);
            viewMemberRoot.set("dimension", (Object)dimId);
            viewMemberRoot.set("level", (Object)1);
            viewMemberRoot.set("isleaf", (Object)Boolean.FALSE);
            viewMemberRoot.set("longnumber", (Object)number);
            viewMemberRoot.set("number", (Object)number);
            viewMemberRoot.set("shownumber", (Object)number);
            viewMemberRoot.set("name", (Object)name);
            viewMemberRoot.set("membersource", (Object)ViewMemberSourceEnum.PRESET.getIndex());
            viewMemberRoot.set("dseq", (Object)1);
            viewMemberRoot.set("enable", (Object)"1");
            viewMemberRoot.set("disable", (Object)"0");
            viewMemberRoot.set("modifier", (Object)UserUtils.getUserId());
            viewMemberRoot.set("modifydate", (Object)TimeServiceHelper.now());
            viewMemberRoot.set("status", (Object)"C");
            viewMemSave.add(viewMemberRoot);
        }
        Object[] entityTrees = new Object[]{entityTree};
        BusinessDataWriter.save((IDataEntityType)entityTree.getDynamicObjectType(), (Object[])entityTrees);
        DynamicObject noneTree = BusinessDataServiceHelper.newDynamicObject((String)"epm_userdefinedmembertree");
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)noneTree);
        long viewMemId2 = GlobalIdUtil.genGlobalLongId();
        noneTree.set("model", (Object)modelId);
        noneTree.set("dimension", (Object)dimId);
        noneTree.set("level", (Object)2);
        noneTree.set("parent", (Object)entityTree);
        noneTree.set("datatype", (Object)"0");
        noneTree.set("aggoprt", (Object)"1");
        noneTree.set("isleaf", (Object)Boolean.TRUE);
        String longNumber = number + "!" + shortNumber + "None";
        noneTree.set("longnumber", (Object)longNumber);
        String noneNumber = shortNumber + "None";
        noneTree.set("number", (Object)noneNumber);
        noneTree.set("shownumber", (Object)noneNumber);
        String noneName = ResManager.loadResFormat((String)"\u4e0d\u533a\u5206%s", (String)"AddDimensionOp_9", (String)"epm-eb-cube", (Object[])new Object[]{name});
        noneTree.set("name", (Object)noneName);
        noneTree.set("membersource", (Object)MemberSourceEnum.PRESET.getIndex());
        noneTree.set("dseq", (Object)1);
        noneTree.set("id", (Object)memberId);
        if (!modelByEB) {
            DynamicObject viewMemberNone = BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember");
            viewMemberNone.set("model", (Object)modelId);
            viewMemberNone.set("dimension", (Object)dimId);
            viewMemberNone.set("level", (Object)2);
            viewMemberNone.set("parent", (Object)viewMemId);
            viewMemberNone.set("aggoprt", (Object)"1");
            viewMemberNone.set("isleaf", (Object)Boolean.TRUE);
            viewMemberNone.set("longnumber", (Object)longNumber);
            viewMemberNone.set("number", (Object)noneNumber);
            viewMemberNone.set("shownumber", (Object)noneNumber);
            viewMemberNone.set("name", (Object)noneName);
            viewMemberNone.set("membersource", (Object)ViewMemberSourceEnum.PRESET.getIndex());
            viewMemberNone.set("dseq", (Object)1);
            viewMemberNone.set("id", (Object)viewMemId2);
            viewMemberNone.set("memberid", (Object)memberId);
            viewMemberNone.set("enable", (Object)"1");
            viewMemberNone.set("disable", (Object)"0");
            viewMemberNone.set("modifier", (Object)UserUtils.getUserId());
            viewMemberNone.set("modifydate", (Object)TimeServiceHelper.now());
            viewMemberNone.set("status", (Object)"C");
            viewMemSave.add(viewMemberNone);
        }
        Object[] noneTrees = new Object[]{noneTree};
        BusinessDataWriter.save((IDataEntityType)noneTree.getDynamicObjectType(), (Object[])noneTrees);
        SaveServiceHelper.save((DynamicObject[])viewMemSave.toArray(new DynamicObject[0]));
    }

    static class DimensionSubmitValidator
    extends AbstractValidator {
        DimensionSubmitValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                String newnumber = String.valueOf(dynamicObject.get("number"));
                String newname = String.valueOf(dynamicObject.get("name"));
                String shortnumber = String.valueOf(dynamicObject.get("shortnumber"));
                Long modelId = dynamicObject.getLong("model.id");
                Long dimId = dynamicObject.getLong("id");
                String membermodel = String.valueOf(dynamicObject.get("membermodel"));
                if (newname == null) {
                    newname = "";
                }
                if (StringUtils.isEmpty((CharSequence)newnumber.trim())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddDimensionOp_0", (String)"epm-eb-cube", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)newname.trim())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AddDimensionOp_1", (String)"epm-eb-cube", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)shortnumber.trim())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b80\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddDimensionOp_2", (String)"epm-eb-cube", (Object[])new Object[0]));
                    return;
                }
                String regEx = "^(?!_)[a-zA-Z0-9]+$";
                Pattern pattern = Pattern.compile(regEx);
                Matcher matcher = pattern.matcher(newnumber);
                Matcher matcher2 = pattern.matcher(shortnumber);
                if (StringUtils.startsWithAny((CharSequence)newnumber, (CharSequence[])num) || StringUtils.startsWithAny((CharSequence)shortnumber, (CharSequence[])num) || !matcher.matches() || !matcher2.matches()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u3001\u7b80\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u6216\u534a\u89d2\u5b57\u6bcd\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AddDimensionOp_3", (String)"epm-eb-cube", (Object[])new Object[0]));
                    return;
                }
                if (newnumber.contains(".") || shortnumber.contains(".")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u3001\u7b80\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u6216\u534a\u89d2\u5b57\u6bcd\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AddDimensionOp_3", (String)"epm-eb-cube", (Object[])new Object[0]));
                    return;
                }
                boolean isEdit = QueryServiceHelper.exists((String)"epm_dimension", (Object)dimId);
                if (!isEdit) {
                    DynamicObjectCollection dim = this.getUserAllDims(modelId);
                    if (dim != null && dim.size() > 0) {
                        if (this.checkNumAndShortNum(newnumber, dim)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u201c\u7f16\u7801\u201d\u5728\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u76f8\u540c\u7b80\u7801\u6216\u7f16\u7801\u3002", (String)"AddDimensionOp_4", (String)"epm-eb-cube", (Object[])new Object[0]));
                            return;
                        }
                        if (this.checkName(newname, dim)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\"\u540d\u79f0\"\u5728\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u3002", (String)"AddDimensionOp_5", (String)"epm-eb-cube", (Object[])new Object[0]));
                            return;
                        }
                        if (this.checkNumAndShortNum(shortnumber, dim)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u201c\u7b80\u7801\u201d\u5728\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u76f8\u540c\u7b80\u7801\u6216\u7f16\u7801\u3002", (String)"AddDimensionOp_6", (String)"epm-eb-cube", (Object[])new Object[0]));
                            return;
                        }
                        if (SysDimensionEnum.include((String)newnumber)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u9884\u7f6e\u7ef4\u5ea6\u3002", (String)"AddDimensionOp_7", (String)"epm-eb-cube", (Object[])new Object[0]));
                            return;
                        }
                    }
                    if (OlapServiceHelper.checkIsOnlineByCube((Long)modelId)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u6e90\u94fe\u63a5\u4e0d\u53ef\u7528\u3002", (String)"AddDimensionOp_10", (String)"epm-eb-cube", (Object[])new Object[0]));
                    return;
                }
                String selectFields = "name";
                QFilter fmodelid = new QFilter("name", "=", (Object)newname);
                QFilter fmodelid2 = new QFilter("model", "=", (Object)modelId);
                QFilter fmodelid3 = new QFilter("id", "!=", dynamicObject.get("id"));
                QFilter[] filters = new QFilter[]{fmodelid, fmodelid2, fmodelid3};
                DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
                boolean result = false;
                if (dcs != null && dcs.size() > 0) {
                    result = true;
                }
                if (!result) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\"\u540d\u79f0\"\u5728\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u3002", (String)"AddDimensionOp_5", (String)"epm-eb-cube", (Object[])new Object[0]));
                return;
            }
        }

        public DynamicObjectCollection getUserAllDims(Long modelid) {
            String selectFields = "id,name,shortnumber,number";
            QFilter filter = new QFilter("model", "=", (Object)modelid);
            QFilter[] filters = new QFilter[]{filter};
            return QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
        }

        public boolean checkNameInMember(String name, String membermodel, Long dimId, String number) {
            boolean is = false;
            String selectFields = "id";
            QFilter filter = new QFilter("name", "=", (Object)name);
            QFilter filter2 = new QFilter("dimension", "=", (Object)dimId);
            QFilter filter3 = new QFilter("number", "!=", (Object)number);
            QFilter[] filters = new QFilter[]{filter, filter2, filter3};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)membermodel, (String)selectFields, (QFilter[])filters);
            if (dcs != null && dcs.size() > 0) {
                is = true;
            }
            return is;
        }

        public boolean checkName(String name, DynamicObjectCollection dims) {
            for (DynamicObject dim : dims) {
                if (!name.equals(dim.getString("name"))) continue;
                return true;
            }
            return false;
        }

        public boolean checkInfoInModel(String selectField, String filter, String filvalue, String form, long modelid) {
            String selectFields = selectField;
            QFilter fmodelid = new QFilter(filter, "=", (Object)filvalue);
            QFilter fmodelid2 = new QFilter("model", "=", (Object)modelid);
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)form, (String)selectFields, (QFilter[])filters);
            boolean result = false;
            if (dcs != null && dcs.size() > 0) {
                result = true;
            }
            return result;
        }

        public boolean checkNumAndShortNum(String newnumber, DynamicObjectCollection dims) {
            for (DynamicObject obj : dims) {
                String number = obj.getString("number");
                String shortnumber = obj.getString("shortnumber");
                if (!newnumber.equalsIgnoreCase(number) && !newnumber.equalsIgnoreCase(shortnumber)) continue;
                return true;
            }
            return false;
        }
    }
}

