/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.ImportAndExport.Export;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.ImportAndExport.Export.DimMemberExportBasePlugin;
import org.apache.poi.ss.usermodel.Row;

public class AccountMemberExport
extends DimMemberExportBasePlugin {
    private final long datasetId;
    private Map<Long, Set<String>> metricMap = null;
    private final Map<Set<String>, String> metricStrMap = Maps.newHashMap();

    protected long getDatasetId() {
        return this.datasetId;
    }

    public AccountMemberExport(String memberKey, long modelId, long dimensionId, long datasetId) {
        super(memberKey, modelId, dimensionId, 0L);
        this.datasetId = datasetId;
    }

    @Override
    protected String getQueryFields() {
        String fields = super.getQueryFields();
        fields = fields + ",accounttype,drcrdirect";
        return fields;
    }

    @Override
    protected QFBuilder getQueryBuilder() {
        QFBuilder builder = super.getQueryBuilder();
        builder.add("dataset", "in", (Object)new Object[]{this.getDatasetId(), 0L});
        return builder;
    }

    @Override
    protected void setSelfDataToBook(Row row, int cellNum, Map<String, Object> object, Map<String, Integer> numberRowHeadMap) {
        this.setCellValue(row.createCell(cellNum++), this.getVoUtils().getAggOprt(object.get("aggoprt")));
        this.setCellValue(row.createCell(cellNum++), this.getVoUtils().transAccountType(object.get("accounttype")));
        this.setCellValue(row.createCell(cellNum++), this.getVoUtils().transDebitCreDit(object.get("drcrdirect")));
        this.setCellValue(row.createCell(cellNum++), this.tranceMetric((Long)object.get("id")));
        this.exportCustomProperty(row, cellNum, object);
    }

    protected String tranceMetric(Long accountId) {
        String metrics = null;
        if (this.getModel().isModelByBGMD() || this.getModel().isModelByNewEB()) {
            Set<String> _metricSet;
            if (this.metricMap == null) {
                this.metricMap = MetricUtils.queryMetricByAccount((Long)this.getModelId());
            }
            if (CollectionUtils.isNotEmpty(_metricSet = this.metricMap.get(accountId))) {
                metrics = this.metricStrMap.computeIfAbsent(_metricSet, f -> StringUtils.join((Collection)_metricSet, (char)','));
            }
        }
        return metrics;
    }
}

