/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.ImportAndExport.Export;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.olap.service.view.bean.utils.MemberVOAssistUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jetbrains.annotations.NotNull;

public class DimMemberExportBasePlugin {
    private static final Log log = LogFactory.getLog(DimMemberExportBasePlugin.class);
    protected String memberKey;
    protected long modelId;
    protected long dimensionId;
    protected long viewId;
    protected ImportEntity importData;
    private MemberVOAssistUtils voUtils = null;
    private Set<String> MEMBER_SOURCE = null;
    private IModelCacheHelper modelCacheHelper = null;
    private Dimension dimension = null;
    private MemberPropCache propCache = null;
    private Map<Object, DynamicObject> user = Maps.newHashMap();
    private boolean initPermission = false;
    private Set<Long> permissions = null;
    private Map<String, CustomProperty> customProperties = null;

    protected MemberVOAssistUtils getVoUtils() {
        if (this.voUtils == null) {
            this.voUtils = MemberVOAssistUtils.get();
        }
        return this.voUtils;
    }

    public DimMemberExportBasePlugin(String memberKey, long modelId, long dimensionId, long viewId) {
        this.memberKey = memberKey;
        this.modelId = modelId;
        this.dimensionId = dimensionId;
        this.viewId = viewId;
    }

    public String exportData() {
        LogStats stats = new LogStats("budget-export-log : ");
        stats.addInfo("begin-export.");
        try {
            Workbook workbook = this.getWorkbook();
            if (workbook == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6a21\u677f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DimMemberExportBasePlugin_0", (String)"epm-eb-cube", (Object[])new Object[0]));
            }
            List<Map<String, Object>> exportData = this.getExportData();
            if (exportData == null || exportData.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u6216\u8005\u6ca1\u6709\u5f53\u524d\u7ef4\u5ea6\u7684\u7ba1\u7406\u6743\u9650\u3002", (String)"DimMemberExportBasePlugin_1", (String)"epm-eb-cube", (Object[])new Object[0]));
            }
            MemberTreeNode root = this.buildTree(exportData);
            if (root != null) {
                this.setDataToBook(root.getChildren(), 3, workbook.getSheetAt(0));
            }
            try {
                String name = this.getImportEntity().getTemplateName();
                String string = DimMemberExportBasePlugin.writeFile(workbook, name);
                return string;
            }
            catch (IOException ex) {
                try {
                    throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
                }
                catch (KDBizException ex2) {
                    throw ex2;
                }
                catch (Throwable ex3) {
                    String tip = StringUtils.isEmpty((String)ex3.getMessage()) ? Arrays.toString(ex3.getStackTrace()) : ex3.getMessage();
                    throw new KDBizException(tip);
                }
            }
        }
        finally {
            stats.addInfo("end-export.");
            log.info(stats.toString());
        }
    }

    private int setDataToBook(List<MemberTreeNode> nodes, int rowIndex, Sheet firstSheet) {
        if (CollectionUtils.isEmpty(nodes)) {
            return rowIndex;
        }
        Map<String, Header> headerData = this.getHeaderData();
        HashMap<String, Integer> numberRowHeadMap = new HashMap<String, Integer>(16);
        for (Map.Entry<String, Header> headerEntry : headerData.entrySet()) {
            String columnNum = headerEntry.getValue().getColumnNum();
            if (!StringUtils.isNotEmpty((String)columnNum)) continue;
            numberRowHeadMap.put(columnNum, Integer.parseInt(headerEntry.getKey()));
        }
        for (MemberTreeNode node : nodes) {
            if (this.filterMember(node)) {
                this.writeRow(rowIndex, firstSheet, node.getSelf(), numberRowHeadMap);
                ++rowIndex;
            }
            rowIndex = this.setDataToBook(node.sort().getChildren(), rowIndex, firstSheet);
        }
        return rowIndex;
    }

    protected boolean filterMember(MemberTreeNode member) {
        if (member == null) {
            return false;
        }
        return this.checkPermission(IDUtils.toLong((Object)member.getSelf().get("id"))) && !this.getMemberSource().contains((String)member.getSelf().get("membersource"));
    }

    protected Set<String> getMemberSource() {
        if (this.MEMBER_SOURCE == null) {
            this.MEMBER_SOURCE = new HashSet<String>();
            if (this.hasView()) {
                this.MEMBER_SOURCE.add(ViewMemberSourceEnum.PRESET.getIndex());
            } else {
                this.MEMBER_SOURCE.add(MemberSourceEnum.PRESET.getIndex());
                this.MEMBER_SOURCE.add(MemberSourceEnum.ANALYZE_VIEW.getIndex());
                this.MEMBER_SOURCE.add(MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
            }
        }
        return this.MEMBER_SOURCE;
    }

    protected IModelCacheHelper getModelCache() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    protected Model getModel() {
        return this.getModelCache().getModelobj();
    }

    protected Dimension getDimension() {
        if (this.dimension == null) {
            this.dimension = this.getModelCache().getDimension(Long.valueOf(this.getDimensionId()));
        }
        return this.dimension;
    }

    protected String getDimensionNumber() {
        return this.getDimension().getNumber();
    }

    protected void writeRow(int rowIndex, Sheet sheet, Map<String, Object> object, Map<String, Integer> headRowMap) {
        Integer disableRow;
        int cellNum = 0;
        Row row = sheet.createRow(rowIndex);
        this.setCellValue(row.createCell(cellNum++), (String)object.get("number"));
        if (!this.getModel().isModelByEB()) {
            this.setCellValue(row.createCell(cellNum++), (String)object.get("shownumber"));
        }
        this.setCellValue(row.createCell(cellNum++), (String)object.get("name"));
        this.setCellValue(row.createCell(cellNum++), (String)object.get("simplename"));
        this.setCellValue(row.createCell(cellNum++), (String)object.get("parent.number"));
        this.setSelfDataToBook(row, cellNum, object, headRowMap);
        Dimension dimension = this.getDimension();
        if ((Dimension.hasDisable((String)dimension.getDimNum()) || !dimension.isPreset()) && (disableRow = headRowMap.get("disable")) != null) {
            this.setCellValue(row.createCell(disableRow.intValue()), this.getVoUtils().getDisable(object.get("disable")));
        }
    }

    protected void setSelfDataToBook(Row row, int cellNum, Map<String, Object> object, Map<String, Integer> numberRowHeadMap) {
    }

    protected void exportCustomProperty(Row row, int cellNum, Map<String, Object> object) {
        if (this.getModel().isModelByBGMD() || this.getModel().isModelByNewEB()) {
            Map<String, CustomProperty> properties = this.getCustomProperties();
            if (CollectionUtils.isEmpty(properties)) {
                return;
            }
            for (Map.Entry<String, CustomProperty> entry : properties.entrySet()) {
                CustomPropertyValue propValue = this.getPropCache().getPropertyValueByMemNumber(this.getDimensionNumber(), entry.getKey(), (String)object.get("number"));
                if (propValue != null) {
                    this.setCellValue(row.createCell(cellNum), propValue.getNumber());
                }
                ++cellNum;
            }
        }
    }

    protected MemberPropCache getPropCache() {
        if (this.propCache == null) {
            this.propCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        }
        return this.propCache;
    }

    protected List<Map<String, Object>> getExportData() {
        List result;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryExportData", (String)this.getQueryMemberModel(), (String)this.getQueryFields(), (QFilter[])this.getQueryBuilder().toArray(), null);){
            result = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        this.queryExtData(result);
        this.queryUser(result);
        return result;
    }

    protected Map<Object, DynamicObject> getUser() {
        return this.user;
    }

    protected void queryExtData(List<Map<String, Object>> result) {
    }

    protected void queryUser(List<Map<String, Object>> result) {
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        LinkedHashSet userIds = Sets.newLinkedHashSet();
        result.forEach(obj -> this.getUserId((Map<String, Object>)obj, userIds));
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            this.user = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("id", "in", (Object)userIds).toArray());
        }
    }

    protected void getUserId(@NotNull Map<String, Object> obj, @NotNull Set<Long> userIds) {
    }

    protected String getQueryMemberModel() {
        if (this.hasView()) {
            return "eb_viewmember";
        }
        return this.getMemberKey();
    }

    protected String getQueryFields() {
        String fields = "id,number,name,aggoprt,dseq,disable,parent.id as parent,membersource";
        if (!this.getModel().isModelByEB()) {
            fields = fields + ",shownumber";
        }
        if (Dimension.hasSimpleName((String)this.getMemberKey())) {
            fields = fields + ",simpleName";
        }
        return fields;
    }

    protected QFBuilder getQueryBuilder() {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getModelId());
        builder.add("dimension", "=", (Object)this.getDimensionId());
        return builder;
    }

    public Set<Long> getPermissions() {
        if (!this.initPermission) {
            this.permissions = DimMembPermHelper.getPermMembIds((String)this.getDimensionNumber(), (Long)this.getModelId(), (Long)0L, (Long)this.getViewId(), (DimMembPermType)DimMembPermType.MANAGER, (boolean)true);
            if (this.permissions == null) {
                log.info("MemberPermValidator-is admin.");
            }
            this.initPermission = true;
        }
        return this.permissions;
    }

    protected boolean checkPermission(Long memberId) {
        return this.getPermissions() == null || this.getPermissions().contains(memberId);
    }

    /*
     * Exception decompiling
     */
    public static String writeFile(Workbook wb, String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Workbook getWorkbook() {
        return FileImportUtils.getInstance((ImportEntity)this.getImportEntity()).createImportTemplate();
    }

    protected void setCellValue(Cell cell, String value) {
        cell.setCellValue(value);
    }

    protected String getMemberKey() {
        return this.memberKey;
    }

    protected boolean hasView() {
        return !this.getModel().isModelByEB() && IDUtils.isNotNull((long)this.getViewId());
    }

    protected long getModelId() {
        return this.modelId;
    }

    protected long getDimensionId() {
        return this.dimensionId;
    }

    protected long getViewId() {
        return this.viewId;
    }

    protected ImportEntity getImportEntity() {
        if (this.importData == null) {
            try {
                Class<?> _clazz = Class.forName("kd.epm.eb.formplugin.importplugin.ImportContext");
                Constructor<?> constructor = _clazz.getDeclaredConstructor(IPageCache.class, IModelCacheHelper.class, String.class, String.class, String.class);
                Object _context = constructor.newInstance(null, this.getModelCache(), this.getDimensionNumber(), this.getDimension().getName(), this.getMemberKey());
                Class<?> _headClazz = Class.forName("kd.epm.eb.formplugin.importplugin.ImportTemplateHeader");
                Method _method = _headClazz.getMethod("get", _clazz);
                Object _header = _method.invoke(_clazz, _context);
                _method = _header.getClass().getMethod("getTemplateData", Boolean.TYPE);
                this.importData = (ImportEntity)_method.invoke(_header, false);
            }
            catch (Throwable ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
        return this.importData;
    }

    protected Map<String, Header> getHeaderData() {
        return this.getImportEntity().getSheetHeaderMap();
    }

    protected Map<String, CustomProperty> getCustomProperties() {
        if (this.getModel().isModelByBGMD() || this.getModel().isModelByNewEB()) {
            if (this.customProperties == null) {
                this.customProperties = DimensionPropertyServiceHelper.getInstance().queryDimCustomProperties(this.getModelId(), this.getDimensionId());
            }
            return this.customProperties;
        }
        return Collections.emptyMap();
    }

    private MemberTreeNode buildTree(List<Map<String, Object>> datas) {
        LinkedHashMap<Long, MemberTreeNode> dataMap = new LinkedHashMap<Long, MemberTreeNode>(datas.size());
        for (Map<String, Object> data : datas) {
            dataMap.put(IDUtils.toLong((Object)data.get("id")), new MemberTreeNode(data));
        }
        MemberTreeNode root = null;
        Member viewRootMember = null;
        if (IDUtils.isNotNull((long)this.getViewId())) {
            viewRootMember = this.getModelCache().getRootMember(this.getDimensionNumber(), Long.valueOf(this.getViewId()));
        }
        ArrayList<MemberTreeNode> noParentMember = new ArrayList<MemberTreeNode>(dataMap.size());
        for (MemberTreeNode entry : dataMap.values()) {
            MemberTreeNode parent = (MemberTreeNode)dataMap.get(IDUtils.toLong((Object)entry.getSelf().get("parent")));
            if (parent == null) {
                if (StringUtils.equals((String)this.getDimensionNumber(), (String)((String)entry.getSelf().get("number")))) {
                    root = entry;
                    continue;
                }
                if (viewRootMember != null && StringUtils.equals((String)viewRootMember.getNumber(), (String)((String)entry.getSelf().get("number")))) {
                    root = entry;
                    continue;
                }
                noParentMember.add(entry);
                continue;
            }
            parent.addChildren(entry);
            entry.getSelf().put("parent.number", parent.getSelf().get("number"));
        }
        Comparator<MemberTreeNode> _comparator = Comparator.comparingLong(n -> IDUtils.toLong((Object)n.getSelf().get("dseq")));
        _comparator.thenComparing(n -> (String)n.getSelf().get("number"));
        if (root != null) {
            root.allSort(_comparator);
            if (!noParentMember.isEmpty()) {
                root.addChildren(noParentMember);
            }
        }
        return root;
    }

    public static class MemberTreeNode
    implements Comparable<MemberTreeNode> {
        private final Map<String, Object> self;
        private List<MemberTreeNode> children = null;

        private MemberTreeNode(Map<String, Object> self) {
            this.self = self;
        }

        public List<MemberTreeNode> getChildren() {
            return this.children;
        }

        public void addChildren(MemberTreeNode child) {
            if (child == null) {
                return;
            }
            if (this.children == null) {
                this.children = Lists.newArrayList();
            }
            this.children.add(child);
        }

        public void addChildren(List<MemberTreeNode> children) {
            if (children == null || children.isEmpty()) {
                return;
            }
            if (this.children == null) {
                this.children = Lists.newArrayList();
            }
            this.children.addAll(children);
        }

        public Map<String, Object> getSelf() {
            return this.self;
        }

        public MemberTreeNode sort() {
            if (this.children != null) {
                Collections.sort(this.children);
            }
            return this;
        }

        public void allSort(Comparator<MemberTreeNode> comparator) {
            if (comparator == null || this.children == null) {
                return;
            }
            this.children.sort(comparator);
            for (MemberTreeNode _child : this.children) {
                _child.allSort(comparator);
            }
        }

        @Override
        public int compareTo(MemberTreeNode o) {
            Object seq1 = this.self.get("dseq");
            Object seq2 = o.getSelf().get("dseq");
            int compare = IDUtils.toLong((Object)seq1).compareTo(IDUtils.toLong((Object)seq2));
            if (compare == 0) {
                compare = ((String)this.self.get("number")).compareTo((String)o.getSelf().get("number"));
            }
            return compare;
        }
    }
}

