/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.ImportAndExport.Export;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.cube.dimension.ImportAndExport.Export.DimMemberExportBasePlugin;
import org.apache.poi.ss.usermodel.Row;
import org.jetbrains.annotations.NotNull;

public class EntityMemberExport
extends DimMemberExportBasePlugin {
    public EntityMemberExport(String memberKey, long modelId, long dimensionId, long viewId) {
        super(memberKey, modelId, dimensionId, viewId);
    }

    @Override
    protected String getQueryFields() {
        String fields = super.getQueryFields();
        fields = fields + ", modifier";
        fields = this.hasView() ? fields + ", modifydate as modifytime, memberid" : fields + ", modifytime, creator.id as creator, owner.id as owner, executor.id as executor, createtime, description";
        return fields;
    }

    @Override
    protected QFBuilder getQueryBuilder() {
        if (this.hasView()) {
            return this.getQueryViewBuilder();
        }
        return this.getQueryDefaultBuilder();
    }

    private QFBuilder getQueryDefaultBuilder() {
        QFBuilder builder = super.getQueryBuilder();
        builder.add("isoffsetentry", "=", (Object)"0");
        return builder;
    }

    private QFBuilder getQueryViewBuilder() {
        QFBuilder builder = super.getQueryBuilder();
        builder.add("view", "=", (Object)this.getViewId());
        builder.add("isoffsetentry", "=", (Object)"0");
        return builder;
    }

    @Override
    protected void queryExtData(List<Map<String, Object>> result) {
        super.queryExtData(result);
        if (this.hasView()) {
            LinkedHashMap memberMap = Maps.newLinkedHashMap();
            result.forEach(m -> memberMap.put((Long)m.get("memberid"), m));
            String fields = "id,modifytime,creator.id as creator,owner.id as owner,executor.id as executor,createtime,description";
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMember", (String)this.getMemberKey(), (String)fields, (QFilter[])this.getQueryDefaultBuilder().toArray(), null);){
                if (ds != null) {
                    for (kd.bos.algo.Row row : ds) {
                        Map object = (Map)memberMap.get(row.getLong("id"));
                        if (object == null) continue;
                        object.put("creator", row.getLong("creator"));
                        object.put("owner", row.getLong("owner"));
                        object.put("executor", row.getLong("executor"));
                        object.put("createtime", row.getDate("createtime"));
                        object.put("description", row.getString("description"));
                    }
                }
            }
        }
    }

    @Override
    protected void queryUser(List<Map<String, Object>> result) {
        super.queryUser(result);
        for (Map<String, Object> member : result) {
            DynamicObject user = this.getUser().get(member.get("owner"));
            if (user != null) {
                member.put("owner.name", user.getString("name"));
                member.put("owner.number", user.getString("number"));
            }
            if ((user = this.getUser().get(member.get("executor"))) != null) {
                member.put("executor.name", user.getString("name"));
                member.put("executor.number", user.getString("number"));
            }
            if ((user = this.getUser().get(member.get("creator"))) != null) {
                member.put("creator.name", user.getString("name"));
                member.put("creator.number", user.getString("number"));
            }
            if ((user = this.getUser().get(member.get("modifier"))) == null) continue;
            member.put("modifier.name", user.getString("name"));
            member.put("modifier.number", user.getString("number"));
        }
    }

    @Override
    protected void getUserId(@NotNull Map<String, Object> obj, @NotNull Set<Long> userIds) {
        userIds.add(IDUtils.toLong((Object)obj.get("owner")));
        userIds.add(IDUtils.toLong((Object)obj.get("executor")));
        userIds.add(IDUtils.toLong((Object)obj.get("creator")));
        userIds.add(IDUtils.toLong((Object)obj.get("modifier")));
    }

    @Override
    protected void setSelfDataToBook(Row row, int cellNum, Map<String, Object> object, Map<String, Integer> numberRowHeadMap) {
        Integer descriptionRow;
        this.setCellValue(row.createCell(cellNum++), this.getVoUtils().getAggOprt(object.get("aggoprt")));
        this.setCellValue(row.createCell(cellNum++), (String)object.get("owner.name"));
        this.setCellValue(row.createCell(cellNum++), (String)object.get("owner.number"));
        this.setCellValue(row.createCell(cellNum++), (String)object.get("executor.name"));
        this.setCellValue(row.createCell(cellNum++), (String)object.get("executor.number"));
        this.exportCustomProperty(row, cellNum, object);
        Integer creatorRow = numberRowHeadMap.get("creator.name");
        if (creatorRow != null) {
            int rowIndex = creatorRow;
            this.setCellValue(row.createCell(rowIndex++), (String)object.get("creator.name"));
            this.setCellValue(row.createCell(rowIndex++), DateTimeUtils.format((LocalDateTime)DateTimeUtils.parse((Date)((Date)object.get("createtime"))), (DateTimeFormatter)DateTimeUtils.DEFAULT_FORMAT));
            this.setCellValue(row.createCell(rowIndex++), (String)object.get("modifier.name"));
            this.setCellValue(row.createCell(rowIndex), DateTimeUtils.format((LocalDateTime)DateTimeUtils.parse((Date)((Date)object.get("modifytime"))), (DateTimeFormatter)DateTimeUtils.DEFAULT_FORMAT));
        }
        if ((descriptionRow = numberRowHeadMap.get("description")) != null) {
            this.setCellValue(row.createCell(descriptionRow.intValue()), (String)object.get("description"));
        }
    }
}

