/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.olap.OlapServiceCaller;
import org.apache.commons.collections4.CollectionUtils;

public class QuoteAction {
    protected DimManagerInfo dimInfo;

    public QuoteAction(DimManagerInfo dimInfo) {
        this.dimInfo = dimInfo;
    }

    public static QuoteAction getInstance(DimManagerInfo dimInfo) {
        return new QuoteAction(dimInfo);
    }

    public boolean checkData() {
        if (this.dimInfo.getMember().isIsleaf()) {
            String dimNumber;
            long modelId = this.dimInfo.getModel().getId();
            DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model");
            List datasets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)(dimNumber = this.dimInfo.getDimension().getNumber()));
            if (CollectionUtils.isEmpty((Collection)datasets)) {
                return false;
            }
            if (ShrekConfigServiceHelper.isStartShrek()) {
                HashSet<String> memberNumbers = new HashSet<String>();
                memberNumbers.add(this.dimInfo.getMember().getNumber());
                return ShrekOlapServiceHelper.existCubeData((Model)Model.of((DynamicObject)model), (List)datasets, (String)dimNumber, memberNumbers);
            }
            OlapServiceCaller olapServiceCaller = new OlapServiceCaller();
            HashSet<Long> memberids = new HashSet<Long>(2);
            memberids.add(this.dimInfo.getMember().getId());
            return olapServiceCaller.existData(Long.valueOf(this.dimInfo.getModel().getId()), this.dimInfo.getDimension().getNumber(), memberids);
        }
        return false;
    }

    private List<MembersKey> queryOneOlapData(Map<String, String[]> filters) {
        Dataset dataset;
        String[] dims;
        if (filters == null || filters.size() == 0) {
            return Collections.emptyList();
        }
        IModelCacheHelper modelContext = ModelCacheContext.getOrCreate((Long)this.dimInfo.getModel().getId());
        Model model = modelContext.getModelobj();
        if (model.isModelByEB()) {
            dims = modelContext.getDimensionNums();
            dataset = new Dataset(model.getId(), model.getNumber());
        } else {
            Long datasetId = modelContext.getDimension(this.dimInfo.getDimension().getNumber()).getMember(this.dimInfo.getViewId(), this.dimInfo.getMember().getNumber()).getDatasetId();
            dims = modelContext.getDimensionNums(datasetId);
            dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
        }
        SelectCommandInfo query = new SelectCommandInfo();
        query.addDims(dims);
        query.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        for (Map.Entry<String, String[]> entry : filters.entrySet()) {
            query.addFilter(entry.getKey(), entry.getValue());
        }
        MembersKey cell = ShrekOlapServiceHelper.queryOne((Model)model, (Dataset)dataset, (SelectCommandInfo)query);
        if (cell != null) {
            ArrayList<MembersKey> membersKeys = new ArrayList<MembersKey>();
            membersKeys.add(cell);
            return membersKeys;
        }
        return Collections.emptyList();
    }

    public boolean checkLeafDataForEb() {
        if (this.dimInfo.getMember().isIsleaf()) {
            HashMap<String, String[]> filters = new HashMap<String, String[]>(4);
            filters.put(this.dimInfo.getDimension().getNumber(), new String[]{this.dimInfo.getMember().getNumber()});
            return this.queryOneOlapData(filters).size() > 0;
        }
        return false;
    }
}

