/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.entitys;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.cube.dimension.entitys.DatasetInfo;
import kd.epm.eb.cube.dimension.entitys.DimensionInfo;
import kd.epm.eb.cube.dimension.entitys.MemberInfo;
import kd.epm.eb.cube.dimension.entitys.ModelInfo;
import kd.epm.eb.cube.dimension.entitys.ViewInfo;
import kd.epm.eb.olap.service.view.bean.DimensionViewGroup;

public class DimManagerInfo
implements Serializable {
    private static final long serialVersionUID = 3597236289118883475L;
    private ModelInfo model = null;
    private DimensionInfo dimension = null;
    private ViewInfo view = null;
    private MemberInfo member = null;
    private DatasetInfo dataset = null;
    private DimensionViewGroup dimensionViewGroup = null;

    public ModelInfo getModel() {
        return this.model;
    }

    public DimensionInfo getDimension() {
        return this.dimension;
    }

    public ViewInfo getView() {
        return this.view;
    }

    public MemberInfo getMember() {
        return this.member;
    }

    public DatasetInfo getDataset() {
        return this.dataset;
    }

    public DimManagerInfo() {
    }

    public DimManagerInfo(long modelId, long dimensionId, long memberId) {
        this.model = new ModelInfo(modelId);
        this.dimension = new DimensionInfo(dimensionId);
        this.view = new ViewInfo(0L, "baseview", ResManager.loadKDString((String)"\u57fa\u51c6\u89c6\u56fe", (String)"DimManagerInfo_0", (String)"epm-eb-cube", (Object[])new Object[0]), "baseview", 0, "-1", "1");
        this.member = new MemberInfo(memberId, this.dimension.getMembermodel());
    }

    public DimManagerInfo(long modelId, long dimensionId, long memberId, long viewId) {
        this.model = new ModelInfo(modelId);
        this.dimension = new DimensionInfo(dimensionId);
        if (viewId == 0L) {
            this.view = new ViewInfo(0L, "baseview", ResManager.loadKDString((String)"\u57fa\u51c6\u89c6\u56fe", (String)"DimManagerInfo_0", (String)"epm-eb-cube", (Object[])new Object[0]), "baseview", 0, "-1", "1");
            this.member = new MemberInfo(memberId, this.dimension.getMembermodel());
        } else {
            this.view = new ViewInfo(viewId);
            this.member = new MemberInfo(memberId, "eb_viewmember");
        }
    }

    public void setModel(long modelid) {
        if (this.model == null || modelid != this.model.getId()) {
            this.model = new ModelInfo(modelid);
        }
    }

    public void setDimension(long dimensionId) {
        if (this.dimension == null || dimensionId != this.dimension.getId()) {
            this.dimension = new DimensionInfo(dimensionId);
        }
    }

    public void setDataset(long datasetId) {
        if (this.dataset == null || datasetId != this.dataset.getId()) {
            this.dataset = new DatasetInfo(datasetId);
        }
    }

    public void setView(Long viewId) {
        if (viewId == null) {
            return;
        }
        if (this.view == null || viewId.compareTo(this.view.getId()) != 0) {
            this.view = viewId == 0L ? new ViewInfo(viewId, "baseview", ResManager.loadKDString((String)"\u57fa\u51c6\u89c6\u56fe", (String)"DimManagerInfo_0", (String)"epm-eb-cube", (Object[])new Object[0]), "baseview", 0, "-1", "1") : new ViewInfo(viewId);
        }
    }

    public void setMember(long memId) {
        if (this.member == null || memId != this.member.getId()) {
            Long viewId = this.view != null ? this.view.getId() : 0L;
            if (this.dimension == null) {
                return;
            }
            String entityNumber = this.dimension.getMembermodel();
            if (0L != viewId) {
                entityNumber = "eb_viewmember";
            }
            this.member = new MemberInfo(memId, entityNumber);
        }
    }

    public void setMemberNull() {
        this.member = null;
    }

    public long getModelId() {
        return this.getModel().getId();
    }

    public long getDimensionId() {
        return this.getDimension().getId();
    }

    public Long getViewId() {
        return this.getView() != null ? this.getView().getId() : 0L;
    }

    public long getMemberId() {
        return this.getMember().getId();
    }
}

