/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.entitys;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class MemberInfo
implements Serializable {
    private static final long serialVersionUID = -33535752942395897L;
    private long id;
    private String number;
    private String name;
    private long parentId;
    private String membersource;
    private String longnumber;
    private int level;
    private boolean isleaf;
    private boolean isShareMember = false;
    private int seq = 0;

    public MemberInfo(long id, String memberKey) {
        this.id = id;
        DynamicObject ob = this.queryMember(memberKey);
        if (ob != null) {
            String storageType;
            if (!"eb_viewmember".equals(memberKey) && StringUtils.isNotEmpty((String)(storageType = ob.getString("storagetype"))) && StorageTypeEnum.SHARE == StorageTypeEnum.getStorageTypeEnumByIndex((String)storageType)) {
                this.isShareMember = true;
            }
            this.number = ob.getString("number");
            this.name = ob.getString("name");
            this.parentId = ob.getLong("parent");
            this.isleaf = ob.getBoolean("isleaf");
            this.longnumber = ob.getString("longnumber");
            this.level = ob.getInt("level");
            this.membersource = ob.getString("membersource");
        }
    }

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getMembersource() {
        return this.membersource;
    }

    public String getLongnumber() {
        return this.longnumber;
    }

    public int getLevel() {
        return this.level;
    }

    public long getParentId() {
        return this.parentId;
    }

    public boolean isIsleaf() {
        return this.isleaf;
    }

    public boolean isShareMember() {
        return this.isShareMember;
    }

    private DynamicObject queryMember(String memberKey) {
        DynamicObject object;
        QFBuilder builder = new QFBuilder();
        builder.add("id", "=", (Object)this.id);
        String field = "id,number,name,longnumber,level,membersource,parent,isleaf";
        if (!"eb_viewmember".equals(memberKey)) {
            field = field + ",storagetype";
        }
        if ((object = QueryServiceHelper.queryOne((String)memberKey, (String)field, (QFilter[])builder.toArray())) == null) {
            object = QueryServiceHelper.queryOne((String)"eb_dimsharemember", (String)field, (QFilter[])builder.toArray());
        }
        return object;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public int getSeq() {
        return this.seq;
    }
}

