/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.entitys;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.QFBuilder;

public class ModelInfo
implements Serializable {
    private static final long serialVersionUID = -6792332717158697258L;
    private long id;
    private String number;
    private String name;
    private String cubeNumber;
    private String reporttype;
    private List<String> periodStatus;
    private String periodDetailed = "halfyear";

    public ModelInfo(long id) {
        this.id = id;
        DynamicObject object = this.queryModel();
        this.number = object.getString("shownumber");
        this.name = object.getString("name");
        this.cubeNumber = object.getString("number");
        this.reporttype = object.getString("reporttype");
        this.periodStatus = this.setPeriodStatusByDy(object);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCubeNumber() {
        return this.cubeNumber;
    }

    public void setCubeNumber(String cubeNumber) {
        this.cubeNumber = cubeNumber;
    }

    public String getReporttype() {
        return this.reporttype;
    }

    public void setReporttype(String reporttype) {
        this.reporttype = reporttype;
    }

    public List<String> getPeriodStatus() {
        return this.periodStatus;
    }

    public String getPeriodDetailed() {
        return this.periodDetailed;
    }

    private DynamicObject queryModel() {
        String field = "id,number,name,shownumber,reporttype,isdetailtomonth,isdetailtoqrt,mincludeqrt,mincludeyear,qrtincludeyear ";
        DynamicObject _model = BusinessDataServiceHelper.loadSingleFromCache((Object)this.id, (String)"epm_model", (String)field);
        if (_model == null) {
            QFBuilder builder = new QFBuilder();
            builder.add("id", "=", (Object)this.id);
            _model = QueryServiceHelper.queryOne((String)"epm_model", (String)field, (QFilter[])builder.toArrays());
        }
        return _model;
    }

    private List<String> setPeriodStatusByDy(DynamicObject object) {
        ArrayList<String> list = new ArrayList<String>(2);
        if (object.getBoolean("isdetailtomonth")) {
            if (!object.getBoolean("mincludeqrt")) {
                list.add("quarter");
            }
            if (!object.getBoolean("mincludeyear")) {
                list.add("halfyear");
            }
            this.periodDetailed = "month";
        } else if (object.getBoolean("isdetailtoqrt")) {
            if (!object.getBoolean("qrtincludeyear")) {
                list.add("halfyear");
            }
            this.periodDetailed = "quarter";
        }
        return list;
    }

    public boolean isBgmd() {
        return ApplicationTypeEnum.isBGMD((String)this.getReporttype());
    }

    public boolean isEb() {
        return ApplicationTypeEnum.isEB((String)this.getReporttype());
    }
}

