/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.saveop;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.MessageType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.FactoryChangeEvent;
import kd.epm.eb.common.eventbus.event.PropValueChangeEvent;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.SimpleNameUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.obj.ObjectUtils;
import kd.epm.eb.cube.dimension.savevalidator.DimensionMemberSaveValidator;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;

public class DimensionMemberSaveOp
extends AbstractOperationServicePlugIn {
    protected boolean isAdd = true;
    protected boolean isEb = false;
    protected Map<Long, Long> oldPropertyIds = null;
    private boolean upModelCacheVersion = false;
    private static final String[] equalsProp = new String[]{"number", "name", "aggoprt", "parent", "disable", "hasAgg", "simplename"};
    private DynamicObject oldMember = null;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DimensionMemberSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DimensionViewMember dimensionViewMember;
        super.beginOperationTransaction(e);
        String viewIdString = this.getOption().getVariableValue("viewId", "0");
        long viewId = StringUtils.isEmpty((String)viewIdString) ? 0L : Long.parseLong(viewIdString);
        String viewMemberIdString = this.getOption().getVariableValue("viewMemberId", "0");
        long parentViewMemberId = StringUtils.isEmpty((String)viewMemberIdString) ? 0L : Long.parseLong(viewMemberIdString);
        DynamicObject dyTree = e.getDataEntities()[0];
        String entityNumber = dyTree.getDynamicObjectType().getName();
        boolean hasSimpleName = SimpleNameUtils.hasSimpleName((String)entityNumber);
        Long memberId = dyTree.getLong("id");
        String dimNumber = dyTree.getString("dimension.number");
        this.isEb = ApplicationTypeEnum.EB.getIndex().equals(dyTree.getString("model.reporttype"));
        String fields = hasSimpleName ? "id,name,disable,simplename" : "id,name,disable";
        DynamicObject oldMember = QueryServiceHelper.queryOne((String)entityNumber, (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)memberId)});
        this.isAdd = oldMember == null;
        dyTree.set("longnumber", (Object)(dyTree.get("parent.longnumber") + "!" + dyTree.get("number")));
        if (this.isAdd) {
            this.setUpModelCacheVersion();
            boolean isleaf = dyTree.getDynamicObject("parent").getBoolean("isleaf");
            if (isleaf) {
                DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)dyTree.getLong("parent.id"), (String)entityNumber);
                parent.set("isleaf", (Object)0);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
            }
            dyTree.set("status", (Object)"C");
            dyTree.set("enable", (Object)"1");
        } else {
            boolean oldDisable;
            boolean disable;
            DynamicObject dyTreeOld = this.getOldMember(memberId, entityNumber);
            if (dyTreeOld.getDynamicObjectType().getProperties().containsKey((Object)"propertyentry")) {
                DynamicObjectCollection properties = dyTreeOld.getDynamicObjectCollection("propertyentry");
                this.oldPropertyIds = properties.stream().filter(pv -> pv.get("propertyvalue") != null).collect(Collectors.toMap(p -> p.getLong("propertyvalue.id"), p -> p.getLong("propertyvalue.property.id"), (o1, o2) -> o2));
            }
            if (!this.equalDynamicObject(dyTree, dyTreeOld)) {
                this.setUpModelCacheVersion();
            }
            if ((disable = dyTree.getBoolean("disable")) != (oldDisable = dyTreeOld.getBoolean("disable"))) {
                List children;
                List ids;
                long modelId = dyTree.getLong("model_id");
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                Member member = modelCacheHelper.getMember(dimNumber, Long.valueOf(viewId), memberId);
                if (disable && org.apache.commons.collections4.CollectionUtils.isNotEmpty(ids = (children = modelCacheHelper.getChildren(member, false).stream().filter(o -> !o.isDisable()).collect(Collectors.toList())).stream().map(BaseCache::getId).collect(Collectors.toList()))) {
                    DynamicObject[] viewMembers;
                    DynamicObject[] dys;
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and(new QFilter("id", "in", ids));
                    for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,disable,disabledate,disabler", (QFilter[])qFilter.toArray())) {
                        dy.set("disable", (Object)true);
                        dy.set("disabledate", (Object)TimeServiceHelper.now());
                        dy.set("disabler", (Object)UserUtils.getUserId());
                    }
                    SaveServiceHelper.save((DynamicObject[])dys);
                    QFilter qFilter1 = new QFilter("dimension", "=", (Object)dyTree.getLong("dimension.id"));
                    qFilter1.and(new QFilter("memberid", "in", ids));
                    for (DynamicObject dy : viewMembers = BusinessDataServiceHelper.load((String)"eb_viewmember", (String)"id,disable", (QFilter[])qFilter1.toArray())) {
                        dy.set("disable", (Object)true);
                    }
                    SaveServiceHelper.save((DynamicObject[])viewMembers);
                }
            }
        }
        if (!View.NoViewDimNums.contains(dimNumber) && !this.isEb && (dimensionViewMember = ViewMemberManager.getInstance().buildViewMemberByOldMember(dyTree, Long.valueOf(viewId), Long.valueOf(parentViewMemberId), Boolean.valueOf(this.isAdd))) != null) {
            ViewMemberManager.getInstance().saveViewMemberOnly(dimensionViewMember.getModel().longValue(), dimNumber, Long.valueOf(viewId), dimensionViewMember);
            OperationResult operationResult = this.getOperationResult();
            operationResult.setMessage(String.valueOf(dimensionViewMember.getViewMemberId()));
            operationResult.setMessageType(MessageType.Notice.getValue());
            operationResult.setShowMessage(false);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject savedMember = e.getDataEntities()[0];
        this.upModelCacheVersion(savedMember);
        String dimensionNumber = savedMember.getDynamicObject("dimension").getString("number");
        if (View.NoViewDimNums.contains(dimensionNumber) || this.isEb) {
            if (this.isAdd) {
                this.syncOlapData(savedMember);
            } else {
                this.updateMemberToOlap(savedMember);
            }
        }
        if (!this.isEb) {
            DynamicObjectCollection properties;
            Map<Long, Long> propertyValueIds;
            Long dimensionId = savedMember.getLong("dimension_id");
            String memKey = SysDimensionEnum.getMemberTreemodelByNumber((String)dimensionNumber);
            if (CustomPropertyUtils.hasCustomPropertyByEntityNumber((String)memKey) && !ObjectUtils.equals(propertyValueIds = (properties = savedMember.getDynamicObjectCollection("propertyentry")).stream().filter(pv -> pv.get("propertyvalue") != null).collect(Collectors.toMap(p -> p.getLong("propertyvalue.id"), p -> p.getLong("propertyvalue.property.id"))), this.oldPropertyIds)) {
                HashSet<Long> checkPropertyIds = new HashSet<Long>();
                for (Map.Entry<Long, Long> entry : propertyValueIds.entrySet()) {
                    if (this.oldPropertyIds == null || this.oldPropertyIds.containsKey(entry.getKey())) continue;
                    checkPropertyIds.add(entry.getValue());
                }
                if (this.oldPropertyIds != null) {
                    for (Map.Entry<Long, Long> entry : this.oldPropertyIds.entrySet()) {
                        if (propertyValueIds.containsKey(entry.getKey())) continue;
                        checkPropertyIds.add(entry.getValue());
                    }
                }
                long modelId = savedMember.getLong("model.id");
                MemberPropCacheService.updateVersion((Long)modelId, (Long)dimensionId);
                if (!this.isUpModelCacheVersion()) {
                    CubeUtils.clearCentralizedCache((Long)modelId, (Long)dimensionId);
                    DimMembPermVerHelper.updateVer4MembChanged(null, (Long)modelId, (Long)dimensionId, (String)"DimensionMemberSaveOp_1");
                }
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u66f4\u65b0\u81ea\u5b9a\u4e49\u5c5e\u6027", "DimensionMemberSaveOp_0", "epm-eb-cube");
                OperationLogUtil.log((String)"bgmd", (String)memKey, (String)savedMember.getString("number"), (String)"save", (MultiLangEnumBridge)opName, null, null);
                EventBusUtil.asyncPost((Object)new PropValueChangeEvent(Long.valueOf(modelId)));
            }
            Long modelId = savedMember.getLong("model_id");
            Long parentId = savedMember.getLong("parent_id");
            Long userId = UserUtils.getUserId();
            String traceId = RequestContext.get().getTraceId();
            EventBusUtil.asyncPost((Object)new FactoryChangeEvent(modelId, dimensionId, CollectionUtils.asSet((Object[])new Long[]{savedMember.getLong("id"), parentId}), userId, traceId));
        }
    }

    protected boolean isUpModelCacheVersion() {
        return this.upModelCacheVersion;
    }

    protected void setUpModelCacheVersion() {
        this.upModelCacheVersion = true;
    }

    protected void upModelCacheVersion(DynamicObject member) {
        if (this.isUpModelCacheVersion()) {
            CubeUtils.get().checkMember(member);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u66f4\u65b0\u4f53\u7cfb\u7248\u672c", "DimensionMemberSaveOp_1", "epm-eb-cube");
            OperationLogUtil.log((String)"bgmd", (String)"epm_model", (String)member.getString("model.number"), (String)"update", (MultiLangEnumBridge)opName);
        }
    }

    protected boolean equalDynamicObject(DynamicObject newObj, DynamicObject oldObj) {
        DataEntityPropertyCollection properties = newObj.getDataEntityType().getProperties();
        for (String property : equalsProp) {
            if (!properties.containsKey((Object)property) || ObjectUtils.equals((Object)newObj.get(property), (Object)oldObj.get(property))) continue;
            return false;
        }
        return true;
    }

    public DynamicObject getOldMember(Long memberId, String entityNumber) {
        if (this.oldMember == null) {
            this.oldMember = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)entityNumber);
        }
        return this.oldMember;
    }

    protected void syncOlapData(DynamicObject dyTree) {
        DynamicObject modelObj = dyTree.getDynamicObject("model");
        String dimensionNumber = dyTree.getDynamicObject("dimension").getString("number");
        List<Dataset> datasets = this.getDataSets(dyTree, false);
        if (datasets.size() > 0) {
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)modelObj);
            boolean isAccount = "Account".equals(dimensionNumber);
            ShrekOlapServiceHelper.addCubeMembers((Model)Model.of((DynamicObject)modelObj), datasets, (String)dimensionNumber, (List)Member.of(Collections.singletonList(dyTree), (boolean)isAccount), (ShrekConfig)config);
        }
    }

    protected List<Dataset> getDataSets(DynamicObject dyTree, boolean isModify) {
        DynamicObject modelObj = dyTree.getDynamicObject("model");
        String dimensionNumber = dyTree.getDynamicObject("dimension").getString("number");
        if (ModelServiceHelper.isBGMDModel((Long)modelObj.getLong("id")) && ShrekOlapServiceHelper.needDMLOlap((DynamicObject)modelObj) && SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            DynamicObject datasetDoj = dyTree.getDynamicObject("dataset");
            Dataset dataset = new Dataset(Long.valueOf(datasetDoj.getLong("id")), datasetDoj.getString("number"));
            return Collections.singletonList(dataset);
        }
        if (isModify) {
            return DatasetServiceHelper.getDatasetsForModify((DynamicObject)modelObj, (String)dimensionNumber);
        }
        return DatasetServiceHelper.getDatasets((DynamicObject)modelObj, (String)dimensionNumber);
    }

    private void updateMemberToOlap(DynamicObject dyTree) {
        DynamicObject modelObj = dyTree.getDynamicObject("model");
        String dimensionNumber = dyTree.getDynamicObject("dimension").getString("number");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelObj.getLong("id"));
        Model model = Model.of((DynamicObject)modelObj);
        if (this.isEb) {
            Member member = modelCacheHelper.getMember(dimensionNumber, null, Long.valueOf(dyTree.getLong("id")));
            Member parent = modelCacheHelper.getParent(null, member);
            EbShrekOlapServiceHelper.updateCubeMember((Model)model, (String)dimensionNumber, (Member)member);
            EbShrekOlapServiceHelper.updateCubeMember((Model)model, (String)dimensionNumber, (Member)parent);
        } else {
            List<Dataset> datasets = this.getDataSets(dyTree, true);
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)modelObj);
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(datasets)) {
                for (Dataset dataset : datasets) {
                    Member parent;
                    Map viewsMap = modelCacheHelper.getViewGroupViewsByDataSet(dataset.getId());
                    Member member = null;
                    if (viewsMap != null) {
                        List viewIds = (List)viewsMap.get(dimensionNumber);
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)viewIds)) {
                            Long view;
                            Iterator iterator = viewIds.iterator();
                            while (iterator.hasNext() && (member = modelCacheHelper.getMember(dimensionNumber, view = (Long)iterator.next(), Long.valueOf(dyTree.getLong("id")))) == null) {
                            }
                        }
                    } else {
                        member = modelCacheHelper.getMember(dimensionNumber, Long.valueOf(0L), Long.valueOf(dyTree.getLong("id")));
                    }
                    if (member == null) continue;
                    member.setAggType(dyTree.getString("aggoprt"));
                    ShrekOlapServiceHelper.updateCubeMember((Model)model, (Dataset)dataset, (String)dimensionNumber, (Member)member, (ShrekConfig)config);
                    Long viewId = 0L;
                    if (member instanceof ViewMember) {
                        viewId = ((ViewMember)member).getViewId();
                    }
                    if ((parent = modelCacheHelper.getParent(viewId, member)) == null) continue;
                    ShrekOlapServiceHelper.updateCubeMember((Model)model, (Dataset)dataset, (String)dimensionNumber, (Member)parent, (ShrekConfig)config);
                }
            }
        }
    }

    protected void updateViewMemberProperties(DynamicObject member) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_viewmember", (String)"name,simplename", (QFilter[])new QFilter[]{new QFilter("memberid", "=", (Object)member.getLong("id"))});
        if (load != null && load.length > 0) {
            String name = member.getString("name");
            boolean isNeedUpdateSimple = this.isNeedUpdateSimpleName();
            for (DynamicObject object : load) {
                object.set("name", (Object)name);
                if (!isNeedUpdateSimple) continue;
                object.set("simplename", (Object)member.getString("simplename"));
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    public SysDimensionEnum getCurrentDimensionEnum() {
        return null;
    }

    protected boolean isNeedUpdateSimpleName() {
        String dimensionNumber = this.getCurrentDimensionEnum().getNumber();
        return SysDimensionEnum.Entity.getNumber().equals(dimensionNumber) || !SysDimensionEnum.include((String)dimensionNumber, (Boolean)true);
    }
}

