/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.saveop;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.saveop.DimensionMemberSaveOp;
import kd.epm.eb.cube.dimension.savevalidator.EntityMemberSaveValidator;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;

public class EntityMemberSaveOp
extends DimensionMemberSaveOp {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EntityMemberSaveValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject dyTree = e.getDataEntities()[0];
        if (StringUtils.isEmpty((String)dyTree.getString("number"))) {
            dyTree.set("number", (Object)dyTree.getString("shownumber"));
        }
        if (!this.isAdd) {
            this.handleOffsetEntity(e);
        }
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject savedMember = e.getDataEntities()[0];
        DynamicObject model = savedMember.getDynamicObject("model");
        if (this.isAdd && this.isEb) {
            AppCacheServiceHelper.removeTemplateDispenseCache((String)EntityMemberSaveOp.getModelNumber(model.getLong("id")));
        }
    }

    private static String getModelNumber(Long modelId) {
        return MemberReader.findModelNumberById((Object)modelId);
    }

    public String getTreeModelType() {
        return "epm_entitymembertree";
    }

    @Override
    public SysDimensionEnum getCurrentDimensionEnum() {
        return SysDimensionEnum.Entity;
    }

    private void handleOffsetEntity(BeginOperationTransactionArgs e) {
        boolean newMergerNode;
        boolean mergerNodeChanged;
        long viewId = IDUtils.toLong((Object)this.getOption().getVariableValue("viewId", "0"));
        long parentViewMemberId = IDUtils.toLong((Object)this.getOption().getVariableValue("viewMemberId", "0"));
        DynamicObject dyTree = e.getDataEntities()[0];
        String entityNumber = dyTree.getDynamicObjectType().getName();
        Long fid = dyTree.getLong("id");
        Long modelId = dyTree.getLong("model.id");
        String number = dyTree.getString("number");
        DynamicObject dyTreeOld = this.getOldMember(fid, entityNumber);
        boolean oldMergerNode = dyTreeOld.getBoolean("mergernode");
        boolean bl = mergerNodeChanged = oldMergerNode != (newMergerNode = dyTree.getBoolean("mergernode"));
        if (!mergerNodeChanged) {
            return;
        }
        if (oldMergerNode) {
            QFilter qFilter1 = new QFilter("orgs.org.id", "=", (Object)fid);
            qFilter1.and("model", "=", (Object)modelId);
            boolean exists = QueryServiceHelper.exists((String)"eb_offsetrule", (QFilter[])qFilter1.toArray());
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u5df2\u5728\u62b5\u9500\u89c4\u5219\u4e2d\u4f7f\u7528\uff0c\u8bf7\u5148\u5728\u62b5\u9500\u89c4\u5219\u4e2d\u7981\u7528\u3002", (String)"EntityMemberEdit_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            QFilter qfModel = new QFilter("model", "=", (Object)modelId);
            QFilter qfId = new QFilter("cslorg", "=", (Object)fid);
            boolean existOffsetData = QueryServiceHelper.exists((String)"eb_offsetentry", (QFilter[])new QFilter[]{qfModel, qfId});
            if (existOffsetData) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u8303\u56f4\u7ec4\u7ec7\uff08\u57fa\u51c6\u6216\u7f16\u5236\u89c6\u56fe\uff09\u5df2\u751f\u6210\u62b5\u9500\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u5408\u5e76\u8282\u70b9\u5c5e\u6027\u3002", (String)"EntityMemberEdit_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObject offsetEntryObj = this.checkExistOffsetEntry(number, viewId);
            if (offsetEntryObj != null) {
                ViewMemberManager.getInstance().delViewMemberToRawView(modelId.longValue(), SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId), offsetEntryObj.getLong("memberid"));
            }
        } else {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Dimension dimension = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
            DynamicObject rawParentDy = BusinessDataServiceHelper.loadSingle((Object)parentViewMemberId, (String)"eb_viewmember");
            int maxDSeq = ViewMemberManager.getInstance().getMaxDSeq(rawParentDy.getLong("id"), "eb_viewmember", viewId);
            String offsetEntryNumber = number + "offsetentry";
            String offsetEntryName = ResManager.loadKDString((String)"\u62b5\u9500\u5206\u5f55", (String)"ViewMemberEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            DimensionViewMember vm = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setNumber, (Object)offsetEntryNumber).with(DimensionViewMember::setParentId, (Object)rawParentDy.getLong("id")).with(DimensionViewMember::setParentMemberId, (Object)rawParentDy.getLong("memberid")).with(DimensionViewMember::setShowNumber, (Object)offsetEntryNumber).with(DimensionViewMember::setName, (Object)offsetEntryName).with(DimensionViewMember::setViewMembersource, (Object)ViewMemberSourceEnum.ADD.getIndex()).with(DimensionViewMember::setLevel, (Object)(rawParentDy.getInt("level") + 1)).with(DimensionViewMember::setLongNumber, (Object)(rawParentDy.getString("longnumber") + "!" + offsetEntryNumber)).with(DimensionViewMember::setIsLeaf, (Object)true).with(DimensionViewMember::setView, (Object)viewId).with(DimensionViewMember::setDimension, (Object)dimension.getId()).with(DimensionViewMember::setModel, (Object)modelId).with(DimensionViewMember::setDseq, (Object)(++maxDSeq)).with(DimensionViewMember::setIsoffsetentry, (Object)"1").with(DimensionViewMember::setCurrency, (Object)dyTree.getLong("currency.id")).build();
            ViewMemberManager.getInstance().insertViewAndDimMember(modelId.longValue(), SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId), Collections.singletonList(vm));
        }
    }

    private DynamicObject checkExistOffsetEntry(String memberNumber, long viewId) {
        QFilter qFilter1 = new QFilter("number", "=", (Object)(memberNumber + "offsetentry"));
        QFilter qFilter2 = new QFilter("isoffsetentry", "=", (Object)true);
        QFilter qFilter3 = new QFilter("view", "=", (Object)viewId);
        return QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"id,memberid", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
    }
}

