/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.savevalidator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.NumberTipTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NameCheckUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.model.utils.DimMemberNumberUtil;

public class DimensionMemberSaveValidator
extends AbstractValidator {
    protected boolean isedit = false;
    protected ExtendedDataEntity dataEntities;

    public void validate() {
        this.dataEntities = this.getDataEntities()[0];
        DynamicObject dynamicObject = this.dataEntities.getDataEntity();
        DynamicObject dot = this.dataEntities.getDataEntity();
        long memberIdLong = dot.getLong("id");
        this.isedit = QueryServiceHelper.exists((String)this.entityKey, (Object)memberIdLong);
        String nameString = dot.getString("name");
        String number = dynamicObject.getString("number");
        String showNumber = dynamicObject.getString("shownumber");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        long model = dot.getLong("model.id");
        long dimensionIdLong = dot.getLong("dimension.id");
        qFilters.add(new QFilter("model", "=", (Object)model));
        qFilters.add(new QFilter("dimension", "=", (Object)dimensionIdLong));
        if (!this.nameCheck(qFilters, dot)) {
            return;
        }
        Long viewIdLong = IDUtils.toLong((Object)this.getOption().getVariableValue("viewId", "0"));
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimensionIdLong));
        String dimensionNumber = dimension.getNumber();
        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            long dataset = dot.getLong("dataset.id");
            NameCheckUtils.checkViewExistNameBoolean((IModelCacheHelper)modelCacheHelper, (Long)dimensionIdLong, (Long)viewIdLong, (Long)memberIdLong, (String)nameString, (Long)dataset);
        } else {
            NameCheckUtils.checkViewExistNameBoolean((IModelCacheHelper)modelCacheHelper, (Long)dimensionIdLong, (Long)viewIdLong, (Long)memberIdLong, (String)nameString, null);
        }
        this.checkParent();
        if (!this.isedit) {
            DynamicObject parent = dot.getDynamicObject("parent");
            String codeNumbernumber = DimMemberNumberUtil.getCodeNumber((IModelCacheHelper)modelCacheHelper, (String)dimensionNumber, (DynamicObject)parent, (boolean)false);
            if (StringUtils.isNotEmpty((String)codeNumbernumber)) {
                dot.set("number", (Object)codeNumbernumber);
            } else if (!this.checkNumberOnly(new ArrayList<QFilter>(qFilters), number)) {
                return;
            }
            this.dataEntities.setBillNo(ResManager.loadResFormat((String)"\u7f16\u7801 %s", (String)"DimensionMemberSaveValidator_0", (String)"epm-eb-cube", (Object[])new Object[]{number}));
            if (View.NoViewDimNums.contains(dimensionNumber) || this.isEB()) {
                this.codingRuleCheck(number);
            } else {
                boolean passedBoolean = this.validateShowNumber(dimension, showNumber);
                if (passedBoolean) {
                    this.codingRuleCheck(number);
                }
            }
        }
    }

    protected boolean numberCheck(List<QFilter> qFilters, DynamicObject member) {
        String number = member.getString("number");
        this.dataEntities.setBillNo(ResManager.loadResFormat((String)"\u7f16\u7801 %s", (String)"DimensionMemberSaveValidator_0", (String)"epm-eb-cube", (Object[])new Object[]{number}));
        if (!this.isedit) {
            return this.codingRuleCheck(number) && this.checkNumberOnly(new ArrayList<QFilter>(qFilters), number);
        }
        return true;
    }

    protected boolean codingRuleCheck(String newnumber) {
        boolean check = true;
        if (!this.isedit) {
            check = this.doCheck(newnumber);
        }
        if (newnumber != null && org.apache.commons.lang3.StringUtils.endsWithIgnoreCase((CharSequence)newnumber, (CharSequence)"._inv")) {
            this.addErrorMessage(this.dataEntities, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5'._inv'\u7ed3\u5c3e", (String)"DimensionMemberSaveValidator_21", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        this.afterCodingRuleCheck(check, null);
        return check;
    }

    protected void afterCodingRuleCheck(boolean passedBoolean, NumberTipTypeEnum numberTipTypeEnum) {
        if (passedBoolean) {
            return;
        }
        DynamicObject dot = this.dataEntities.getDataEntity();
        long modelId = dot.getLong("model.id");
        Boolean needOffsetentryTipBoolean = !this.isEB() && SysDimensionEnum.Entity.getNumber().equals(this.getEntityKey());
        if (NumberTipTypeEnum.CODE == numberTipTypeEnum || this.isEB() && !NewEbAppUtil.isNewEbModel((Long)modelId)) {
            this.addErrorMessage(this.dataEntities, NumberCheckUtils.getNumberTipString((NumberTipTypeEnum)NumberTipTypeEnum.CODE, (Boolean)false, (Boolean)needOffsetentryTipBoolean));
        } else {
            this.addErrorMessage(this.dataEntities, NumberCheckUtils.getNumberTipString((NumberTipTypeEnum)NumberTipTypeEnum.INTERNAL_CODE, (Boolean)false, (Boolean)needOffsetentryTipBoolean));
        }
    }

    protected boolean doCheck(String newnumber) {
        return NumberCheckUtils.checkNumber((String)newnumber) && !newnumber.equalsIgnoreCase("other") && !newnumber.equalsIgnoreCase("all") && !newnumber.equalsIgnoreCase("none") && !newnumber.equalsIgnoreCase("null");
    }

    protected boolean validateShowNumber(Dimension dimension, String showNumberString) {
        boolean passedBoolean = true;
        if (!this.isedit) {
            passedBoolean = this.checkShowNumberBoolean(dimension, showNumberString);
        }
        if (showNumberString != null && org.apache.commons.lang3.StringUtils.endsWithIgnoreCase((CharSequence)showNumberString, (CharSequence)"._inv")) {
            this.addErrorMessage(this.dataEntities, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5'._inv'\u7ed3\u5c3e", (String)"DimensionMemberSaveValidator_21", (String)"epm-eb-cube", (Object[])new Object[0]));
            return passedBoolean;
        }
        this.afterCodingRuleCheck(passedBoolean, NumberTipTypeEnum.CODE);
        return passedBoolean;
    }

    protected boolean checkShowNumberBoolean(Dimension dimension, String numberString) {
        return NumberCheckUtils.checkShowNumberBoolean((Dimension)dimension, (String)numberString) && !numberString.equalsIgnoreCase("other") && !numberString.equalsIgnoreCase("all") && !numberString.equalsIgnoreCase("none") && !numberString.equalsIgnoreCase("null");
    }

    protected boolean checkNumberOnly(List<QFilter> qFilters, String newNumber) {
        block18: {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMemberNumber", (String)this.entityKey, (String)"id,number, model.id", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
                if (ds == null) break block18;
                for (Row row : ds) {
                    if (!newNumber.equalsIgnoreCase(row.getString("number"))) continue;
                    if (this.isEB() && !NewEbAppUtil.isNewEbModel((Long)row.getLong("model.id"))) {
                        this.addErrorMessage(this.dataEntities, ResManager.loadResFormat((String)"\u7f16\u7801\u201c%1\u201d\u5df2\u5b58\u5728\u4e8e\u8be5\u4f53\u7cfb\u4e2d\u3002", (String)"DimensionMemberSaveValidator_24", (String)"epm-eb-cube", (Object[])new Object[]{newNumber}));
                    } else {
                        this.addErrorMessage(this.dataEntities, ResManager.loadResFormat((String)"\u5185\u7801\u201c%1\u201d\u5df2\u5b58\u5728\u4e8e\u8be5\u4f53\u7cfb\u4e2d\u3002", (String)"DimensionMemberSaveValidator_23", (String)"epm-eb-cube", (Object[])new Object[]{newNumber}));
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    protected boolean nameCheck(List<QFilter> qFilters, DynamicObject member) {
        this.dataEntities.setBillNo(ResManager.loadResFormat((String)"\u540d\u79f0 %s", (String)"DimensionMemberSaveValidator_11", (String)"epm-eb-cube", (Object[])new Object[]{member.getString("name")}));
        return this.checkNameOnly(new ArrayList<QFilter>(qFilters), member);
    }

    protected boolean checkNameOnly(List<QFilter> qFilters, DynamicObject member) {
        String name = member.getString("name");
        if (this.checkSpcialDemension(this.entityKey) && StringUtils.isNotEmpty((String)name)) {
            qFilters.add(new QFilter("name", "=", (Object)name.trim()));
            if (this.isedit) {
                qFilters.add(new QFilter("id", "!=", (Object)member.getLong("id")));
            }
        }
        return true;
    }

    protected void checkParent() {
        DynamicObject parent;
        DynamicObject member;
        this.dataEntities = this.getDataEntities()[0];
        if (this.dataEntities != null && (member = this.dataEntities.getDataEntity()) != null && (parent = member.getDynamicObject("parent")) != null) {
            QFBuilder builder = new QFBuilder();
            builder.add("id", "=", (Object)member.getLong("parent.id"));
            if (!QueryServiceHelper.exists((String)this.entityKey, (QFilter[])builder.toArrays())) {
                this.addErrorMessage(this.dataEntities, ResManager.loadKDString((String)"\u4e0a\u7ea7\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimensionMemberSaveValidator_12", (String)"epm-eb-cube", (Object[])new Object[0]));
            }
        }
    }

    protected boolean checkSpcialDemension(String treeModelType) {
        return !"epm_entitymembertree".equals(treeModelType) && !"epm_accountmembertree".equals(treeModelType);
    }

    protected boolean isEB() {
        String appnumber = this.getValidateContext().getOption().getVariableValue("appnumber");
        return ApplicationTypeEnum.EB.getAppnum().equals(appnumber);
    }
}

