/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.savevalidator;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.savevalidator.DimensionMemberSaveValidator;

public class InterCompanyMemberSaveValidator
extends DimensionMemberSaveValidator {
    @Override
    public void validate() {
        super.validate();
        this.checkParentAndChild();
    }

    @Override
    protected boolean numberCheck(List<QFilter> qFilters, DynamicObject member) {
        if (!super.numberCheck(qFilters, member)) {
            return false;
        }
        if (!this.isedit) {
            Long modelId = member.getLong("model.id");
            String number = member.getString("number");
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter qfNumber = new QFilter("number", "=", (Object)number);
            boolean exists = QueryServiceHelper.exists((String)"epm_entitymembertree", (QFilter[])new QFilter[]{modelFilter, qfNumber});
            if (exists) {
                this.addErrorMessage(this.dataEntities, ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u4e2d\u5b58\u5728\u540c\u7f16\u7801\u6210\u5458\uff0c\u8bf7\u4fee\u6539\u7f16\u7801\u3002", (String)"InterCompanyMemberSaveValidator_0", (String)"epm-eb-cube", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected void checkParentAndChild() {
        this.dataEntities = this.getDataEntities()[0];
        DynamicObject member = this.dataEntities.getDataEntity();
        if (this.isedit) {
            return;
        }
        DynamicObject modelObject = member.getDynamicObject("model");
        Model model = Model.of((DynamicObject)modelObject);
        if (model.isModelByEB() || model.isModelByNewEB()) {
            return;
        }
        Long modelId = member.getLong("model.id");
        Long dimensionId = member.getLong("dimension.id");
        String number = member.getString("number");
        DynamicObject parent = member.getDynamicObject("parent");
        if (parent != null && !StringUtils.equals((String)"ICEntity", (String)parent.getString("number"))) {
            return;
        }
        String viewIdString = this.getOption().getVariableValue("viewId", "0");
        Long viewId = StringUtils.isEmpty((String)viewIdString) ? 0L : Long.parseLong(viewIdString);
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "=", (Object)"Entity");
        DynamicObject entityDim = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_dimension", (String)"id", (QFilter[])builder.toArray());
        boolean re = this.checkParent(modelId, dimensionId, viewId, number, entityDim);
        if (re) {
            this.checkChildren(modelId, dimensionId, viewId, number, entityDim);
        }
    }

    protected boolean checkParent(Long modelId, Long dimensionId, Long viewId, String number, DynamicObject entityDim) {
        LinkedHashSet parents = Sets.newLinkedHashSet();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select flongnumber from t_eb_viewmember where fmodelid = ? and fdimensionid = ? and fnumber = ?", new Object[]{modelId, entityDim.getLong("id"), number});
        try (DataSet ds = DB.queryDataSet((String)"queryMember", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    String longNumber = row.getString("flongnumber");
                    if (longNumber == null) continue;
                    parents.addAll(Arrays.asList(longNumber.split("!")));
                }
                parents.remove(number);
            }
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("view", "=", (Object)viewId);
        builder.add("dimension", "=", (Object)dimensionId);
        builder.add("number", "in", (Object)parents);
        DynamicObject icMember = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"id,name,number", (QFilter[])builder.toArray());
        if (icMember != null) {
            String msg = StringUtils.join((Object[])new String[]{icMember.getString("name"), icMember.getString("number")}, (char)'-');
            this.addErrorMessage(this.dataEntities, ResManager.loadResFormat((String)"\u5728\u5f53\u524d\u5f80\u6765\u7ec4\u7ec7\u89c6\u56fe\u4e2d\u5b58\u5728\u5f53\u524d\u7f16\u7801\u7684\u7ec4\u7ec7\u6210\u5458\u7684\u4e0a\u4e0b\u7ea7\u5185\u90e8\u5f80\u6765\u7ec4\u7ec7\u6210\u5458(%1)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InterCompanyMemberSaveValidator_1", (String)"epm-eb-cube", (Object[])new Object[]{msg}));
            return false;
        }
        return true;
    }

    protected void checkChildren(Long modelId, Long dimensionId, Long viewId, String number, DynamicObject entityDim) {
        block13: {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            builder.add("view", "=", (Object)viewId);
            builder.add("number", "=", (Object)"ICEntity");
            DynamicObject icEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_viewmember", (String)"id", (QFilter[])builder.toArray());
            SqlBuilder sql = new SqlBuilder();
            sql.append("select e.fid, e.fnumber, e.flongnumber from t_eb_viewmember e where e.fmodelid = ? and e.fdimensionid = ? and exists (select ic.fnumber from t_eb_viewmember ic where ic.fmodelid = ? and ic.fdimensionid = ? and ic.fparentid = ? and e.fnumber = ic.fnumber)", new Object[]{modelId, entityDim.getLong("id"), modelId, dimensionId, icEntity.getLong("id")});
            try (DataSet ds = DB.queryDataSet((String)"queryMember", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds == null) break block13;
                for (Row row : ds) {
                    String _number = row.getString("fnumber");
                    String _longNumber = row.getString("flongnumber");
                    if (_longNumber == null || StringUtils.equals((String)number, (String)_number) || !CollectionUtils.asSet((Object[])_longNumber.split("!")).contains(number)) continue;
                    DynamicObject icMember = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getLong("fid"), (String)"eb_viewmember", (String)"id,number,name");
                    String msg = StringUtils.join((Object[])new String[]{icMember.getString("name"), icMember.getString("number")}, (char)'-');
                    this.addErrorMessage(this.dataEntities, ResManager.loadResFormat((String)"\u5728\u5f53\u524d\u5f80\u6765\u7ec4\u7ec7\u89c6\u56fe\u4e2d\u5b58\u5728\u5f53\u524d\u7f16\u7801\u7684\u7ec4\u7ec7\u6210\u5458\u7684\u4e0a\u4e0b\u7ea7\u5185\u90e8\u5f80\u6765\u7ec4\u7ec7\u6210\u5458(%1)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InterCompanyMemberSaveValidator_1", (String)"epm-eb-cube", (Object[])new Object[]{msg}));
                    break;
                }
            }
        }
    }
}

