/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.dimension.savevalidator;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.cube.dimension.savevalidator.DimensionMemberSaveValidator;

public class YearMemberSaveValidator
extends DimensionMemberSaveValidator {
    @Override
    public void validate() {
        super.validate();
    }

    @Override
    protected boolean numberCheck(List<QFilter> qFilters, DynamicObject member) {
        if (!super.numberCheck(qFilters, member)) {
            return false;
        }
        if (this.isedit) {
            return true;
        }
        String pnumber = member.getString("parent.number");
        String number = member.getString("number");
        if ("Year".equals(pnumber) && number.toLowerCase(Locale.getDefault()).startsWith("fy")) {
            this.addErrorMessage(this.dataEntities, ResManager.loadKDString((String)"\u4e00\u822c\u8d22\u5e74\u4e0d\u80fd\u4ee5fy\u6216FY\u5f00\u5934", (String)"YearMemberSaveValidator_0", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        return this.checkNumberLegal(member);
    }

    private boolean checkNumberLegal(DynamicObject member) {
        String number = member.getString("number");
        if (member.getInt("level") == 3) {
            if (number.matches("FY[\\d]{4}")) {
                Calendar calendar = Calendar.getInstance();
                int cuYear = calendar.get(1);
                int rangeSize = 50;
                int year = Integer.parseInt(number.substring(2));
                if (year <= cuYear + rangeSize && year >= cuYear - rangeSize) {
                    return true;
                }
            }
            this.addErrorMessage(this.dataEntities, ResManager.loadKDString((String)"\u6807\u51c6\u8d22\u5e74\u7f16\u7801\u5fc5\u987b\u4ee5FY\u5f00\u59cb\uff0c\u4ee5\u6570\u5b57\u7ed3\u675f\u3002", (String)"YearMemberSaveValidator_1", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

