/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.model.validators.BgmdModelDeleteValidator;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BgmdModelDeleteOp
extends AbstractOperationServicePlugIn {
    private List<Dataset> datasets;
    private int total;
    private Boolean hasMainSub = false;
    private static final String[][] deleteModelStrs = new String[][]{{"eb_bizruleentity", "model"}, {"epm_userselect", "model"}, {"eb_tasklist", "model"}, {"eb_tasklistgroup", "model"}, {"eb_task", "model"}, {"eb_approvaltype", "model"}, {"eb_examine", "model"}, {"eb_examinecategory", "model"}, {"eb_examinecheck", "model"}};

    private Boolean mainSubModel(Set<Long> modelIds) {
        QFilter qFilter;
        DynamicObjectCollection dynamicObjects;
        if (CollectionUtils.isNotEmpty(modelIds) && CollectionUtils.isNotEmpty((Collection)(dynamicObjects = QueryServiceHelper.query((String)"epm_model", (String)"id,level", (QFilter[])(qFilter = new QFilter("id", "in", modelIds)).toArray())))) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (StringUtils.equals((String)"0", (String)dynamicObject.getString("level"))) continue;
                return true;
            }
        }
        return false;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            HashSet<Long> ids = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                ids.add(dynamicObject.getLong("id"));
            }
            this.hasMainSub = this.mainSubModel(ids);
            this.total = dynamicObjects.length;
        }
        e.addValidator((AbstractValidator)new BgmdModelDeleteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("id");
        fields.add("name");
        fields.add("number");
        fields.add("shownumber");
        fields.add("version");
        fields.add("reportType");
        fields.add("datasource");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        CubeUtils utils = CubeUtils.get();
        try (TXHandle th = TX.required();){
            try {
                DynamicObject[] models;
                for (DynamicObject model : models = e.getDataEntities()) {
                    long modelId = Long.parseLong(model.getPkValue().toString());
                    QFilter[] filters = new QFilter("model.id", "=", (Object)modelId).toArray();
                    utils.deleteCube(Long.valueOf(modelId));
                    this.deleteBussinessTable(modelId, model.getString("number"));
                    this.deleteDataset(modelId);
                    this.deleteBusinessModel(modelId);
                    this.deleteDimensionMember(filters, this.getMemberKeys(modelId));
                    this.deleteProperty(modelId);
                    this.deleteDimension(filters);
                    this.deleteViewAndViewMember(modelId);
                    this.deleteModel(modelId);
                    this.deleteMainSubModel(modelId);
                    ModelUtils.updateDataSourceState();
                }
            }
            catch (Exception ex) {
                th.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    private void deletePerms(long modelId) {
        FunPermissionHelper.delPermBymodelId((Long)modelId);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        if (this.hasMainSub.booleanValue() && e.getDataEntities().length != this.total) {
            e.setCancel(true);
            return;
        }
        DynamicObject dataEntity = e.getDataEntities()[0];
        if ("7".equals(dataEntity.getString("reporttype")) || "6".equals(dataEntity.getString("reporttype"))) {
            this.datasets = Dataset.of((Map)DataSetServiceHelper.loadDatasets((Long)dataEntity.getLong("id")));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] models;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject model : models = e.getDataEntities()) {
            Model modelObj = Model.of((DynamicObject)model);
            if (modelObj.isModelByEB()) {
                ShrekOlapServiceHelper.dropCube((Model)modelObj, Collections.singletonList(new Dataset(Long.valueOf(model.getLong("id")), model.getString("shownumber"))));
            } else if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
                ShrekOlapServiceHelper.dropCube((Model)modelObj, this.datasets);
            }
            this.deletePerms(Long.parseLong(model.getPkValue().toString()));
        }
        ModelSyncHelper.deleteEpbsModel((Collection)Arrays.stream(models).map(dyn -> Long.valueOf(dyn.getPkValue().toString())).collect(Collectors.toList()));
    }

    private List<String> getMemberKeys(long modelId) {
        QFilter filter = new QFilter("model.id", "=", (Object)modelId);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"epm_dimension", (String)"membermodel", (QFilter[])filter.toArray(), (String)"");
        if (dcs != null && !dcs.isEmpty()) {
            return dcs.stream().map(dc -> dc.getString("membermodel")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private void deleteDimensionMember(QFilter[] filters, List<String> memberKeys) {
        for (String memberKey : memberKeys) {
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)memberKey, (String)"id", (QFilter[])filters, (String)"");
            if (dcs == null || dcs.isEmpty()) continue;
            List list = dcs.stream().map(dc -> dc.getLong("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)memberKey, (QFilter[])new QFilter("id", "in", list).toArray());
        }
    }

    private void deleteDimension(QFilter[] filters) {
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"epm_dimension", (String)"id", (QFilter[])filters, (String)"");
        if (dcs != null && !dcs.isEmpty()) {
            List list = dcs.stream().map(dc -> dc.getLong("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)"epm_dimension", (QFilter[])new QFilter("id", "in", list).toArray());
        }
    }

    private void deleteModel(long modelId) {
        DeleteServiceHelper.delete((String)"epm_model", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray());
    }

    private void deleteMainSubModel(long modelId) {
        DeleteServiceHelper.delete((String)"eb_mainsubmodel_base", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray());
    }

    private void deleteViewAndViewMember(long modelId) {
        if (modelId == 0L) {
            return;
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        DeleteServiceHelper.delete((String)"eb_viewmember", (QFilter[])qf.toArray());
        DeleteServiceHelper.delete((String)"eb_dimensionview", (QFilter[])qf.toArray());
    }

    private void deleteBussinessTable(long modelId, String modelNumber) {
        for (String[] str : deleteModelStrs) {
            QFilter[] filters = new QFilter(str[1], "=", (Object)modelId).toArray();
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)str[0], (String)"id", (QFilter[])filters, (String)"");
            if (dcs == null || dcs.isEmpty()) continue;
            List list = dcs.stream().map(dc -> dc.getLong("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)str[0], (QFilter[])new QFilter("id", "in", list).toArray());
        }
        DBRoute epm = new DBRoute("epm");
        DB.execute((DBRoute)epm, (String)("delete from t_eb_member_quote where fmodelnumber='" + modelNumber + "'"));
        DB.execute((DBRoute)epm, (String)"delete from t_eb_examineresult where not exists (select fresultid from t_eb_examinecheck where fresultid = t_eb_examineresult.fid)");
    }

    private void deleteBusinessModel(long modelId) {
        if (IDUtils.isNull((long)modelId)) {
            return;
        }
        QFilter[] filters = new QFilter("model", "=", (Object)modelId).toArray();
        DeleteServiceHelper.delete((String)"eb_applicationscenario", (QFilter[])filters);
        DeleteServiceHelper.delete((String)"eb_dataset", (QFilter[])filters);
    }

    private void deleteProperty(long modelId) {
        if (IDUtils.isNull((long)modelId)) {
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"eb_customproperty", (QFilter[])filter.toArray(), null, (int)1000);
        if (pks != null && !pks.isEmpty()) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("delete from t_eb_custompropertyvalue where ", new Object[0]).appendIn("fpropertyid", pks);
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            sql = new SqlBuilder();
            sql.append("delete from t_eb_customproperty where ", new Object[0]).appendIn("fid", pks);
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        }
    }

    private void deleteDataset(long modelId) {
        if (IDUtils.isNull((long)modelId)) {
            return;
        }
        DeleteServiceHelper.delete((String)"eb_businessmodel", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
    }
}

