/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.model;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.model.preDimensionHelper.PreDimensionUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.AppUtil;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.cube.model.validators.BgmdModelSaveValidator;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import kd.epm.eb.model.serviceHelper.InitModelServiceHelper;

public class BgmdModelSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(BgmdModelSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BgmdModelSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject model = e.getDataEntities()[0];
        this.initCommmonInformation(model);
        InitModelServiceHelper.preSetModelPerm((DynamicObject)model);
        PreDimensionUtil pre = new PreDimensionUtil(model, "4".equals(model.getString("reporttype")) ? ApplicationTypeEnum.EB : ApplicationTypeEnum.BGMD);
        List dimemtrees = pre.resolveDimemTrees();
        pre.afterModelSaveBGMD(dimemtrees, true);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject model = e.getDataEntities()[0];
                ApplicationTypeEnum app = ApplicationTypeEnum.BGMD;
                if (ApplicationTypeEnum.EB.getIndex().equals(model.getString("reporttype"))) {
                    app = ApplicationTypeEnum.EB;
                } else if (ApplicationTypeEnum.BG.getIndex().equals(model.getString("reporttype"))) {
                    app = ApplicationTypeEnum.BG;
                }
                long id = DBServiceHelper.genGlobalLongId();
                model.set("id", (Object)id);
                if (AppUtil.isEpmAppId((String)app.getAppnum())) {
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"addEPMPermByUser", (Object[])new Object[]{id, UserUtils.getUserId(), app.getAppnum(), app.getIndex()});
                }
            }
            catch (Throwable ex) {
                log.error("model-save-error:", ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject model = e.getDataEntities()[0];
        if ("7".equals(model.getString("reporttype")) || ApplicationTypeEnum.BG.getIndex().equals(model.getString("reporttype"))) {
            CubeUtils utils = CubeUtils.get();
            utils.checkCube(Long.valueOf(model.getLong("id")));
        }
        this.createOlapCube(model);
    }

    private void initCommmonInformation(DynamicObject model) {
        String beginyearofmonth = model.getString("beginyearofmonth");
        String beginperiod = model.getString("beginperiod");
        String beginPeriodText = "1".equals(beginyearofmonth) ? ResManager.loadResFormat((String)"\u5f53\u5e74%1\u6708", (String)"BgmdModelSaveOp_1", (String)"epm-eb-cube", (Object[])new Object[]{beginperiod}) : ResManager.loadResFormat((String)"\u4e0a\u5e74%1\u6708", (String)"BgmdModelSaveOp_2", (String)"epm-eb-cube", (Object[])new Object[]{beginperiod});
        model.set("beginperiodtext", (Object)beginPeriodText);
        model.set("status", (Object)"C");
        model.set("mainsubstatus", (Object)"0");
        if ("4".equals(model.getString("reporttype"))) {
            model.set("number", (Object)("CUBE" + model.getString("shownumber") + model.getString("id")));
        }
    }

    private void createOlapCube(DynamicObject model) {
        long modelId = model.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dataset dataset = null;
        if ("4".equals(model.getString("reporttype"))) {
            dataset = new Dataset(Long.valueOf(modelId), model.getString("shownumber"));
        } else if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
            dataset = Dataset.of((DynamicObject)DataSetServiceHelper.loadDefault((Long)modelId));
            dataset.addDimension(modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber()));
        }
        if (dataset != null) {
            ShrekOlapServiceHelper.createCube((Model)Model.of((DynamicObject)model), (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model));
        }
    }
}

