/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.model;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum DetailedPeriodEnum {
    Month("isdetailtomonth", DetailedPeriodEnum.getMonthName(), Arrays.asList(PulldownValue.No, PulldownValue.PHalfYear, PulldownValue.PSeason, PulldownValue.PHalfYearAndSeason)),
    Season("isdetailtoqrt", DetailedPeriodEnum.getSeasonName(), Arrays.asList(PulldownValue.No, PulldownValue.SHalfYear)),
    HalfYear("isdetailtohalfyear", DetailedPeriodEnum.getHalfYearName(), null);

    private String key;
    private MultiLangEnumBridge name;
    private List<PulldownValue> pulldownValues;

    private DetailedPeriodEnum(String key, MultiLangEnumBridge name, List<PulldownValue> pulldownValues) {
        this.key = key;
        this.name = name;
        this.pulldownValues = pulldownValues;
    }

    public static DetailedPeriodEnum getEnumByKey(String key) {
        for (DetailedPeriodEnum value : DetailedPeriodEnum.values()) {
            if (!value.key.equals(key)) continue;
            return value;
        }
        return Month;
    }

    public static List<String> getSubEnumLegalKeys(String key) {
        DetailedPeriodEnum enumByKey = DetailedPeriodEnum.getEnumByKey(key);
        List<PulldownValue> pulldownValues = enumByKey.pulldownValues;
        LinkedList<String> keys = new LinkedList<String>();
        if (pulldownValues != null) {
            for (PulldownValue pulldownValue : pulldownValues) {
                if (PulldownValue.No == pulldownValue || PulldownValue.PHalfYearAndSeason == pulldownValue) continue;
                keys.add(pulldownValue.key);
            }
        }
        return keys;
    }

    private static MultiLangEnumBridge getNoName() {
        return new MultiLangEnumBridge("\u65e0", "DetailedPeriodEnum_0", "epm-eb-cube");
    }

    private static MultiLangEnumBridge getMonthName() {
        return new MultiLangEnumBridge("\u6708", "DetailedPeriodEnum_1", "epm-eb-cube");
    }

    private static MultiLangEnumBridge getSeasonName() {
        return new MultiLangEnumBridge("\u5b63\u5ea6", "DetailedPeriodEnum_2", "epm-eb-cube");
    }

    private static MultiLangEnumBridge getSeasonAndHalfYear() {
        return new MultiLangEnumBridge("\u5b63\u5ea6+\u534a\u5e74", "DetailedPeriodEnum_4", "epm-eb-cube");
    }

    private static MultiLangEnumBridge getHalfYearName() {
        return new MultiLangEnumBridge("\u534a\u5e74", "DetailedPeriodEnum_3", "epm-eb-cube");
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public List<PulldownValue> getPulldownValues() {
        return this.pulldownValues;
    }

    static /* synthetic */ MultiLangEnumBridge access$000() {
        return DetailedPeriodEnum.getNoName();
    }

    static /* synthetic */ MultiLangEnumBridge access$100() {
        return DetailedPeriodEnum.getHalfYearName();
    }

    static /* synthetic */ MultiLangEnumBridge access$200() {
        return DetailedPeriodEnum.getSeasonName();
    }

    static /* synthetic */ MultiLangEnumBridge access$300() {
        return DetailedPeriodEnum.getSeasonAndHalfYear();
    }

    public static enum PulldownValue {
        No("no", DetailedPeriodEnum.access$000()),
        PHalfYear("mincludeyear", DetailedPeriodEnum.access$100()),
        PSeason("mincludeqrt", DetailedPeriodEnum.access$200()),
        PHalfYearAndSeason("mincludeyear+mincludeqrt", DetailedPeriodEnum.access$300()),
        SHalfYear("qrtincludeyear", DetailedPeriodEnum.access$100());

        private String key;
        private MultiLangEnumBridge name;

        private PulldownValue(String key, MultiLangEnumBridge name) {
            this.key = key;
            this.name = name;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name.loadKDString();
        }
    }
}

