/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.cube.model.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class BgmdModelDeleteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntitiess = this.getDataEntities();
        ArrayList<String> templateList = new ArrayList<String>();
        ArrayList<ExtendedDataEntity> dyList = new ArrayList<ExtendedDataEntity>();
        ArrayList<String> listperm = new ArrayList<String>();
        ArrayList<ExtendedDataEntity> dypermList = new ArrayList<ExtendedDataEntity>();
        ArrayList<String> listcVersion = new ArrayList<String>(dataEntitiess.length);
        ArrayList<ExtendedDataEntity> dycVersionList = new ArrayList<ExtendedDataEntity>(dataEntitiess.length);
        ArrayList<String> listdimmaterule = new ArrayList<String>(dataEntitiess.length);
        ArrayList<ExtendedDataEntity> dydimmateruleList = new ArrayList<ExtendedDataEntity>(dataEntitiess.length);
        ArrayList<String> listdimmembermapping = new ArrayList<String>(dataEntitiess.length);
        ArrayList<ExtendedDataEntity> dydimmembermappingList = new ArrayList<ExtendedDataEntity>(dataEntitiess.length);
        ArrayList<String> listTask = new ArrayList<String>(dataEntitiess.length);
        ArrayList<ExtendedDataEntity> dyTask = new ArrayList<ExtendedDataEntity>(dataEntitiess.length);
        ArrayList<String> rules = new ArrayList<String>(dataEntitiess.length);
        ArrayList<ExtendedDataEntity> rulesDe = new ArrayList<ExtendedDataEntity>(dataEntitiess.length);
        ArrayList<String> ctrlDims = new ArrayList<String>(dataEntitiess.length);
        ArrayList<ExtendedDataEntity> ctrlDimsDe = new ArrayList<ExtendedDataEntity>(dataEntitiess.length);
        ArrayList<String> cent = new ArrayList<String>(dataEntitiess.length);
        ArrayList<ExtendedDataEntity> centDe = new ArrayList<ExtendedDataEntity>(dataEntitiess.length);
        String appNum = this.getValidateContext().getOption().getVariableValue("appnumber");
        boolean isEb = ApplicationTypeEnum.EB.getAppnum().equals(appNum);
        String key = isEb ? "eb_templateentity_bg" : "eb_templateentity";
        long modelId = 0L;
        HashSet<Long> set = new HashSet<Long>(16);
        for (ExtendedDataEntity de : dataEntitiess) {
            set.add(de.getDataEntity().getLong("id"));
        }
        Set<Long> allMainSubModelIds = this.checkMainSubModel(set);
        for (ExtendedDataEntity de : dataEntitiess) {
            DynamicObject dot = de.getDataEntity();
            modelId = dot.getLong("id");
            String name = dot.getString("name");
            if (this.isExitTemplate(modelId, key)) {
                templateList.add(name);
                dyList.add(de);
            }
            if (!this.hasDeletePerm(modelId)) {
                listperm.add(name);
                dypermList.add(de);
            }
            if (this.isExitControlVersion(modelId)) {
                listcVersion.add(name);
                dycVersionList.add(de);
            }
            if (this.isExitDimMateRule(modelId)) {
                listdimmaterule.add(name);
                dydimmateruleList.add(de);
            }
            if (this.isExitControlDims(modelId)) {
                ctrlDims.add(name);
                ctrlDimsDe.add(de);
            }
            if (this.isExitControlRule(modelId)) {
                rules.add(name);
                rulesDe.add(de);
            }
            if (this.isExitControlCentralized(modelId)) {
                cent.add(name);
                centDe.add(de);
            }
            if (this.isExitDimMemberMapping(modelId)) {
                listdimmembermapping.add(name);
                dydimmembermappingList.add(de);
            }
            if (!isEb && this.isExitTask(modelId)) {
                listTask.add(name);
                dyTask.add(de);
            }
            try {
                CubeUtils.get().checkDeleteModel(dot);
            }
            catch (KDBizException ex) {
                this.addErrorMessage(de, ex.getMessage());
            }
        }
        if (templateList.size() > 0 && !allMainSubModelIds.contains(modelId)) {
            for (int i = 0; i < templateList.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c%1\u5df2\u7ecf\u5b58\u5728\u6a21\u677f\u8bb0\u5f55\u3002", (String)"BgmdModelDeleteValidator_0", (String)"epm-eb-cube", (Object[])new Object[]{templateList.get(i)});
                this.addErrorMessage((ExtendedDataEntity)dyList.get(i), sb);
            }
        }
        if (listperm.size() > 0) {
            for (int i = 0; i < listperm.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c\u60a8\u6ca1\u6709\u201c%1\u201d\u4f53\u7cfb\u7684\u5220\u9664\u6743\u9650\u3002", (String)"BgmdModelDeleteValidator_1", (String)"epm-eb-cube", (Object[])new Object[]{listperm.get(i)});
                this.addErrorMessage((ExtendedDataEntity)dypermList.get(i), sb);
            }
        }
        if (listcVersion != null && listcVersion.size() > 0) {
            for (int i = 0; i < listcVersion.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1\u201d\u5df2\u5b58\u5728\u63a7\u5236\u7248\u672c\u8bb0\u5f55\u3002", (String)"BgmdModelDeleteValidator_3", (String)"epm-eb-cube", (Object[])new Object[]{listcVersion.get(i)});
                this.addErrorMessage((ExtendedDataEntity)dycVersionList.get(i), sb);
            }
        }
        if (listdimmaterule != null && listdimmaterule.size() > 0) {
            for (int i = 0; i < listdimmaterule.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c%1\u5df2\u7ecf\u5b58\u5728\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u8bb0\u5f55\u3002", (String)"BgmdModelDeleteValidator_4", (String)"epm-eb-cube", (Object[])new Object[]{listdimmaterule.get(i)});
                this.addErrorMessage((ExtendedDataEntity)dydimmateruleList.get(i), sb);
            }
        }
        if (listdimmembermapping != null && listdimmembermapping.size() > 0) {
            for (int i = 0; i < listdimmembermapping.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1\u201d \u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u8bb0\u5f55\u5df2\u5b58\u5728\u3002", (String)"BgmdModelDeleteValidator_5", (String)"epm-eb-cube", (Object[])new Object[]{listdimmembermapping.get(i)});
                this.addErrorMessage((ExtendedDataEntity)dydimmembermappingList.get(i), sb);
            }
        }
        if (listTask != null && dyTask != null && !listTask.isEmpty()) {
            for (int i = 0; i < listTask.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c%1\u5df2\u7ecf\u5b58\u5728\u7f16\u5236\u4efb\u52a1\u3002", (String)"BgmdModelDeleteValidator_6", (String)"epm-eb-cube", (Object[])new Object[]{listTask.get(i)});
                this.addErrorMessage((ExtendedDataEntity)dyTask.get(i), sb);
            }
        }
        if (!ctrlDims.isEmpty()) {
            for (int i = 0; i < ctrlDims.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1\u201d\u5df2\u5b58\u5728\u63a7\u5236\u7ef4\u5ea6\u3002", (String)"BgmdModelDeleteValidator_7", (String)"epm-eb-cube", (Object[])new Object[]{ctrlDims.get(i)});
                this.addErrorMessage((ExtendedDataEntity)ctrlDimsDe.get(i), sb);
            }
        }
        if (!rules.isEmpty()) {
            for (int i = 0; i < rules.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c%1\u5df2\u7ecf\u5b58\u5728\u63a7\u5236\u65b9\u5f0f\u3002", (String)"BgmdModelDeleteValidator_8", (String)"epm-eb-cube", (Object[])new Object[]{rules.get(i)});
                this.addErrorMessage((ExtendedDataEntity)rulesDe.get(i), sb);
            }
        }
        if (!cent.isEmpty()) {
            for (int i = 0; i < cent.size(); ++i) {
                String sb = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1\u201d\u5df2\u5b58\u5728\u5f52\u53e3\u7ba1\u63a7\u65b9\u6848\u3002", (String)"BgmdModelDeleteValidator_9", (String)"epm-eb-cube", (Object[])new Object[]{cent.get(i)});
                this.addErrorMessage((ExtendedDataEntity)centDe.get(i), sb);
            }
        }
    }

    private boolean isExitControlVersion(long id) {
        QFilter filter = new QFilter("model.id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        return QueryServiceHelper.exists((String)"eb_controlversion", (QFilter[])filters);
    }

    private boolean isExitDimMateRule(long id) {
        QFilter filter = new QFilter("cardentity.model", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        return QueryServiceHelper.exists((String)"eb_adddimmaterule", (QFilter[])filters);
    }

    private boolean isExitControlRule(long modelId) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("isdefault", "=", (Object)Character.valueOf('0')));
        return QueryServiceHelper.exists((String)"eb_bgcontrolrulemain", (QFilter[])builder.toArrays());
    }

    private boolean isExitControlDims(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.exists((String)"eb_bgmcontroldimension", (QFilter[])new QFilter[]{filter});
    }

    private boolean isExitControlCentralized(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.exists((String)"eb_centralized_entity", (QFilter[])new QFilter[]{filter});
    }

    private boolean isExitDimMemberMapping(long id) {
        QFilter filter = new QFilter("model.id", "=", (Object)id);
        return QueryServiceHelper.exists((String)"eb_dimmembermapping", (QFilter[])new QFilter[]{filter});
    }

    private boolean hasDeletePerm(long id) {
        QFilter qfmodel = new QFilter("model", "=", (Object)id);
        QFilter qfuser = new QFilter("modelpermentry.eusers", "=", (Object)UserUtils.getUserId());
        DynamicObject doc = QueryServiceHelper.queryOne((String)"epm_modelperm", (String)"modelpermentry.id", (QFilter[])new QFilter[]{qfmodel, qfuser});
        return doc != null;
    }

    private boolean isExitTemplate(long id, String key) {
        QFilter filter = new QFilter("model.id", "=", (Object)id);
        return QueryServiceHelper.exists((String)key, (QFilter[])filter.toArray());
    }

    private boolean isExitTask(long id) {
        QFilter filter = new QFilter("model.id", "=", (Object)id);
        return QueryServiceHelper.exists((String)"eb_task", (QFilter[])filter.toArray());
    }

    private Set<Long> checkMainSubModel(Set<Long> modelIds) {
        QFilter qFilter;
        DynamicObjectCollection dynamicObjects;
        HashSet<Long> set = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(modelIds) && CollectionUtils.isNotEmpty((Collection)(dynamicObjects = QueryServiceHelper.query((String)"epm_model", (String)"id,level", (QFilter[])(qFilter = new QFilter("id", "in", modelIds)).toArray())))) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (StringUtils.equals((String)"0", (String)dynamicObject.getString("level"))) continue;
                set.add(dynamicObject.getLong("id"));
            }
        }
        return set;
    }
}

