/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.formop.Close;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.tree.AbstractTreeNode;
import kd.epm.eb.common.tree.ICEntityTreeNode;
import kd.epm.eb.common.tree.TreeModel;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.MultipleMemberF7BasePlugin;
import kd.epm.eb.model.utils.ICEntityTreeBuilder;

public class MultipleMemberF7TemPlugin
extends MultipleMemberF7BasePlugin {
    private static final String TREELEFT = "treeleft";
    private static final String TREELEFTNODECLICK = "treeleftnodeclick";
    private static final String BILLLISTAP = "billlistap";
    public static final String MEMRANGDECOMBO = "memrangdecombo";
    private long modelId = 0L;
    private static final List<String> LEVEL_LIST = new ArrayList<String>(Arrays.asList("60", "70"));
    private static final List<String> RANGE_LIST = new ArrayList<String>(Arrays.asList("memrangdecombo", "filltypevalue1", "filltypevalue2"));

    @Override
    public void initialize() {
        super.initialize();
        final TreeView tree = (TreeView)this.getView().getControl(TREELEFT);
        final BillList billList = (BillList)this.getControl(BILLLISTAP);
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        if (this.isICBoolean(sign)) {
            billList.addSetFilterListener(new SetFilterListener(){

                public void setFilter(SetFilterEvent event) {
                    String serial = MultipleMemberF7TemPlugin.this.getPageCache().get(MultipleMemberF7TemPlugin.TREELEFTNODECLICK);
                    MultipleMemberF7TemPlugin.this.initModelId();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)serial)) {
                        long id = (Long)ObjectSerialUtil.deSerializedBytes((String)serial);
                        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"epm_icmembertree", (String)"number");
                        String number = dy == null ? "" : dy.getString("number");
                        QFilter qFilter = new QFilter("model", "=", (Object)MultipleMemberF7TemPlugin.this.modelId);
                        qFilter.and(new QFilter("longnumber", "like", (Object)("%" + number + "!" + "%")));
                        qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
                        qFilter.or(new QFilter("number", "=", (Object)number).and(new QFilter("model", "=", (Object)MultipleMemberF7TemPlugin.this.modelId)));
                        event.getQFilters().add(qFilter);
                    } else {
                        QFilter qFilter = new QFilter("model", "=", (Object)MultipleMemberF7TemPlugin.this.modelId);
                        event.getQFilters().clear();
                        event.getQFilters().add(qFilter);
                    }
                    event.setOrderBy("longnumber");
                }
            });
            tree.addTreeNodeClickListener(new TreeNodeClickListener(){

                public void treeNodeClick(TreeNodeEvent evt) {
                    MultipleMemberF7TemPlugin.this.treenodeClick(tree);
                    billList.refresh();
                }
            });
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btntop", "btnup", "btndown", "btnbottom"});
    }

    private void treenodeClick(TreeView tree) {
        TreeView.TreeState state = tree.getTreeState();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (state.getFocusNode() != null) {
            long id = Long.parseLong((String)state.getFocusNode().get("id"));
            this.initModelId();
            this.getPageCache().put(TREELEFTNODECLICK, ObjectSerialUtil.toByteSerialized((Object)id));
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"epm_icmembertree", (String)"number");
            String number = dy == null ? "" : dy.getString("number");
            QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
            qFilter.and(new QFilter("longnumber", "like", (Object)("%" + number + "!" + "%")));
            qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            qFilter.or(new QFilter("number", "=", (Object)number).and(new QFilter("model", "=", (Object)this.modelId)));
            billList.setFilter(qFilter);
        } else {
            QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
            billList.setFilter(qFilter);
        }
        billList.setOrderBy("longnumber");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        this.initModelId();
        if (parentPageCache.get(sign) != null) {
            List membColl = (List)SerializationUtils.fromJsonString((String)parentPageCache.get(sign), List.class);
            IDataModel model = this.getModel();
            int index = 0;
            for (Map map : membColl) {
                index = model.createNewEntryRow(this.entryentity);
                model.setValue(this.mid, map.get("id"), index);
                model.setValue(this.mnum, map.get("number"), index);
                model.setValue(this.mname, map.get("name"), index);
                model.setValue(this.filltypevalue, map.get("scope"), index);
                model.setValue(this.pid, map.get("pid"), index);
            }
            if (membColl.size() > 0 && ((Map)membColl.get(0)).get("pid") != null && StringUtils.isNotEmpty((CharSequence)((String)((Map)membColl.get(0)).get("pid")).trim())) {
                this.getModel().setValue("radio", (Object)20);
                this.refrushMember();
                this.getPageCache().remove("membername");
            }
        }
        this.setICEntityVisual(sign);
        if (sign != null && parentPageCache.get(sign) == null && sign.startsWith("row") && !StringUtils.isEmpty((CharSequence)parentPageCache.get("parentSelectedParam"))) {
            String entity = this.FromFieldKeyToFormIdentity(sign);
            String parentSelectedParam = parentPageCache.get("parentSelectedParam");
            if (!StringUtils.isEmpty((CharSequence)parentSelectedParam)) {
                Map<String, Object> temp = this.getSelected(parentSelectedParam, entity);
                DynamicObjectCollection membColl = (DynamicObjectCollection)temp.get("dimensions");
                Map scope = (Map)temp.get("scope");
                IDataModel model = this.getModel();
                int index = 0;
                for (DynamicObject map : membColl) {
                    index = model.createNewEntryRow(this.entryentity);
                    model.setValue(this.mid, map.get("id"), index);
                    model.setValue(this.mnum, map.get("number"), index);
                    model.setValue(this.mname, map.get("name"), index);
                    model.setValue(this.filltypevalue, scope.get(map.get("id") + ""), index);
                    model.setValue(this.pid, (Object)1, index);
                }
            }
        }
        this.setDefaultComboEdit();
    }

    private void setDefaultComboEdit() {
        String isNeedPerm = (String)this.getView().getFormShowParameter().getCustomParam("needPermission");
        if (!StringUtils.isEmpty((CharSequence)isNeedPerm) && this.isDimInPermList() && !this.checkDimPerm()) {
            this.removeLevelItems();
        }
    }

    private boolean checkDimPerm() {
        String rootCache = this.getPageCache().get("treeroot");
        String entityName = this.getEntityName();
        Long dimensionId = Convert.toLong((Object)this.getPageCache().get("dimension"), (Long)0L);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootCache, TreeNode.class);
        String rootUsr = this.getPageCache().get("rootuser");
        if (!StringUtils.isEmpty((CharSequence)rootUsr) && "true".equals(rootUsr)) {
            return true;
        }
        List<Long> childIds = this.getNodeChildIdsById(new ArrayList<String>(Collections.singletonList(root.getId())), entityName);
        Set<Long> permMemberList = this.getBaseViewHasPermMemberIds(entityName, dimensionId);
        return permMemberList.containsAll(childIds);
    }

    private void removeLevelItems() {
        for (String key : RANGE_LIST) {
            ComboEdit edit = (ComboEdit)this.getControl(key);
            ComboProp prop = (ComboProp)edit.getProperty();
            List items = prop.getComboItems();
            ArrayList<ComboItem> newItems = new ArrayList<ComboItem>(16);
            ComboItem comboItem = null;
            for (ValueMapItem item : items) {
                if (LEVEL_LIST.contains(item.getValue())) continue;
                comboItem = new ComboItem(item.getName(), item.getValue());
                newItems.add(comboItem);
            }
            edit.setComboItems(newItems);
        }
    }

    private Map<String, Object> getSelected(String parentSelectedParam, String entity) {
        String[] cache_Param = parentSelectedParam.split("\uff0c");
        ArrayList<String> ids = new ArrayList<String>(cache_Param.length);
        HashMap<String, String> scope = new HashMap<String, String>(cache_Param.length);
        for (String id : cache_Param) {
            String[] params = id.split("_");
            scope.put(params[0], params[1]);
            ids.add(params[0]);
        }
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)entity, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("scope", scope);
        result.put("dimensions", dimensions);
        return result;
    }

    private String FromFieldKeyToFormIdentity(String fieldKey) {
        if (fieldKey.contains("accountbefore")) {
            return "epm_accountmembertree";
        }
        if (fieldKey.contains("changetypebefore")) {
            return "epm_changetypemembertree";
        }
        if (fieldKey.contains("dim")) {
            return "epm_userdefinedmembertree";
        }
        return null;
    }

    private void setICEntityVisual(String sign) {
        if (this.isICBoolean(sign)) {
            this.initLeftTree();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"membertreeap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"splitcontainerap1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap31"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"membertreeap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap1"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap31"});
        }
    }

    private boolean isICBoolean(String sign) {
        return sign != null && (sign.startsWith("epm_icmembertree") || sign.contains(SysDimensionEnum.InternalCompany.getNumber()) || sign.contains("mapdiminternalcompany") || sign.contains("company")) && !sign.contains("mycompany");
    }

    private void initModelId() {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String str = pageCache.get("KEY_MODEL_ID");
        if (kd.bos.util.StringUtils.isNotEmpty((String)str)) {
            this.modelId = Long.parseLong(str);
        }
    }

    public void initLeftTree() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.modelId));
        qfBuilder.add(new QFilter("isleaf", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_icmembertree", (String)"id,name,number,parent,isleaf,0 as storagetype", (QFilter[])qfBuilder.toArray());
        ICEntityTreeNode root = ICEntityTreeBuilder.getICEntityTreeNode((DynamicObjectCollection)doc);
        if (root != null) {
            TreeView tree = (TreeView)this.getControl(TREELEFT);
            tree.deleteAllNodes();
            this.buildLeftTree((AbstractTreeNode<Object>)root);
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
            qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            billList.setFilter(qFilter);
            billList.refresh();
        }
    }

    protected void buildLeftTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREELEFT);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode nodeRoot = treemodel.buildEntryTree(tree);
            nodeRoot.iterate(999, v -> v.setIsOpened(false));
            nodeRoot.iterate(0, v -> v.setIsOpened(true));
            if (root.getChildren() == null) {
                return;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        String val = (String)this.getModel().getValue("radio");
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        switch (key) {
            case "radio": {
                if (val.equals("10")) {
                    this.setICEntityVisual(sign);
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"membertreeap"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap1"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap31"});
            }
        }
        super.propertyChanged(e);
    }

    @Override
    public void click(EventObject evt) {
        this.setCurrentTabPage();
        String key = ((Control)evt.getSource()).getKey();
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        String val = (String)this.getModel().getValue("radio");
        if (key.equals("addoneb") || key.equals("addallb")) {
            if (this.isICBoolean(sign) && val.equals("10")) {
                IDataModel model = this.getModel();
                DynamicObjectCollection doc = model.getEntryEntity(this.entryentity);
                String mlist = this.getPageCache().get("memberlist");
                this.getSelectMembers(mlist, key);
                this.MoveMember(mlist, key, model, doc, val);
                return;
            }
        } else if (key.equals("btntop")) {
            this.moveTop();
        } else if (key.equals("btnup")) {
            this.moveUp();
        } else if (key.equals("btndown")) {
            this.moveDown();
        } else if (key.equals("btnbottom")) {
            this.moveBottom();
        } else if (key.equals("btnok") && this.isModelOlap()) {
            DynamicObjectCollection doc = this.getModel().getEntryEntity(this.entryentity);
            if (doc.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u6570\u636e\u3002", (String)"MultipleMemberF7TemPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)doc);
            ThreadCache.put((Object)"okbtn", (Object)true);
            this.getView().close();
        }
        super.click(evt);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Close) {
            ThreadCache.put((Object)"close", (Object)true);
        }
    }

    @Override
    protected List<Map<String, String>> getSelectMembers(String mlist, String key) {
        String val = (String)this.getModel().getValue("radio");
        if (this.getPageCache().get("membermodel").startsWith("epm_icmembertree") && val.equals("10")) {
            List<Map<String, String>> selectMemList = this.getMemberList(key);
            if (selectMemList != null && selectMemList.size() > 0) {
                return selectMemList;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MultipleMemberF7TemPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return super.getSelectMembers(mlist, key);
    }

    protected List<Long> getNodeChildIdsById(List<String> ids, String entityName) {
        ArrayList<Long> memberIds = new ArrayList<Long>(16);
        for (String idStr : ids) {
            Long id = Long.parseLong(idStr);
            if (!memberIds.contains(id)) {
                memberIds.add(id);
            }
            QFilter qf1 = new QFilter("parent", "=", (Object)id);
            QFilter qf2 = new QFilter("model", "=", (Object)this.modelId);
            QFilter qf3 = new QFilter("number", "!=", (Object)"RatePreset");
            DynamicObjectCollection members = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{qf1, qf2, qf3});
            if (members == null) continue;
            for (DynamicObject member : members) {
                Long memberId = member.getLong("id");
                if (memberIds.contains(memberId)) continue;
                memberIds.add(memberId);
            }
        }
        return memberIds;
    }

    protected List<Map<String, String>> getMemberList(String key) {
        String val = (String)this.getModel().getValue("radio");
        if (this.getPageCache().get("membermodel").startsWith("epm_icmembertree") && val.equals("10")) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection lc = billList.getCurrentListAllRowCollection();
            HashSet<Long> ids = new HashSet<Long>(16);
            for (ListSelectedRow selectedRow : lc) {
                ids.add((Long)selectedRow.getPrimaryKeyValue());
            }
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("id", "in", ids));
            String selectFields = "id,name,number,parent,0 as storagetype,longnumber";
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_icmembertree", (String)selectFields, (QFilter[])qfBuilder.toArray());
            List<Map<String, String>> billMemList = this.getMemberList(dcs, "id", "number", "name", "parent", null);
            List<Object> selectmemberlist = new ArrayList(16);
            if ("addoneb".equals(key)) {
                ListSelectedRowCollection lc2 = billList.getSelectedRows();
                HashSet<Long> selectIds = new HashSet<Long>(16);
                for (ListSelectedRow selectedRow : lc2) {
                    selectIds.add((Long)selectedRow.getPrimaryKeyValue());
                }
                qfBuilder = new QFBuilder();
                qfBuilder.add(new QFilter("id", "in", selectIds));
                dcs = QueryServiceHelper.query((String)"epm_icmembertree", (String)selectFields, (QFilter[])qfBuilder.toArray());
                selectmemberlist = this.getMemberList(dcs, "id", "number", "name", "parent", null);
            } else {
                selectmemberlist = billMemList;
            }
            return selectmemberlist;
        }
        return null;
    }

    @Override
    protected String getPresetMemberOrder() {
        return "longnumber";
    }

    protected void moveTop() {
        DynamicObject obj;
        DynamicObjectCollection objs;
        int rowIndex;
        EntryGrid entry = (EntryGrid)this.getControl("entryentity1");
        if (entry != null && (rowIndex = entry.getEntryState().getFocusRow()) > 0 && (objs = this.getModel().getEntryEntity("entryentity1")) != null && (obj = (DynamicObject)objs.get(rowIndex)) != null) {
            this.getModel().deleteEntryRow("entryentity1", rowIndex);
            this.getModel().createNewEntryRow("entryentity1", 0, obj);
            entry.selectRows(0);
        }
    }

    protected void moveUp() {
        DynamicObject obj;
        DynamicObjectCollection objs;
        int rowIndex;
        EntryGrid entry = (EntryGrid)this.getControl("entryentity1");
        if (entry != null && (rowIndex = entry.getEntryState().getFocusRow()) > 0 && (objs = this.getModel().getEntryEntity("entryentity1")) != null && (obj = (DynamicObject)objs.get(rowIndex)) != null) {
            this.getModel().deleteEntryRow("entryentity1", rowIndex);
            this.getModel().createNewEntryRow("entryentity1", rowIndex - 1, obj);
            entry.selectRows(rowIndex - 1);
        }
    }

    protected void moveDown() {
        DynamicObject obj;
        DynamicObjectCollection objs;
        int rowIndex;
        EntryGrid entry = (EntryGrid)this.getControl("entryentity1");
        if (entry != null && (rowIndex = entry.getEntryState().getFocusRow()) >= 0 && (objs = this.getModel().getEntryEntity("entryentity1")) != null && rowIndex < objs.size() - 1 && (obj = (DynamicObject)objs.get(rowIndex)) != null) {
            this.getModel().deleteEntryRow("entryentity1", rowIndex);
            this.getModel().createNewEntryRow("entryentity1", rowIndex + 1, obj);
            entry.selectRows(rowIndex + 1);
        }
    }

    protected void moveBottom() {
        DynamicObject obj;
        DynamicObjectCollection objs;
        int rowIndex;
        EntryGrid entry = (EntryGrid)this.getControl("entryentity1");
        if (entry != null && (rowIndex = entry.getEntryState().getFocusRow()) >= 0 && (objs = this.getModel().getEntryEntity("entryentity1")) != null && rowIndex < objs.size() - 1 && (obj = this.getModel().getEntryRowEntity("entryentity1", rowIndex)) != null) {
            this.getModel().deleteEntryRow("entryentity1", rowIndex);
            this.getModel().createNewEntryRow("entryentity1", obj);
            entry.selectRows(objs.size() - 1);
        }
    }
}

