/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.Mutex;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.formplugin.Mutex.MixingMutexRecordObj;

public class MutexRecordListPlugin
extends AbstractFormPlugin {
    private static final String entryentityKey = "entryentity";

    public void afterCreateNewData(EventObject e) {
        this.initRecordList();
    }

    private void initRecordList() {
        ArrayList<MixingMutexRecordObj> allRecord = new ArrayList<MixingMutexRecordObj>(16);
        this.selectAuditBillMutexRecord(allRecord);
        this.selectOtherMutexRecord(allRecord);
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(entryentityKey);
        if (allRecord.size() > 0) {
            dataModel.batchCreateNewEntryRow(entryentityKey, allRecord.size());
            int index = 0;
            for (MixingMutexRecordObj recordObj : allRecord) {
                DynamicObject object = dataModel.getEntryRowEntity(entryentityKey, index);
                object.set("id", (Object)recordObj.getRowId());
                object.set("billtype", (Object)recordObj.getBillType());
                object.set("billnumber", (Object)recordObj.getBillNumber());
                object.set("optype", (Object)recordObj.getOpType());
                object.set("nodenumber", (Object)recordObj.getNodeNumber());
                if (recordObj.getCreator() != null) {
                    object.set("creator", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)recordObj.getCreator(), (String)"bos_user"));
                }
                object.set("createdate", (Object)recordObj.getCreateDate());
                object.set("isauditbill", (Object)recordObj.isAuditBill());
                object.set("ipaddress", (Object)recordObj.getIpAddress());
                ++index;
            }
            this.getView().updateView(entryentityKey);
        }
    }

    private void selectAuditBillMutexRecord(List<MixingMutexRecordObj> allRecord) {
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_centralappmutex", (String)"id,billno,nodenumber,approver,createdate,ipaddress", null);
        objects.forEach(obj -> {
            MixingMutexRecordObj recordObj = new MixingMutexRecordObj();
            recordObj.setBillNumber(obj.getString("billno"));
            recordObj.setRowId(obj.getLong("id"));
            recordObj.setCreator(obj.getLong("approver"));
            recordObj.setCreateDate(obj.getDate("createdate"));
            recordObj.setNodeNumber(obj.getString("nodenumber"));
            recordObj.setBillType("eb_centralappbill");
            recordObj.setOpType("edit");
            recordObj.setAuditBill(true);
            recordObj.setIpAddress(obj.getString("ipaddress"));
            allRecord.add(recordObj);
        });
    }

    private void selectOtherMutexRecord(List<MixingMutexRecordObj> allRecord) {
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_mutexrecord", (String)"id,billtype,billnumber,optype,creator,createdate,ipaddress", null);
        objects.forEach(obj -> {
            MixingMutexRecordObj recordObj = new MixingMutexRecordObj();
            recordObj.setBillNumber(obj.getString("billnumber"));
            recordObj.setRowId(obj.getLong("id"));
            recordObj.setCreator(obj.getLong("creator"));
            recordObj.setCreateDate(obj.getDate("createdate"));
            recordObj.setBillType(obj.getString("billtype"));
            recordObj.setOpType(obj.getString("optype"));
            recordObj.setIpAddress(obj.getString("ipaddress"));
            allRecord.add(recordObj);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("reflush".equals(itemKey)) {
            this.initRecordList();
        } else if ("delete".equals(itemKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryentityKey);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"MutexRecordListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u662f\u5426\u8981\u5220\u9664\u9009\u4e2d\u7684%1\u6761\u8bb0\u5f55\uff1f", (String)"MutexRecordListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{selectRows.length}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delete", (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("delete".equals(callBackId) && result == MessageBoxResult.Yes) {
            this.deleteRecord();
        }
    }

    private void deleteRecord() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryentityKey);
        int[] selectRows = entryGrid.getSelectRows();
        HashSet<Long> auditRecords = new HashSet<Long>(16);
        HashSet<Long> otherRecords = new HashSet<Long>(16);
        for (int index : selectRows) {
            DynamicObject row = this.getModel().getEntryRowEntity(entryentityKey, index);
            if (row.getBoolean("isauditbill")) {
                auditRecords.add(row.getLong("id"));
                continue;
            }
            otherRecords.add(row.getLong("id"));
        }
        if (auditRecords.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_centralappmutex"), (Object[])auditRecords.toArray());
        }
        if (otherRecords.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_mutexrecord"), (Object[])otherRecords.toArray());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"MutexRecordListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.initRecordList();
    }
}

