/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.PCPage;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.PCPage.ChildPageHandler;
import kd.epm.eb.formplugin.PCPage.PCPageHandler;
import kd.epm.eb.formplugin.PCPage.event.PCPageEvent;

public interface ParentPageHandler
extends PCPageHandler {
    default public void callChildes(PCPageEvent event) {
        if (event != null) {
            Map<String, ChildPageHandler> childPageHandler = this.getChildPageHandler();
            childPageHandler.forEach((containerKey, handler) -> {
                if (event.getTargetContainerKey() == null || event.getTargetContainerKey().equals(containerKey)) {
                    handler.onCall(event);
                    this.getView().sendFormAction(handler.getView());
                }
            });
        }
    }

    default public Map<String, ChildPageHandler> getChildPageHandler() {
        HashMap<String, ChildPageHandler> result = new HashMap<String, ChildPageHandler>(16);
        IFormView currentView = this.getView();
        if (currentView != null) {
            Map<String, String> childPageIdMap = this.getOrCacheChildPageIdMap(null);
            childPageIdMap.forEach((containerKey, childPageId) -> {
                IFormView childView = currentView.getView(childPageId);
                if (childView != null) {
                    FormViewPluginProxy curProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
                    for (IFormPlugin plugin : curProxy.getPlugIns()) {
                        if (!(plugin instanceof ChildPageHandler)) continue;
                        result.put((String)containerKey, (ChildPageHandler)plugin);
                    }
                }
            });
        }
        return result;
    }

    default public void loadChildForm(String childFormKey, String targetContainerKey, Consumer<FormShowParameter> parameterConsumer) {
        IFormView currentView = this.getView();
        if (currentView == null) {
            return;
        }
        boolean isBaseForm = currentView.getFormShowParameter() instanceof BaseShowParameter;
        BaseShowParameter formShowParameter = isBaseForm ? new BaseShowParameter() : new FormShowParameter();
        formShowParameter.setFormId(childFormKey);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetContainerKey);
        if (parameterConsumer != null) {
            parameterConsumer.accept((FormShowParameter)formShowParameter);
        }
        this.cacheChildPageId(formShowParameter.getPageId(), targetContainerKey);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    default public void cacheChildPageId(String pageId, String targetContainer) {
        Map<String, String> childPageIdMap = this.getOrCacheChildPageIdMap(null);
        childPageIdMap.put(targetContainer, pageId);
        this.getOrCacheChildPageIdMap(childPageIdMap);
    }

    default public Map<String, String> getOrCacheChildPageIdMap(Map<String, String> pageIdMap) {
        IFormView view = this.getView();
        if (view != null) {
            if (pageIdMap == null) {
                String cacheStr = view.getPageCache().get("ChildPageIdMap");
                if (StringUtils.isNotEmpty((String)cacheStr)) {
                    pageIdMap = (Map)SerializationUtils.fromJsonString((String)cacheStr, HashMap.class);
                }
            } else {
                view.getPageCache().put("ChildPageIdMap", SerializationUtils.toJsonString(pageIdMap));
            }
        }
        if (pageIdMap == null) {
            pageIdMap = new HashMap<String, String>(16);
        }
        return pageIdMap;
    }
}

