/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;

public class PageCacheSearchPlugin
extends AbstractFormPlugin
implements CellClickListener {
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"cachevalue"});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if ("cachevalue".equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    String text = PageCacheSearchPlugin.this.getValText();
                    if (text != null && text.length() > 10000) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6587\u672c\u5185\u5bb9\u5927\u4e8e10000\u5b57\u7b26\uff0c\u8bf7\u53cc\u51fb\u8be5\u5355\u5143\u683c\u8f6c\u4e3a\u6587\u6863\u4e0b\u8f7d", (String)"", (String)"", (Object[])new Object[0]));
                    } else {
                        super.detailClick(args);
                    }
                }
            };
            control.setKey("cachevalue");
            control.setEntryKey("entryentity");
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        }
    }

    private void downTextFile(int index) {
        String text = (String)this.getModel().getValue("cachevalue_tag", index);
        String name = (String)this.getModel().getValue("cachekey", index);
        if (name == null) {
            name = "XXX";
        }
        if (text == null) {
            text = "";
        }
        String fileName = name + ".txt";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes());
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inputStream, 10000);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        if (inputStream != null) {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private String getValText() {
        String text = null;
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        if (entryentity != null) {
            int index = entryentity.getEntryState().getFocusRow();
            text = (String)this.getModel().getValue("cachevalue_tag", index);
        }
        return text;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addCellClickListener((CellClickListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("search".equals(itemKey)) {
            this.searchPageCache();
        } else if ("searchebcache".equals(itemKey)) {
            this.searchEbCache();
        } else if ("searchmodeldata".equals(itemKey)) {
            this.searchModelCache();
        }
    }

    private void searchEbCache() {
        String pageId = (String)this.getModel().getValue("pageid");
        if (StringUtils.isNotEmpty((String)pageId)) {
            this.getModel().deleteEntryData("entryentity");
            Object cacheValue = CacheServiceHelper.get((String)pageId, Object.class);
            if (cacheValue != null) {
                String cacheString = null;
                cacheString = cacheValue instanceof String ? (String)cacheValue : JSONUtils.toString((Object)cacheValue);
                HashMap<String, String> cacheVal = new HashMap<String, String>(16);
                cacheVal.put(pageId, cacheString);
                this.fillEntry(cacheVal);
            }
        }
    }

    private void searchPageCache() {
        String pageId = (String)this.getModel().getValue("pageid");
        if (StringUtils.isNotEmpty((String)pageId)) {
            pageId = pageId.trim();
            DistributeSessionlessCache sessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache");
            String regionKey = CacheKeyUtil.getAcctId() + ".pagecache." + pageId;
            HashMap<String, String> allCache = new HashMap<String, String>(sessionlessCache.getAll(regionKey));
            regionKey = regionKey + ".bo";
            allCache.putAll(sessionlessCache.getAll(regionKey));
            this.fillEntry(allCache);
        }
    }

    private void searchModelCache() {
        String pageId = (String)this.getModel().getValue("pageid");
        String formKey = (String)this.getModel().getValue("formKey");
        if (StringUtils.isNotEmpty((String)pageId) && StringUtils.isNotEmpty((String)formKey)) {
            String pId = pageId.trim();
            DistributeSessionlessCache sessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("formmodel", new DistributeCacheHAPolicy(true, true));
            String regionKey = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), formKey, pId);
            String cacheStr = (String)sessionlessCache.get(regionKey);
            HashMap<String, String> allVal = new HashMap<String, String>(16);
            if (StringUtils.isNotEmpty((String)cacheStr)) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formKey);
                DataEntityDeserializerOption option = new DataEntityDeserializerOption();
                option.setIncludeDataEntityState(true);
                DynamicObject object = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)cacheStr, (IDataEntityType)dataEntityType, (DataEntityDeserializerOption)option);
                BusinessDataReader.loadRefence((Object[])new DynamicObject[]{object}, (IDataEntityType)dataEntityType);
                dataEntityType.getProperties().forEach(prop -> {
                    if (prop instanceof EntryProp) {
                        String entryCacheKey = String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), formKey, prop.getName(), pId);
                        String[] strRows = sessionlessCache.getList(entryCacheKey);
                        IDataEntityType itemType = ((EntryProp)prop).getItemType();
                        allVal.put(prop.getName(), String.format("keyIndex:%s,rowDatas:%s", itemType.getProperties().toString(), SerializationUtils.toJsonString((Object)strRows)));
                    } else {
                        Object val = prop.getValueFast((Object)object);
                        if (val == null) {
                            allVal.put(prop.getName(), "");
                        } else {
                            allVal.put(prop.getName(), val.toString());
                        }
                    }
                });
            }
            this.fillEntry(allVal);
        }
    }

    private void fillEntry(Map<String, String> cacheAll) {
        this.getModel().deleteEntryData("entryentity");
        if (cacheAll != null) {
            DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entryentity");
            cacheAll.forEach((cacheKey, cacheVal) -> {
                DynamicObject dynamicObject = entryRows.addNew();
                dynamicObject.set("cachekey", cacheKey);
                if (cacheVal.length() > 100) {
                    dynamicObject.set("cachevalue", (Object)cacheVal.substring(0, 100));
                    dynamicObject.set("cachevalue_tag", cacheVal);
                } else {
                    dynamicObject.set("cachevalue", cacheVal);
                }
            });
            this.getModel().updateEntryCache(entryRows);
            this.getView().updateView("entryentity");
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("cachevalue".equals(fieldKey)) {
            this.downTextFile(cellClickEvent.getRow());
        }
    }
}

