/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.adminmode;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.adminmode.PurposeTypeEnum;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.task.notice.ScheduleHelper;

public class AdminModeClosePlugin
extends AbstractBasePlugin {
    private static final String BTN_OK = "btnok";
    private static final Log log = LogFactory.getLog(AdminModeClosePlugin.class);

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject defaultScheme = this.getDefaultScheme();
        if (defaultScheme != null) {
            this.getModel().setValue("title", (Object)defaultScheme.getString("title"));
            String content = defaultScheme.getString("content");
            DynamicObject modelInfo = this.getModelInfo();
            if (content.contains("@model_number@") && modelInfo != null) {
                content = content.replace("@model_number@", modelInfo.getString("shownumber"));
            }
            if (content.contains("@model_name@") && modelInfo != null) {
                content = content.replace("@model_name@", modelInfo.getLocaleString("name").getLocaleValue() == null ? "" : modelInfo.getLocaleString("name").getLocaleValue());
            }
            this.getModel().setValue("content", (Object)content);
        }
    }

    public DynamicObject getModelInfo() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getModelId())});
        return dynamicObject;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            if (!AdminModelUtil.checkTitleAndContentLength(this.getView(), this.getModel())) {
                return;
            }
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_announcement_content");
            DynamicObject defaultScheme = this.getDefaultScheme();
            if (defaultScheme != null) {
                object.set("mntscheme", (Object)defaultScheme.getLong("id"));
            }
            object.set("model", (Object)this.getModelId());
            object.set("title", this.getModel().getValue("title"));
            object.set("content", this.getModel().getValue("content"));
            object.set("issendmessage", this.getModel().getValue("issendmessage"));
            object.set("pushtimeassistant", (Object)true);
            object.set("isclose", (Object)Boolean.TRUE);
            object.set("createrfield", (Object)this.getUserId());
            object.set("createdatefield", (Object)TimeServiceHelper.now());
            object.set("pushmessagecenter", (Object)true);
            DynamicObject[] dynamicObjects = new DynamicObject[]{object};
            try {
                Object[] save = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                if (save.length > 0) {
                    ScheduleHelper.createNotice((DynamicObject)object, (Long)((DynamicObject)save[0]).getLong("id"), (String)this.getView().getFormShowParameter().getAppId(), (Boolean)true, (PurposeTypeEnum)PurposeTypeEnum.OPERATION, null);
                }
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u7ba1\u7406\u5458\u6a21\u5f0f\u6210\u529f\u3002", (String)"AdminModeClosePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                log.error("close error:", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                this.getView().close();
            }
        }
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelid");
    }

    private DynamicObject getDefaultScheme() {
        QFilter filter = new QFilter("number", "=", (Object)"defaultclose");
        filter.and("purpose", "=", (Object)PurposeTypeEnum.OPERATION.getValue());
        filter.and("schemetype", "=", (Object)"1");
        return QueryServiceHelper.queryOne((String)"eb_mntscheme", (String)"id,title,content", (QFilter[])new QFilter[]{filter});
    }
}

