/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.adminmode;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.adminmode.PurposeTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.task.notice.ScheduleHelper;

public class AnnouncementPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_OK = "btnok";
    private static final String ANNOUNCEMENTADDCLOSECALLBACK_EB = "announcementaddclosecallback_eb";
    private DynamicObject mntScheme;
    private static final Log log = LogFactory.getLog(AnnouncementPlugin.class);

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_OK});
        BasedataEdit modelBaseDate = (BasedataEdit)this.getView().getControl("mntscheme");
        modelBaseDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().equals("mntscheme")) {
            QFilter filter = new QFilter("number", "!=", (Object)"defaultclose");
            filter.and("purpose", "=", (Object)PurposeTypeEnum.OPERATION.getValue());
            filter.and("schemetype", "=", (Object)"1");
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(filter));
        }
    }

    public void afterCreateNewData(EventObject e) {
        DateTimeEdit endTimeEdit;
        DateTimeEdit dateTimeEdit;
        super.afterCreateNewData(e);
        DynamicObject defaultScheme = this.getDefaultScheme();
        if (defaultScheme != null) {
            this.refreshViewByScheme(defaultScheme);
        }
        if ((dateTimeEdit = (DateTimeEdit)this.getControl("starttime")) != null) {
            dateTimeEdit.setMinDate(TimeServiceHelper.now());
            dateTimeEdit.setIsStartDate(Boolean.valueOf(true));
            dateTimeEdit.setRelatedDate("endtime");
        }
        if ((endTimeEdit = (DateTimeEdit)this.getControl("endtime")) != null) {
            endTimeEdit.setMinDate(TimeServiceHelper.now());
        }
    }

    private void refreshViewByScheme(DynamicObject defaultScheme) {
        this.getModel().setValue("mntscheme", (Object)defaultScheme.getString("id"));
        this.getModel().setValue("title", (Object)defaultScheme.getString("title"));
        ILocaleString contentString = defaultScheme.getLocaleString("content");
        DynamicObject modelInfo = this.getModelInfo();
        String content = contentString.getLocaleValue();
        if (content.contains("@model_number@") && modelInfo != null) {
            content = content.replace("@model_number@", modelInfo.getString("shownumber"));
        }
        if (content.contains("@model_name@") && modelInfo != null) {
            String name = modelInfo.getLocaleString("name").getLocaleValue();
            content = content.replace("@model_name@", name == null ? "" : name);
        }
        contentString.setLocaleValue(content);
        this.getModel().setValue("content", (Object)contentString);
        this.getModel().setValue("pushmessagecenter", (Object)defaultScheme.getBoolean("pushmessagecenter"));
        this.getModel().setValue("pushtimeassistant", (Object)defaultScheme.getBoolean("pushtimeassistant"));
        this.getModel().setValue("instantpush", (Object)defaultScheme.getBoolean("instantpush"));
        this.switchTimeSet(defaultScheme.getBoolean("instantpush"));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btn_save": {
                if (!AdminModelUtil.checkTitleAndContentLength(this.getView(), this.getModel())) break;
                this.openAnnouncementAddPage();
                break;
            }
            case "btnok": {
                if (!AdminModelUtil.checkTitleAndContentLength(this.getView(), this.getModel())) break;
                this.saveAnouncementContent(this.getSchemeId(), this.getModelId());
            }
        }
    }

    @Override
    public Long getModelId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam("modelid");
    }

    public DynamicObject getModelInfo() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getModelId())});
        return dynamicObject;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object propValue = changeData.getNewValue();
        if (propValue instanceof DynamicObject) {
            DynamicObject obj = (DynamicObject)propValue;
            Long id = (Long)obj.get("id");
            this.mntScheme = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_mntscheme");
        }
        if (this.mntScheme != null) {
            this.refreshViewByScheme(this.mntScheme);
        }
        if ("instantpush".equals(name) && propValue != null) {
            Boolean value = (Boolean)propValue;
            this.switchTimeSet(value);
        }
    }

    private void switchTimeSet(Boolean invisible) {
        if (invisible.booleanValue()) {
            this.getModel().setValue("starttime", null);
            this.getModel().setValue("endtime", null);
            this.getModel().setValue("remind", null);
        } else {
            this.getModel().setValue("starttime", (Object)new Date(TimeServiceHelper.now().getTime() + 660000L));
            this.getModel().setValue("endtime", null);
            this.getModel().setValue("remind", (Object)1);
        }
        this.getView().setEnable(Boolean.valueOf(invisible == false), new String[]{"flexpanelap3"});
    }

    private Long getSchemeId() {
        DynamicObject object = (DynamicObject)this.getModel().getValue("mntscheme");
        if (object != null) {
            return object.getLong("id");
        }
        return null;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returndata;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ANNOUNCEMENTADDCLOSECALLBACK_EB.equals(key) && (returndata = closedCallBackEvent.getReturnData()) != null) {
            Map returnObj = (Map)ObjectSerialUtil.deSerializedBytes((String)((String)returndata));
            this.saveMntScheme(returnObj);
        }
    }

    private void openAnnouncementAddPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ANNOUNCEMENTADDCLOSECALLBACK_EB);
        formShowParameter.setFormId("eb_announcement_add");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void saveMntScheme(Map<String, Object> map) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_mntscheme");
        object.set("number", map.get("number"));
        object.set("name", map.get("name"));
        object.set("purpose", (Object)"1");
        object.set("able", (Object)true);
        object.set("title", this.getModel().getValue("title"));
        object.set("content", this.getModel().getValue("content"));
        object.set("pushmessagecenter", this.getModel().getValue("pushmessagecenter"));
        object.set("pushtimeassistant", this.getModel().getValue("pushtimeassistant"));
        object.set("instantpush", this.getModel().getValue("instantpush"));
        object.set("starttime", this.getModel().getValue("starttime"));
        object.set("schemetype", (Object)"1");
        Object endtime = this.getModel().getValue("endtime");
        if (endtime != null) {
            object.set("endtime", endtime);
        }
        object.set("remind", this.getModel().getValue("remind"));
        DynamicObject[] dynamicObjects = new DynamicObject[]{object};
        try {
            Object[] save = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            if (save.length > 0) {
                object.set("id", (Object)((DynamicObject)save[0]).getLong("id"));
                this.refreshViewByScheme(object);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnnouncementPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void saveAnouncementContent(Long schemeId, Long modelId) {
        Object starttime;
        if (modelId == null || schemeId == null) {
            return;
        }
        Object instantpush = this.getModel().getValue("instantpush");
        if (instantpush != null && !((Boolean)instantpush).booleanValue() && (starttime = this.getModel().getValue("starttime")) != null) {
            Date end;
            Date start = (Date)starttime;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(TimeServiceHelper.now().getTime() + 600000L));
            if (start.compareTo(calendar.getTime()) <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u6bd4\u5f53\u524d\u65f6\u95f4\u5c11\u4e8e10\u5206\u949f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AnnouncementPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("endtime") != null && (end = (Date)this.getModel().getValue("endtime")).compareTo(start) <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"AnnouncementPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_announcement_content");
        object.set("mntscheme", (Object)schemeId);
        object.set("model", (Object)modelId);
        object.set("title", this.getModel().getValue("title"));
        object.set("content", this.getModel().getValue("content"));
        object.set("pushmessagecenter", this.getModel().getValue("pushmessagecenter"));
        object.set("pushtimeassistant", this.getModel().getValue("pushtimeassistant"));
        object.set("instantpush", this.getModel().getValue("instantpush"));
        object.set("starttime", this.getModel().getValue("starttime"));
        object.set("endtime", this.getModel().getValue("endtime"));
        object.set("remind", this.getModel().getValue("remind"));
        object.set("createrfield", (Object)this.getUserId());
        object.set("createdatefield", (Object)TimeServiceHelper.now());
        DynamicObject[] dynamicObjects = new DynamicObject[]{object};
        try {
            Object[] save = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            if (save.length > 0) {
                ScheduleHelper.createNotice((DynamicObject)object, (Long)((DynamicObject)save[0]).getLong("id"), (String)this.getView().getFormShowParameter().getAppId(), (Boolean)false, (PurposeTypeEnum)PurposeTypeEnum.OPERATION, (Long)this.getPlanId());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnnouncementPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "AnnouncementPlugin_0", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u65b0\u589e\u6267\u884c\u8ba1\u5212\uff1a%1$s\u3002", "AnnouncementPlugin_7", "epm-eb-formplugin");
            this.writeLog("save", opName, opDescription, new String[]{((DynamicObject)save[0]).getString("id")});
            this.getView().close();
        }
        catch (Exception e) {
            log.error("saveAnouncementContent:", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private DynamicObject getDefaultScheme() {
        DynamicObject dynamicObject;
        if (this.getPlanId() != null && this.getPlanId() != 0L && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getPlanId(), (String)"eb_mnt_executeplan")) != null) {
            DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)"eb_mntscheme");
            temp.set("id", (Object)dynamicObject.getLong("mntscheme.id"));
            temp.set("title", (Object)dynamicObject.getLocaleString("announcementcontent.title"));
            temp.set("content", (Object)dynamicObject.getLocaleString("announcementcontent.content"));
            temp.set("pushmessagecenter", dynamicObject.get("announcementcontent.pushmessagecenter"));
            temp.set("pushtimeassistant", dynamicObject.get("announcementcontent.pushtimeassistant"));
            temp.set("instantpush", dynamicObject.get("announcementcontent.instantpush"));
            temp.set("starttime", dynamicObject.get("announcementcontent.starttime"));
            temp.set("endtime", dynamicObject.get("announcementcontent.endtime"));
            temp.set("remind", dynamicObject.get("announcementcontent.remind"));
            return temp;
        }
        QFilter filter = new QFilter("number", "=", (Object)"default");
        filter.and("purpose", "=", (Object)PurposeTypeEnum.OPERATION.getValue());
        filter.and("schemetype", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingle((String)"eb_mntscheme", (String)"id,title,content,pushmessagecenter,pushtimeassistant,instantpush,starttime,endtime,remind", (QFilter[])new QFilter[]{filter});
    }

    private Long getPlanId() {
        Object planid = this.getView().getFormShowParameter().getCustomParam("planid");
        return IDUtils.toLong((Object)planid);
    }
}

