/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.adminmode;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;

public class MntExecuteLogListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
CreateListDataProviderListener {
    private static final String MODEL = "model";
    private static final String BILLLIST = "billlistap";
    private static final String TOOLBARAP = "toolbarap";

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit modelBaseDate = (BasedataEdit)this.getView().getControl(MODEL);
        modelBaseDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                QFilter qFilter1 = MntExecuteLogListPlugin.this.getqFilter();
                setFilterEvent.getQFilters().add(qFilter1);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam(MODEL));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView().getParentView());
        }
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put(MODEL, modelId.toString());
            this.modelChanged(modelId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"VersionCopyRecordListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refreshBillList();
    }

    private void refreshBillList() {
        QFilter qFilter1 = this.getqFilter();
        BillList billList = (BillList)this.getView().getControl(BILLLIST);
        billList.setFilter(qFilter1);
        billList.setClearSelection(true);
        billList.refresh();
    }

    public void modelChanged(Long modelId) {
        this.getPageCache().put(MODEL, modelId.toString());
        this.refreshBillList();
    }

    protected QFilter getqFilter() {
        Long modelIdLong = -1L;
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(MODEL))) {
            modelIdLong = this.getModelId();
        }
        return new QFilter(MODEL, "=", (Object)modelIdLong);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            PluginUtils.setModelFilter(e, this.getView().getParentView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model != null) {
                Long modelId = model.getLong("id");
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView().getParentView(), (long)modelId);
                this.modelChanged(modelId);
            } else {
                this.getPageCache().put(MODEL, null);
                this.refreshBillList();
            }
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                return 0L;
            }
            modelId = model.getString("id");
            this.getPageCache().put(MODEL, modelId);
        }
        return Long.valueOf(modelId);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("btn_refresh".equals(itemKey)) {
            this.refreshBillList();
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                for (DynamicObject allRow : allRows) {
                    boolean executeresult;
                    DynamicObject announcementcontent = allRow.getDynamicObject("announcementcontent");
                    if (announcementcontent != null) {
                        String channel;
                        boolean pushmessagecenter;
                        StringBuilder content = new StringBuilder();
                        content.append(ResManager.loadResFormat((String)"\u4e3b\u9898\uff1a%1;", (String)"MntExecutePlanListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{announcementcontent.getString("title")})).append("\\n").append(ResManager.loadResFormat((String)"\u6b63\u6587\uff1a%1;", (String)"MntExecutePlanListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{announcementcontent.getString("content")}));
                        allRow.set("content", (Object)content.toString());
                        String actiontype = allRow.getString("actiontype");
                        if (StringUtils.isNotEmpty((CharSequence)actiontype) && "2".equals(actiontype)) {
                            pushmessagecenter = allRow.getBoolean("announcementcontent.pushmessagecenter");
                            if (!pushmessagecenter) {
                                allRow.set("channel", (Object)"");
                            } else {
                                channel = ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3\uff1b", (String)"MntExecutePlanListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                                allRow.set("channel", (Object)channel);
                            }
                            String executetype = allRow.getString("executetype");
                            if (StringUtils.isNotEmpty((CharSequence)executetype) && executetype.equals("1")) {
                                allRow.set("mntscheme", null);
                            }
                        } else {
                            pushmessagecenter = allRow.getBoolean("announcementcontent.pushmessagecenter");
                            if (!pushmessagecenter) {
                                channel = ResManager.loadKDString((String)"\u5f39\u7a97\uff1b", (String)"MntExecutePlanListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                                allRow.set("channel", (Object)channel);
                            } else {
                                StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u5f39\u7a97\uff1b", (String)"MntExecutePlanListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                                if (!"1".equals(actiontype)) {
                                    stringBuilder.append(ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3\uff1b", (String)"MntExecutePlanListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                                }
                                String channel2 = stringBuilder.toString();
                                allRow.set("channel", (Object)channel2);
                            }
                        }
                    }
                    if (!(executeresult = allRow.getBoolean("executeresult"))) {
                        allRow.set("reason", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"MntExecuteLogListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    allRow.set("reason", (Object)ResManager.loadKDString((String)"\u5931\u8d25", (String)"MntExecuteLogListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                return allRows;
            }
        });
    }
}

