/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.adminmode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.adminmode.CurrentModeEnum;
import kd.epm.eb.common.enums.adminmode.PlanStatusEnum;
import kd.epm.eb.common.enums.adminmode.RemindEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.task.notice.ScheduleHelper;

public class MntExecutePlanListPlugin
extends AbstractListPlugin
implements CreateListDataProviderListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(MntExecutePlanListPlugin.class);
    private static final String MODEL = "model";
    private static final String BILLLIST = "billlistap";
    private static final String TOOLBARAP = "toolbarap";

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit modelBaseDate = (BasedataEdit)this.getView().getControl(MODEL);
        modelBaseDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                QFilter qFilter1 = MntExecutePlanListPlugin.this.getqFilter();
                setFilterEvent.getQFilters().add(qFilter1);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam(MODEL));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView().getParentView());
        }
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put(MODEL, modelId.toString());
            this.modelChanged(modelId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"VersionCopyRecordListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refreshBillList();
    }

    private void refreshBillList() {
        QFilter qFilter1 = this.getqFilter();
        BillList billList = (BillList)this.getView().getControl(BILLLIST);
        billList.setFilter(qFilter1);
        billList.setClearSelection(true);
        billList.refresh();
    }

    public void modelChanged(Long modelId) {
        this.getPageCache().put(MODEL, modelId.toString());
        this.refreshBillList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model != null) {
                Long modelId = model.getLong("id");
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView().getParentView(), (long)modelId);
                this.modelChanged(modelId);
            } else {
                this.getPageCache().put(MODEL, null);
                this.refreshBillList();
            }
        }
    }

    protected QFilter getqFilter() {
        Long modelIdLong = -1L;
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(MODEL))) {
            modelIdLong = this.getModelId();
        }
        return new QFilter(MODEL, "=", (Object)modelIdLong);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                for (DynamicObject allRow : allRows) {
                    DynamicObject announcementcontent = allRow.getDynamicObject("announcementcontent");
                    if (announcementcontent == null) continue;
                    StringBuilder content = new StringBuilder();
                    content.append(ResManager.loadResFormat((String)"\u4e3b\u9898\uff1a%1;", (String)"MntExecutePlanListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{announcementcontent.getString("title")})).append("\\n").append(ResManager.loadResFormat((String)"\u6b63\u6587\uff1a%1;", (String)"MntExecutePlanListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{announcementcontent.getString("content")}));
                    allRow.set("content", (Object)content.toString());
                    boolean pushmessagecenter = allRow.getBoolean("announcementcontent.pushmessagecenter");
                    if (pushmessagecenter) {
                        StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u5f39\u7a97\uff1b", (String)"MntExecutePlanListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        stringBuilder.append(ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3\uff1b", (String)"MntExecutePlanListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        String channel = stringBuilder.toString();
                        allRow.set("channel", (Object)channel);
                        continue;
                    }
                    String channel = ResManager.loadKDString((String)"\u5f39\u7a97\uff1b", (String)"MntExecutePlanListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    allRow.set("channel", (Object)channel);
                }
                return allRows;
            }
        });
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            PluginUtils.setModelFilter(e, this.getView().getParentView());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("btn_refresh".equals(itemKey)) {
            this.refreshBillList();
        } else if ("btn_executelog".equals(itemKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_mnt_executeloglist");
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setShowTitle(true);
            formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
            this.getView().showForm(formShowParameter);
        } else if ("btn_cancel".equals(itemKey) || "btn_execute".equals(itemKey) || "btn_delete".equals(itemKey)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"MntExecutePlanListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                Set planIdSet = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
                DynamicObject[] planDyns = BusinessDataServiceHelper.load((String)"eb_mnt_executeplan", (String)"id,model,plan,status,announcementcontent.starttime,announcementcontent.remind,job_entry,job_entry.plan", (QFilter[])new QFilter[]{new QFilter("id", "in", planIdSet)});
                if ("btn_cancel".equals(itemKey)) {
                    Optional<DynamicObject> first = Arrays.stream(planDyns).filter(x -> PlanStatusEnum.CANCEL.getIndex().equals(x.getString("status")) || PlanStatusEnum.END.getIndex().equals(x.getString("status"))).findFirst();
                    if (first.isPresent()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u8ba1\u5212\u3001\u6267\u884c\u4e2d\u7684\u65b9\u6848\u53ef\u64a4\u9500", (String)"MntExecutePlanListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u53d6\u6d88\u6240\u9009\u7684\u6267\u884c\u8ba1\u5212\uff1f", (String)"MntExecutePlanListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("cancelCallBack", (IFormPlugin)this));
                    }
                } else if ("btn_execute".equals(itemKey)) {
                    if (planDyns.length > 1) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u6b21\u53ea\u80fd\u6267\u884c\u4e00\u6761\u8bb0\u5f55", (String)"MntExecutePlanListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject selectPlanDyn = planDyns[0];
                    if (!PlanStatusEnum.CANCEL.getIndex().equals(selectPlanDyn.getString("status"))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u5df2\u64a4\u9500\u7684\u65b9\u6848\u53ef\u6267\u884c", (String)"MntExecutePlanListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
                    qFilter.and("status", "in", Arrays.asList(PlanStatusEnum.WAIT.getIndex(), PlanStatusEnum.EXECUTING.getIndex()));
                    qFilter.and("id", "!=", (Object)selectPlanDyn.getLong("id"));
                    DynamicObject[] ids = BusinessDataServiceHelper.load((String)"eb_mnt_executeplan", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (ids != null && ids.length > 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u4e2a\u4f53\u7cfb\u53ea\u80fd\u6709\u4e00\u6761\u72b6\u6001\u4e3a\u8ba1\u5212\u6216\u6267\u884c\u4e2d\u7684\u6267\u884c\u8ba1\u5212", (String)"MntExecutePlanListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u91cd\u65b0\u6267\u884c\u5df2\u9009\u8ba1\u5212\uff1f", (String)"MntExecutePlanListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("executeCallBack", (IFormPlugin)this));
                } else if ("btn_delete".equals(itemKey)) {
                    Optional<DynamicObject> first = Arrays.stream(planDyns).filter(x -> PlanStatusEnum.WAIT.getIndex().equals(x.getString("status")) || PlanStatusEnum.EXECUTING.getIndex().equals(x.getString("status"))).findFirst();
                    if (first.isPresent()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u5df2\u64a4\u9500\u3001\u5b8c\u6210\u7684\u65b9\u6848\u53ef\u5220\u9664", (String)"MntExecutePlanListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5df2\u9009\u8ba1\u5212\uff1f", (String)"MntExecutePlanListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteCallBack", (IFormPlugin)this));
                    }
                }
            }
        }
    }

    private void handleExecute(DynamicObject[] planDyns, DynamicObject selectPlanDyn) {
        Date now = new Date(TimeServiceHelper.now().getTime() + 600000L);
        Date starttime = selectPlanDyn.getDate("announcementcontent.starttime");
        if (starttime.compareTo(now) >= 0) {
            HashSet<String> planIds = new HashSet<String>(16);
            for (DynamicObject planDyn : planDyns) {
                DynamicObjectCollection job_entry = planDyn.getDynamicObjectCollection("job_entry");
                for (DynamicObject dynamicObject : job_entry) {
                    planIds.add(dynamicObject.getString("plan.id"));
                }
            }
            if (CollectionUtils.isNotEmpty(planIds)) {
                log.info("\u91cd\u542f\u6267\u884c\u8ba1\u5212\uff1a{}", planIds);
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "in", planIds)});
                if (load != null && load.length > 0) {
                    for (DynamicObject dynamicObject : load) {
                        dynamicObject.set("status", (Object)"1");
                    }
                    ScheduleHelper.updatePlan((DynamicObject[])load);
                }
            }
            if (planDyns != null && planDyns.length > 0) {
                ArrayList<String> executeIds = new ArrayList<String>(planDyns.length);
                ArrayList<String> waitIds = new ArrayList<String>(planDyns.length);
                for (DynamicObject planDyn : planDyns) {
                    RemindEnum remindEnumByIndex = RemindEnum.getRemindEnumByIndex((String)planDyn.getString("announcementcontent.remind"));
                    if (TimeServiceHelper.now().compareTo(new Date(planDyn.getDate("announcementcontent.starttime").getTime() - remindEnumByIndex.getMillis())) > 0) {
                        planDyn.set("status", (Object)PlanStatusEnum.EXECUTING.getIndex());
                        executeIds.add(planDyn.getString("id"));
                        continue;
                    }
                    planDyn.set("status", (Object)PlanStatusEnum.WAIT.getIndex());
                    waitIds.add(planDyn.getString("id"));
                }
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6267\u884c", "MntExecutePlanListPlugin_16", "epm-eb-formplugin");
                if (CollectionUtils.isNotEmpty(executeIds)) {
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u8ba1\u5212ID\u201c%1$s\u201d\uff0c\u72b6\u6001\u201c%2$s\u201d\u3002", "MntExecutePlanListPlugin_14", "epm-eb-formplugin");
                    OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_mnt_executeplan", null, (String)"execute", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", executeIds), PlanStatusEnum.EXECUTING.getTitle()});
                }
                if (CollectionUtils.isNotEmpty(waitIds)) {
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u8ba1\u5212ID\u201c%1$s\u201d\uff0c\u72b6\u6001\u201c%2$s\u201d\u3002", "MntExecutePlanListPlugin_14", "epm-eb-formplugin");
                    OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_mnt_executeplan", null, (String)"execute", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", waitIds), PlanStatusEnum.WAIT.getTitle()});
                }
                SaveServiceHelper.save((DynamicObject[])planDyns);
            }
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_announcement");
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("modelid", (Object)selectPlanDyn.getLong("model.id"));
            formShowParameter.setCustomParam("planid", (Object)selectPlanDyn.getLong("id"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "resetExecutePlan"));
            this.getView().showForm(formShowParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("resetExecutePlan".equals(actionId)) {
            this.refreshBillList();
        }
    }

    private void handleCancel(Set<Object> planIdSet, DynamicObject[] planDyns) {
        DynamicObject[] load;
        HashSet<String> planIds = new HashSet<String>(16);
        HashSet<Long> modelIds = new HashSet<Long>(16);
        for (DynamicObject planDyn : planDyns) {
            DynamicObjectCollection job_entry = planDyn.getDynamicObjectCollection("job_entry");
            for (DynamicObject dynamicObject : job_entry) {
                planIds.add(dynamicObject.getString("plan.id"));
                modelIds.add(planDyn.getLong("model.id"));
            }
        }
        log.info("\u4fee\u6539\u8c03\u5ea6\u7cfb\u7edf\u4fe1\u606f\uff1a{}", planIds);
        if (CollectionUtils.isNotEmpty(planIds) && (load = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "in", planIds)})) != null && load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                dynamicObject.set("status", (Object)"0");
            }
            ScheduleHelper.updatePlan((DynamicObject[])load);
        }
        log.info("\u4fee\u6539\u9884\u7b97\u7cfb\u7edf\u4fe1\u606f\uff1a{}", planIdSet);
        if (planDyns != null && planDyns.length > 0) {
            ArrayList<String> idSet = new ArrayList<String>(planDyns.length);
            for (DynamicObject planDyn : planDyns) {
                planDyn.set("status", (Object)PlanStatusEnum.CANCEL.getIndex());
                idSet.add(planDyn.getString("id"));
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u6267\u884c\u8ba1\u5212", "MntExecutePlanListPlugin_13", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u8ba1\u5212ID\u201c%1$s\u201d\uff0c\u72b6\u6001\u201c%2$s\u201d\u3002", "MntExecutePlanListPlugin_14", "epm-eb-formplugin");
            OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_mnt_executeplan", null, (String)"execute", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", idSet), PlanStatusEnum.CANCEL.getTitle()});
            SaveServiceHelper.save((DynamicObject[])planDyns);
        }
        if (CollectionUtils.isNotEmpty(modelIds)) {
            QFilter qFilter = new QFilter("id", "in", modelIds);
            qFilter.and("currentmode", "=", (Object)CurrentModeEnum.ADMIN.getIndex());
            DynamicObject[] load2 = BusinessDataServiceHelper.load((String)"epm_model", (String)"id,currentmode", (QFilter[])new QFilter[]{qFilter});
            if (load2 != null && load2.length > 0) {
                ArrayList<String> idSet = new ArrayList<String>(load2.length);
                for (DynamicObject dynamicObject : load2) {
                    dynamicObject.set("currentmode", (Object)CurrentModeEnum.EMPTYMODE.getIndex());
                    idSet.add(dynamicObject.getString("id"));
                }
                log.info("\u4fee\u6539\u4f53\u7cfb\u4e3a\u7f16\u5236\u6a21\u5f0f\uff1a{}", (Object)load2.length);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u6267\u884c\u8ba1\u5212", "MntExecutePlanListPlugin_13", "epm-eb-formplugin");
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4fee\u6539\u4f53\u7cfb\u201c%1$s\u201d\u7684\u72b6\u6001\u4e3a\u201c%2$s\u201d\u3002", "MntExecutePlanListPlugin_15", "epm-eb-formplugin");
                OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_mnt_executeplan", null, (String)"execute", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", idSet), CurrentModeEnum.NORMAL.getDesc()});
                SaveServiceHelper.update((DynamicObject[])load2);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        BillList billList;
        ListSelectedRowCollection selectedRows;
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && CollectionUtils.isNotEmpty((Collection)(selectedRows = (billList = (BillList)this.getControl(BILLLIST)).getSelectedRows()))) {
            Set<Object> planIdSet = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
            DynamicObject[] planDyns = BusinessDataServiceHelper.load((String)"eb_mnt_executeplan", (String)"id,model,plan,status,announcementcontent.starttime,announcementcontent.remind,job_entry,job_entry.plan", (QFilter[])new QFilter[]{new QFilter("id", "in", planIdSet)});
            if ("cancelCallBack".equals(callBackId)) {
                this.handleCancel(planIdSet, planDyns);
            } else if ("executeCallBack".equals(callBackId)) {
                this.handleExecute(planDyns, planDyns[0]);
            } else if ("deleteCallBack".equals(callBackId) && CollectionUtils.isNotEmpty(planIdSet)) {
                log.info("\u5220\u9664\u8ba1\u5212\uff1a{}", planIdSet);
                DeleteServiceHelper.delete((String)"eb_mnt_executeplan", (QFilter[])new QFilter[]{new QFilter("id", "in", planIdSet)});
                if (CollectionUtils.isNotEmpty(planIdSet)) {
                    Set collect = planIdSet.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet());
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "MntExecutePlanListPlugin_17", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664\u6267\u884c\u8ba1\u5212\uff1a%1$s\u3002", "MntExecutePlanListPlugin_18", "epm-eb-formplugin");
                    OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_mnt_executeplan", null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", collect)});
                }
            }
            this.refreshBillList();
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                return 0L;
            }
            modelId = model.getString("id");
            this.getPageCache().put(MODEL, modelId);
        }
        return Long.valueOf(modelId);
    }
}

