/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.adminmode.utils;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.adminmode.CurrentModeEnum;
import kd.epm.eb.common.enums.adminmode.PlanStatusEnum;
import kd.epm.eb.common.enums.adminmode.PurposeTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.model.utils.ModelUtil;
import org.jetbrains.annotations.NotNull;

public class AdminModelUtil {
    public static String getCacheKey(@NotNull Long model, @NotNull Long plan) {
        return "ADMIN_WAIT_" + model + "_" + plan + "_" + UserUtils.getUserId();
    }

    public static void checkAdminMode(Long modelId, IFormView formView) {
        AdminModelUtil.checkAdminModeNeedResult(modelId, formView);
    }

    public static boolean checkAdminModeNeedResult(Long modelId, IFormView formView) {
        if (IDUtils.isNull((Long)modelId) || ModelServiceHelper.isModelManager((Long)modelId, (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)formView))) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model", (String)"id,currentmode");
        if (dynamicObject != null) {
            String currentmode = dynamicObject.getString("currentmode");
            if (StringUtils.isNotEmpty((String)currentmode) && CurrentModeEnum.ADMIN.getIndex().equals(currentmode)) {
                DynamicObject planDyn = AdminModelUtil.queryModelExecutePlanByStatus(modelId, PlanStatusEnum.EXECUTING);
                if (planDyn != null) {
                    Cache.get().remove(AdminModelUtil.getCacheKey(modelId, planDyn.getLong("id")));
                    AdminModelUtil.showConfirm(formView, planDyn.getString("announcementcontent.content"), null, null);
                    return true;
                }
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                qFilter.and(new QFilter("actiontype", "!=", (Object)"2"));
                DynamicObjectCollection logDyns = QueryServiceHelper.query((String)"eb_mnt_executelog", (String)"announcementcontent,announcementcontent.content", (QFilter[])new QFilter[]{qFilter}, (String)"executetime desc", (int)1);
                if (CollectionUtils.isNotEmpty((Collection)logDyns)) {
                    AdminModelUtil.showConfirm(formView, ((DynamicObject)logDyns.get(0)).getString("announcementcontent.content"), null, null);
                    return true;
                }
            } else {
                String cacheInfo;
                DynamicObject planDyn = AdminModelUtil.queryModelExecutePlanByStatus(modelId, PlanStatusEnum.EXECUTING);
                if (planDyn != null && StringUtils.isEmpty((String)(cacheInfo = Cache.get().get(AdminModelUtil.getCacheKey(modelId, planDyn.getLong("id"))))) && planDyn.getDate("announcementcontent.starttime") != null) {
                    int time = (int)(planDyn.getDate("announcementcontent.starttime").getTime() - TimeServiceHelper.now().getTime());
                    Cache.get().set(AdminModelUtil.getCacheKey(modelId, planDyn.getLong("id")), planDyn.getString("id"), time, TimeUnit.MILLISECONDS);
                    AdminModelUtil.showConfirm(formView, planDyn.getString("announcementcontent.content"), null, null);
                    return true;
                }
            }
        }
        return false;
    }

    public static void showConfirm(IFormView view, String message, String closeCallBackId, IFormPlugin formPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("title", (Object)PurposeTypeEnum.OPERATION.getDesc().loadKDString());
        formShowParameter.setCustomParam("content", (Object)message);
        formShowParameter.setFormId("eb_mnt_showconfirm");
        if (closeCallBackId != null && formPlugin != null) {
            formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, closeCallBackId));
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    private static DynamicObject queryModelExecutePlanByStatus(@NotNull Long model, PlanStatusEnum planStatusEnum) {
        QFilter qFilter = new QFilter("model", "=", (Object)model);
        qFilter.and("status", "=", (Object)planStatusEnum.getIndex());
        qFilter.and("purpose", "=", (Object)PurposeTypeEnum.OPERATION.getValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_mnt_executeplan", (String)"id,announcementcontent.title,announcementcontent.content,announcementcontent.starttime", (QFilter[])new QFilter[]{qFilter});
        return dynamicObject;
    }

    public static boolean isAdminMode(Long modelId) {
        DynamicObject modelObj;
        if (IDUtils.isNotNull((Long)modelId) && (modelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"currentmode")) != null) {
            return CurrentModeEnum.ADMIN.getIndex().equals(modelObj.getString("currentmode"));
        }
        return false;
    }

    public static void checkAdminModeBeforeItemClick(BeforeItemClickEvent evt, Long modelId, IFormView formView) {
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, modelId, formView, null);
    }

    public static void checkAdminModeBeforeItemClick(BeforeItemClickEvent evt, Long modelId, IFormView formView, Set<String> ignoreKeys) {
        if (IDUtils.isNotNull((Long)modelId) && formView != null && evt != null) {
            if (ignoreKeys != null && ignoreKeys.contains(evt.getItemKey())) {
                return;
            }
            if (AdminModelUtil.checkAdminModeNeedResult(modelId, formView)) {
                evt.setCancel(true);
            }
        }
    }

    public static void checkAdminModeBeforeClick(BeforeClickEvent evt, Long modelId, IFormView formView) {
        AdminModelUtil.checkAdminModeBeforeClick(evt, modelId, formView, null);
    }

    public static void checkAdminModeBeforeClick(BeforeClickEvent evt, Long modelId, IFormView formView, Set<String> ignoreKeys) {
        if (IDUtils.isNotNull((Long)modelId) && formView != null && evt != null) {
            if (ignoreKeys != null && ignoreKeys.contains(((Control)evt.getSource()).getKey())) {
                return;
            }
            if (AdminModelUtil.checkAdminModeNeedResult(modelId, formView)) {
                evt.setCancel(true);
            }
        }
    }

    public static boolean checkTitleAndContentLength(@NotNull IFormView formView, @NotNull IDataModel model) {
        OrmLocaleValue titleLocal;
        Object title = model.getValue("title");
        if (title != null && (titleLocal = (OrmLocaleValue)title).getLocaleValue().length() > 200) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u516c\u544a\u4e3b\u9898\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc7200\u5b57\u7b26\u3002", (String)"AnnouncementPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

