/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.quote.QuoteSave;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.fileimport.AnalyseReportTemplate;
import kd.epm.eb.common.analysereport.pojo.fileimport.AnalyseTemplateRelVal;
import kd.epm.eb.common.analysereport.pojo.fileimport.RptTemplateImportLog;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptTemplateService;
import kd.epm.eb.formplugin.billimpexp.AbstractImportTempPlugin;
import kd.epm.eb.spread.utils.AttachmentHelper;

public class ARptTemplateImportPlugin
extends AbstractImportTempPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btndownload", "replace"});
    }

    @Override
    protected boolean doImport(List<String> currentUrls) {
        try (InputStream fileInputStream = UploadUtil.getFileInputStream((String)currentUrls.get(0));){
            this.readTemplateZipFileContent(ModelCacheContext.getOrCreate((Long)this.getModelId()), fileInputStream);
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                this.getView().showErrorNotification(e.getMessage());
            }
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent backEvent) {
        super.closedCallBack(backEvent);
        String actionId = backEvent.getActionId();
        if ("templateBizModelSetting".equals(actionId)) {
            this.templateBizModelSettingCallBack(backEvent.getReturnData());
        }
    }

    private void templateBizModelSettingCallBack(Object returnData) {
        if (returnData instanceof List) {
            try {
                this.doImportTemplate((List)returnData);
            }
            catch (Exception e) {
                if (e instanceof KDBizException) {
                    this.getView().showErrorNotification(e.getMessage());
                }
                OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)"eb_analyserpttemplatelist", null, (String)"download", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165\u3002", "ARptTemplateImportService_19", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165\u5931\u8d25\u3002", "ARptTemplateImportService_22", "epm-eb-formplugin"), null);
                log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            }
        }
    }

    private void doImportTemplate(List<AnalyseReportTemplate> reportTemplateData) {
        Long modelId = this.getModelId();
        int readTemplateSize = reportTemplateData.size();
        List<RptTemplateImportLog> importLogList = this.checkReportTemplateDataData(modelId, reportTemplateData);
        if (reportTemplateData.size() == 0) {
            this.saveImportLogInfo(importLogList);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7\u3002", (String)"ARptTemplateImportService_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Set<String> importTemplateNumbers = this.saveImportAnalyseTemplateData(modelId, reportTemplateData, importLogList);
        this.showTipNotification(readTemplateSize, importLogList, importTemplateNumbers);
        this.getView().returnDataToParent((Object)"IMPORTSUSS");
        this.getView().close();
    }

    public void showTipNotification(int readTemplateSize, List<RptTemplateImportLog> importLogList, Set<String> importTemplateNumbers) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            MultiLangEnumBridge opDescription;
            if (importTemplateNumbers.size() > 0 && importTemplateNumbers.size() < readTemplateSize) {
                parentView.showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u6210\u529f\uff0c\u8bf7\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7\u3002", (String)"ARptTemplateImportService_24", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                opDescription = new MultiLangEnumBridge("\u90e8\u5206\u5bfc\u5165\u6210\u529f\u3002", "ARptTemplateImportService_20", "epm-eb-formplugin");
            } else if (readTemplateSize == importTemplateNumbers.size() && importLogList.stream().anyMatch(e -> "3".equals(e.getErrorType()))) {
                parentView.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff0c\u5b58\u5728\u90e8\u5206\u53d8\u91cf\u672a\u5339\u914d\u4e0a\uff0c\u8bf7\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7\u3002", (String)"ARptTemplateImportService_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                opDescription = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u529f\uff0c\u5b58\u5728\u90e8\u5206\u53d8\u91cf\u672a\u5339\u914d\u4e0a\u3002", "ARptTemplateImportService_21", "epm-eb-formplugin");
            } else {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ARptTemplateImportService_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                opDescription = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u529f\u3002", "ARptTemplateImportService_15", "epm-eb-formplugin");
            }
            this.getView().sendFormAction(parentView);
            OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)"eb_analyserpttemplatelist", null, (String)"import", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165\u3002", "ARptTemplateImportService_19", "epm-eb-formplugin"), (MultiLangEnumBridge)opDescription, null);
        }
    }

    private List<RptTemplateImportLog> checkReportTemplateDataData(Long modelId, List<AnalyseReportTemplate> reportTemplateData) {
        Map<String, Long> bizModelNumberIdMap = this.getCurModelBizModelNumberIdMap(modelId);
        HashMap<String, Map<String, Long>> bizModelValNumberIdMapHasRelFuc = new HashMap<String, Map<String, Long>>(16);
        HashMap<String, Map<String, Long>> bizModelValNumberIdMap = new HashMap<String, Map<String, Long>>(16);
        HashMap<Long, String> curModelValIdNameMap = new HashMap<Long, String>(16);
        this.getCurModelValNumberIdMap(modelId, bizModelValNumberIdMapHasRelFuc, curModelValIdNameMap, false);
        this.getCurModelValNumberIdMap(modelId, bizModelValNumberIdMap, curModelValIdNameMap, true);
        ArrayList<RptTemplateImportLog> importLogList = new ArrayList<RptTemplateImportLog>(10);
        HashSet<AnalyseReportTemplate> removeTemplateData = new HashSet<AnalyseReportTemplate>(16);
        for (AnalyseReportTemplate reportTemplate : reportTemplateData) {
            String number = reportTemplate.getNumber();
            String name = reportTemplate.getName();
            String bizModel = reportTemplate.getBizModel();
            String description = reportTemplate.getDescription();
            String status = reportTemplate.getStatus();
            List relValList = reportTemplate.getRelValList();
            String tempFileUrl = reportTemplate.getTempFileUrl();
            String tempFileName = reportTemplate.getTempFileName();
            Long bizModelId = bizModelNumberIdMap.get(bizModel);
            if (IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
                importLogList.add(new RptTemplateImportLog(modelId, number, name, "1", ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u201c%1\u201d\u5728\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"ARptTemplateImportService_4", (String)"epm-eb-formplugin", (Object[])new Object[]{bizModel})));
                removeTemplateData.add(reportTemplate);
                continue;
            }
            reportTemplate.setBizModelId(bizModelId);
            if (StringUtils.isNotEmpty((String)description) && description.length() > 255) {
                importLogList.add(new RptTemplateImportLog(modelId, number, name, "1", ResManager.loadKDString((String)"\u63cf\u8ff0\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\u3002", (String)"ARptTemplateImportService_5", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                removeTemplateData.add(reportTemplate);
                continue;
            }
            if (!"0".equals(status) && !"1".equals(status)) {
                importLogList.add(new RptTemplateImportLog(modelId, number, name, "1", ResManager.loadKDString((String)"status\u5b57\u6bb5\u503c\u53ea\u80fd\u4e3a'0'\u6216'1'\u3002", (String)"ARptTemplateImportService_6", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                removeTemplateData.add(reportTemplate);
                continue;
            }
            if (StringUtils.isEmpty((String)tempFileName) || StringUtils.isEmpty((String)tempFileUrl)) {
                importLogList.add(new RptTemplateImportLog(modelId, number, name, "2", ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684word\u6587\u4ef6\u3002", (String)"ARptTemplateImportService_7", (String)"epm-eb-formplugin", (Object[])new Object[]{bizModel})));
                removeTemplateData.add(reportTemplate);
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)relValList)) continue;
            Map curModelValNumberIdMapHasRelFuc = bizModelValNumberIdMapHasRelFuc.getOrDefault(bizModel, new HashMap(0));
            Map curModelValNumberIdMap = bizModelValNumberIdMap.getOrDefault(bizModel, new HashMap(0));
            ArrayList<AnalyseTemplateRelVal> validRelValList = new ArrayList<AnalyseTemplateRelVal>(relValList.size());
            for (AnalyseTemplateRelVal relVal : relValList) {
                String varKey = relVal.getVarKey();
                String varNum = relVal.getVarNum();
                String varType = relVal.getVarType();
                VariableTypeEnum varTypeEnum = VariableTypeEnum.getVariableTypeByNumber((String)varType);
                Long varId = (Long)curModelValNumberIdMap.get(varType + "#" + varNum);
                Long varIdHasRelFuc = (Long)curModelValNumberIdMapHasRelFuc.get(varType + "#" + varNum);
                String varName = (String)curModelValIdNameMap.get(varId);
                if (StringUtils.isEmpty((String)varKey)) {
                    importLogList.add(new RptTemplateImportLog(modelId, number, name, varNum, varName, null, false, "3", ResManager.loadKDString((String)"\u5f53\u524d\u53d8\u91cf\u7684varkey\u4e3a\u7a7a\u3002", (String)"ARptTemplateImportService_8", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                    continue;
                }
                if (varTypeEnum == null) {
                    importLogList.add(new RptTemplateImportLog(modelId, number, name, varNum, varName, null, false, "3", ResManager.loadResFormat((String)"\u5f53\u524d\u53d8\u91cf\u7c7b\u578b\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"ARptTemplateImportService_9", (String)"epm-eb-formplugin", (Object[])new Object[]{varType})));
                    continue;
                }
                if (IDUtils.isEmptyLong((Long)varId).booleanValue()) {
                    if (IDUtils.isNotEmptyLong((Long)varIdHasRelFuc).booleanValue()) {
                        importLogList.add(new RptTemplateImportLog(modelId, number, name, varNum, varName, varTypeEnum, false, "3", ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u76f8\u540c\u7f16\u7801\u53d8\u91cf\u5b58\u5728\u51fd\u6570\u7c7b\u578b\u3002", (String)"ARptTemplateImportService_25", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                        continue;
                    }
                    if (IDUtils.isNotEmptyLong((Long)((Long)curModelValNumberIdMap.get(varNum))).booleanValue()) {
                        importLogList.add(new RptTemplateImportLog(modelId, number, name, varNum, varName, varTypeEnum, false, "3", ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5b58\u5728\u76f8\u540c\u7f16\u7801\u53d8\u91cf\uff0c\u4f46\u7c7b\u578b\u4e0d\u540c\u3002", (String)"ARptTemplateImportService_17", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                        continue;
                    }
                    importLogList.add(new RptTemplateImportLog(modelId, number, name, varNum, varName, varTypeEnum, false, "3", ResManager.loadResFormat((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728\u6b64\u7f16\u7801\u7684\u201c%1\u201d\u7c7b\u578b\u53d8\u91cf\u3002", (String)"ARptTemplateImportService_10", (String)"epm-eb-formplugin", (Object[])new Object[]{varTypeEnum.getName()})));
                    continue;
                }
                relVal.setVarId(varId);
                importLogList.add(new RptTemplateImportLog(modelId, number, name, varNum, varName, varTypeEnum, true, null, null));
                validRelValList.add(relVal);
            }
            reportTemplate.setRelValList(validRelValList);
        }
        reportTemplateData.removeAll(removeTemplateData);
        return importLogList;
    }

    private void saveImportLogInfo(List<RptTemplateImportLog> importLogList) {
        if (CollectionUtils.isEmpty(importLogList)) {
            return;
        }
        DynamicObject[] importLogObjects = (DynamicObject[])importLogList.stream().map(RptTemplateImportLog::toDynamicObject).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])importLogObjects);
    }

    public void readTemplateZipFileContent(IModelCacheHelper orCreate, InputStream inputStream) {
        ArrayList<AnalyseReportTemplate> reportTemplates = new ArrayList(10);
        try (ZipInputStream zis = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String fileName = entry.getName();
                if (!fileName.equals("allTempRefData.json")) continue;
                reportTemplates = this.readTemplateData(orCreate, this.readTemplateDataJsonFile(zis));
                break;
            }
            if (reportTemplates.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6a21\u677f\u6570\u636eallTempRefData.json\u6587\u4ef6\u6216\u6587\u4ef6\u4e2d\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u6a21\u677f\u6570\u636e\u3002", (String)"ARptTemplateImportService_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            HashMap validTemplateRelWordFileMap = new HashMap(16);
            reportTemplates.forEach(e -> {
                validTemplateRelWordFileMap.put(String.format("%s(%s).doc", e.getName(), e.getNumber()), e);
                validTemplateRelWordFileMap.put(String.format("%s(%s).docx", e.getName(), e.getNumber()), e);
            });
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            while ((entry = zis.getNextEntry()) != null) {
                String fileName = entry.getName();
                AnalyseReportTemplate reportTemplate = (AnalyseReportTemplate)validTemplateRelWordFileMap.get(fileName);
                if (reportTemplate == null) continue;
                this.readWordFileGenTempFileFromZip(zis, reportTemplate, tempFileCache);
            }
            zis.closeEntry();
        }
        catch (Exception e2) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e2));
            throw new KDBizException(e2.getMessage());
        }
        this.openTemplateBizModelSettingPage(reportTemplates);
    }

    private void openTemplateBizModelSettingPage(List<AnalyseReportTemplate> readTemplateData) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_analysebizmodelset");
        formShowParameter.setCustomParam("readTemplateData", (Object)SerializationUtils.serializeToBase64(readTemplateData));
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "templateBizModelSetting"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    public Map<String, Object> readTemplateDataJsonFile(ZipInputStream zis) throws IOException {
        Map allTemplateData;
        int len;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((len = zis.read(buffer)) > 0) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        try {
            allTemplateData = (Map)SerializationUtils.fromJsonString((String)new String(byteArrayOutputStream.toByteArray()), Map.class);
        }
        catch (Exception e) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u6a21\u677f\u6570\u636ejson\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u662f\u5426\u6b63\u786e\u3002", (String)"ARptTemplateImportService_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return allTemplateData;
    }

    private Set<String> saveImportAnalyseTemplateData(Long modelId, List<AnalyseReportTemplate> reportTemplateData, List<RptTemplateImportLog> importLogList) {
        ArrayList urls = new ArrayList(10);
        ArrayList<DynamicObject> templateObjects = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> relValObjects = new ArrayList<DynamicObject>(10);
        ArrayList<Object> memberQuoteList = new ArrayList<Object>(10);
        int i = 0;
        Long userId = UserUtils.getUserId();
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)reportTemplateData.size());
        for (AnalyseReportTemplate analyseReportTemplate : reportTemplateData) {
            Object relVal22;
            long templateId = ids[i++];
            DynamicObject templateObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_analysereporttemplate");
            templateObject.set("id", (Object)templateId);
            templateObject.set("model", (Object)modelId);
            templateObject.set("number", (Object)analyseReportTemplate.getNumber());
            templateObject.set("name", (Object)analyseReportTemplate.getName());
            templateObject.set("bizmodel", (Object)analyseReportTemplate.getBizModelId());
            templateObject.set("description", (Object)analyseReportTemplate.getDescription());
            templateObject.set("status", (Object)analyseReportTemplate.getStatus());
            templateObject.set("creater", (Object)userId);
            templateObjects.add(templateObject);
            HashMap<String, Set> refObjIds = new HashMap<String, Set>(16);
            for (Object relVal22 : analyseReportTemplate.getRelValList()) {
                DynamicObject relValObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_analysevarsel");
                relValObject.set("rpttemp", (Object)templateId);
                relValObject.set("vartype", (Object)relVal22.getVarType());
                relValObject.set("var", (Object)relVal22.getVarId());
                relValObject.set("varkey", (Object)relVal22.getVarKey());
                relValObjects.add(relValObject);
                refObjIds.computeIfAbsent(relVal22.getVarType(), key -> new HashSet(16)).add(relVal22.getVarId());
            }
            ArrayList<MemberQuoteDao> templateQuoteList = new ArrayList<MemberQuoteDao>(10);
            relVal22 = refObjIds.entrySet().iterator();
            while (relVal22.hasNext()) {
                MemberTypeEnum memberTypeEnum;
                Map.Entry entry = (Map.Entry)relVal22.next();
                VariableTypeEnum variableTypeEnum = VariableTypeEnum.getVariableTypeByNumber((String)((String)entry.getKey()));
                if (variableTypeEnum == null || (memberTypeEnum = MemberTypeEnum.getEnumByFormKey((String)variableTypeEnum.getMetadata())) == null) continue;
                templateQuoteList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), (Collection)entry.getValue(), memberTypeEnum, MemberQuoteResourceEnum.RPTTEMPLATE, Long.valueOf(templateId)));
            }
            if (templateQuoteList.isEmpty()) {
                memberQuoteList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), analyseReportTemplate.getBizModelId(), MemberTypeEnum.BUSINESS_MODEL, MemberQuoteResourceEnum.RPTTEMPLATE, Long.valueOf(templateId)));
            } else {
                memberQuoteList.addAll(templateQuoteList);
            }
            HashMap<String, Object> url = new HashMap<String, Object>(16);
            url.put("url", analyseReportTemplate.getTempFileUrl());
            url.put("id", templateId);
            url.put("uid", GlobalIdUtil.genStringId());
            url.put("name", analyseReportTemplate.getTempFileName());
            urls.add(url);
        }
        try {
            for (Map map : urls) {
                AttachmentHelper.saveAttachmentData(Collections.singletonList(map), (Long)IDUtils.toLong(map.get("id")), (String)"eb_analysereporttemplate");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])templateObjects.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])relValObjects.toArray(new DynamicObject[0]));
                QuoteSave.get().save(memberQuoteList);
                this.saveImportLogInfo(importLogList);
            }
            catch (Throwable e) {
                log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
                tx.markRollback();
                throw new KDBizException("save error!");
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        Set<String> importTemplateNumbers = reportTemplateData.stream().map(AnalyseReportTemplate::getNumber).collect(Collectors.toSet());
        log.info(String.format("importTemplateNumbers:%s", StringUtils.join((Object[])importTemplateNumbers.toArray(), (String)",")));
        return importTemplateNumbers;
    }

    private List<AnalyseReportTemplate> readTemplateData(IModelCacheHelper orCreate, Map<String, Object> allTemplateData) {
        List tempData = (List)allTemplateData.get("tempData");
        if (CollectionUtils.isEmpty((Collection)tempData)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u6570\u636eallTempRefData.json\u6587\u4ef6\u4e2d\u6ca1\u6709\u6a21\u677f\u6570\u636e\u3002", (String)"ARptTemplateImportService_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<AnalyseReportTemplate> reportTemplates = new ArrayList<AnalyseReportTemplate>(10);
        for (Map data : tempData) {
            String number = (String)data.get("number");
            String name = (String)data.get("name");
            String bizModelNum = (String)data.get("bizmodel");
            String bizModelName = (String)data.get("bizmodelName");
            String description = (String)data.get("description");
            String status = (String)data.get("status");
            List varPropValue = (List)data.get("refVarData");
            AnalyseReportTemplate reportTemplate = new AnalyseReportTemplate(number, name, bizModelNum, bizModelName, description, status);
            if (CollectionUtils.isNotEmpty((Collection)varPropValue)) {
                for (Map varMap : varPropValue) {
                    String varKey = (String)varMap.get("varkey");
                    String varType = (String)varMap.get("vartype");
                    String varNum = varMap.get("var") instanceof String ? (String)varMap.get("var") : null;
                    reportTemplate.addRelVal(new AnalyseTemplateRelVal(varType, varKey, varNum));
                }
            }
            reportTemplates.add(reportTemplate);
        }
        return reportTemplates;
    }

    private void readWordFileGenTempFileFromZip(ZipInputStream zis, AnalyseReportTemplate reportTemplate, TempFileCache tempFileCache) throws IOException {
        byte[] content;
        int len;
        byte[] buffer = new byte[1024];
        String tempFile = String.valueOf(TimeServiceHelper.getTimeStamp());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
            while ((len = zis.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
        }
        try (FileInputStream stream = new FileInputStream(new File(tempFile));
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            while ((len = ((InputStream)stream).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            content = baos.toByteArray();
        }
        var9_11 = null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);){
            String tempFileName = String.format("%s(%s).docx", reportTemplate.getName(), reportTemplate.getNumber());
            String url = tempFileCache.saveAsUrl(tempFileName, (InputStream)byteArrayInputStream, 7200);
            reportTemplate.setTempFileUrl(url);
            reportTemplate.setTempFileName(tempFileName);
        }
        catch (Throwable throwable) {
            var9_11 = throwable;
            throw throwable;
        }
    }

    private Map<String, Long> getCurModelBizModelNumberIdMap(Long modelId) {
        HashMap<String, Long> bizModelNumberIdMap = new HashMap<String, Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            query.forEach(e -> bizModelNumberIdMap.put(e.getString("number"), e.getLong("id")));
        }
        return bizModelNumberIdMap;
    }

    private void getCurModelValNumberIdMap(Long modelId, Map<String, Map<String, Long>> bizModelValNumberIdMap, Map<Long, String> curModelValIdNameMap, boolean filterRefFunction) {
        List<Map<String, String>> allVariables = AnalyseRptTemplateService.queryAllVariables(modelId, 0L, filterRefFunction);
        for (Map<String, String> variables : allVariables) {
            Long id = IDUtils.toLong((Object)variables.get("id"));
            String bizModel = variables.get("bizmodel");
            String type = variables.get("type");
            String number = variables.get("number");
            String name = variables.get("name");
            curModelValIdNameMap.put(id, name);
            Map valNumberIdMap = bizModelValNumberIdMap.computeIfAbsent(bizModel, b -> new HashMap(16));
            valNumberIdMap.put(type + "#" + number, id);
            valNumberIdMap.put(number, id);
        }
    }

    @Override
    protected Set<String> selFileTypeNames() {
        return Sets.newHashSet((Object[])new String[]{".zip"});
    }

    @Override
    public Long getModelId() {
        String paramStr = (String)this.getView().getFormShowParameter().getCustomParams().get("modelId");
        return IDUtils.toLong((Object)paramStr);
    }

    @Override
    protected String getFileTypeErrTip() {
        return ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u4ece\u5206\u6790\u62a5\u544a\u6a21\u677f\u5bfc\u51fa\u7684\u538b\u7f29\u5305\u6587\u4ef6\uff08\u5305\u542bword\u6587\u4ef6\u548cjson\u6587\u4ef6\uff09\u3002", (String)"BillImportTempPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }
}

