/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.impexp.ARptExportService;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteCheck;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.quote.QuoteDelete;
import kd.epm.eb.common.analysereport.constants.SectionEventType;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;

public class AnalyReportVariableListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeview = (TreeView)this.getControl("treeview");
        treeview.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7SelectListener(this, new String[]{"bizmodel"});
        this.addClickListeners(new String[]{"btn_batsetting"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
        this.getModel().setValue("bizmodel", (Object)this.getDefBizModelId());
        this.initLeftTree();
    }

    private void initLeftTree() {
        TreeView treeview = (TreeView)this.getControl("treeview");
        treeview.deleteAllNodes();
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u53d8\u91cf\u5206\u7c7b", (String)"AnalyReportVariableListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        AnalyseRptCommonService.checkAndBuildDefVariable(this.getModelId(), this.getBizModelId());
        for (VariableTypeEnum typeEnum : VariableTypeEnum.values()) {
            root.addChild(new TreeNode("root", typeEnum.getNumber(), typeEnum.getName()));
        }
        treeview.addNode(root);
        treeview.expand("root");
        treeview.focusNode(root.getTreeNode(VariableTypeEnum.Combination.getNumber(), 20));
        this.treeNodeClick(new TreeNodeEvent((Object)treeview, (Object)"root", (Object)VariableTypeEnum.Combination.getNumber()));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (this.getBizModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"AnalyReportVariableListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String errorMes = this.checkOp4RptSection(itemKey);
        if (this.notEmpty(errorMes)) {
            this.getView().showTipNotification(errorMes);
            return;
        }
        switch (itemKey) {
            case "btn_add": {
                this.addNew(itemKey);
                break;
            }
            case "btn_delete": {
                this.beforeDelete(itemKey);
                break;
            }
            case "btn_refresh": {
                this.refreshEntryEntity();
                break;
            }
            case "btn_copy": {
                this.copyOpen(itemKey);
                break;
            }
            case "btn_upgrade": {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"ReportVarUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{null, null, null, null});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"AnalyReportVariableListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_update_param": {
                this.updateParamDims();
                break;
            }
            case "btn_export": {
                this.exportVar();
                break;
            }
            case "btn_import": {
                this.importVar();
                break;
            }
            case "btn_importlog": {
                this.importLog();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String ctrlKey = this.getClickCtrlKey(evt);
        if ("btn_batsetting".equals(ctrlKey)) {
            this.batSetRptSection();
        }
    }

    private void importLog() {
        Long modelId = this.getModelId();
        if (this.isEmpty(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"MembPermSearchPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long bizModelId = this.getBizModelId();
        if (this.isEmpty(bizModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimMembPermBasePlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("eb_analysevarimportlog");
        parameter.setCustomParam("model", (Object)modelId);
        parameter.setCustomParam("bizmodel", (Object)bizModelId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void importVar() {
        AnalyseReportUtil.getInstance().openImportPage(this.getView(), false, this.getModelId(), this.getBizModelId(), new CloseCallBack((IFormPlugin)this, "import"));
    }

    private void exportVar() {
        Long modelId = this.getModelId();
        if (this.isEmpty(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"MembPermSearchPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long bizModelId = this.getBizModelId();
        if (this.isEmpty(bizModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimMembPermBasePlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ARptExportService.getInstance().exportVar(this.getView(), modelId, bizModelId);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u51fa", "DimMembPermBasePlugin_45", "epm-eb-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "DimMembPermBasePlugin_46", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getView().getEntityId(), (String)"", (String)"export", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
    }

    private String checkOp4RptSection(String itemKey) {
        String mes = null;
        VariableTypeEnum typeEnum = this.getTypeEnumByLeftTree();
        if (VariableTypeEnum.RptSection == typeEnum && ("btn_add".equals(itemKey) || "btn_copy".equals(itemKey))) {
            mes = ResManager.loadKDString((String)"\u8bf7\u5728\u9884\u7b97\u6a21\u677f\u754c\u9762\u901a\u8fc7\u201c\u751f\u6210\u62a5\u544a\u53d8\u91cf\u201d\u6309\u94ae\u589e\u52a0\u62a5\u8868\u5207\u7247\u3002", (String)"AnalyReportVariableListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return mes;
    }

    private void batSetRptSection() {
        LinkedHashSet<Long> selectRowIds = this.getSelectRowIds();
        if (this.isEmpty(selectRowIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"AnalyReportVariableListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter rptSectionForm = AnalyseReportUtil.getInstance().getRptSectionForm(this.getView(), this.getModelId(), this.getBizModelId(), "eb_rptsection_batset");
        rptSectionForm.setCustomParam("BatSettingIds", (Object)SerializationUtils.toJsonString(selectRowIds));
        rptSectionForm.setCustomParam("BatSetting", (Object)"true");
        this.getView().showForm((FormShowParameter)rptSectionForm);
    }

    private void updateParamDims() {
        DynamicObject[] load;
        Long modelId = this.getModelId();
        QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
        Long bizModelId = this.getBizModelId();
        QFilter qFilter2 = new QFilter("bizmodel", "=", (Object)bizModelId);
        DynamicObjectCollection parameters = QueryServiceHelper.query((String)VariableTypeEnum.Parameter.getMetadata(), (String)"id, dimension", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        HashSet<Long> paramDims = new HashSet<Long>(16);
        HashMap<Long, List> paramDimMap = new HashMap<Long, List>(16);
        for (DynamicObject parameter : parameters) {
            long dimension = parameter.getLong("dimension");
            paramDims.add(dimension);
            List pkIds = paramDimMap.computeIfAbsent(dimension, k -> new ArrayList(16));
            pkIds.add(parameter.getLong("id"));
        }
        QFilter qFilter3 = new QFilter("id", "=", (Object)bizModelId);
        DynamicObjectCollection businessModels = QueryServiceHelper.query((String)"eb_businessmodel", (String)"viewentry.dimension.id as dimId, viewentry.dimension.number as dimNumber, viewentry.dimension.name as dimName", (QFilter[])new QFilter[]{qFilter1, qFilter3});
        HashMap<Long, BasedataPojo> bizModelDims = new HashMap<Long, BasedataPojo>(16);
        for (DynamicObject businessModel : businessModels) {
            long dimId = businessModel.getLong("dimId");
            bizModelDims.put(dimId, new BasedataPojo(Long.valueOf(dimId), businessModel.getString("dimNumber"), businessModel.getString("dimName")));
        }
        ArrayList<DynamicObject> toAddParameters = new ArrayList<DynamicObject>(16);
        Long userId = UserUtils.getUserId();
        Date time = TimeServiceHelper.now();
        HashSet dims = new HashSet(bizModelDims.keySet());
        for (Long dim : dims) {
            if (paramDims.contains(dim)) continue;
            BasedataPojo basedataPojo = (BasedataPojo)bizModelDims.get(dim);
            DynamicObject parameter = BusinessDataServiceHelper.newDynamicObject((String)VariableTypeEnum.Parameter.getMetadata());
            parameter.set("dimension", (Object)dim);
            parameter.set("number", (Object)basedataPojo.getNumber());
            parameter.set("name", (Object)basedataPojo.getName());
            parameter.set("model", (Object)modelId);
            parameter.set("bizmodel", (Object)bizModelId);
            parameter.set("creater", (Object)userId);
            parameter.set("modifier", (Object)userId);
            parameter.set("createdate", (Object)time);
            parameter.set("modifydate", (Object)time);
            toAddParameters.add(parameter);
        }
        if (toAddParameters.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toAddParameters.toArray(new DynamicObject[0]));
        }
        paramDims.removeAll(dims);
        HashSet toRemoveParameters = new HashSet(16);
        paramDims.forEach(e -> toRemoveParameters.addAll((Collection)paramDimMap.get(e)));
        CheckQuote checkQuote = new CheckQuote(this.getModelId(), Long.valueOf(0L), toRemoveParameters, VariableTypeEnum.Parameter.getRefMemberType());
        Set quoteParams = QuoteCheck.get().checkQuote(checkQuote);
        toRemoveParameters.removeAll(quoteParams);
        if (toRemoveParameters.size() != 0) {
            QFilter qFilter = new QFilter("id", "in", toRemoveParameters);
            DeleteServiceHelper.delete((String)VariableTypeEnum.Parameter.getMetadata(), (QFilter[])new QFilter[]{qFilter});
        }
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])quoteParams.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)VariableTypeEnum.Parameter.getMetadata()))) {
            String description = dynamicObject.getString("description");
            description = description + ResManager.loadKDString((String)"\u6b64\u7ef4\u5ea6\u5df2\u88ab\u4e1a\u52a1\u6a21\u578b\u79fb\u9664\uff0c\u8bf7\u68c0\u67e5\u62a5\u544a\u6a21\u677f\u662f\u5426\u5f15\u7528\u6b64\u7ef4\u5ea6\u4f5c\u4e3a\u53c2\u6570\uff0c\u5982\u6709\u5f15\u7528\uff0c\u8bf7\u81ea\u884c\u5220\u9664\u3002", (String)"AnalyReportVariableListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            dynamicObject.set("description", (Object)description);
        }
        SaveServiceHelper.save((DynamicObject[])load);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53c2\u6570\u7ef4\u5ea6\u66f4\u65b0\u6210\u529f\u3002", (String)"AnalyReportVariableListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refreshEntryEntity();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if ("bizmodel".equals(key)) {
            if (newValue == null) {
                this.getModel().setValue("bizmodel", (Object)((DynamicObject)changeData.getOldValue()).getLong("id"));
            } else {
                this.initLeftTree();
            }
        }
    }

    private void beforeDelete(String itemKey) {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryentity.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"AnalyReportVariableListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.deleteValidator()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8981\u5220\u9664\u6240\u9009\u62e9\u7684\u6570\u636e\uff1f", (String)"AnalyReportVariableListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
        }
    }

    private void addNew(String key) {
        FormShowParameter formShowParameter = this.getAddFormShowParameter(key);
        if (formShowParameter == null) {
            return;
        }
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        int rowIndex = evt.getRowIndex();
        DynamicObject object = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        if (object == null) {
            return;
        }
        String typeNumber = object.getString("type");
        VariableTypeEnum type = VariableTypeEnum.getVariableTypeByNumber((String)typeNumber);
        if (type == null) {
            return;
        }
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", type.getShowPage());
        openParameter.put("pkId", object.getString("id"));
        openParameter.put("Status", String.valueOf(OperationStatus.EDIT.getValue()));
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        if (VariableTypeEnum.Function == type) {
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "update"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("update".equals(actionId) || "btn_add".equals(actionId) || "btn_copy".equals(actionId) || "import".equals(actionId)) {
            this.refreshEntryEntity();
            if (("update".equals(actionId) || "btn_add".equals(actionId)) && "successful".equals(returnData.toString())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"", (String)"", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.Yes == evt.getResult() && "btn_delete".endsWith(callBackId)) {
            this.delVar();
        }
    }

    private void delVar() {
        LinkedHashSet<Long> ids = this.getSelectRowIds();
        VariableTypeEnum value = this.getTypeEnumByLeftTree();
        if (value != null) {
            try (TXHandle tx = TX.required((String)"delVar");){
                try {
                    DeleteServiceHelper.delete((String)value.getMetadata(), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                    QuoteDelete.get().delete(value.getRefQuoteResource().getType(), ids);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            if (value == VariableTypeEnum.RptSection) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"RptSectionService", (String)"notify4Change2Bcm", (Object[])new Object[]{this.getModelId(), this.getBizModelId(), new ArrayList<Long>(ids), SectionEventType.DELETE});
            }
        }
        this.refreshEntryEntity();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalyReportVariableListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.getView().getPageCache().put("clickTree", nodeId);
        this.refreshEntryEntity();
    }

    @Override
    public Long getModelId() {
        Long value = (Long)this.getValue("model", "id");
        if (value == null) {
            value = 0L;
        }
        return value;
    }

    private Long getBizModelId() {
        Long value = (Long)this.getValue("bizmodel", "id");
        if (value == null) {
            value = 0L;
        }
        return value;
    }

    private void refreshEntryEntity() {
        VariableTypeEnum variableType = this.getTypeEnumByLeftTree();
        if (variableType == null) {
            return;
        }
        String typeNumber = variableType.getNumber();
        IDataModel iDataModel = this.getModel();
        iDataModel.deleteEntryData("entryentity");
        QFBuilder qf = new QFBuilder("model", "=", (Object)this.getModelId());
        qf.add("bizmodel", "=", (Object)this.getBizModelId());
        String selectProps = this.getSelectFields(variableType);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)variableType.getMetadata(), (String)selectProps, (QFilter[])qf.toArrays(), (String)"modifydate desc");
        if (objectMap.size() > 0) {
            iDataModel.beginInit();
            iDataModel.batchCreateNewEntryRow("entryentity", objectMap.size());
            iDataModel.endInit();
            int i = 0;
            for (DynamicObject object : objectMap.values()) {
                AnalyseRptCommonService.fillEntryEntityRow(object, iDataModel, i, typeNumber, variableType);
                ++i;
            }
            iDataModel.updateCache();
        }
        this.setFieldVisible(variableType);
        this.getView().updateView("entryentity");
    }

    private void setFieldVisible(VariableTypeEnum variableType) {
        ArrayList<String> unVisibleKeys = new ArrayList<String>(Arrays.asList("showfields", "functiontype", "formula", "btn_update_param", "btn_batsetting", "ebtemplate"));
        ArrayList<String> visibleKeys = new ArrayList<String>(Arrays.asList("btn_add", "btn_copy", "btn_delete"));
        if (VariableTypeEnum.Function == variableType) {
            this.changeFieldVisible(unVisibleKeys, visibleKeys, "showfields");
            this.changeFieldVisible(unVisibleKeys, visibleKeys, "functiontype");
        } else if (VariableTypeEnum.Combination == variableType) {
            this.changeFieldVisible(unVisibleKeys, visibleKeys, "formula");
            this.changeFieldVisible(unVisibleKeys, visibleKeys, "functiontype");
        } else if (VariableTypeEnum.Parameter != variableType && VariableTypeEnum.RptSection == variableType) {
            this.changeFieldVisible(unVisibleKeys, visibleKeys, "btn_batsetting");
            this.changeFieldVisible(unVisibleKeys, visibleKeys, "ebtemplate");
        }
        for (VariableTypeEnum variableTypeEnum : VariableTypeEnum.values()) {
            String labelKey = variableTypeEnum.name().toLowerCase() + "_label";
            if (variableTypeEnum == variableType) {
                visibleKeys.add(labelKey);
                continue;
            }
            unVisibleKeys.add(labelKey);
        }
        if (unVisibleKeys.size() != 0) {
            this.getView().setVisible(Boolean.valueOf(false), unVisibleKeys.toArray(new String[0]));
        }
        if (visibleKeys.size() != 0) {
            this.getView().setVisible(Boolean.valueOf(true), visibleKeys.toArray(new String[0]));
        }
    }

    private void changeFieldVisible(List<String> unVisibleKeys, List<String> visibleKeys, String fieldKey) {
        unVisibleKeys.remove(fieldKey);
        visibleKeys.add(fieldKey);
    }

    private String getSelectFields(VariableTypeEnum variableType) {
        String selectProps = "id,number,name,description,modifier,modifydate,creater,createdate";
        if (VariableTypeEnum.Function == variableType) {
            selectProps = selectProps + ",showfields,type";
        } else if (VariableTypeEnum.Combination == variableType) {
            selectProps = selectProps + ",dimgrouptype,formula_show";
        } else if (VariableTypeEnum.RptSection == variableType) {
            selectProps = selectProps + ",template";
        }
        return selectProps;
    }

    private VariableTypeEnum getTypeEnumByLeftTree() {
        String focusNodeId = this.getView().getPageCache().get("clickTree");
        if (focusNodeId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u4fa7\u5206\u7c7b\u8282\u70b9\u3002", (String)"AnalyReportVariableListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return VariableTypeEnum.getVariableTypeByNumber((String)focusNodeId);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("bizmodel".equals(name)) {
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    private Long getDefBizModelId() {
        Object bizmodel = this.getView().getFormShowParameter().getCustomParam("bizmodel");
        if (bizmodel != null) {
            return (Long)bizmodel;
        }
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            return 0L;
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"getDefBizModelId", (String)"eb_businessmodel", (String)"id", (QFilter[])qf.toArray(), (String)"id", (int)1);
        if (rows != null && !rows.isEmpty()) {
            return ((Row)rows.iterator().next()).getLong("id");
        }
        return 0L;
    }

    private void copyOpen(String key) {
        DynamicObject load;
        LinkedHashSet<Long> ids = this.getSelectRowIds();
        if (ids.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AnalyReportVariableListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long firstRowId = (Long)ids.iterator().next();
        VariableTypeEnum type = this.getTypeEnumByLeftTree();
        if (VariableTypeEnum.Parameter == type && (load = BusinessDataServiceHelper.loadSingle((Object)firstRowId, (String)"eb_dimensionparameter", (String)"dimension.number")) != null && !"BudgetPeriod".equals(load.getString("dimension.number"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u590d\u5236\u671f\u95f4\u53c2\u6570\u3002", (String)"AnalyReportVariableListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = this.getAddFormShowParameter(key);
        if (formShowParameter == null) {
            return;
        }
        formShowParameter.setCustomParam("copyId", (Object)firstRowId);
        this.getView().showForm(formShowParameter);
    }

    private FormShowParameter getAddFormShowParameter(String key) {
        VariableTypeEnum value = this.getTypeEnumByLeftTree();
        if (value == null) {
            return null;
        }
        HashMap<String, Object> openParameter = new HashMap<String, Object>(4);
        openParameter.put("formId", value.getShowPage());
        openParameter.put("Status", String.valueOf(OperationStatus.ADDNEW.getValue()));
        openParameter.put("model", this.getModelId());
        openParameter.put("bizmodel", this.getBizModelId());
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        if (value == VariableTypeEnum.Function) {
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        return formShowParameter;
    }

    private LinkedHashSet<Long> getSelectRowIds() {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryentity.getEntryState().getSelectedRows();
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(selectedRows.length);
        for (int selectedRow : selectedRows) {
            ids.add(Long.parseLong(this.getModel().getEntryRowEntity("entryentity", selectedRow).getString("id")));
        }
        return ids;
    }

    private boolean deleteValidator() {
        VariableTypeEnum type = this.getTypeEnumByLeftTree();
        if (type == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u4fa7\u5206\u7c7b\u8282\u70b9\u3002", (String)"AnalyReportVariableListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        LinkedHashSet<Long> selectRowIds = this.getSelectRowIds();
        CheckQuote checkQuote = new CheckQuote(this.getModelId(), Long.valueOf(0L), selectRowIds, type.getRefMemberType());
        QuoteCheckResult quoteCheckResult = QuoteCheck.get().checkQuoteResult(checkQuote);
        if (quoteCheckResult.isHasQuote()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u4e0d\u53ef\u5220\u9664", (String)"AnalyReportVariableListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{quoteCheckResult.getMsg()}));
            return false;
        }
        return true;
    }
}

