/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptTmpUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.var.MemberVarValObj;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysereport.VarValSettingHandler;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;

public class AnalyseReportEditPlugin
extends AbstractBasePlugin
implements VarValSettingHandler {
    private static final String BTN_OK = "btn_ok";

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"varvaltext"});
    }

    public void afterCreateNewData(EventObject e) {
        this.setValueWhenEdit();
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String langStr = RequestContext.get().getLang().toString();
        OrmLocaleValue nameOrmValue = (OrmLocaleValue)this.getModel().getValue("name");
        if (StringUtils.isEmpty((String)nameOrmValue.get((Object)langStr)) && nameOrmValue != null && !nameOrmValue.isEmpty()) {
            nameOrmValue.setItem(langStr, nameOrmValue.toString());
        }
        this.getModel().setValue("name", (Object)nameOrmValue);
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btn_ok": {
                this.confirm();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String ctlKey = ((Control)evt.getSource()).getKey();
        if ("varvaltext".equals(ctlKey)) {
            this.openVarValSelForm((IFormPlugin)this);
        }
    }

    @Override
    public Long getModelId() {
        return Long.parseLong(this.getPageCache().get("rpt_modelId"));
    }

    @Override
    public Long getBizModelId() {
        return Long.parseLong(this.getPageCache().get("rpt_bizModelId"));
    }

    private Long getRptTemplateId() {
        return Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("tempid"));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData != null && "VarValSel".equals(actionId)) {
            this.fillBackVarVal((ListSelectedRowCollection)returnData);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.dealPropChange(e);
    }

    private void confirm() {
        if (!this.validator()) {
            return;
        }
        if (this.isEdit() && this.getModel().getDataChanged()) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
        }
        this.getView().returnDataToParent(this.getReportData());
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private boolean validator() {
        String number = (String)this.getModel().getValue("number");
        if (!AnalyseRptCommonService.numberFormatCheck(number, this.getView())) {
            return false;
        }
        String tempid = (String)this.getView().getFormShowParameter().getCustomParam("tempid");
        QFBuilder qf = new QFBuilder("rpttemp", "=", (Object)Long.parseLong(tempid));
        qf.add("number", "=", (Object)number);
        if (!this.isEdit() && QueryServiceHelper.exists((String)"eb_analysereport", (QFilter[])qf.toArrays())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u7f16\u7801\u5728\u8be5\u6a21\u677f\u4e0b\u5df2\u5b58\u5728\u3002", (String)"AnalyseReportEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("varentryentity");
        HashMap<Long, Pair> varValMap = new HashMap<Long, Pair>(entryRows.size());
        ArrayList<String> emptyRowIndex = new ArrayList<String>(entryRows.size());
        int index = 1;
        for (DynamicObject row : entryRows) {
            Long varValId = row.getLong("varvalid");
            Long viewId = row.getLong("varvalviewid");
            if (this.isEmpty(varValId)) {
                emptyRowIndex.add(String.valueOf(index));
            }
            Long varId = row.getLong("varitem.id");
            varValMap.put(varId, new Pair((Object)varValId, (Object)viewId));
            ++index;
        }
        if (emptyRowIndex.size() > 0) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u884c\u201c%1\u201d\u7684\u53d8\u91cf\u503c\u672a\u8bbe\u7f6e\u3002", (String)"AnalyseReportEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", emptyRowIndex)}));
            return false;
        }
        AnalyseRptTmpUtil.getInstance().addVarValUserRecord(this.getRptTemplateId(), varValMap);
        return true;
    }

    private Map<String, Object> getReportData() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("rptnumber", this.getValue("number", null));
        map.put("rptname", this.getValue("name", null));
        map.put("tempid", this.getView().getFormShowParameter().getCustomParam("tempid"));
        if (!this.isEdit()) {
            AnalyseReportUtil.getInstance().addVarValInfo4Params(this.selValInfo(), map);
        }
        return map;
    }

    private boolean isEdit() {
        return OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus();
    }

    private void setValueWhenEdit() {
        Long tempId = this.getRptTemplateId();
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)tempId, (String)"eb_analysereporttemplate");
        if (tempObj == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u6a21\u677f\u5bf9\u8c61\u5931\u8d25\uff1a%1\u3002", (String)"AnalyseReportEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{tempId}));
        }
        this.getPageCache().put("rpt_modelId", tempObj.getString("model.id"));
        this.getPageCache().put("rpt_bizModelId", tempObj.getString("bizmodel.id"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.isEdit()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        } else {
            Map varValInfo;
            Object name;
            IDataModel iDataModel = this.getModel();
            Object number = customParams.get("rptnumber");
            if (this.notEmpty(number)) {
                iDataModel.setValue("number", number);
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            }
            if (this.notEmpty(name = customParams.get("rptname"))) {
                Map rptName = (Map)JSONUtils.parse((String)name.toString(), HashMap.class);
                OrmLocaleValue nameOrmValue = (OrmLocaleValue)this.getModel().getValue("name");
                if (rptName != null) {
                    for (Map.Entry entry : rptName.entrySet()) {
                        nameOrmValue.setItem((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                iDataModel.setValue("name", (Object)nameOrmValue);
            }
            if (this.notEmpty(varValInfo = AnalyseReportUtil.getInstance().getVarValInfoFromParam(customParams))) {
                this.initVarEntry(varValInfo);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tips"});
            }
        }
        if ("1".equals(customParams.get("isReadOnly"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_OK});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"varentryentity"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tips"});
        }
        this.initVarEntry(this.getModelId());
        this.getModel().setValue("tips", (Object)ResManager.loadKDString((String)"\u4fee\u6539\u53d8\u91cf\u8d4b\u503c\uff0c\u70b9\u51fb\u201c\u751f\u6210\u62a5\u544a\u201d\u66f4\u65b0\u62a5\u544a\u5185\u5bb9\u3002", (String)"AnalyseReportEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getModel().setDataChanged(false);
    }

    private void initVarEntry(Map<String, List<MemberVarValObj>> varValObjs) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("varentryentity");
        AnalyseReportUtil.getInstance().buildVarEntryRows(varValObjs, entryRows, modelCacheHelper);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setValueWhenEdit();
    }

    @Override
    public Map<Long, MemberView> getVarValUserRecord() {
        if (this.loadUserRecord()) {
            Map varValUserRecord = AnalyseRptTmpUtil.getInstance().getVarValUserRecord(this.getRptTemplateId());
            if (this.notEmpty(varValUserRecord)) {
                Long bizModelId = this.getBizModelId();
                Long modelId = this.getModelId();
                DynamicObject[] varObjs = BusinessDataServiceHelper.load((String)"eb_periodvariable", (String)"id,dimension.number", (QFilter[])new QFilter("id", "in", varValUserRecord.keySet()).toArray());
                IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
                Map defaultViews = modelCacheHelper.getViewsByBusModel(bizModelId);
                for (DynamicObject obj : varObjs) {
                    Set permMembIds;
                    Long varId = obj.getLong("id");
                    String dimNumber = obj.getString("dimension.number");
                    MemberView memberInfo = (MemberView)varValUserRecord.get(varId);
                    if (!this.notEmpty(dimNumber) || memberInfo == null) continue;
                    Long viewId = memberInfo.getViewId();
                    if (this.isEmpty(viewId) && SysDimensionEnum.dimHasView((String)dimNumber)) {
                        viewId = (Long)defaultViews.get(dimNumber);
                        memberInfo.setViewId(viewId);
                    }
                    if ((permMembIds = DimMembPermHelper.getPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModelId, (Long)memberInfo.getViewId(), (DimMembPermType)DimMembPermType.READ, (boolean)true)) == null || permMembIds.contains(memberInfo.getMemberId())) continue;
                    varValUserRecord.remove(varId);
                }
            }
            return varValUserRecord;
        }
        return new HashMap<Long, MemberView>(1);
    }

    @Override
    public Map<Long, Set<Long>> getDimVarInfo() {
        Long rptTemplateId = this.getRptTemplateId();
        return AnalyseReportUtil.getInstance().getTempRefVarInfos(rptTemplateId);
    }

    @Override
    public boolean loadUserRecord() {
        return this.isEmpty(this.getModel().getValue("number"));
    }
}

