/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.form.helper.WebOfficeBrowserHelper;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.url.UrlService;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.analysereport.constants.FilterEnum;
import kd.epm.eb.common.analysereport.pojo.AnalyseRptEntity;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptTemplateService;
import kd.epm.eb.spread.utils.AttachmentHelper;

public class AnalyseReportListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
SearchEnterListener,
SetFilterListener {
    private static final String TREEROOTID = "ID-9527";
    private static final String CACHE_ROOT = "rootCache";
    private static final String BIZMODEL_TAG = "bizmodel";
    private static final String CACHE_SEARCH_CURRENTID = "searchCurrentIdCache";
    private static final String CACHE_SEARCH_RESULTIDS = "searchResultIdsCache";
    private static final String CACHE_FILTER_STATUS = "filterStatusCache";
    private static final String CACHE_STATUS_REPORT_IDS = "allReportIdsCache";
    private static final List<String> filterPanelKeys = Arrays.asList("allpanel", "readpanel", "unreadpanel");
    private static final String FOCUSID_TREE = "leftTreeFocusid";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"unreadnum", "readnum", "allnum", "modelswitch", "expand_all", "shrink_all", "searchbefore", "searchnext"});
        TreeView treeview = (TreeView)this.getControl("lefttreeview");
        treeview.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search searchap = (Search)this.getControl("searchap");
        searchap.addEnterListener((SearchEnterListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userSelectModelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        if (userSelectModelId != 0L) {
            this.getModel().setValue("model", (Object)userSelectModelId);
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            if (model != null) {
                Label modellabel = (Label)this.getControl("modellabel");
                modellabel.setText(model.getString("name"));
            }
        }
        this.layoutPage();
        this.loadLeftTree();
        this.loadFilterPanel();
        this.setStatusFilter((String)this.getView().getFormShowParameter().getCustomParam("clickKey"));
        BillList control = (BillList)this.getControl("billlistap");
        String focusNodeId = this.getView().getPageCache().get("clickTree");
        if (focusNodeId != null) {
            control.getFilterParameter().getQFilters().addAll(this.getClickFilter().getFilters());
        } else {
            control.getFilterParameter().getQFilters().add(new QFilter("model", "=", (Object)9527));
        }
        control.refresh();
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        super.hyperLinkClick(arg);
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        BillList control = (BillList)this.getControl("billlistap");
        Long focusRowPkId = (Long)control.getFocusRowPkId();
        AnalyseRptCommonService.updateReportRead(focusRowPkId);
        this.showNewRpt(this.getReportData(focusRowPkId), false);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        if (0L == this.getModelId()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyseReportListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (itemKey = evt.getItemKey()) {
            case "btn_add": {
                this.addNew(itemKey);
                break;
            }
            case "btn_delete": {
                this.beforeDelete(itemKey);
                break;
            }
            case "btn_load": {
                this.printOrDownLoadFiles();
                break;
            }
            case "btn_refresh": {
                this.refreshAll();
                break;
            }
            case "btn_viewinfo": {
                this.openBaseInfoForm();
                break;
            }
        }
    }

    private void openBaseInfoForm() {
        BillList billList = this.getBillListControl();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AnalyseReportListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AnalyseReportListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            ListSelectedRow selectedRow = selectedRows.get(0);
            AnalyseRptEntity rptData = new AnalyseRptEntity();
            rptData.setFileId((Long)selectedRow.getPrimaryKeyValue());
            rptData.setRptNumber(selectedRow.getNumber());
            rptData.setRptName(selectedRow.getName());
            rptData.setSaved(true);
            AnalyseReportUtil.getInstance().openBaseForm(Long.valueOf(Long.parseLong(this.getFocusNodeId())), true, rptData, this.getView(), null);
        }
    }

    private void printOrDownLoadFiles() {
        DynamicObject[] bd_attachments = this.getFilesUrl();
        if (bd_attachments == null || bd_attachments.length == 0) {
            return;
        }
        String errInfo = ResManager.loadKDString((String)"\u4e0b\u8f7d\u62a5\u544a\u5931\u8d25\u3002", (String)"AnalyseReportListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        try {
            for (int i = 0; i < bd_attachments.length; ++i) {
                String docUrl = UrlService.getAttachmentFullUrl((String)URLEncoder.encode(bd_attachments[i].getString("ffileid"), "utf-8"));
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)docUrl);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(errInfo + e.getMessage() + e.getStackTrace());
        }
    }

    private DynamicObject[] getFilesUrl() {
        List<Long> seletePkids = this.getSeletePkids();
        if (seletePkids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AnalyseReportListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return AnalyseRptCommonService.getFileObj(this.getStrLst(seletePkids));
    }

    private List<String> getStrLst(List<Long> seletePkids) {
        ArrayList<String> returns = new ArrayList<String>(seletePkids.size());
        seletePkids.forEach(e -> returns.add(e.toString()));
        return returns;
    }

    private void beforeDelete(String itemKey) {
        List<Long> seletePkids = this.getSeletePkids();
        if (seletePkids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AnalyseReportListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8981\u5220\u9664\u6240\u9009\u5185\u5bb9\uff1f", (String)"AnalyseReportListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
    }

    private void deleteRows() {
        List<Long> seletePkids = this.getSeletePkids();
        AttachmentHelper.deleteAttachmentData((QFilter)new QFilter("finterid", "in", seletePkids.stream().map(String::valueOf).collect(Collectors.toSet())));
        QFBuilder qfBuilder = new QFBuilder("id", "in", seletePkids);
        DeleteServiceHelper.delete((String)"eb_analysereport", (QFilter[])qfBuilder.toArray());
        qfBuilder = new QFBuilder("report", "in", seletePkids);
        DeleteServiceHelper.delete((String)"eb_analyserpt_user", (QFilter[])qfBuilder.toArray());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalyseReportListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void addNew(String itemKey) {
        if (!this.isTempNode()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u8282\u70b9\u3002", (String)"AnalyseReportListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!AnalyseRptCommonService.tempIsEnable(Long.parseLong(this.getFocusNodeId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"AnalyseReportListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        AnalyseReportUtil.getInstance().openBaseForm(Long.valueOf(this.getFocusNodeId()), false, null, this.getView(), new CloseCallBack((IFormPlugin)this, itemKey));
    }

    private String getFocusNodeId() {
        String focusNodeId = this.getView().getPageCache().get("clickTree");
        if (focusNodeId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u8282\u70b9\u3002", (String)"AnalyseReportListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return focusNodeId;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "modelswitch": {
                this.modelSwitch();
                break;
            }
            case "expand_all": 
            case "shrink_all": {
                this.expendNode(key);
                break;
            }
            case "searchbefore": 
            case "searchnext": {
                this.searchNext(key);
                break;
            }
            case "unreadnum": 
            case "readnum": 
            case "allnum": 
            case "unreadpanel": 
            case "readpanel": 
            case "allpanel": {
                this.setStatusFilter(key);
                this.loadLeftTree();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("model".equals(name)) {
            Label modellabel = (Label)this.getControl("modellabel");
            modellabel.setText(this.getValue("model", "name").toString());
            this.getView().updateView("modellabel");
            this.setStatusFilter(null);
            this.loadFilterPanel();
            this.loadLeftTree();
            this.getPageCache().put(CACHE_SEARCH_RESULTIDS, null);
            this.getPageCache().put(CACHE_SEARCH_CURRENTID, null);
            UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)this.getModelId());
            this.refreshBillList();
        }
    }

    private void modelSwitch() {
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.click();
    }

    private void expendNode(String key) {
        TreeNode root = this.getLeftTree();
        this.modefyIsExpand("expand_all".equals(key), root);
        TreeView treeview = (TreeView)this.getControl("lefttreeview");
        treeview.updateNode(root);
    }

    private void modefyIsExpand(boolean isExpand, TreeNode node) {
        List children = node.getChildren();
        if (children != null && children.size() > 0) {
            node.setIsOpened(isExpand);
            for (TreeNode child : children) {
                this.modefyIsExpand(isExpand, child);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.getView().getPageCache().put("clickTree", nodeId);
        BillList control = (BillList)this.getControl("billlistap");
        control.clearSelection();
        control.refresh();
    }

    private void layoutPage() {
        if (this.isReadOnly()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_add", "btn_delete"});
            String filterStatus = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_FILTER_STATUS);
            filterStatus = filterStatus == null ? FilterEnum.unRead.getIndex() : filterStatus;
            this.getPageCache().put(CACHE_FILTER_STATUS, filterStatus);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"statusfilter"});
        }
    }

    private void loadLeftTree() {
        TreeNode focusNode;
        String cacheId;
        Map map;
        Long modelId = this.getModelId();
        String prefix = "";
        if (this.isReadOnly()) {
            Set<Long> reportIds = AnalyseRptCommonService.queryReadReportIds(modelId, this.getPageCache().get(CACHE_FILTER_STATUS));
            this.getPageCache().put(CACHE_STATUS_REPORT_IDS, SerializationUtils.toJsonString(reportIds));
            map = BusinessDataServiceHelper.loadFromCache((String)"eb_analysereport", (String)"id,rpttemp", (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
            prefix = "rpttemp.";
        } else {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("shareusers.fbasedataid", "=", (Object)UserUtils.getUserId());
            map = BusinessDataServiceHelper.loadFromCache((String)"eb_analysereporttemplate", (String)"id,name,bizmodel,status", (QFilter[])qfBuilder.toArray());
        }
        TreeNode root = new TreeNode("", TREEROOTID, ResManager.loadKDString((String)"\u5206\u6790\u62a5\u544a\u6a21\u677f", (String)"AnalyseReportListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        AnalyseRptCommonService.buildAnalyseRptListTree(root, map, prefix);
        TreeView treeview = (TreeView)this.getControl("lefttreeview");
        treeview.deleteAllNodes();
        treeview.addNode(root);
        treeview.expand(TREEROOTID);
        TreeNode defFocusNode = root;
        List children = root.getChildren();
        if (children != null && children.size() > 0) {
            treeview.expand(((TreeNode)children.get(0)).getId());
            children = ((TreeNode)children.get(0)).getChildren();
            if (children != null && children.size() > 0) {
                defFocusNode = (TreeNode)children.get(0);
            }
        }
        if ((cacheId = this.getPageCache().get(FOCUSID_TREE)) != null && (focusNode = root.getTreeNode(cacheId, 20)) != null) {
            defFocusNode = focusNode;
        }
        treeview.focusNode(defFocusNode);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.serializeToBase64((Object)root));
        this.getPageCache().put("clickTree", defFocusNode.getId());
        treeview.treeNodeClick(defFocusNode.getParentid(), defFocusNode.getId());
    }

    private boolean isReadOnly() {
        Object readOnly = this.getView().getFormShowParameter().getCustomParam("isReadOnly");
        return readOnly != null && "1".equals(readOnly.toString());
    }

    @Override
    public Long getModelId() {
        Object value = this.getModel().getValue("model");
        if (value == null) {
            return 0L;
        }
        return ((DynamicObject)value).getLong("id");
    }

    public void search(SearchEnterEvent evt) {
        String text = evt.getText();
        if (StringUtils.isEmpty((String)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u641c\u7d22\u7684\u5185\u5bb9\u3002", (String)"AnalyseReportListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode root = this.getLeftTree();
        List<String> resultIds = this.getSearchIds(null, root, text);
        if (resultIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"AnalyseReportListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusid = resultIds.get(0);
        List childPath = root.getChildPath(focusid);
        TreeView treeview = (TreeView)this.getControl("lefttreeview");
        if (childPath != null && childPath.size() > 0) {
            childPath.remove(childPath.size() - 1);
            for (String s : childPath) {
                treeview.expand(s);
            }
        }
        treeview.focusNode(root.getTreeNode(focusid, 20));
        this.getPageCache().put(CACHE_SEARCH_CURRENTID, focusid);
        this.getPageCache().put(CACHE_SEARCH_RESULTIDS, SerializationUtils.toJsonString(resultIds));
    }

    private List<String> getSearchIds(List<String> ids, TreeNode node, String text) {
        List children;
        if (ids == null) {
            ids = new ArrayList<String>(10);
        }
        if (node.getText().contains(text)) {
            ids.add(node.getId());
        }
        if ((children = node.getChildren()) != null && children.size() > 0) {
            for (TreeNode child : children) {
                this.getSearchIds(ids, child, text);
            }
        }
        return ids;
    }

    private void searchNext(String key) {
        String currentId = this.getPageCache().get(CACHE_SEARCH_CURRENTID);
        String results = this.getPageCache().get(CACHE_SEARCH_RESULTIDS);
        if (currentId == null || results == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22\u6570\u636e\u3002", (String)"AnalyseReportListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List resultIds = (List)SerializationUtils.fromJsonString((String)results, ArrayList.class);
        int index = resultIds.indexOf(currentId);
        if (index < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22\u6570\u636e\u3002", (String)"AnalyseReportListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isNext = "searchnext".equals(key);
        if (isNext) {
            if (++index >= resultIds.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u4e2a\u641c\u7d22\u9879\u3002", (String)"AnalyseReportListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (--index < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u4e2a\u641c\u7d22\u9879\u3002", (String)"AnalyseReportListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        currentId = (String)resultIds.get(index);
        TreeNode root = this.getLeftTree();
        List childPath = root.getChildPath(currentId);
        TreeView treeview = (TreeView)this.getControl("lefttreeview");
        if (childPath != null && childPath.size() > 0) {
            childPath.remove(childPath.size() - 1);
            for (String s : childPath) {
                treeview.expand(s);
            }
        }
        treeview.focusNode(root.getTreeNode(currentId, 20));
        this.getPageCache().put(CACHE_SEARCH_CURRENTID, currentId);
    }

    private List<Long> getSeletePkids() {
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        return selectedRows.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes != evt.getResult()) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if ("btn_delete".equals(callBackId)) {
            this.deleteRows();
            BillList control = (BillList)this.getControl("billlistap");
            control.clearSelection();
            control.addSetFilterListener((SetFilterListener)this);
            control.refresh();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("btn_add".equals(actionId) && (returnData = (Map)evt.getReturnData()) != null) {
            this.showNewRpt(returnData, true);
        }
    }

    private void showNewRpt(Map<String, Object> returnData, boolean isNew) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("pageID", this.getView().getPageId());
        paramMap.put("edit", "1");
        paramMap.put("isnew", isNew);
        paramMap.put("isReadOnly", this.isReadOnly() ? "1" : "0");
        AnalyseReportUtil.getInstance().cacheVarValInfo2Redis(returnData);
        paramMap.putAll(returnData);
        WebOfficeBrowserParam webOfficeBrowserParam = new WebOfficeBrowserParam("eb_analyserptgen");
        webOfficeBrowserParam.setParams(paramMap);
        webOfficeBrowserParam.setHideAddressBar(true);
        this.getView().openUrl(WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)webOfficeBrowserParam));
    }

    private void refreshAll() {
        this.getPageCache().put(FOCUSID_TREE, this.getFocusNodeId());
        this.loadFilterPanel();
        if (this.isReadOnly()) {
            this.getPageCache().put(CACHE_STATUS_REPORT_IDS, SerializationUtils.toJsonString(AnalyseRptCommonService.queryReadReportIds(this.getModelId(), this.getPageCache().get(CACHE_FILTER_STATUS))));
        }
        this.loadLeftTree();
        BillList control = (BillList)this.getControl("billlistap");
        control.clearSelection();
        control.refresh();
    }

    private QFBuilder getClickFilter() {
        String nodeId = this.getFocusNodeId();
        TreeNode root = this.getLeftTree();
        HashSet<Long> tempIds = new HashSet<Long>(16);
        if (TREEROOTID.equals(nodeId)) {
            tempIds.addAll(AnalyseRptCommonService.getTempIdFromTree(root, null));
        } else {
            TreeNode node = root.getTreeNode(nodeId, 20);
            String longNumber = node.getLongNumber();
            if (StringUtils.isNotEmpty((String)longNumber) && BIZMODEL_TAG.equals(longNumber)) {
                List children = node.getChildren();
                if (children != null) {
                    tempIds.addAll(children.stream().map(c -> Long.parseLong(c.getId())).collect(Collectors.toSet()));
                }
            } else {
                tempIds.add(Long.parseLong(nodeId));
            }
        }
        QFBuilder qf = new QFBuilder("rpttemp", "in", tempIds);
        if (this.isReadOnly()) {
            qf.add("id", "in", SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_STATUS_REPORT_IDS), HashSet.class));
        } else {
            qf.add("creater", "=", (Object)UserUtils.getUserId());
        }
        qf.add("model", "=", (Object)this.getModelId());
        return qf;
    }

    private void setStatusFilter(String key) {
        if (!this.isReadOnly()) {
            return;
        }
        key = key == null ? "unread" : key;
        String status = FilterEnum.unRead.getIndex();
        String panelKey = "unreadpanel";
        if (key.startsWith("read")) {
            status = FilterEnum.read.getIndex();
            panelKey = "readpanel";
        } else if (key.startsWith("all")) {
            status = FilterEnum.all.getIndex();
            panelKey = "allpanel";
        }
        HashMap<String, String> parmClearBc = new HashMap<String, String>(16);
        parmClearBc.put("bc", "");
        for (String filterPanelKey : filterPanelKeys) {
            this.getView().updateControlMetadata(filterPanelKey, parmClearBc);
        }
        HashMap<String, String> parmSetBc = new HashMap<String, String>(16);
        parmSetBc.put("bc", "#e5e5e5");
        this.getView().updateControlMetadata(panelKey, parmSetBc);
        this.getPageCache().put(CACHE_FILTER_STATUS, status);
    }

    private void loadFilterPanel() {
        Long modelId = this.getModelId();
        if (!this.isReadOnly() || 0L == modelId) {
            return;
        }
        String readnum = AnalyseRptCommonService.getReportCount(true, modelId);
        String unreadnum = AnalyseRptCommonService.getReportCount(false, modelId);
        String allnum = Integer.parseInt(readnum) + Integer.parseInt(unreadnum) + "";
        Label label = (Label)this.getControl("readnum");
        label.setText(readnum);
        label = (Label)this.getControl("unreadnum");
        label.setText(unreadnum);
        label = (Label)this.getControl("allnum");
        label.setText(allnum);
    }

    private boolean isTempNode() {
        String focusNodeId = this.getFocusNodeId();
        if (TREEROOTID.equals(focusNodeId)) {
            return false;
        }
        TreeNode root = this.getLeftTree();
        TreeNode treeNode = root.getTreeNode(focusNodeId, 20);
        return treeNode == null || !StringUtils.isNotEmpty((String)treeNode.getLongNumber());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (e.getSource() instanceof BillList) {
            e.getQFilters().addAll(this.getClickFilter().getFilters());
        }
    }

    private TreeNode getLeftTree() {
        String cache = this.getPageCache().get(CACHE_ROOT);
        if (cache == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u8fc7\u671f\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u91cd\u65b0\u8fdb\u5165\u3002", (String)"AnalyseReportListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (TreeNode)SerializationUtils.deSerializeFromBase64((String)cache);
    }

    private Map<String, Object> getReportData(Long pkId) {
        Map<String, Object> rptObj = AnalyseRptTemplateService.getReportData(pkId);
        if (rptObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AnalyseReportListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return rptObj;
    }

    private void refreshBillList() {
        BillList control = (BillList)this.getControl("billlistap");
        control.clearSelection();
        control.refresh();
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        AdminModelUtil.checkAdminModeBeforeClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"modelswitch", "treepanelswitchrpt"}));
    }
}

