/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.analysereport.constants.AnalyseReportTemplate;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;

public class AnalyseReportTemplateEditPlugin
extends AbstractFormPlugin {
    private static final String MODEL = "model";
    private static final String BTN_OK = "btn_ok";

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam(MODEL);
        this.getModel().setValue(MODEL, (Object)modelid);
        this.setValueWhenEdit();
        BasedataEdit bizmodel = (BasedataEdit)this.getControl("bizmodel");
        bizmodel.setQFilter(new QFilter(MODEL, "=", (Object)modelid));
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btn_ok": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        if (!this.validator()) {
            return;
        }
        this.getView().returnDataToParent((Object)this.getReportData());
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private boolean validator() {
        String number = (String)this.getModel().getValue("number");
        if (!AnalyseRptCommonService.numberFormatCheck(number, this.getView())) {
            return false;
        }
        Long id = (Long)this.getModel().getValue("id");
        QFBuilder qf1 = new QFBuilder(MODEL, "=", (Object)this.getModelId());
        qf1.add("number", "=", (Object)number);
        qf1.add("id", "!=", (Object)id);
        if (QueryServiceHelper.exists((String)"eb_analysereporttemplate", (QFilter[])qf1.toArrays())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5728\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u3002", (String)"AnalyseReportTemplateEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (this.isEdit()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
            }
            return false;
        }
        QFBuilder qf = new QFBuilder(MODEL, "=", (Object)this.getModelId());
        String name = this.getModel().getValue("name").toString();
        qf.add("name", "=", (Object)name);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_analysereporttemplate", (String)"id,number", (QFilter[])qf.toArray());
        objectMap.remove(id);
        if (objectMap.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5728\u8be5\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u3002", (String)"AnalyseReportTemplateEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue(MODEL, "id");
    }

    private AnalyseReportTemplate getReportData() {
        IDataModel iDataModel = this.getModel();
        AnalyseReportTemplate template = new AnalyseReportTemplate();
        template.setNumber(iDataModel.getValue("number").toString());
        template.setName(iDataModel.getValue("name").toString());
        template.setDescription(iDataModel.getValue("description").toString());
        template.setModelid(this.getModelId());
        template.setEnable(((Boolean)iDataModel.getValue("status")).booleanValue());
        template.setBizModelid(Long.valueOf(((DynamicObject)iDataModel.getValue("bizmodel")).getLong("id")));
        return template;
    }

    private boolean isEdit() {
        return OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus();
    }

    private void setValueWhenEdit() {
        if (this.isEdit()) {
            AnalyseReportTemplate temp = (AnalyseReportTemplate)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("data")), AnalyseReportTemplate.class);
            IDataModel iDataModel = this.getModel();
            iDataModel.setValue("number", (Object)temp.getNumber());
            iDataModel.setValue("name", (Object)temp.getName());
            iDataModel.setValue("description", (Object)temp.getDescription());
            iDataModel.setValue("status", (Object)temp.isEnable());
            iDataModel.setValue("bizmodel", (Object)temp.getBizModelid());
            Long id = temp.getId();
            if (id != null) {
                iDataModel.setValue("id", (Object)id);
                if (QueryServiceHelper.exists((String)"eb_analysereporttemplate", (QFilter[])new QFilter("id", "=", (Object)id).and("shareusers.fbasedataid_id", "is not null", (Object)"").toArray())) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
                }
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizmodel"});
        }
    }
}

