/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.helper.WebOfficeBrowserHelper;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.impexp.ARptExportService;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptTmpUtil;
import kd.epm.eb.business.quote.QuoteDelete;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.analysereport.constants.AnalyseReportTemplate;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptTemplateService;
import kd.epm.eb.formplugin.analysereport.webOffice.AnalyseTmpCopy;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.spread.utils.AttachmentHelper;

public class AnalyseReportTemplateListPlugin
extends AbstractListPlugin
implements SetFilterListener,
BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_COPY = "btn_copy";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_VARIABLESET = "btn_variableset";
    private static final String BTN_SHARE_SCHEME = "btn_sharescheme";
    private static final String BTN_SHARE_RANGE = "btn_sharerange";
    private static final String BTN_IMPORT = "btn_import";
    private static final String BTN_IMPORT_LOG = "btn_importlog";
    private static final String BTN_EXPORT = "btn_export";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addF7SelectListener(this, new String[]{"shareusers"});
    }

    public void afterCreateNewData(EventObject e) {
        long userSelectModelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        if (userSelectModelId != 0L) {
            this.getModel().setValue(MODEL, (Object)userSelectModelId);
        }
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.setQFilters(ModelUtil.getModelFilter((IFormView)this.getView()));
    }

    private AnalyseReportTemplate getTempData(Long pkId) {
        AnalyseReportTemplate rptObj = AnalyseRptTemplateService.getTempData(pkId);
        if (rptObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AnalyseReportTemplateListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return rptObj;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg) {
        super.hyperLinkClick(arg);
        if (arg.getFieldName().equals("number")) {
            BillList control = (BillList)this.getControl("billlistap");
            this.showTemplateEdit(this.getTempData((Long)control.getFocusRowPkId()), false);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (this.getModelId() == 0L) {
            return;
        }
        switch (key) {
            case "btn_add": {
                this.addNew(key);
                break;
            }
            case "btn_copy": {
                this.copyOne();
                break;
            }
            case "btn_enable": 
            case "btn_disable": {
                this.changeStatus(key);
                break;
            }
            case "btn_delete": {
                this.beforeDelete(key);
                break;
            }
            case "btn_refresh": {
                this.refresh(this.getModelId());
                break;
            }
            case "btn_variableset": {
                this.openVariableSetPage(key);
                break;
            }
            case "btn_sharescheme": {
                this.openShareSchemeListPage(key);
                break;
            }
            case "btn_sharerange": {
                this.selectShareUsers();
                break;
            }
            case "btn_import": {
                this.importTemplate();
                break;
            }
            case "btn_export": {
                this.export();
                break;
            }
            case "btn_importlog": {
                this.importTemplateLog();
                break;
            }
        }
    }

    private void importTemplate() {
        AnalyseReportUtil.getInstance().openImportPage(this.getView(), true, this.getModelId(), Long.valueOf(0L), new CloseCallBack((IFormPlugin)this, BTN_IMPORT));
    }

    private void importTemplateLog() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setPageId(this.getView().getPageId() + "_importlog_" + this.getModelId());
        parameter.setBillFormId("eb_analysetempimportlog");
        parameter.setCustomParam(MODEL, (Object)this.getModelId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void export() {
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        if (this.isEmpty(selectRowPkIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u6570\u636e\u3002", (String)"AnalyseReportTemplateListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ARptExportService.getInstance().exportTemp(this.getView(), this.getModelId(), selectRowPkIds);
        this.writeLog("export", new MultiLangEnumBridge("\u5bfc\u51fa", "AnalyseReportTemplateListPlugin_18", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "AnalyseReportTemplateListPlugin_19", "epm-eb-formplugin"));
    }

    private void addNew(String key) {
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_analysereporttemplate");
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void copyOne() {
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        if (selectRowPkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u6570\u636e\u3002", (String)"AnalyseReportTemplateListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.copyTempData(selectRowPkIds);
        this.refresh(this.getModelId());
    }

    private void changeStatus(String key) {
        MultiLangEnumBridge opNameBridge;
        String opName;
        DynamicObject[] load;
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        if (selectRowPkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u6570\u636e\u3002", (String)"AnalyseReportTemplateListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        char enable = key.equals(BTN_ENABLE) ? (char)'1' : '0';
        ArrayList<String> numbers = new ArrayList<String>(16);
        for (DynamicObject object : load = BusinessDataServiceHelper.load((String)"eb_analysereporttemplate", (String)"status,number", (QFilter[])new QFilter[]{new QFilter("id", "in", selectRowPkIds)})) {
            object.set("status", (Object)Character.valueOf(enable));
            numbers.add(object.getString("number"));
        }
        if (load.length > 0) {
            SaveServiceHelper.save((DynamicObject[])load);
        }
        if (enable == '1') {
            opName = ResManager.loadKDString((String)"\u542f\u7528", (String)"AnalyseReportTemplateListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            opNameBridge = new MultiLangEnumBridge("\u542f\u7528", "AnalyseReportTemplateListPlugin_15", "epm-eb-formplugin");
        } else {
            opName = ResManager.loadKDString((String)"\u7981\u7528", (String)"AnalyseReportTemplateListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            opNameBridge = new MultiLangEnumBridge("\u7981\u7528", "AnalyseReportTemplateListPlugin_16", "epm-eb-formplugin");
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"AnalyseReportTemplateListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{opName}));
        this.addObjOpLog(opName, opNameBridge, numbers);
        this.refresh(this.getModelId());
    }

    private void beforeDelete(String key) {
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        if (selectRowPkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"AnalyseReportTemplateListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFBuilder qf = new QFBuilder("id", "in", selectRowPkIds);
        qf.add("status", "=", (Object)"1");
        if (QueryServiceHelper.exists((String)"eb_analysereporttemplate", (QFilter[])qf.toArrays())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5b58\u5728\u542f\u7528\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AnalyseReportTemplateListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"eb_analysereport", (String)"rpttemp.name", (QFilter[])new QFilter("rpttemp.id", "in", selectRowPkIds).toArray());
        if (reports.size() > 0) {
            Set collect = reports.stream().map(r -> r.getString("rpttemp.name")).collect(Collectors.toSet());
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6a21\u677f\uff1a%1\u5df2\u5b58\u5728\u62a5\u544a\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AnalyseReportTemplateListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", collect)}));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8981\u5220\u9664\u6240\u9009\u6570\u636e\uff1f", (String)"AnalyseReportTemplateListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
    }

    private void deleteRows() {
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        QFBuilder qf = new QFBuilder("id", "in", selectRowPkIds);
        List tempNumbers = QueryServiceHelper.query((String)"eb_analysereporttemplate", (String)"number", (QFilter[])qf.toArrays()).stream().map(obj -> obj.getString("number")).collect(Collectors.toList());
        AttachmentHelper.deleteAttachmentData((QFilter)new QFilter("finterid", "in", this.Long2Str(selectRowPkIds)));
        DeleteServiceHelper.delete((String)"eb_analysevarsel", (QFilter[])new QFilter[]{new QFilter("rpttemp.id", "in", selectRowPkIds)});
        DeleteServiceHelper.delete((String)"eb_analysereporttemplate", (QFilter[])qf.toArray());
        QuoteDelete.get().delete(MemberQuoteResourceEnum.RPTTEMPLATE.getType(), selectRowPkIds);
        AnalyseRptTmpUtil.getInstance().delVarValUserRecord(selectRowPkIds);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalyseReportTemplateListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "AnalyseReportTemplateListPlugin_14", "epm-eb-formplugin");
        this.addObjOpLog(ResManager.loadKDString((String)"\u5220\u9664", (String)"AnalyseReportTemplateListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), opNameBridge, tempNumbers);
        this.refresh(this.getModelId());
    }

    private Set<String> Long2Str(List<Long> selectRowPkIds) {
        HashSet<String> returns = new HashSet<String>(16);
        selectRowPkIds.forEach(e -> returns.add(e.toString()));
        return returns;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult result = evt.getResult();
        if (result == MessageBoxResult.No) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if (BTN_DELETE.equals(callBackId)) {
            this.deleteRows();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (BTN_IMPORT.equals(actionId)) {
            this.refresh(this.getModelId());
        }
        if ((returnData = evt.getReturnData()) == null) {
            return;
        }
        if (BTN_ADD.equals(actionId)) {
            ((AnalyseReportTemplate)returnData).setId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
            this.showTemplateEdit(returnData, true);
        } else if (BTN_SHARE_SCHEME.equals(actionId)) {
            DynamicObject object = (DynamicObject)returnData;
            DynamicObjectCollection user = object.getDynamicObjectCollection("user");
            Object[] ids = user.stream().map(d -> d.getLong("fbasedataid.id")).toArray();
            this.getModel().setValue("shareusers", (Object)ids);
            this.shareOperation();
        } else if (BTN_SHARE_RANGE.equals(actionId)) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
            if (data.size() == 0) {
                return;
            }
            Object[] ids = data.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            this.getModel().setValue("shareusers", (Object)ids);
            this.shareOperation();
        }
    }

    private void showTemplateEdit(Object returnData, boolean isNew) {
        if (returnData == null) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("pageID", this.getView().getPageId());
        paramMap.put("data", SerializationUtils.toJsonString((Object)returnData));
        paramMap.put("edit", "1");
        paramMap.put("isnew", isNew);
        WebOfficeBrowserParam webOfficeBrowserParam = new WebOfficeBrowserParam("eb_analyserpttempsetting");
        webOfficeBrowserParam.setParams(paramMap);
        webOfficeBrowserParam.setHideAddressBar(true);
        this.getView().openUrl(WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)webOfficeBrowserParam));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (MODEL.equals(key)) {
            long modelid = 0L;
            if (newValue != null) {
                modelid = ((DynamicObject)newValue).getLong("id");
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelid);
            }
            this.refresh(modelid);
        }
    }

    private void refresh(Long modelid) {
        BillList control = (BillList)this.getControl("billlistap");
        control.getFilterParameter().getQFilters().add(new QFilter(MODEL, "=", (Object)modelid));
        control.clearSelection();
        control.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (e.getSource() instanceof BillList) {
            e.getQFilters().add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        }
    }

    private void openVariableSetPage(String key) {
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_analyserptvariablelist");
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IFormView parentView = this.getView().getParentView();
        IFormView mainView = this.getView().getMainView();
        if (parentView != null && mainView != null) {
            String menuPageID = "eb_analyserptvariablelist" + mainView.getPageId();
            if (mainView.getView(menuPageID) != null) {
                IFormView childFormView = mainView.getView(menuPageID);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            } else {
                formShowParameter.setPageId(menuPageID);
                IFormView appPageView = this.getView().getView(parentView.getPageId());
                appPageView.showForm(formShowParameter);
                this.getView().sendFormAction(appPageView);
            }
        } else {
            this.getView().showForm(formShowParameter);
        }
    }

    @Override
    public Long getModelId() {
        Object value = this.getModel().getValue(MODEL);
        if (value == null) {
            return 0L;
        }
        return ((DynamicObject)value).getLong("id");
    }

    private List<Long> getSelectRowPkIds() {
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        return selectedRows.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    private void copyTempData(List<Long> selectRowPkIds) {
        if (selectRowPkIds == null || selectRowPkIds.size() == 0) {
            return;
        }
        BillList list = (BillList)this.getControl("billlistap");
        HashMap<String, String> paras = new HashMap<String, String>(16);
        paras.put(MODEL, this.getModelId().toString());
        paras.put("formId", "eb_analysereporttemplate");
        new AnalyseTmpCopy().copyData(list, paras);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u590d\u5236", "AnalyseReportTemplateListPlugin_12", "epm-eb-formplugin");
        this.addObjOpLog(ResManager.loadKDString((String)"\u590d\u5236", (String)"AnalyseReportTemplateListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), opNameBridge, paras.get("cloneObjNumbers"));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"AnalyseReportTemplateListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void openShareSchemeListPage(String key) {
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_rptshareschemelist");
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(formShowParameter);
    }

    private void selectShareUsers() {
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        if (selectRowPkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AnalyseReportTemplateListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectRowPkIds.size() == 1) {
            Set<Long> userids = AnalyseRptTemplateService.queryShareUserIdsFromTemp(selectRowPkIds.get(0));
            this.getModel().setValue("shareusers", (Object)userids.toArray());
        } else {
            this.getModel().setValue("shareusers", null);
        }
        BasedataEdit shareusers = (BasedataEdit)this.getControl("shareusers");
        shareusers.click();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("shareusers".equals(name)) {
            evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SHARE_RANGE));
        }
    }

    private void shareOperation() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_analysereporttemplate", (String)"shareusers", (QFilter[])new QFilter("id", "in", this.getSelectRowPkIds()).toArray());
        Set userids = ((DynamicObjectCollection)this.getModel().getValue("shareusers")).stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toSet());
        if (load != null && load.length > 0) {
            boolean isBat = load.length > 1;
            for (DynamicObject dy : load) {
                DynamicObjectCollection shareusers = dy.getDynamicObjectCollection("shareusers");
                HashSet newUserIds = new HashSet(userids);
                if (isBat) {
                    shareusers.forEach(row -> newUserIds.add(row.getLong("fbasedataid_id")));
                }
                shareusers.clear();
                for (Long userid : newUserIds) {
                    shareusers.addNew().set("fbasedataid_id", (Object)userid);
                }
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u4eab\u6210\u529f\u3002", (String)"AnalyseReportTemplateListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refresh(this.getModelId());
    }
}

