/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.common.analysereport.constants.AnalyseReportTemplate;
import kd.epm.eb.common.analysereport.pojo.AnalyseRptEntity;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptTemplateService;

public class AnalyseReportTemplateSetPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_BASE_INFO = "btn_baseinfo";
    private static final String BTN_TEMPLATE_IMPORT = "btn_templateimport";
    private static final String BTN_SHARE_SCHEME = "btn_sharescheme";
    private static final String BTN_SHARE_RANGE = "btn_sharerange";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_VAR_MANAGER = "btn_varmanager";
    private static final String CACHE_TEMPLATE_INFO = "templateInfoCache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7SelectListener(this, new String[]{"shareusers"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(CACHE_TEMPLATE_INFO, (String)this.getView().getFormShowParameter().getCustomParam("data"));
        this.loadShareUsers();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SHARE_RANGE});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_baseinfo": {
                this.openBaseInfoPage(key);
                break;
            }
            case "btn_sharescheme": {
                this.openShareSchemeListPage(key);
                break;
            }
            case "btn_sharerange": {
                this.selectShareUsers();
                break;
            }
            case "btn_varmanager": {
                this.openVarManager(key);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (BTN_BASE_INFO.equals(actionId)) {
            this.updateBaseInfoCache((AnalyseReportTemplate)returnData);
        } else if (BTN_SHARE_SCHEME.equals(actionId)) {
            DynamicObject object = (DynamicObject)returnData;
            DynamicObjectCollection user = object.getDynamicObjectCollection("user");
            Object[] ids = user.stream().map(d -> d.getLong("fbasedataid.id")).toArray();
            this.getModel().setValue("shareusers", (Object)ids);
        }
    }

    private void openBaseInfoPage(String key) {
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_analysereporttemplate");
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCustomParam("model", (Object)this.getTemplateInfo().getModelid());
        formShowParameter.setCustomParam("data", (Object)this.getPageCache().get(CACHE_TEMPLATE_INFO));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(formShowParameter);
    }

    private void openShareSchemeListPage(String key) {
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_rptshareschemelist");
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        AnalyseReportTemplate templateInfo = this.getTemplateInfo();
        formShowParameter.setCustomParam("model", (Object)templateInfo.getModelid());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(formShowParameter);
    }

    private void selectShareUsers() {
        BasedataEdit shareusers = (BasedataEdit)this.getControl("shareusers");
        shareusers.click();
    }

    private void openVarManager(String key) {
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_analyserptvariablelist");
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.setCustomParam("model", (Object)this.getTemplateInfo().getModelid());
        formShowParameter.setCustomParam("bizmodel", (Object)this.getTemplateInfo().getBizModelid());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setAppId("bgmd");
        this.getView().showForm(formShowParameter);
    }

    private AnalyseReportTemplate getTemplateInfo() {
        return (AnalyseReportTemplate)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_TEMPLATE_INFO), AnalyseReportTemplate.class);
    }

    private void updateBaseInfoCache(AnalyseReportTemplate info) {
        AnalyseReportTemplate templateInfo = this.getTemplateInfo();
        templateInfo.setNumber(info.getNumber());
        templateInfo.setName(info.getName());
        templateInfo.setEnable(info.isEnable());
        templateInfo.setDescription(info.getDescription());
        this.getPageCache().put(CACHE_TEMPLATE_INFO, SerializationUtils.toJsonString((Object)templateInfo));
        String cache = this.getPageCache().get("rptWebOfficeCache");
        if (cache != null) {
            AnalyseRptEntity entity = (AnalyseRptEntity)SerializationUtils.deSerializeFromBase64((String)cache);
            entity.setRptTemp(templateInfo);
            this.getPageCache().put("rptWebOfficeCache", SerializationUtils.serializeToBase64((Object)entity));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("shareusers".equals(name)) {
            // empty if block
        }
    }

    private void loadShareUsers() {
        AnalyseReportTemplate templateInfo = this.getTemplateInfo();
        if (templateInfo.getId() != null && templateInfo.getId() != 0L) {
            Set<Long> userids = AnalyseRptTemplateService.queryShareUserIdsFromTemp(templateInfo.getId());
            this.getModel().setValue("shareusers", (Object)userids.toArray());
        }
    }
}

