/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.analysereport.NewF7FuzzySearchWithVarListener;

public interface AnalyseRptMemberEntrySupport {
    public IFormView getView();

    default public void openF7(BeforeF7SelectEvent evt, IFormPlugin formPlugin, BiConsumer<List<QFilter>, String> customFilterConsumer) {
        String key = evt.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        String billFormId = listShowParameter.getBillFormId();
        CloseCallBack closeCallBack = null;
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        String dimNumber = this.getCurrentDimNumber(key);
        MemberF7Parameter memberF7Parameter = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        boolean isOrderEntry = this.isOrderEntryKey(key);
        if (this.isMemberCol(key)) {
            if (VariableTypeEnum.Parameter.getMetadata().equals(billFormId)) {
                qFilters.add(new QFilter("model", "=", (Object)modelId));
                qFilters.add(new QFilter("dimension.number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber()));
                qFilters.add(new QFilter("bizmodel", "=", (Object)bizModelId));
                listShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
                return;
            }
            closeCallBack = new CloseCallBack(formPlugin, "memberSelect_" + key);
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                qFilters.add(new QFilter("number", "!=", (Object)SysDimensionEnum.BudgetPeriod.getNumber()));
            }
            memberF7Parameter.setShowVariable(true);
        }
        if (DimensionViewServiceHelper.hasView((String)dimNumber)) {
            Long viewId;
            memberF7Parameter.setEnableView(true);
            Object dimViewObj = this.getView().getModel().getValue(this.getDimViewKey(isOrderEntry));
            if (dimViewObj != null) {
                DynamicObject dimView = (DynamicObject)dimViewObj;
                Long viewId2 = dimView.getLong("id");
                if (IDUtils.isNotEmptyLong((Long)viewId2).booleanValue()) {
                    memberF7Parameter.setViewId(viewId2);
                }
            } else if (!isOrderEntry && (viewId = this.getDefaultViewId(dimNumber)) != null) {
                memberF7Parameter.setViewId(viewId);
            }
        }
        memberF7Parameter.setCanSelectRoot(false);
        memberF7Parameter.setBusModelId(bizModelId);
        SysDimensionEnum sysDimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
        if (sysDimensionEnum == null) {
            memberF7Parameter.setCanSelectRoot(true);
        }
        customFilterConsumer.accept(qFilters, dimNumber);
        memberF7Parameter.setVerifyPermission(false);
        memberF7Parameter.addCustomFilter(qFilters);
        NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)memberF7Parameter, (CloseCallBack)closeCallBack);
        if (this.isMemberCol(key) && ("getLookUpList".equals(evt.getSourceMethod()) || "setItemByIdFromClient".equals(evt.getSourceMethod()) || "setItemByNumber".equals(evt.getSourceMethod())) && evt.getSource() instanceof BasedataEdit) {
            String type = this.getView().getModel().getValue(this.getMemberTypeKey(isOrderEntry)).toString();
            if ("eb_periodvariable".equals(type)) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                listFilterParameter.getQFilters().clear();
                listFilterParameter.setOrderBy("number");
            }
            BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
            basedataEdit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)NewF7FuzzySearchWithVarListener.getInstance(memberF7Parameter));
        }
    }

    default public void handleMemberFillBack(ClosedCallBackEvent evt) {
        Object returnData;
        String actionId = evt.getActionId();
        if (actionId.startsWith("memberSelect") && (returnData = evt.getReturnData()) instanceof ListSelectedRowCollection) {
            String classType;
            String memberKey = actionId.replace("memberSelect_", "");
            boolean isOrderEntry = this.isOrderEntryKey(memberKey);
            ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)returnData).get(0);
            Map dataMap = listSelectedRow.getDataMap();
            Long viewId = ConvertUtils.toLong(dataMap.get("viewid"));
            String type = dataMap.get("type").toString();
            RangeF7PropertyCataEnum rangeF7 = RangeF7PropertyCataEnum.ofIndex((String)type);
            if (RangeF7PropertyCataEnum.Var == rangeF7) {
                classType = "eb_periodvariable";
                viewId = null;
            } else {
                String dimNumber = dataMap.get("dimNumber").toString();
                classType = "epm_userdefinedmembertree";
                SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
                if (dimensionEnum != null) {
                    classType = dimensionEnum.getMemberTreemodel();
                }
            }
            IDataModel dataModel = this.getView().getModel();
            dataModel.setValue(this.getMemberTypeKey(isOrderEntry), (Object)classType);
            dataModel.setValue(memberKey, listSelectedRow.getPrimaryKeyValue());
            dataModel.setValue(this.getDimViewKey(isOrderEntry), (Object)viewId);
        }
    }

    default public void dealAfterF7Select(AfterF7SelectEvent event) {
        String curMemberClass;
        Control source = (Control)event.getSource();
        String controlKey = source.getKey();
        boolean isOrderEntry = this.isOrderEntryKey(controlKey);
        String dimViewKey = this.getDimViewKey(isOrderEntry);
        String entryKey = this.getEntryKey(isOrderEntry);
        String memberTypeKey = this.getMemberTypeKey(isOrderEntry);
        String currentDimNumber = this.getCurrentDimNumber(controlKey);
        Object inputValue = event.getInputValue();
        Long pkId = ConvertUtils.toLong((Object)inputValue);
        Long viewId = null;
        IDataModel dataModel = this.getView().getModel();
        Object view = dataModel.getValue(dimViewKey);
        if (view != null || pkId == 0L) {
            return;
        }
        EntryGrid memberEntry = (EntryGrid)this.getView().getControl(entryKey);
        int focusRow = memberEntry.getEntryState().getFocusRow();
        if (this.isBudgetParam(currentDimNumber, focusRow, isOrderEntry)) {
            return;
        }
        if (this.isVar(currentDimNumber, pkId)) {
            curMemberClass = "eb_periodvariable";
            viewId = 0L;
        } else {
            if (!isOrderEntry) {
                viewId = this.getDefaultViewId(currentDimNumber);
            }
            if (viewId == null) {
                viewId = !this.isAnalyseViewMember(currentDimNumber, pkId) ? DatasetServiceHelper.getViewIdByBusModelIdOfDim((Long)this.getBizModelId(), (String)currentDimNumber) : this.getViewIdByViewMember(pkId);
            }
            curMemberClass = "epm_userdefinedmembertree";
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)currentDimNumber);
            if (dimensionEnum != null) {
                curMemberClass = dimensionEnum.getMemberTreemodel();
            }
        }
        String memberClassType = dataModel.getValue(memberTypeKey).toString();
        if (!curMemberClass.equals(memberClassType)) {
            dataModel.setValue(memberTypeKey, (Object)curMemberClass, focusRow);
            dataModel.setValue(this.getDimMemberKey(isOrderEntry), (Object)pkId, focusRow);
        }
        if (!DimensionViewServiceHelper.hasView((String)currentDimNumber)) {
            return;
        }
        dataModel.setValue(dimViewKey, (Object)viewId, focusRow);
    }

    default public boolean isMemberCol(String f7Key) {
        return f7Key != null && f7Key.startsWith("member");
    }

    default public String getDimTypeKey(boolean isOrderEntry) {
        return isOrderEntry ? "dimmembertype1" : "dimmembertype";
    }

    default public String getDimMemberKey(boolean isOrderEntry) {
        return isOrderEntry ? "member1" : "member";
    }

    default public String getDimViewKey(boolean isOrderEntry) {
        return isOrderEntry ? "dimview1" : "dimview";
    }

    default public String getDimKey(boolean isOrderEntry) {
        return isOrderEntry ? "dimension1" : "dimension";
    }

    default public String getEntryKey(boolean isOrderEntry) {
        return isOrderEntry ? "orderentry" : "memberentry";
    }

    default public String getMemberTypeKey(boolean isOrderEntry) {
        return isOrderEntry ? "memberclasstype1" : "memberclasstype";
    }

    default public Long getViewIdByViewMember(Long memberId) {
        QFilter qFilter = new QFilter("memberid", "=", (Object)memberId);
        DynamicObject viewMember = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"view", (QFilter[])new QFilter[]{qFilter});
        if (viewMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u89c6\u56fe\u6210\u5458\u4fe1\u606f\u5931\u8d25\uff1a%1", (String)"DimensionCombinationEditNewPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{memberId}));
        }
        return viewMember.getLong("view");
    }

    default public boolean isVar(String currentDimNumber, Long pkId) {
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        qFilter.and("dimension.number", "=", (Object)currentDimNumber);
        return QueryServiceHelper.exists((String)"eb_periodvariable", (QFilter[])new QFilter[]{qFilter});
    }

    default public boolean isAnalyseViewMember(String currentDimNumber, Long memberId) {
        String memberTreeModel = SysDimensionEnum.getMemberTreemodelByNumber((String)currentDimNumber);
        DynamicObject query = QueryServiceHelper.queryOne((String)memberTreeModel, (String)"membersource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)memberId)});
        if (query == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u6210\u5458\u4fe1\u606f\u5931\u8d25\uff1a%1", (String)"DimensionCombinationEditNewPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{memberId}));
        }
        String memberSource = query.getString("membersource");
        return MemberSourceEnum.ANALYZE_VIEW.getIndex().equals(memberSource);
    }

    default public boolean isBudgetParam(String currentDimNumber, int focusRow, boolean isOrderEntry) {
        if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(currentDimNumber)) {
            return false;
        }
        Object memberType = this.getView().getModel().getValue(this.getDimTypeKey(isOrderEntry), focusRow);
        if (memberType == null) {
            return false;
        }
        return DimMemberTypeEnum.PARAM.getIndex().equals(memberType.toString());
    }

    default public boolean isOrderEntryKey(String itemKey) {
        return itemKey != null && itemKey.endsWith("1");
    }

    default public Long getDefaultViewId(String dimNumber) {
        return null;
    }

    public String getCurrentDimNumber(String var1);

    public Long getModelId();

    public Long getBizModelId();
}

