/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.analysereport.pojo.fileimport.AnalyseReportTemplate;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class AptImportBizModelSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addF7SelectListener(this, new String[]{"tarbizmodel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadPageData();
    }

    public void loadPageData() {
        List<AnalyseReportTemplate> readTemplateData = this.getReadTemplateData();
        if (readTemplateData.size() == 0) {
            return;
        }
        Map<String, DynamicObject> curModelBizModel = this.getCurModelBizModel(this.getModelId());
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        int[] index = this.getModel().batchCreateNewEntryRow("entryentity", readTemplateData.size());
        int i = 0;
        for (AnalyseReportTemplate data : readTemplateData) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", index[i]);
            rowEntity.set("templatenumber", (Object)data.getNumber());
            rowEntity.set("templatename", (Object)data.getName());
            rowEntity.set("srcbizmodelnumber", (Object)data.getBizModel());
            rowEntity.set("srcbizmodelname", (Object)data.getBizModelName());
            if (curModelBizModel.containsKey(data.getBizModel())) {
                rowEntity.set("tarbizmodel", (Object)curModelBizModel.get(data.getBizModel()));
            }
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            evt.setCancel(this.checkBeforeOk());
        }
    }

    private boolean checkBeforeOk() {
        return this.checkTemplateNameAndNumber();
    }

    private boolean checkTemplateNameAndNumber() {
        Long modelId = this.getModelId();
        Set<String> existTemplateNumbers = this.getCurModelExistTemplateNumbers(modelId);
        Set<String> existTemplateNames = this.getCurModelExistTemplateNames(modelId);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            ArrayList<Integer> repeatNumberRow = new ArrayList<Integer>(10);
            ArrayList<Integer> repeatNameRow = new ArrayList<Integer>(10);
            HashSet<String> pageTemplateNumbers = new HashSet<String>(16);
            HashSet<String> pageTemplateNames = new HashSet<String>(16);
            for (DynamicObject object : entryEntity) {
                String number = object.getString("templatenumber");
                String name = object.getString("templatename");
                if (pageTemplateNumbers.contains(number)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u9875\u9762\u4e0a\u5b58\u5728\u91cd\u590d\u7684\u6a21\u677f\u7f16\u7801\u201c%1\u201d\u3002", (String)"AptImportBizModelSettingPlugin_00", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                    return true;
                }
                if (pageTemplateNames.contains(name)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u9875\u9762\u4e0a\u5b58\u5728\u91cd\u590d\u7684\u6a21\u677f\u540d\u79f0\u201c%1\u201d\u3002", (String)"AptImportBizModelSettingPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[]{name}));
                    return true;
                }
                if (!CheckStringsUtil.checkNumber((String)number)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6a21\u677f\u7f16\u7801\u201c%1\u201d\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u5b58\u5728\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u5c0f\u6570\u70b9\uff0c\u4e14\u4e0d\u80fd\u5b58\u5728\u8fde\u7eed\u7684\u4e24\u4e2a\u5c0f\u6570\u70b9\u4ee5\u53ca\u4ee5\u5c0f\u6570\u70b9\u5f00\u5934\u548c\u7ed3\u5c3e\u3002", (String)"AptImportBizModelSettingPlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                    return true;
                }
                if (existTemplateNumbers.contains(number)) {
                    repeatNumberRow.add(object.getInt("seq"));
                }
                if (existTemplateNames.contains(name)) {
                    repeatNameRow.add(object.getInt("seq"));
                }
                pageTemplateNumbers.add(number);
                pageTemplateNames.add(name);
            }
            if (repeatNumberRow.size() > 0 && repeatNameRow.size() > 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6a21\u677f\u7f16\u7801\uff0c%2\u884c\u6a21\u677f\u540d\u79f0\u5728\u76ee\u6807\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AptImportBizModelSettingPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])repeatNumberRow.toArray(), (String)","), StringUtils.join((Object[])repeatNameRow.toArray(), (String)",")}));
                return true;
            }
            if (repeatNumberRow.size() > 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6a21\u677f\u7f16\u7801\u5728\u76ee\u6807\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AptImportBizModelSettingPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])repeatNumberRow.toArray(), (String)",")}));
                return true;
            }
            if (repeatNameRow.size() > 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6a21\u677f\u540d\u79f0\u5728\u76ee\u6807\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AptImportBizModelSettingPlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])repeatNameRow.toArray(), (String)",")}));
                return true;
            }
        }
        return false;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnPageData();
        }
    }

    private void returnPageData() {
        List<AnalyseReportTemplate> readTemplateData = this.getReadTemplateData();
        for (int i = 0; i < readTemplateData.size(); ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", i);
            AnalyseReportTemplate template = readTemplateData.get(i);
            if (rowEntity == null || template == null) continue;
            template.setNumber(rowEntity.getString("templatenumber"));
            template.setName(rowEntity.getString("templatename"));
            template.setBizModel(rowEntity.getString("tarbizmodel.number"));
        }
        this.getView().returnDataToParent(readTemplateData);
        this.getView().close();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("tarbizmodel".equals(name)) {
            this.tarBizModelSelectBeforeF7(event);
        }
    }

    private void tarBizModelSelectBeforeF7(BeforeF7SelectEvent event) {
        event.addCustomQFilter(new QFilter("model", "=", (Object)this.getModelId()));
    }

    private Map<String, DynamicObject> getCurModelBizModel(Long modelId) {
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (query.length > 0) {
            return Arrays.stream(query).collect(Collectors.toMap(e -> e.getString("number"), e -> e));
        }
        return new HashMap<String, DynamicObject>(0);
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("modelId"));
    }

    private List<AnalyseReportTemplate> getReadTemplateData() {
        return (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getCustomFormParam("readTemplateData")));
    }

    private Set<String> getCurModelExistTemplateNumbers(Long modelId) {
        DynamicObjectCollection templateObjects = QueryServiceHelper.query((String)"eb_analysereporttemplate", (String)"number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)templateObjects)) {
            return templateObjects.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    private Set<String> getCurModelExistTemplateNames(Long modelId) {
        DynamicObjectCollection templateObjects = QueryServiceHelper.query((String)"eb_analysereporttemplate", (String)"name", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)templateObjects)) {
            return templateObjects.stream().map(e -> e.getString("name")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }
}

