/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.io.InputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.AttachmentDownLoadEvent;
import kd.bos.form.control.events.AttachmentDownloadListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.mvc.list.AttachmentModel;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class AttachePopupPlugin
extends AbstractFormPlugin
implements UploadListener,
AttachmentDownloadListener {
    private static final String CACHE_ATTACH_POPUP = "attachPopupCache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
        attach.addDownloadListener((AttachmentDownloadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAttachProperties();
        this.loadAttachData();
    }

    private void loadAttachData() {
        List<Map<String, Object>> attachments = new ArrayList(16);
        String file_url = this.getView().getParentView().getPageCache().get(CACHE_ATTACH_POPUP);
        if (!StringUtils.isEmpty((String)file_url)) {
            attachments = (List)SerializationUtils.deSerializeFromBase64((String)file_url);
        } else if (this.getFileId() != 0L) {
            attachments.addAll(AttachmentServiceHelper.getAttachments((String)"eb_analysereport", (Object)this.getFileId(), (String)"attachmentpanelap"));
        } else {
            return;
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        if (attachments.size() != 0) {
            this.saveToTemp(attachments);
            this.addPreView(attachments);
            attachmentPanel.bindData(attachments);
        }
        if (attachments != null && attachments.size() > 0) {
            this.getView().getParentView().getPageCache().put(CACHE_ATTACH_POPUP, SerializationUtils.serializeToBase64(attachments));
        }
    }

    public void attachmentAfterDownload(AttachmentDownLoadEvent evt) {
        Object attachmentObj = evt.getTargetAttachments();
        if (attachmentObj == null) {
            return;
        }
        List attachments = (List)attachmentObj;
        for (Map attachment : attachments) {
            String realPath = this.getRealPath(attachment);
            if (realPath == null) continue;
            attachment.put("url", realPath);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_ok": {
                this.returnFileUrls();
                break;
            }
        }
    }

    private void returnFileUrls() {
        List<Map<String, Object>> attachmentData = this.getAttachmentData();
        this.getView().getParentView().getPageCache().put(CACHE_ATTACH_POPUP, SerializationUtils.serializeToBase64(attachmentData));
        this.getView().close();
    }

    public void upload(UploadEvent evt) {
        ArrayList<Map> urls = new ArrayList<Map>(16);
        List<Map<String, Object>> attachmentData = this.getAttachmentData();
        ArrayList errMessage = new ArrayList(16);
        for (Object url : evt.getUrls()) {
            Map urlData = (Map)url;
            if (this.checkAttachmentContains(attachmentData, urlData, false)) {
                errMessage.add(urlData.get("name"));
                continue;
            }
            urls.add(urlData);
        }
        if (errMessage.size() != 0) {
            evt.setCancel(true);
            evt.setCancelMsg(ResManager.loadKDString((String)"\u5df2\u6709\u540c\u540d\u6587\u4ef6\uff0c\u65e0\u6cd5\u91cd\u590d\u4e0a\u4f20\u3002", (String)"AttachePopupPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            attachmentData.addAll(urls);
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
            attachmentPanel.bindData(attachmentData);
        } else if (urls.size() != 1) {
            evt.setCancelMsg(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f201\u4e2a\u6587\u4ef6\u3002", (String)"AttachePopupPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private boolean checkAttachmentContains(List<Map<String, Object>> attachmentData, Map<String, Object> urlData, Boolean isInitData) {
        ArrayList<Map<String, Object>> attachmentData_tmp = new ArrayList<Map<String, Object>>(attachmentData);
        for (Map map : attachmentData_tmp) {
            Date date2;
            Date date1;
            String name = map.get("name").toString();
            Long size = Convert.toLong(map.get("size"));
            if (!name.equals(urlData.get("name")) || !size.equals(Convert.toLong((Object)urlData.get("size")))) continue;
            if (isInitData.booleanValue() && (date1 = this.getConvertedDate(map)).before(date2 = this.getConvertedDate(urlData))) {
                attachmentData.remove(map);
                attachmentData.add(urlData);
            }
            return true;
        }
        return false;
    }

    private Date getConvertedDate(Map<String, Object> url) {
        Date modifyTime = null;
        try {
            if (url.containsKey("lastModified")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Long time = sdf.parse(url.get("lastModified").toString()).getTime();
                modifyTime = Convert.toDate((Object)time);
            } else {
                modifyTime = Convert.toDate((Object)System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            modifyTime = Convert.toDate((Object)url.get("lastModified"));
        }
        return modifyTime;
    }

    private List<Map<String, Object>> getAttachmentData() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachmentData = attachmentPanel.getAttachmentData();
        if (attachmentData != null) {
            return attachmentData;
        }
        return new ArrayList<Map<String, Object>>(16);
    }

    private Long getFileId() {
        Object templateId = this.getView().getFormShowParameter().getCustomParam("fileid");
        if (templateId == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)templateId);
    }

    private void setAttachProperties() {
        Integer maxatmsize;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Integer maxatmcount = (Integer)customParams.get("maxatmcount");
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        if (maxatmcount != null) {
            dataMap.put("maxatmcount", maxatmcount);
        }
        if ((maxatmsize = (Integer)customParams.get("maxatmsize")) != null) {
            dataMap.put("maxatmcount", maxatmsize);
        }
        if (dataMap.size() > 0) {
            this.getView().updateControlMetadata("attachmentpanelap", dataMap);
        }
    }

    private String getRealPath(Map<String, Object> attachment) {
        String url = attachment.get("url").toString();
        String[] urlArr = url.split("path=|&");
        if (urlArr.length < 2) {
            return null;
        }
        return urlArr[1];
    }

    private void saveToTemp(List<Map<String, Object>> attachments) {
        if (attachments.size() != 0) {
            HashMap<String, List<Map<String, Object>>> attachCache = new HashMap<String, List<Map<String, Object>>>(16);
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            for (Map<String, Object> attachment : attachments) {
                String realPath = this.getRealPath(attachment);
                if (realPath == null || realPath.contains("tempfile")) continue;
                InputStream fileInputStream = null;
                try {
                    fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(URLDecoder.decode(realPath, "utf-8"));
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
                String tempUrl = tempFileCache.saveAsUrl(attachment.get("name").toString(), fileInputStream, 7200);
                attachment.put("url", tempUrl);
            }
            attachCache.put("attachmentpanelap", attachments);
            this.getPageCache().put("TampAttCache" + this.getView().getPageId(), SerializationUtils.toJsonString(attachCache));
        }
    }

    private void addPreView(List<Map<String, Object>> attachments) {
        AttachmentModel attachmentModel = new AttachmentModel();
        for (Map<String, Object> attachment : attachments) {
            String type;
            String name = String.valueOf(attachment.get("name"));
            int index = name.lastIndexOf(".") + 1;
            if (index >= name.length() || !FileUtil.isExtExist((String)(type = name.substring(index))) || attachment.get("previewurl") != null) continue;
            String tempUrl = attachment.get("url").toString();
            String tempFilePreviewUrl = attachmentModel.getTempFilePreviewUrl(tempUrl);
            attachment.put("previewurl", tempFilePreviewUrl);
        }
    }
}

