/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteCheck;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.constants.ApplicableObjectEnum;
import kd.epm.eb.common.analysereport.constants.DataFormatTypeEnum;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.constants.FormulaFrontMethodEnum;
import kd.epm.eb.common.analysereport.constants.FunOperationEnum;
import kd.epm.eb.common.analysereport.constants.LogicOperationEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.formula.FormulaCheckResult;
import kd.epm.eb.common.analysereport.pojo.formula.InvokeParam;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimColInfo;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimStrInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.SaveCheck;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analysereport.AnalyseRptMemberEntrySupport;

public class DimensionCombinationEditNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
SaveCheck,
SearchEnterListener,
AnalyseRptMemberEntrySupport {
    private static final String DIM_GROUP_TYPE = "dimgrouptype";
    private static final String FLEX_PANEL_NUMBER = "flexpanel_number";
    private static final String FLEX_PANEL_FORMULA = "flexpanel_formula";
    private static final String MODEL = "model";
    private static final String PK_ID = "pkId";
    private static final String SUIT_OBJECT = "suitobject";
    private static final List<String> ignoreKeys = Arrays.asList("id", "seq");
    private static final List<String> logicOperate = Arrays.asList("plus", "subtract", "multiple", "divide", "leftparentheses", "rightparentheses");
    private static final List<String> funOperate = Collections.singletonList("abs");
    private static final Log log = LogFactory.getLog(DimensionCombinationEditNewPlugin.class);
    private int needPropertyChange = 0;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_delete", "btn_clear", "before", "next"});
        this.addClickListeners(logicOperate.toArray(new String[0]));
        this.addClickListeners(funOperate.toArray(new String[0]));
        this.addTreeNodeClickListener(this, "treeviewap");
        this.addF7SelectListener(this, new String[]{"account", "metric", "member"});
        this.addAfterF7SelectListener(this, new String[]{"member"});
        Search search = (Search)this.getControl("search");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
        this.setShowDimGroupType();
    }

    private void initData() {
        Long dimCombineId = this.getPkId();
        long copyId = this.getCopyId();
        if (dimCombineId == 0L && copyId == 0L) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unit"});
            Long bizModel = (Long)this.getView().getFormShowParameter().getCustomParam("bizmodel");
            if (bizModel != null) {
                this.getModel().setValue("bizmodel", (Object)bizModel);
            }
            Long model = (Long)this.getView().getFormShowParameter().getCustomParam(MODEL);
            this.getModel().setValue(MODEL, (Object)model);
        } else {
            boolean isCopy = false;
            Long loadDataId = dimCombineId;
            if (dimCombineId == 0L) {
                loadDataId = copyId;
                isCopy = true;
            }
            this.bindData(loadDataId, isCopy);
            this.initControlStatus(dimCombineId);
        }
        this.initNumberColTree();
    }

    private void initControlStatus(Long dimCombineId) {
        String dimGroupType;
        DimGroupTypeEnum dimGroupTypeEnum;
        boolean isQuote = false;
        if (dimCombineId != 0L) {
            QuoteCheck quoteCheck = QuoteCheck.get();
            QuoteCheckResult checkResult = quoteCheck.checkQuoteResult(new CheckQuote(this.getModelId(), Long.valueOf(0L), (Set)Sets.newHashSet((Object[])new Long[]{dimCombineId}), MemberTypeEnum.DIMGROUP));
            if (checkResult.isHasQuote()) {
                isQuote = true;
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FLEX_PANEL_FORMULA, DIM_GROUP_TYPE});
                this.getPageCache().put("isQuote", "true");
                this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u4e0d\u5141\u8bb8\u4fee\u6539\u6210\u5458\u7c7b\u578b\u53ca\u516c\u5f0f\u3002", (String)"DimensionCombinationEditNewPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{checkResult.getMsg()}));
            }
        }
        if (DimGroupTypeEnum.NUMBER == (dimGroupTypeEnum = DimGroupTypeEnum.getDimGroupEnumByIndex((String)(dimGroupType = (String)this.getValue(DIM_GROUP_TYPE, null))))) {
            this.setEntityStatus(isQuote);
        }
    }

    private void setEntityStatus(boolean isQuote) {
        DynamicObjectCollection memberEntity = this.getModel().getEntryEntity("memberentry");
        for (int i = 0; i < memberEntity.size(); ++i) {
            DynamicObject memberEntry = (DynamicObject)memberEntity.get(i);
            String dimMemberTypeStr = memberEntry.getString("dimmembertype");
            DimMemberTypeEnum dimMemberType = DimMemberTypeEnum.getDimMemberTypeEnumByIndex((String)dimMemberTypeStr);
            DynamicObject dimension = memberEntry.getDynamicObject("dimension");
            String dimNumber = dimension.getString("number");
            SysDimensionEnum sysDimension = SysDimensionEnum.getEnumByNumber((String)dimNumber);
            if (DimMemberTypeEnum.MEMBER == dimMemberType) {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"member"});
                if (SysDimensionEnum.ChangeType == sysDimension || SysDimensionEnum.AuditTrail == sysDimension) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"dimmembertype"});
                }
            } else if (DimMemberTypeEnum.FUNCTION == dimMemberType) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"member"});
            } else {
                this.getView().setEnable(Boolean.valueOf(SysDimensionEnum.BudgetPeriod == sysDimension), i, new String[]{"member"});
            }
            if (!isQuote) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"dimmembertype"});
        }
    }

    private void bindData(Long dimCombineId, boolean isCopy) {
        DynamicObject dimCombination = BusinessDataServiceHelper.loadSingle((Object)dimCombineId, (String)this.getEntityId());
        DataEntityPropertyCollection properties = dimCombination.getDynamicObjectType().getProperties();
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if ("memberentry".equals(name)) {
                DynamicObjectCollection memberEntity = dimCombination.getDynamicObjectCollection(name);
                DataEntityPropertyCollection memberProperties = memberEntity.getDynamicObjectType().getProperties();
                EntryProp entryProp = (EntryProp)dataEntityType.getProperty(name);
                DynamicObjectType dynamicCollectionItemPropertyType = entryProp.getDynamicCollectionItemPropertyType();
                for (DynamicObject memberEntry : memberEntity) {
                    int newEntryRow = this.getModel().createNewEntryRow(name);
                    for (IDataEntityProperty memberProperty : memberProperties) {
                        DynamicProperty dynamicProperty;
                        String memberPropertyName = memberProperty.getName();
                        if (ignoreKeys.contains(memberPropertyName) || (dynamicProperty = dynamicCollectionItemPropertyType.getProperty(memberPropertyName)) == null) continue;
                        this.getModel().setValue(memberPropertyName, memberEntry.get(memberPropertyName), newEntryRow);
                    }
                }
                continue;
            }
            if ("multilanguagetext".equals(name)) continue;
            DynamicProperty dynamicProperty = dataEntityType.getProperty(name);
            if (dynamicProperty != null) {
                this.dealBaseData(dimCombination, name, isCopy);
                continue;
            }
            this.bindSpecialData(dimCombination, name);
        }
    }

    private void dealBaseData(DynamicObject dimCombination, String propertyName, boolean isCopy) {
        Object propertyValue;
        switch (propertyName) {
            case "description": {
                ILocaleString localeString = dimCombination.getLocaleString(propertyName);
                propertyValue = localeString;
                break;
            }
            case "name": {
                if (isCopy) {
                    ILocaleString nameLocalString = dimCombination.getLocaleString(propertyName);
                    Set langSet = nameLocalString.keySet();
                    for (String lang : langSet) {
                        String item = (String)nameLocalString.getItem(lang);
                        nameLocalString.setItem(lang, (Object)this.getAfterCopyStr(dimCombination, item));
                    }
                    propertyValue = nameLocalString;
                    break;
                }
                propertyValue = dimCombination.getLocaleString(propertyName);
                break;
            }
            case "number": {
                if (isCopy) {
                    String number = dimCombination.getString(propertyName);
                    propertyValue = this.getAfterCopyStr(dimCombination, number);
                    break;
                }
                propertyValue = dimCombination.get(propertyName);
                break;
            }
            default: {
                propertyValue = dimCombination.get(propertyName);
            }
        }
        this.getModel().setValue(propertyName, propertyValue);
    }

    private String getAfterCopyStr(DynamicObject dimCombination, String baseStr) {
        String number = dimCombination.getString("number");
        QFilter qFilter = new QFilter("bizmodel", "=", (Object)dimCombination.getLong("bizmodel.id"));
        String indexStr = ExecuteAnalyseUtil.getInstance().getCopyIndex(number, this.getEntityId(), Long.valueOf(dimCombination.getLong("model.id")), qFilter);
        String copy = baseStr + indexStr;
        if (copy.length() > 50) {
            copy = copy.substring(0, 50);
        }
        return copy;
    }

    private void bindSpecialData(DynamicObject dimCombination, String propertyName) {
        switch (propertyName) {
            case "digit": {
                String dataFormat = dimCombination.getString("dataformat");
                String digit_key = "digit_number";
                if (DataFormatTypeEnum.RATE.getIndex().equals(dataFormat)) {
                    digit_key = "digit_rate";
                }
                this.getModel().setValue(digit_key, dimCombination.get(propertyName));
                break;
            }
            case "formula": {
                this.initFormula(dimCombination.getString(propertyName));
                break;
            }
        }
    }

    private void initFormula(String formulaString) {
        List<Map<String, String>> formulaNodeList = this.parseToFrontNodes(formulaString);
        if (formulaNodeList.size() != 0) {
            this.invokeFrontMethod(FormulaFrontMethodEnum.INITFORMULA, formulaNodeList, "setFormulaStatus");
        }
    }

    private List<Map<String, String>> parseToFrontNodes(String formulaString) {
        return AnalyseReportUtil.getInstance().parseToFrontNodes(formulaString);
    }

    private void setShowDimGroupType() {
        String value = (String)this.getValue(DIM_GROUP_TYPE, null);
        this.setShowDimGroupType(value);
    }

    private void setContraryShowDimGroupType() {
        String value = (String)this.getValue(DIM_GROUP_TYPE, null);
        this.setShowDimGroupType(value, true);
    }

    private void setShowDimGroupType(String dimGroupType) {
        this.setShowDimGroupType(dimGroupType, false);
    }

    private void setShowDimGroupType(String dimGroupType, Boolean isContrary) {
        boolean isNumberCol = DimGroupTypeEnum.NUMBER.getIndex().equals(dimGroupType);
        if (isContrary.booleanValue()) {
            isNumberCol = !isNumberCol;
            this.setNeedPropertyChange(false);
            this.getModel().setValue(DIM_GROUP_TYPE, (Object)(isNumberCol ? DimGroupTypeEnum.NUMBER.getIndex() : DimGroupTypeEnum.FORMULA.getIndex()));
            this.setNeedPropertyChange(true);
            this.clearPanelData(!isNumberCol);
        }
        this.setPanelVisible(isNumberCol);
    }

    private void clearPanelData(boolean isNumberCol) {
        if (isNumberCol) {
            this.clearNumberPanelData();
        } else {
            this.clearFormulaPanelData();
        }
    }

    private void clearNumberPanelData() {
        this.getModel().setValue("account", null);
        this.getModel().setValue("metric", null);
        this.getModel().deleteEntryData("memberentry");
        this.getModel().setValue("unit", null);
    }

    private void clearFormulaPanelData() {
        this.invokeFrontMethod(FormulaFrontMethodEnum.DELETEALLNODES, null, null);
    }

    private void setPanelVisible(boolean isNumberCol) {
        String visiblePanel = isNumberCol ? FLEX_PANEL_NUMBER : FLEX_PANEL_FORMULA;
        String unVisiblePanel = isNumberCol ? FLEX_PANEL_FORMULA : FLEX_PANEL_NUMBER;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{unVisiblePanel});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{visiblePanel});
        this.getView().setVisible(Boolean.valueOf(isNumberCol), new String[]{SUIT_OBJECT});
        this.getView().setVisible(Boolean.valueOf(!isNumberCol), new String[]{"unit_formula"});
        if (isNumberCol) {
            this.setUnitVisible(this.getValue("metric", null));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.needPropertyChange().booleanValue()) {
            return;
        }
        String name = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "dimgrouptype": {
                boolean isNumberCol = DimGroupTypeEnum.NUMBER.getIndex().equals(oldValue.toString());
                if (isNumberCol) {
                    if (this.isNumberColExistData()) {
                        this.setNeedPropertyChange(false);
                        this.getModel().setValue(DIM_GROUP_TYPE, oldValue);
                        this.setNeedPropertyChange(true);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6307\u6807\u7c7b\u578b\u5c06\u4f1a\u6e05\u7a7a\u5f53\u524d\u7c7b\u578b\u7684\u6570\u636e\uff0c\u662f\u5426\u786e\u5b9a\uff1f", (String)"DimensionCombinationEditNewPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeDimGroupType", (IFormPlugin)this));
                        break;
                    }
                    this.setShowDimGroupType(newValue.toString());
                    this.focusFormulaPanel();
                    break;
                }
                this.setNeedPropertyChange(false);
                this.getModel().setValue(DIM_GROUP_TYPE, oldValue);
                this.setNeedPropertyChange(true);
                this.isExistFormula();
                break;
            }
            case "metric": {
                this.setUnitVisible(newValue);
                break;
            }
            case "account": {
                this.dealAccountChange(oldValue, newValue);
                break;
            }
            case "dimmembertype": {
                this.dealMemberTypeChange(e.getChangeSet()[0]);
                break;
            }
            case "member": {
                if (newValue != null) break;
                this.getModel().setValue("dimview", null);
                break;
            }
            case "suitobject": {
                if (newValue == null) {
                    return;
                }
                ApplicableObjectEnum suitObject = ApplicableObjectEnum.getEnumByIndex((String)newValue.toString());
                if (ApplicableObjectEnum.Self == suitObject) {
                    return;
                }
                if (!this.existFunDim()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6210\u5458\u7c7b\u578b\u4e3a\u51fd\u6570\u7684\u7ef4\u5ea6\uff0c\u9002\u7528\u5bf9\u8c61\u53ea\u80fd\u4f7f\u7528\u201c\u81ea\u8eab\u201d\u3002", (String)"DimensionCombinationEditNewPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(name, e.getChangeSet()[0].getOldValue());
                break;
            }
        }
    }

    private boolean existFunDim() {
        DynamicObjectCollection memberEntity = this.getModel().getEntryEntity("memberentry");
        for (DynamicObject memberEntry : memberEntity) {
            String dimMemberTypeIndex = memberEntry.getString("dimmembertype");
            DimMemberTypeEnum dimMemberType = DimMemberTypeEnum.getDimMemberTypeEnumByIndex((String)dimMemberTypeIndex);
            if (DimMemberTypeEnum.FUNCTION != dimMemberType) continue;
            return true;
        }
        return false;
    }

    private boolean isNumberColExistData() {
        Object accountValue = this.getModel().getValue("account");
        Object metricValue = this.getModel().getValue("metric");
        DynamicObjectCollection memberEntry = this.getModel().getEntryEntity("memberentry");
        return accountValue != null || metricValue != null || memberEntry.size() != 0;
    }

    private void isExistFormula() {
        this.invokeFrontMethod(FormulaFrontMethodEnum.GETFORMULA, null, "existFormulaCheck");
    }

    private void initNumberColTree() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.deleteAllNodes();
        DynamicObjectCollection combinations = this.getNumberCombinations();
        if (combinations.size() != 0) {
            TreeNode root = this.getWholeTree(combinations);
            treeView.addNode(root);
            treeView.expand(root.getId());
            this.putCache("wholeTree", root);
        }
    }

    private TreeNode getWholeTree(DynamicObjectCollection combinations) {
        boolean onlyView = this.isQuote();
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setParentid("");
        root.setText("root");
        ArrayList children = new ArrayList(16);
        root.setChildren(children);
        combinations.forEach(e -> {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(e.getString("id"));
            treeNode.setParentid("0");
            treeNode.setText(e.getString("number") + " " + e.getString("name"));
            treeNode.setDisabled(onlyView);
            children.add(treeNode);
        });
        return root;
    }

    private DynamicObjectCollection getNumberCombinations() {
        QFilter qFilter = new QFilter(DIM_GROUP_TYPE, "=", (Object)DimGroupTypeEnum.NUMBER.getIndex());
        qFilter.and(MODEL, "=", (Object)this.getModelId());
        qFilter.and("bizModel", "=", (Object)this.getBizModelId());
        Long dimCombineId = this.getPkId();
        if (dimCombineId != 0L) {
            qFilter.and("id", "!=", (Object)dimCombineId);
        }
        qFilter.and(AnalyseReportUtil.getInstance().getMetricTypeQFilter());
        return QueryServiceHelper.query((String)this.getEntityId(), (String)"id, name, number", (QFilter[])new QFilter[]{qFilter}, (String)"modifydate desc");
    }

    private void setUnitVisible(Object newValue) {
        boolean isCurrency = false;
        if (newValue instanceof DynamicObject) {
            DynamicObject metric = (DynamicObject)newValue;
            String datatype = metric.getString("datatype");
            if (this.isCurrencyMetric(datatype)) {
                isCurrency = true;
            }
            this.getModel().setValue("metricdatatype", (Object)datatype);
        }
        this.getView().setVisible(Boolean.valueOf(isCurrency), new String[]{"unit"});
    }

    private void dealAccountChange(Object oldValue, Object newValue) {
        long newDatasetId;
        long oldDatasetId = this.getDatasetIdByAccount(oldValue);
        if (oldDatasetId == (newDatasetId = this.getDatasetIdByAccount(newValue))) {
            return;
        }
        if (oldDatasetId == 0L) {
            this.getModel().deleteEntryData("memberentry");
            this.initMemberEntity(newDatasetId);
        } else if (newDatasetId == 0L) {
            this.getModel().deleteEntryData("memberentry");
        } else {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Map<String, Map<String, Object>> memberEntryInfo = this.getAllMemberInfos();
            this.getModel().deleteEntryData("memberentry");
            List dimensionList_new = modelCacheHelper.getDimensionList(Long.valueOf(newDatasetId));
            this.setNeedPropertyChange(false);
            for (Dimension dimension : dimensionList_new) {
                String number = dimension.getNumber();
                SysDimensionEnum sysDimension = SysDimensionEnum.getEnumByNumber((String)number);
                if (SysDimensionEnum.Account == sysDimension || SysDimensionEnum.Metric == sysDimension) continue;
                int newEntryRow = this.getModel().createNewEntryRow("memberentry");
                Map<String, Object> detailInfos = memberEntryInfo.get(number);
                if (detailInfos == null) {
                    detailInfos = this.buildNewInfoByDimension(dimension);
                }
                detailInfos.forEach((key, value) -> {
                    if (value instanceof DynamicObject) {
                        this.getModel().setValue(key, (Object)((DynamicObject)value).getLong("id"), newEntryRow);
                    } else {
                        this.getModel().setValue(key, value, newEntryRow);
                        if ("dimmembertype".equals(key) && (DimMemberTypeEnum.FUNCTION.getIndex().equals(value.toString()) || DimMemberTypeEnum.PARAM.getIndex().equals(value.toString()) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(number))) {
                            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"member"});
                        }
                    }
                });
                if (SysDimensionEnum.ChangeType != sysDimension && SysDimensionEnum.AuditTrail != sysDimension && !this.isQuote()) continue;
                this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"dimmembertype"});
            }
            this.setNeedPropertyChange(true);
        }
        this.getModel().updateCache();
    }

    private Map<String, Object> buildNewInfoByDimension(Dimension dimension) {
        LinkedHashMap<String, Object> detailInfos = new LinkedHashMap<String, Object>(5);
        detailInfos.put("dimension", dimension.getId());
        detailInfos.put("dimmembertype", DimMemberTypeEnum.MEMBER.getIndex());
        detailInfos.put("memberclasstype", SysDimensionEnum.getMemberTreemodelByNumber((String)dimension.getNumber()));
        detailInfos.put("member", 0L);
        detailInfos.put("dimview", 0L);
        return detailInfos;
    }

    private Map<String, Map<String, Object>> getAllMemberInfos() {
        HashMap<String, Map<String, Object>> memberInfos = new HashMap<String, Map<String, Object>>(16);
        DynamicObjectCollection memberEntry = this.getModel().getEntryEntity("memberentry");
        DataEntityPropertyCollection properties = memberEntry.getDynamicObjectType().getProperties();
        for (DynamicObject entry : memberEntry) {
            String dimKey = entry.getString("dimension.number");
            LinkedHashMap<String, Object> detailInfos = new LinkedHashMap<String, Object>(16);
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if (ignoreKeys.contains(name)) continue;
                if ("member".equals(name)) {
                    detailInfos.put("memberclasstype", entry.getString("memberclasstype"));
                }
                detailInfos.put(name, entry.get(property));
            }
            memberInfos.put(dimKey, detailInfos);
        }
        return memberInfos;
    }

    private long getDatasetIdByAccount(Object accountValue) {
        long datasetId = 0L;
        if (accountValue instanceof DynamicObject) {
            DynamicObject account = (DynamicObject)accountValue;
            datasetId = account.getLong("dataset.id");
        }
        return datasetId;
    }

    private void dealMemberTypeChange(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (!this.checkMemberTypeChange(oldValue, newValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6307\u6807\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u51fd\u6570\u6210\u5458\u7c7b\u578b\u3002", (String)"DimensionCombinationEditNewPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.setNeedPropertyChange(false);
            this.getModel().setValue("dimmembertype", oldValue);
            this.setNeedPropertyChange(true);
            return;
        }
        DimMemberTypeEnum dimMemberType = DimMemberTypeEnum.getDimMemberTypeEnumByIndex((String)newValue.toString());
        EntryGrid memberEntry = (EntryGrid)this.getControl("memberentry");
        int focusRow = memberEntry.getEntryState().getFocusRow();
        Object dimensionObj = this.getModel().getValue("dimension", focusRow);
        String dimNumber = ((DynamicObject)dimensionObj).getString("number");
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
        if (DimMemberTypeEnum.MEMBER == dimMemberType) {
            this.getView().setEnable(Boolean.valueOf(true), focusRow, new String[]{"member"});
            String memberModel = "epm_userdefinedmembertree";
            if (dimensionEnum != null) {
                memberModel = dimensionEnum.getMemberTreemodel();
            }
            this.getModel().setValue("memberclasstype", (Object)memberModel, focusRow);
        } else if (DimMemberTypeEnum.FUNCTION == dimMemberType) {
            if (this.isNotSelf()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9002\u7528\u5bf9\u8c61\u975e\u201c\u81ea\u8eab\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u51fd\u6570\u7c7b\u578b\u6210\u5458\u3002", (String)"DimensionCombinationEditNewPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.setNeedPropertyChange(false);
                this.getModel().setValue("dimmembertype", oldValue);
                this.setNeedPropertyChange(true);
                return;
            }
            this.getView().setEnable(Boolean.valueOf(false), focusRow, new String[]{"member"});
        } else if (SysDimensionEnum.BudgetPeriod == dimensionEnum) {
            this.getView().setEnable(Boolean.valueOf(true), focusRow, new String[]{"member"});
            this.getModel().setValue("memberclasstype", (Object)"eb_dimensionparameter");
        } else {
            this.getView().setEnable(Boolean.valueOf(false), focusRow, new String[]{"member"});
        }
        this.getModel().setValue("dimview", null);
        this.getModel().setValue("member", null);
    }

    private boolean checkMemberTypeChange(Object oldValue, Object newValue) {
        if (!this.isQuote()) {
            return true;
        }
        return !DimMemberTypeEnum.FUNCTION.getIndex().equals(oldValue) && !DimMemberTypeEnum.FUNCTION.getIndex().equals(newValue);
    }

    private boolean isNotSelf() {
        Object suitObjectIndex = this.getValue(SUIT_OBJECT, null);
        if (suitObjectIndex == null) {
            return false;
        }
        ApplicableObjectEnum suitObject = ApplicableObjectEnum.getEnumByIndex((String)suitObjectIndex.toString());
        return ApplicableObjectEnum.Self != suitObject;
    }

    private void initMemberEntity(long datasetId) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(datasetId));
        for (Dimension dimension : dimensionList) {
            String number = dimension.getNumber();
            SysDimensionEnum sysDimension = SysDimensionEnum.getEnumByNumber((String)number);
            if (SysDimensionEnum.Account == sysDimension || SysDimensionEnum.Metric == sysDimension) continue;
            int newEntryRow = this.getModel().createNewEntryRow("memberentry");
            this.getModel().setValue("dimension", (Object)dimension.getId(), newEntryRow);
            this.getModel().setValue("dimmembertype", (Object)DimMemberTypeEnum.MEMBER.getIndex(), newEntryRow);
            if (SysDimensionEnum.ChangeType == sysDimension || SysDimensionEnum.AuditTrail == sysDimension || this.isQuote()) {
                this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"dimmembertype"});
            }
            this.getModel().setValue("memberclasstype", (Object)SysDimensionEnum.getMemberTreemodelByNumber((String)number), newEntryRow);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        this.openF7(evt, (IFormPlugin)this, (qFilters, dimNumber) -> {
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber) && this.isQuote()) {
                qFilters.add(new QFilter("datatype", "=", this.getValue("metricdatatype", null)));
            }
        });
    }

    @Override
    public String getCurrentDimNumber(String controlKey) {
        String dimNumber = null;
        switch (controlKey) {
            case "account": {
                dimNumber = SysDimensionEnum.Account.getNumber();
                break;
            }
            case "metric": {
                dimNumber = SysDimensionEnum.Metric.getNumber();
                break;
            }
            case "member": {
                EntryGrid memberEntry = (EntryGrid)this.getControl("memberentry");
                int focusRow = memberEntry.getEntryState().getFocusRow();
                Object dimensionObj = this.getModel().getValue("dimension", focusRow);
                dimNumber = ((DynamicObject)dimensionObj).getString("number");
                break;
            }
        }
        return dimNumber;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (this.addLogicNode(key) || this.addFunNode(key)) {
            return;
        }
        switch (key) {
            case "btn_ok": {
                if (!this.checkBeforeSave() || !this.saveDimensionCombination()) break;
                this.getView().returnDataToParent((Object)"successful");
                this.getView().close();
                break;
            }
            case "btn_delete": {
                this.invokeFrontMethod(FormulaFrontMethodEnum.DELETENODE, null, null);
                break;
            }
            case "btn_clear": {
                this.invokeFrontMethod(FormulaFrontMethodEnum.DELETEALLNODES, null, null);
                break;
            }
            case "before": {
                this.move(false);
                break;
            }
            case "next": {
                this.move(true);
                break;
            }
        }
    }

    private boolean addLogicNode(String controlKey) {
        LogicOperationEnum logicOperation = LogicOperationEnum.getLogicEnum((String)controlKey);
        if (logicOperation != null) {
            HashMap<String, String> logicNode = new HashMap<String, String>(16);
            logicNode.put("id", "0");
            logicNode.put("name", logicOperation.getExpress());
            this.invokeFrontMethod(FormulaFrontMethodEnum.ADDNODE, logicNode, null);
            return true;
        }
        return false;
    }

    private boolean addFunNode(String controlKey) {
        FunOperationEnum function = FunOperationEnum.getFunctionEnumByKey((String)controlKey);
        if (function != null) {
            HashMap<String, String> logicNode = new HashMap<String, String>(16);
            logicNode.put("id", function.getIndex());
            logicNode.put("name", function.getExpress());
            this.invokeFrontMethod(FormulaFrontMethodEnum.ADDFUNNODE, logicNode, null);
            return true;
        }
        return false;
    }

    private boolean checkBeforeSave() {
        String checkMessage = this.saveValidate();
        if (StringUtils.isNotEmpty((String)checkMessage)) {
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%1", (String)"DimensionCombinationEditNewPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{checkMessage}));
            return false;
        }
        return true;
    }

    public String validate(String checkType) {
        if ("quoteCheck".equals(checkType)) {
            return this.checkQuote();
        }
        if ("entityCheck".equals(checkType)) {
            return this.checkEntity();
        }
        return null;
    }

    private String checkQuote() {
        String curMetricType;
        String curDimGroupType;
        Long pkId = this.getPkId();
        if (pkId == null || pkId == 0L) {
            return null;
        }
        QuoteCheckResult checkResult = QuoteCheck.get().checkQuoteResult(new CheckQuote(this.getModelId(), Long.valueOf(0L), (Set)Sets.newHashSet((Object[])new Long[]{pkId}), MemberTypeEnum.DIMGROUP));
        if (!checkResult.isHasQuote()) {
            return null;
        }
        DynamicObject combination = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)this.getEntityId());
        String dimGroupType = combination.getString(DIM_GROUP_TYPE);
        if (!dimGroupType.equals(curDimGroupType = (String)this.getValue(DIM_GROUP_TYPE, null))) {
            return ResManager.loadResFormat((String)"%1\u4e0d\u5141\u8bb8\u4fee\u6539\u6307\u6807\u7c7b\u578b\u3002", (String)"DimensionCombinationEditNewPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{checkResult.getMsg()});
        }
        if (DimGroupTypeEnum.FORMULA.getIndex().equals(curDimGroupType)) {
            return null;
        }
        String metricType = combination.getString("metricdatatype");
        if (StringUtils.isEmpty((String)metricType)) {
            metricType = combination.getDynamicObject("account").getString("dataType");
        }
        if (StringUtils.isEmpty((String)(curMetricType = (String)this.getValue("metricdatatype", null)))) {
            curMetricType = (String)this.getValue("account", "dataType");
        }
        if (!metricType.equals(curMetricType)) {
            return ResManager.loadResFormat((String)"%1\u4e0d\u5141\u8bb8\u4fee\u6539\u5ea6\u91cf\u7c7b\u578b\u3002", (String)"DimensionCombinationEditNewPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{checkResult.getMsg()});
        }
        DynamicObjectCollection memberEntity = combination.getDynamicObjectCollection("memberentry");
        DynamicObjectCollection curMemberEntity = this.getModel().getEntryEntity("memberentry");
        Map<String, DimMemberTypeEnum> memberTypeMap = this.collectMemberTypes(memberEntity);
        Map<String, DimMemberTypeEnum> curMemberTypeMap = this.collectMemberTypes(curMemberEntity);
        for (Map.Entry<String, DimMemberTypeEnum> memberType : memberTypeMap.entrySet()) {
            String dimKey = memberType.getKey();
            DimMemberTypeEnum memberTypeValue = memberType.getValue();
            DimMemberTypeEnum typeEnum = curMemberTypeMap.get(dimKey);
            if (typeEnum == null || memberTypeValue == typeEnum) continue;
            return ResManager.loadResFormat((String)"%1\u4e0d\u5141\u8bb8\u4fee\u6539\u6210\u5458\u7c7b\u578b\u3002", (String)"DimensionCombinationEditNewPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{checkResult.getMsg()});
        }
        return null;
    }

    private Map<String, DimMemberTypeEnum> collectMemberTypes(DynamicObjectCollection memberEntity) {
        HashMap<String, DimMemberTypeEnum> memberTypes = new HashMap<String, DimMemberTypeEnum>(16);
        if (memberEntity == null) {
            return memberTypes;
        }
        for (DynamicObject dynamicObject : memberEntity) {
            String dimKey = dynamicObject.getString("dimension.number");
            String dimMemberType = dynamicObject.getString("dimmembertype");
            memberTypes.put(dimKey, DimMemberTypeEnum.getDimMemberTypeEnumByIndex((String)dimMemberType));
        }
        return memberTypes;
    }

    private String checkEntity() {
        String curDimGroupType = (String)this.getValue(DIM_GROUP_TYPE, null);
        if (DimGroupTypeEnum.FORMULA.getIndex().equals(curDimGroupType)) {
            return null;
        }
        boolean isContainFunMember = false;
        RefDimColInfo refDimColInfo = new RefDimColInfo();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("memberentry");
        ArrayList<String> emptyMemberDim = new ArrayList<String>(16);
        for (DynamicObject entry : entity) {
            String dimMemberType = entry.getString("dimmembertype");
            String dimNum = entry.getString("dimension.number");
            DimMemberTypeEnum type = DimMemberTypeEnum.getDimMemberTypeEnumByIndex((String)dimMemberType);
            if (DimMemberTypeEnum.MEMBER == type) {
                Object member = entry.get("member");
                if (member != null) continue;
                emptyMemberDim.add(entry.getString("dimension.name"));
                continue;
            }
            if (DimMemberTypeEnum.FUNCTION == type) {
                refDimColInfo.getRefFunctionDims().add(dimNum);
                isContainFunMember = true;
                continue;
            }
            if (DimMemberTypeEnum.PARAM != type) continue;
            refDimColInfo.getRefParamDims().add(dimNum);
        }
        if (emptyMemberDim.size() != 0) {
            return ResManager.loadResFormat((String)"\u7ef4\u5ea6\u8bbe\u7f6e\u4e2d\u7ef4\u5ea6 %1 \u7684\u6210\u5458\u4e3a\u7a7a\u3002", (String)"DimensionCombinationEditNewPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{emptyMemberDim.stream().collect(Collectors.joining("\u201c\uff0c\u201d", "\u201c", "\u201d"))});
        }
        Long pkId = this.getPkId();
        if (this.isQuote() && pkId != 0L) {
            RefDimStrInfo refDimStrInfo = AnalyseReportUtil.getInstance().getRefDimNumsStr(refDimColInfo, this.getModelId(), this.getBizModelId());
            DynamicObject combination = QueryServiceHelper.queryOne((String)this.getEntityId(), (String)"refparamdimnums,reffunctiondimnums", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
            String paramValue = combination.getString("refparamdimnums");
            String funValue = combination.getString("reffunctiondimnums");
            if (!paramValue.equals(refDimStrInfo.getRefParamDims()) || !funValue.equals(refDimStrInfo.getRefFunctionDims())) {
                return ResManager.loadKDString((String)"\u8be5\u6307\u6807\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7ef4\u5ea6\u53c2\u6570\u6216\u51fd\u6570\u7c7b\u578b\u3002", (String)"DimensionCombinationEditNewPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        boolean notSelf = this.isNotSelf();
        if (isContainFunMember && notSelf) {
            return ResManager.loadKDString((String)"\u9002\u7528\u5bf9\u8c61\u975e\u201c\u81ea\u8eab\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u51fd\u6570\u7c7b\u578b\u6210\u5458\u3002", (String)"DimensionCombinationEditNewPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        String dataType = (String)this.getValue("metricdatatype", null);
        if (!AnalyseReportUtil.dataTypes.contains(dataType) && notSelf) {
            return ResManager.loadKDString((String)"\u9002\u7528\u5bf9\u8c61\u975e\u201c\u81ea\u8eab\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u975e\u6570\u503c\u5ea6\u91cf\u6210\u5458\u3002", (String)"DimensionCombinationEditNewPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public QFilter getExtraFilter() {
        return new QFilter("bizmodel", "=", (Object)this.getBizModelId());
    }

    public String getEntityId() {
        return VariableTypeEnum.Combination.getMetadata();
    }

    public List<String> getAllCheckTypes() {
        List baseCheckTypes = this.getBaseCheckTypes();
        baseCheckTypes.add("quoteCheck");
        baseCheckTypes.add("entityCheck");
        return baseCheckTypes;
    }

    private boolean isQuote() {
        return this.getPageCache().get("isQuote") != null;
    }

    private boolean saveDimensionCombination() {
        String dimGroupType = (String)this.getValue(DIM_GROUP_TYPE, null);
        DimGroupTypeEnum dimGroupTypeEnum = DimGroupTypeEnum.getDimGroupEnumByIndex((String)dimGroupType);
        if (DimGroupTypeEnum.FORMULA == dimGroupTypeEnum) {
            this.invokeFrontMethod(FormulaFrontMethodEnum.GETFORMULA, null, "saveFormula");
            return false;
        }
        StringBuilder name_new = new StringBuilder();
        DynamicObject dimensionCombination = this.getBaseInfoDynamicObject(name_new);
        long modelId = dimensionCombination.getLong(MODEL);
        long combineId = dimensionCombination.getLong("id");
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
        RefDimColInfo refDimColInfo = new RefDimColInfo();
        dimensionCombination.set(SUIT_OBJECT, this.getValue(SUIT_OBJECT, null));
        DynamicObject account = (DynamicObject)this.getValue("account", null);
        dimensionCombination.set("account", (Object)account.getLong("id"));
        long datasetId = account.getLong("dataset.id");
        dimensionCombination.set("dataset", (Object)datasetId);
        quotes.add(new MemberQuoteDao(Long.valueOf(modelId), Long.valueOf(datasetId), Long.valueOf(account.getLong("dimension.id")), Long.valueOf(account.getLong("id")), MemberQuoteResourceEnum.DimGroup, Long.valueOf(combineId)));
        DynamicObject metric = (DynamicObject)this.getValue("metric", null);
        dimensionCombination.set("metric", (Object)metric.getLong("id"));
        quotes.add(new MemberQuoteDao(Long.valueOf(modelId), Long.valueOf(datasetId), Long.valueOf(metric.getLong("dimension.id")), Long.valueOf(metric.getLong("id")), MemberQuoteResourceEnum.DimGroup, Long.valueOf(combineId)));
        String dataType = metric.getString("datatype");
        dimensionCombination.set("metricdatatype", (Object)dataType);
        if (this.isCurrencyMetric(dataType)) {
            dimensionCombination.set("unit", this.getValue("unit", null));
        }
        DynamicObjectCollection memberEntity = dimensionCombination.getDynamicObjectCollection("memberentry");
        memberEntity.clear();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("memberentry");
        for (DynamicObject entry : entity) {
            DynamicObject memberEntry = memberEntity.addNew();
            DataEntityPropertyCollection properties = memberEntry.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                memberEntry.set(name, entry.get(name));
            }
        }
        AnalyseReportUtil.getInstance().selMemberEntryQ(Long.valueOf(modelId), true, memberEntity, MemberQuoteResourceEnum.DimGroup, quotes, refDimColInfo, Long.valueOf(datasetId), Long.valueOf(combineId));
        dimensionCombination.set("unit_formula", (Object)"0");
        dimensionCombination.set("formula", (Object)"");
        dimensionCombination.set("formula_show", (Object)"");
        RefDimStrInfo refDimStrInfo = AnalyseReportUtil.getInstance().getRefDimNumsStr(refDimColInfo, this.getModelId(), this.getBizModelId());
        dimensionCombination.set("refparamdimnums", (Object)refDimStrInfo.getRefParamDims());
        dimensionCombination.set("reffunctiondimnums", (Object)refDimStrInfo.getRefFunctionDims());
        DynamicObject[] dimGroups = null;
        if (name_new.length() != 0) {
            Long dimCombineId = this.getPkId();
            Set dimGroupIds = (Set)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"queryQuote", (Object[])new Object[]{modelId, 0L, Collections.singleton(dimCombineId), MemberQuoteResourceEnum.DimGroup.getType()});
            String pkId = dimCombineId.toString();
            for (DynamicObject dimGroup : dimGroups = BusinessDataServiceHelper.load((Object[])dimGroupIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityId()))) {
                String formulaString = dimGroup.getString("formula");
                List<Map<String, String>> formulaNodeList = this.parseToFrontNodes(formulaString);
                StringBuilder formulaToShow = new StringBuilder();
                formulaString = this.parseToFormulaString(formulaNodeList, formulaToShow, (Pair<String, String>)new Pair((Object)pkId, (Object)name_new.toString()));
                dimGroup.set("formula_show", (Object)formulaToShow.toString());
                dimGroup.set("formula", (Object)formulaString);
            }
        }
        if (quotes.size() == 0) {
            quotes.add(new MemberQuoteDao(Long.valueOf(modelId), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), MemberQuoteResourceEnum.DimGroup, Long.valueOf(combineId)));
        }
        try (TXHandle tx = TX.required((String)"saveNumber");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimensionCombination});
                if (dimGroups != null) {
                    SaveServiceHelper.save(dimGroups);
                }
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error("DimensionCombinationEditNewPlugin_saveNumberFailed: \n" + ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        return true;
    }

    private DynamicObject getBaseInfoDynamicObject(StringBuilder name_new) {
        DynamicObject dimensionCombination;
        Long dimCombineId = this.getPkId();
        String metadataModel = this.getEntityId();
        Long userId = this.getUserId();
        Date now = TimeServiceHelper.now();
        ILocaleString name = (ILocaleString)this.getValue("name", null);
        if (dimCombineId == 0L) {
            dimensionCombination = BusinessDataServiceHelper.newDynamicObject((String)metadataModel);
            dimensionCombination.set("id", (Object)DB.genGlobalLongId());
            dimensionCombination.set("creater", (Object)userId);
            dimensionCombination.set("createdate", (Object)now);
        } else {
            dimensionCombination = BusinessDataServiceHelper.loadSingle((Object)dimCombineId, (String)metadataModel);
            if (this.isQuote() && !name.getLocaleValue().equals(dimensionCombination.getString("name"))) {
                name_new.append(name);
            }
        }
        dimensionCombination.set("modifier", (Object)userId);
        dimensionCombination.set("modifydate", (Object)now);
        dimensionCombination.set("number", this.getValue("number", null));
        dimensionCombination.set("name", (Object)name);
        dimensionCombination.set("description", this.getValue("description", null));
        dimensionCombination.set(MODEL, this.getValue(MODEL, "id"));
        dimensionCombination.set("bizmodel", this.getValue("bizmodel", "id"));
        String dataFormat = (String)this.getValue("dataformat", null);
        dimensionCombination.set("dataformat", (Object)dataFormat);
        int digit = DataFormatTypeEnum.NUMBER.getIndex().equals(dataFormat) ? ((Integer)this.getValue(DataFormatTypeEnum.NUMBER.getReferDigitKey(), null)).intValue() : ((Integer)this.getValue(DataFormatTypeEnum.RATE.getReferDigitKey(), null)).intValue();
        dimensionCombination.set("digit", (Object)digit);
        String dimGroupType = (String)this.getValue(DIM_GROUP_TYPE, null);
        dimensionCombination.set(DIM_GROUP_TYPE, (Object)dimGroupType);
        return dimensionCombination;
    }

    private boolean isCurrencyMetric(String dataType) {
        return MetricDataTypeEnum.CURRENCY.getIndex().equals(dataType);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(nodeId));
        DynamicObject combine = QueryServiceHelper.queryOne((String)this.getEntityId(), (String)"id, name", (QFilter[])new QFilter[]{qFilter});
        if (combine != null) {
            HashMap<String, String> formulaNode = new HashMap<String, String>(16);
            formulaNode.put("id", combine.getString("id"));
            formulaNode.put("name", combine.getString("name"));
            this.invokeFrontMethod(FormulaFrontMethodEnum.ADDNODE, formulaNode, null);
        }
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue(MODEL, "id");
    }

    @Override
    public Long getBizModelId() {
        return (Long)this.getValue("bizmodel", "id");
    }

    public Long getPkId() {
        return this.getPageCachedId(PK_ID);
    }

    private Long getCopyId() {
        return this.getPageCachedId("copyId");
    }

    private Long getPageCachedId(String cacheKey) {
        Object cacheInfoObj;
        String cacheInfo = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)cacheInfo) && (cacheInfoObj = this.getView().getFormShowParameter().getCustomParam(cacheKey)) != null) {
            cacheInfo = cacheInfoObj.toString();
            this.getPageCache().put(cacheKey, cacheInfo);
        }
        return ConvertUtils.toLong((Object)cacheInfo);
    }

    private void invokeFrontMethod(FormulaFrontMethodEnum formulaFrontMethod, Object dataObj, String callbackEndMethod) {
        InvokeParam invokeParam = new InvokeParam();
        invokeParam.setUuidString(StrUtils.getUuidIdWithDataString());
        invokeParam.setFrontMethod(formulaFrontMethod.getMethodName());
        if (dataObj != null) {
            invokeParam.setDataObject(dataObj);
        }
        if (StringUtils.isNotEmpty((String)callbackEndMethod)) {
            invokeParam.setCallbackEndMethod(callbackEndMethod);
        }
        CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
        customControl.setData((Object)invokeParam);
    }

    private void setNeedPropertyChange(boolean isNeed) {
        this.needPropertyChange = isNeed ? ++this.needPropertyChange : --this.needPropertyChange;
    }

    private Boolean needPropertyChange() {
        return this.needPropertyChange == 0;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Cancel == messageBoxClosedEvent.getResult()) {
            return;
        }
        if ("changeDimGroupType".equals(messageBoxClosedEvent.getCallBackId())) {
            this.setContraryShowDimGroupType();
            this.focusFormulaPanel();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        switch (eventName) {
            case "existFormulaCheck": {
                this.existFormulaCheck(eventArgs);
                break;
            }
            case "saveFormula": {
                this.saveFormula(eventArgs);
                break;
            }
            case "rebuildFormula": {
                this.rebuildFormulaInfo();
                break;
            }
            case "setFormulaStatus": {
                this.setFormulaStatus();
                break;
            }
        }
    }

    private void setFormulaStatus() {
        if (this.isQuote()) {
            this.invokeFrontMethod(FormulaFrontMethodEnum.SETUNABLEEDIT, null, null);
        }
    }

    private void rebuildFormulaInfo() {
        Long dimCombineId = this.getPkId();
        DynamicObject query = QueryServiceHelper.queryOne((String)this.getEntityId(), (String)"formula", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimCombineId)});
        List<Map<String, String>> formulaNodeList = this.parseToFrontNodes(query.getString("formula"));
        for (Map<String, String> formulaNodeData : formulaNodeList) {
            this.invokeFrontMethod(FormulaFrontMethodEnum.ADDNODE, formulaNodeData, null);
        }
    }

    private void saveFormula(String eventArgs) {
        if (StringUtils.isNotEmpty((String)eventArgs)) {
            StringBuilder formulaToShow;
            JSONArray jsonArray = JSONArray.parseArray((String)eventArgs);
            List<Map<String, String>> formulaNodes = this.convertToList(jsonArray);
            String formulaString = this.parseToFormulaString(formulaNodes, formulaToShow = new StringBuilder(), null);
            FormulaCheckResult checkResult = this.checkFormulaNodes(formulaString);
            if (!checkResult.getSuccess().booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%1", (String)"DimensionCombinationEditNewPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{checkResult.getErrMessage()}));
                return;
            }
            this.saveFormulaToDataBase(checkResult.getRelateDimGroups(), formulaString, formulaToShow);
            this.getView().returnDataToParent((Object)"successful");
            this.getView().close();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u516c\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DimensionCombinationEditNewPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void saveFormulaToDataBase(List<Long> relateDimGroups, String formulaString, StringBuilder formulaToShow) {
        DynamicObject dimensionCombination = this.getBaseInfoDynamicObject(new StringBuilder());
        dimensionCombination.set("formula", (Object)formulaString);
        dimensionCombination.set("formula_show", (Object)formulaToShow);
        dimensionCombination.set(SUIT_OBJECT, (Object)"1");
        dimensionCombination.set("account", (Object)0L);
        dimensionCombination.set("dataset", (Object)0L);
        dimensionCombination.set("metric", (Object)0L);
        dimensionCombination.set("unit", (Object)"0");
        dimensionCombination.set("metricdatatype", (Object)MetricDataTypeEnum.CURRENCY.getIndex());
        dimensionCombination.set("unit_formula", this.getValue("unit_formula", null));
        DynamicObjectCollection memberEntity = dimensionCombination.getDynamicObjectCollection("memberentry");
        memberEntity.clear();
        dimensionCombination.set("memberentry", (Object)memberEntity);
        RefDimColInfo refDimColInfo = this.getRefDimColInfos(relateDimGroups);
        RefDimStrInfo refDimStrInfo = AnalyseReportUtil.getInstance().getRefDimNumsStr(refDimColInfo, this.getModelId(), this.getBizModelId());
        dimensionCombination.set("refparamdimnums", (Object)refDimStrInfo.getRefParamDims());
        dimensionCombination.set("reffunctiondimnums", (Object)refDimStrInfo.getRefFunctionDims());
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
        long modelId = dimensionCombination.getLong(MODEL);
        long combineId = dimensionCombination.getLong("id");
        relateDimGroups.forEach(e -> quotes.add(new MemberQuoteDao(Long.valueOf(modelId), Long.valueOf(0L), Long.valueOf(0L), e, MemberTypeEnum.DIMGROUP, MemberQuoteResourceEnum.DimGroup, Long.valueOf(combineId))));
        if (quotes.size() == 0) {
            quotes.add(new MemberQuoteDao(Long.valueOf(modelId), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), MemberQuoteResourceEnum.DimGroup, Long.valueOf(combineId)));
        }
        try (TXHandle tx = TX.required((String)"saveFormula");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimensionCombination});
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error("DimensionCombinationEditNewPlugin_saveFormulaFailed: \n" + ex);
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    private RefDimColInfo getRefDimColInfos(List<Long> relateDimGroups) {
        RefDimColInfo refDimColInfo = new RefDimColInfo();
        QFilter qFilter = new QFilter("id", "in", relateDimGroups);
        Map combinations = BusinessDataServiceHelper.loadFromCache((String)this.getEntityId(), (String)"memberentry.dimmembertype, memberentry.dimension", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject combination : combinations.values()) {
            DynamicObjectCollection memberEntry = combination.getDynamicObjectCollection("memberentry");
            for (DynamicObject memberRow : memberEntry) {
                String dimMemberType = memberRow.getString("dimmembertype");
                String dimNum = memberRow.getString("dimension.number");
                if (DimMemberTypeEnum.FUNCTION.getIndex().equals(dimMemberType)) {
                    refDimColInfo.getRefFunctionDims().add(dimNum);
                    continue;
                }
                if (!DimMemberTypeEnum.PARAM.getIndex().equals(dimMemberType)) continue;
                refDimColInfo.getRefParamDims().add(dimNum);
            }
        }
        return refDimColInfo;
    }

    private FormulaCheckResult checkFormulaNodes(String formulaString) {
        FormulaCheckResult checkResult = new FormulaCheckResult();
        try {
            checkResult = AnalyseReportUtil.getInstance().parseToFormulaNode(formulaString, this.getModelId(), this.getBizModelId(), Boolean.valueOf(true));
        }
        catch (Exception ex) {
            if (ex instanceof KDBizException) {
                checkResult.setSuccess(Boolean.valueOf(false));
                checkResult.setErrMessage(ex.getMessage());
            }
            throw new KDBizException(ex.getMessage());
        }
        return checkResult;
    }

    private String parseToFormulaString(List<Map<String, String>> formulaNodes, StringBuilder formulaToShow, Pair<String, String> baseInfo) {
        return AnalyseReportUtil.getInstance().parseToFormulaString(formulaNodes, formulaToShow, baseInfo);
    }

    private List<Map<String, String>> convertToList(JSONArray jsonArray) {
        ArrayList<Map<String, String>> formulaNodes = new ArrayList<Map<String, String>>(16);
        if (jsonArray.size() == 0) {
            return formulaNodes;
        }
        for (Object json : jsonArray) {
            if (json == null) continue;
            formulaNodes.add((Map<String, String>)SerializationUtils.fromJsonString((String)json.toString(), HashMap.class));
        }
        return formulaNodes;
    }

    private void existFormulaCheck(String eventArgs) {
        if (StringUtils.isNotEmpty((String)eventArgs)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6307\u6807\u7c7b\u578b\u5c06\u4f1a\u6e05\u7a7a\u5f53\u524d\u7c7b\u578b\u7684\u6570\u636e\uff0c\u662f\u5426\u786e\u5b9a\uff1f", (String)"DimensionCombinationEditNewPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeDimGroupType", (IFormPlugin)this));
        } else {
            this.setNeedPropertyChange(false);
            this.getModel().setValue(DIM_GROUP_TYPE, (Object)DimGroupTypeEnum.NUMBER.getIndex());
            this.setNeedPropertyChange(true);
            this.setShowDimGroupType(DimGroupTypeEnum.NUMBER.getIndex());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.handleMemberFillBack(evt);
    }

    private void focusFormulaPanel() {
        this.invokeFrontMethod(FormulaFrontMethodEnum.FOCUSFORMULA, null, null);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        TreeNode root = this.getRootNode();
        if (root == null) {
            return;
        }
        ArrayList matchedNodes = new ArrayList(16);
        root.getTreeNodeListByText(matchedNodes, text, 5);
        TreeNode toRemoveNode = null;
        for (TreeNode matchedNode : matchedNodes) {
            if (!"0".equals(matchedNode.getId())) continue;
            toRemoveNode = matchedNode;
            break;
        }
        if (toRemoveNode != null) {
            matchedNodes.remove(toRemoveNode);
        }
        if (matchedNodes.size() != 0) {
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            treeView.focusNode((TreeNode)matchedNodes.get(0));
            this.putCache("matchedNodes", matchedNodes);
        } else {
            this.getPageCache().remove("matchedNodes");
        }
    }

    private TreeNode getRootNode() {
        String wholeTree = this.getPageCache().get("wholeTree");
        if (StringUtils.isEmpty((String)wholeTree)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)wholeTree, TreeNode.class);
    }

    private void move(boolean isNext) {
        TreeNode matchedNode;
        int pos;
        String matchedNodesJson = this.getPageCache().get("matchedNodes");
        if (StringUtils.isEmpty((String)matchedNodesJson)) {
            return;
        }
        List matchedNodes = (List)ObjectSerialUtil.parseObject((String)matchedNodesJson, (TypeReference)new TypeReference<List<TreeNode>>(){}, (Feature[])new Feature[0]);
        if (matchedNodes.size() == 0) {
            return;
        }
        TreeNode root = this.getRootNode();
        if (root == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)nodeId)) {
            return;
        }
        TreeNode treeNode = root.getTreeNode(nodeId);
        if (treeNode == null) {
            return;
        }
        int index = this.getIndexFromNodeArray(matchedNodes, treeNode);
        if (index != -1) {
            pos = index;
        } else {
            List children = root.getChildren();
            int curPos = this.getIndexFromNodeArray(children, treeNode);
            pos = -999;
            if (isNext) {
                for (int i = 0; i < matchedNodes.size(); ++i) {
                    TreeNode matchedNode2 = (TreeNode)matchedNodes.get(i);
                    int matchIndex = this.getIndexFromNodeArray(children, matchedNode2);
                    if (matchIndex <= curPos) continue;
                    pos = i - 1;
                    break;
                }
            } else {
                for (int i = matchedNodes.size() - 1; i >= 0; --i) {
                    TreeNode matchedNode3 = (TreeNode)matchedNodes.get(i);
                    int matchIndex = this.getIndexFromNodeArray(children, matchedNode3);
                    if (matchIndex >= curPos) continue;
                    pos = i + 1;
                    break;
                }
            }
        }
        if (pos != -999) {
            if (pos == 0 && !isNext) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"RuleControlAccountsInfoPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (isNext && pos == matchedNodes.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u6761\u6570\u636e\u3002", (String)"RuleControlAccountsInfoPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            pos = isNext ? ++pos : --pos;
            matchedNode = (TreeNode)matchedNodes.get(pos);
            treeView.focusNode(matchedNode);
        } else {
            matchedNode = (TreeNode)matchedNodes.get(0);
            treeView.focusNode(matchedNode);
            if (!isNext) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"RuleControlAccountsInfoPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private int getIndexFromNodeArray(List<TreeNode> nodes, TreeNode curNode) {
        if (nodes == null || nodes.size() == 0) {
            return -1;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            TreeNode node = nodes.get(i);
            if (!node.getId().equals(curNode.getId())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        this.dealAfterF7Select(afterF7SelectEvent);
    }
}

