/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;

public class DimensionParameterEditPlugin
extends AbstractBasePlugin {
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
        this.getModel().setValue("bizmodel", this.getView().getFormShowParameter().getCustomParam("bizmodel"));
        this.setSelectDimension();
        AnalyseRptCommonService.copyAdd(this.getView(), this.getModel());
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"number", "dimension"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension == null || !"BudgetPeriod".equals(dimension.getString("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"offset"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        String name = e.getProperty().getName();
        if ("dimension".equals(name)) {
            boolean visible = newValue != null && "BudgetPeriod".equals(((DynamicObject)newValue).getString("number"));
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{"offset"});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (!(!(source instanceof Save) || this.isValidatorOk() && this.checkNameOk())) {
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
        }
    }

    private boolean checkNameOk() {
        String name = this.getModel().getValue("name").toString();
        return AnalyseRptCommonService.nameFormatCheck(name, this.getView());
    }

    private boolean isValidatorOk() {
        String offset;
        if (!this.isEdit()) {
            boolean isCheck;
            String number = this.getModel().getValue("number").toString();
            boolean bl = isCheck = AnalyseRptCommonService.numberFormatCheck(number, this.getView()) && AnalyseRptCommonService.numberOnlyCheck(number, this.getModelId(), (Long)this.getValue("bizmodel", "id"), "eb_dimensionparameter", this.getView());
            if (!isCheck) {
                return false;
            }
        }
        if (StringUtils.isNotEmpty((String)(offset = this.getModel().getValue("offset").toString()))) {
            long n;
            Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
            if (pattern.matcher(offset).matches() && (n = Long.parseLong(offset)) >= -100L && n <= 100L) {
                if (n == 0L) {
                    offset = "";
                }
                this.getModel().setValue("offset", (Object)offset);
                return true;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u504f\u79fb\u91cf\u683c\u5f0f\u9519\u8bef\uff0c\u6570\u5b57\u8303\u56f4\u4e3a\u3010-100 \u2014 100\u3011\u3002", (String)"DimensionParameterEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue("model", "id");
    }

    private boolean isEdit() {
        return OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus();
    }

    private void setSelectDimension() {
        Long modelId = this.getModelId();
        Long bizmodelId = (Long)this.getValue("bizmodel", "id");
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("bizmodel", "=", (Object)bizmodelId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"eb_dimensionparameter", (String)"id,dimension.id", (QFilter[])qf.toArrays());
        Set hasExist = map.values().stream().map(m -> m.getLong("dimension.id")).collect(Collectors.toSet());
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = orCreate.getDimensionListByBusModel(bizmodelId);
        Set select = dimensionList.stream().map(BaseCache::getId).filter(id -> !hasExist.contains(id)).collect(Collectors.toSet());
        select.add(orCreate.getDimension("BudgetPeriod").getId());
        BasedataEdit control = (BasedataEdit)this.getControl("dimension");
        control.setQFilter(new QFilter("id", "in", select));
    }
}

