/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteCheck;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimStrInfo;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;

public class JudgeConditionEditPlugin
extends AbstractBasePlugin {
    private static Map<String, String> columnKey = new LinkedHashMap<String, String>(16);
    private static final String entryKey = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        int rowIndex = e.getRowIndex();
        FieldEdit source = (FieldEdit)e.getSource();
        String key = source.getKey();
        if ("isend".equals(key) && rowIndex + 1 == this.getModel().getEntryRowCount(entryKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6700\u540e\u4e00\u884c\uff0c\u5fc5\u987b\u4ee5\u7ed3\u675f\u884c\u7ed3\u5c3e\u3002", (String)"JudgeConditionEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView("isend", rowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
        this.getModel().setValue("bizmodel", this.getView().getFormShowParameter().getCustomParam("bizmodel"));
        this.getModel().setValue("connector", (Object)"", 0);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!this.isEdit()) {
            AnalyseRptCommonService.copyAdd(this.getView(), this.getModel());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDimCombationFilter();
        this.lockCell();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(key)) {
            boolean iscancel = !this.isValidatorOk() || !this.volidateEntryEntity(args);
            args.setCancel(iscancel);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
        }
    }

    private boolean checkNameOk() {
        String name = this.getModel().getValue("name").toString();
        return AnalyseRptCommonService.nameFormatCheck(name, this.getView());
    }

    private boolean isValidatorOk() {
        String number = this.getModel().getValue("number").toString();
        boolean isCheck = AnalyseRptCommonService.numberFormatCheck(number, this.getView()) && AnalyseRptCommonService.numberOnlyCheck(number, this.getModelId(), (Long)this.getValue("bizmodel", "id"), this.getView().getFormShowParameter().getFormId(), this.getView(), (Long)this.getValue("id", null));
        return isCheck && this.checkNameOk();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int row = e.getRowDataEntities()[0].getRowIndex();
        this.getModel().setValue("connector", (Object)"", row);
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"connector"});
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int rowIndex = e.getRowIndexs()[0];
        this.getPageCache().put("deleteRow", (Boolean)this.getModel().getValue("isend", rowIndex) != false ? "1" : "0");
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        int rowIndex = e.getRowIndexs()[0];
        IDataModel iDataModel = this.getModel();
        IFormView iFormView = this.getView();
        boolean isend = "1".equals(this.getPageCache().get("deleteRow"));
        if (isend) {
            if (rowIndex > 0) {
                iDataModel.setValue("isend", (Object)Boolean.TRUE, rowIndex - 1);
            }
        } else if (rowIndex - 1 < 0 || ((Boolean)iDataModel.getValue("isend", rowIndex - 1)).booleanValue()) {
            iDataModel.setValue("connector", (Object)"", rowIndex);
            iFormView.setEnable(Boolean.FALSE, rowIndex, new String[]{"connector"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        if ("isend".equals(name)) {
            this.setEndRow(changeData.getRowIndex());
        }
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue("model", "id");
    }

    private void setDimCombationFilter() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("bizmodel", "=", this.getValue("bizmodel", "id"));
        qFilter.and(AnalyseReportUtil.getInstance().getMetricTypeQFilter());
        BasedataEdit dimCombation = (BasedataEdit)this.getControl("source");
        dimCombation.setQFilter(qFilter);
        dimCombation = (BasedataEdit)this.getControl("compare");
        dimCombation.setQFilter(qFilter);
    }

    private boolean isEdit() {
        return OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus();
    }

    private void setEndRow(int index) {
        IDataModel iDataModel = this.getModel();
        IFormView iFormView = this.getView();
        int count = this.getModel().getEntryRowCount(entryKey);
        Boolean isend = (Boolean)iDataModel.getValue("isend", index);
        if (!isend.booleanValue()) {
            iDataModel.setValue("worddisplay", (Object)"", index);
            iDataModel.setValue("warngraph", (Object)"", index);
            iDataModel.setValue("numberdisplay", (Object)"", index);
            if (index + 1 <= count) {
                iDataModel.setValue("connector", (Object)"|", index + 1);
                iFormView.setEnable(Boolean.TRUE, index + 1, new String[]{"connector"});
            }
        } else if (index + 1 < count) {
            iDataModel.setValue("connector", (Object)"", index + 1);
            iFormView.setEnable(Boolean.FALSE, index + 1, new String[]{"connector"});
        }
        iFormView.setEnable(isend, index, new String[]{"worddisplay", "numberdisplay", "warngraph", "warncolor"});
    }

    private boolean volidateEntryEntity(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryKey);
        if (entryentity.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"JudgeConditionEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        int rowIndex = 0;
        ArrayList<String> nonColumn = new ArrayList<String>(16);
        VarQuoteInfo varQuoteInfo = new VarQuoteInfo();
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryentity.get(i);
            rowIndex = i + 1;
            if (row.getBoolean("isend") && this.isEmpty(row.get("worddisplay")) && this.isEmpty(row.get("numberdisplay")) && this.isEmpty(row.get("warngraph"))) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6761\u4ef6\u5206\u5f55\u7b2c%1\u884c\u4e3a\u7ed3\u675f\u884c\uff0c\u201c\u6587\u5b57\u663e\u793a\u201d\u3001\u201c\u6570\u503c\u663e\u793a\u201d\u3001\u201c\u9884\u8b66\u56fe\u5f62\u201d\u4e0d\u5141\u8bb8\u90fd\u4e3a\u7a7a\u3002", (String)"JudgeConditionEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex}));
                return false;
            }
            for (Map.Entry<String, String> entry : columnKey.entrySet()) {
                String key = entry.getKey();
                if ("connector".equals(key) && (i == 0 || ((DynamicObject)entryentity.get(i - 1)).getBoolean("isend")) || row.get(key) != null && row.get(key).toString().length() != 0) continue;
                nonColumn.add(entry.getValue());
            }
            varQuoteInfo.addDimGroupId(Long.valueOf(row.getLong("source.id")));
            varQuoteInfo.addDimGroupId(Long.valueOf(row.getLong("compare.id")));
            if (nonColumn.size() <= 0) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6761\u4ef6\u5206\u5f55\u7b2c%1\u884c\u5b58\u5728\u7a7a\u503c\uff1a%2\u3002", (String)"JudgeConditionEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex, String.join((CharSequence)"\u3001", nonColumn)}));
            return false;
        }
        RefDimStrInfo refDimNumsByQuote = AnalyseReportUtil.getInstance().getRefDimNumsByQuote(varQuoteInfo, this.getModelId(), (Long)this.getValue("bizmodel", "id"));
        Long id = (Long)this.getValue("id", null);
        QuoteCheck quoteCheck = QuoteCheck.get();
        QuoteCheckResult checkResult = quoteCheck.checkQuoteResult(new CheckQuote(this.getModelId(), Long.valueOf(0L), (Set)Sets.newHashSet((Object[])new Long[]{id}), MemberTypeEnum.JUDGECONDITION));
        if (checkResult.isHasQuote()) {
            String oldRefParamDimNums = (String)this.getValue("refparamdimnums", null);
            String oldRefFuncDimNums = (String)this.getValue("reffunctiondimnums", null);
            StringBuilder sb = new StringBuilder();
            if (!oldRefParamDimNums.equals(refDimNumsByQuote.getRefParamDims())) {
                sb.append(ResManager.loadResFormat((String)"\u53c2\u6570\u7ef4\u5ea6\u53d1\u751f\u53d8\u5316[%1->%2]", (String)"", (String)"epm-eb-opplugin", (Object[])new Object[]{oldRefParamDimNums, refDimNumsByQuote.getRefParamDims()})).append('\n');
            }
            if (!oldRefFuncDimNums.equals(refDimNumsByQuote.getRefFunctionDims())) {
                sb.append(ResManager.loadResFormat((String)"\u51fd\u6570\u7ef4\u5ea6\u53d1\u751f\u53d8\u5316[%1->%2]", (String)"", (String)"epm-eb-opplugin", (Object[])new Object[]{oldRefFuncDimNums, refDimNumsByQuote.getRefFunctionDims()})).append('\n');
            }
            if (sb.length() > 0) {
                this.getView().showTipNotification(sb.toString());
                return false;
            }
        }
        this.getModel().setValue("refparamdimnums", (Object)refDimNumsByQuote.getRefParamDims());
        this.getModel().setValue("reffunctiondimnums", (Object)refDimNumsByQuote.getRefFunctionDims());
        varQuoteInfo.getRefDimGroupIds().removeIf(dimGroupId -> dimGroupId == null || dimGroupId.equals(0L));
        ((FormOperate)args.getSource()).getOption().setVariableValue("conditionRefDimGroupIds", SerializationUtils.toJsonString((Object)varQuoteInfo.getRefDimGroupIds()));
        return true;
    }

    private void lockCell() {
        IFormView view = this.getView();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryKey);
        ArrayList<String> cells = new ArrayList<String>(4);
        for (int i = 0; i < entryentity.size(); ++i) {
            if (i == 0 || ((DynamicObject)entryentity.get(i - 1)).getBoolean("isend")) {
                cells.add("connector");
            }
            if (!((DynamicObject)entryentity.get(i)).getBoolean("isend")) {
                cells.add("worddisplay");
                cells.add("numberdisplay");
                cells.add("warngraph");
            }
            view.setEnable(Boolean.FALSE, i, cells.toArray(new String[0]));
            cells.clear();
        }
    }

    static {
        columnKey.put("connector", ResManager.loadKDString((String)"\u8fde\u63a5\u7b26", (String)"JudgeConditionEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        columnKey.put("source", ResManager.loadKDString((String)"\u6e90\u6307\u6807", (String)"JudgeConditionEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

