/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;

public class RptShareSchemeEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"user"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (!this.isEdit() && source instanceof Save && !this.isValidatorOk()) {
            args.setCancel(true);
        }
    }

    private boolean isValidatorOk() {
        String number = this.getModel().getValue("number").toString();
        boolean isCheck = AnalyseRptCommonService.numberFormatCheck(number, this.getView()) && AnalyseRptCommonService.numberOnlyCheck(number, this.getModelId(), this.getView().getFormShowParameter().getFormId(), this.getView());
        return isCheck && this.checkNameOk();
    }

    private boolean checkNameOk() {
        String name = this.getModel().getValue("name").toString();
        return AnalyseRptCommonService.nameFormatCheck(name, this.getView());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue("model", "id");
    }

    private boolean isEdit() {
        return OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus();
    }
}

