/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class RptShareSchemeListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
SetFilterListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList control = (BillList)this.getControl("billlistap");
        control.addHyperClickListener((HyperLinkClickListener)this);
        control.addSetFilterListener((SetFilterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
        this.refresh(this.getModelId());
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_add": {
                this.addNew(itemKey);
                break;
            }
            case "btn_delete": {
                this.beforeDelete(itemKey);
                break;
            }
            case "btn_select": {
                this.selectSchemeForTemplate();
                break;
            }
            case "btn_refresh": {
                this.refresh(this.getModelId());
                break;
            }
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Object focusRowPkId = ((BillList)evt.getSource()).getFocusRowPkId();
        if (focusRowPkId == null) {
            return;
        }
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_rptsharescheme");
        openParameter.put("pkId", focusRowPkId.toString());
        openParameter.put("Status", String.valueOf(OperationStatus.EDIT.getValue()));
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    private void addNew(String key) {
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_rptsharescheme");
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void beforeDelete(String key) {
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        if (selectRowPkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"RptShareSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8981\u5220\u9664\u6240\u9009\u6570\u636e\uff1f", (String)"RptShareSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
    }

    private void deleteRows() {
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        QFBuilder qf = new QFBuilder("id", "in", selectRowPkIds);
        DeleteServiceHelper.delete((String)"eb_rptsharescheme", (QFilter[])qf.toArray());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RptShareSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refresh(this.getModelId());
    }

    private void selectSchemeForTemplate() {
        List<Long> selectRowPkIds = this.getSelectRowPkIds();
        if (selectRowPkIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"RptShareSchemeListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)selectRowPkIds.get(0), (String)"eb_rptsharescheme");
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"RptShareSchemeListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)object);
        this.getView().close();
    }

    private void refresh(Long modelid) {
        BillList control = (BillList)this.getControl("billlistap");
        control.getFilterParameter().getQFilters().add(new QFilter("model", "=", (Object)modelid));
        control.clearSelection();
        control.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (e.getSource() instanceof BillList) {
            e.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue("model", "id");
    }

    private List<Long> getSelectRowPkIds() {
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        return selectedRows.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.refresh(this.getModelId());
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult result = evt.getResult();
        if (result == MessageBoxResult.No) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if ("btn_delete".equals(callBackId)) {
            this.deleteRows();
        }
    }
}

