/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptGenUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.var.MemberVarValObj;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.var.ReportVarUtil;

public interface VarValSettingHandler {
    public IFormView getView();

    public Map<Long, Set<Long>> getDimVarInfo();

    default public boolean initVarEntry(Long modelId) {
        Map<Long, Set<Long>> dimVarInfo = this.getDimVarInfo();
        IFormView formView = this.getView();
        if (formView == null) {
            return false;
        }
        IDataModel dataModel = this.getView().getModel();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        DynamicObjectCollection entryRows = dataModel.getEntryEntity("varentryentity");
        Count rowChanged = new Count();
        Set<Long> periodVarIds = dimVarInfo.get(modelCacheHelper.getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getId());
        if (periodVarIds != null && periodVarIds.size() > 0) {
            QFBuilder qb = new QFBuilder();
            qb.add("id", "in", periodVarIds);
            qb.add("grouptype", "=", (Object)"2");
            if (QueryServiceHelper.exists((String)"eb_periodvariable", (QFilter[])qb.toArray())) {
                periodVarIds.add(AnalyseReportUtil.getInstance().getBaseYearVarId(modelId));
            }
        }
        int baseYearIndex = -1;
        int index = 0;
        while (index < entryRows.size()) {
            Long membreId;
            Member member;
            DynamicObject row = (DynamicObject)entryRows.get(index);
            Long varId = row.getLong("varitem.id");
            Long dimId = row.getLong("vardim.id");
            String dimNum = row.getString("vardim.number");
            Set<Long> varIds = dimVarInfo.get(dimId);
            Long viewId = row.getLong("varvalviewid");
            if (varIds == null || !varIds.remove(varId)) {
                entryRows.remove(index);
                rowChanged.addOne();
                continue;
            }
            if (varIds.isEmpty()) {
                dimVarInfo.remove(dimId);
            }
            if ((member = modelCacheHelper.getMember(dimNum, viewId, membreId = Long.valueOf(row.getLong("varvalid")))) != null) {
                row.set("varvaltext", (Object)member.getName());
                if (row.getString("varitem.number").equals("@BaseY")) {
                    baseYearIndex = index;
                }
            }
            ++index;
        }
        boolean changed = AnalyseReportUtil.getInstance().buildVarEntryRows(entryRows, dimVarInfo, this.getVarValUserRecord(), modelCacheHelper);
        if (baseYearIndex != -1) {
            this.updateYearValInfo(baseYearIndex, false);
        }
        formView.updateView("varentryentity");
        this.checkAndLockYearVar(entryRows);
        return changed || rowChanged.getCount() > 0;
    }

    default public void checkAndLockYearVar(DynamicObjectCollection entryRows) {
        int index = 0;
        ArrayList<Integer> lockIndex = new ArrayList<Integer>(16);
        for (DynamicObject entryRow : entryRows) {
            String varNum = entryRow.getString("varitem.number");
            if (AnalyseRptGenUtil.getInstance().isOffsetYearVar(varNum)) {
                lockIndex.add(index);
            }
            ++index;
        }
        if (lockIndex.size() > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("varentryentity");
            entryGrid.setRowLock(true, CommonServiceHelper.changeIntArrays(lockIndex));
        }
    }

    default public Map<Long, MemberView> getVarValUserRecord() {
        return new HashMap<Long, MemberView>(16);
    }

    default public void openVarValSelForm(IFormPlugin formPlugin) {
        int rowIndex = this.getCurrentRowIndex();
        DynamicObject rowObj = this.getDataModel().getEntryRowEntity("varentryentity", rowIndex);
        Long dimId = rowObj.getLong("vardim.id");
        String groupType = rowObj.getString("varitem.grouptype");
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)dimId), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(this.getBizModelId());
        if ("2".equals(groupType)) {
            f7Param.addCustomCommFilter(new QFilter("level", "=", (Object)2));
        }
        Long varValId = (Long)this.getDataModel().getValue("varvalid", rowIndex);
        Long viewId = (Long)this.getDataModel().getValue("varvalviewid", rowIndex);
        f7Param.setSelectId(varValId);
        f7Param.setEnableView(true);
        f7Param.setViewId(viewId);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack(formPlugin, "VarValSel"));
    }

    default public void fillBackVarVal(ListSelectedRowCollection selectedRows) {
        if (selectedRows.isEmpty()) {
            return;
        }
        ListSelectedRow row = selectedRows.get(0);
        int currentRowIndex = this.getCurrentRowIndex();
        this.getDataModel().setValue("varvaltext", (Object)row.getName(), currentRowIndex);
        this.getDataModel().setValue("varvalid", row.getPrimaryKeyValue(), currentRowIndex);
        this.getDataModel().setValue("varvalviewid", row.getDataMap().get("viewid"), currentRowIndex);
        if (this.isBaseYearRow(currentRowIndex)) {
            this.updateYearValInfo(currentRowIndex, true);
        }
    }

    default public Map<String, List<MemberVarValObj>> selValInfo() {
        DynamicObjectCollection rows = this.getDataModel().getEntryEntity("varentryentity");
        return AnalyseReportUtil.getInstance().selValInfo(rows, this.getModelId(), this.getBizModelId());
    }

    default public String getCurrentRowDimNum() {
        return this.getDataModel().getEntryRowEntity("vardim", this.getCurrentRowIndex()).getString("number");
    }

    default public int getCurrentRowIndex() {
        return this.getDataModel().getEntryCurrentRowIndex("varentryentity");
    }

    default public IDataModel getDataModel() {
        IFormView formView = this.getView();
        if (formView == null) {
            throw new KDBizException("view is null");
        }
        return formView.getModel();
    }

    default public Long getBizModelId() {
        return 0L;
    }

    default public Long getModelId() {
        return 0L;
    }

    default public void dealPropChange(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("varvaltext".equals(propName) && StringUtils.isEmpty((String)((String)e.getChangeSet()[0].getNewValue()))) {
            int currentRowIndex = e.getChangeSet()[0].getRowIndex();
            this.getDataModel().setValue("varvalid", null, currentRowIndex);
            this.getDataModel().setValue("varvalviewid", null, currentRowIndex);
            if (this.isBaseYearRow(currentRowIndex)) {
                this.updateYearValInfo(currentRowIndex, true);
            }
        }
    }

    default public boolean isBaseYearRow(int rowIndex) {
        String varNum;
        DynamicObject varObj = (DynamicObject)this.getDataModel().getValue("varitem", rowIndex);
        String string = varNum = varObj == null ? null : varObj.getString("number");
        return varNum != null && varNum.equals("@BaseY");
    }

    default public void updateYearValInfo(int baseYearRowIndex, boolean updateView) {
        DynamicObjectCollection entryRows = this.getDataModel().getEntryEntity("varentryentity");
        DynamicObject baseYearRow = (DynamicObject)entryRows.get(baseYearRowIndex);
        Long varValId = baseYearRow.getLong("varvalid");
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, varValId);
        HashMap<String, String> varMap = new HashMap<String, String>(1);
        if (member != null) {
            varMap.put("@BaseY!@BaseY", member.getNumber());
        }
        IDataModel dataModel = this.getDataModel();
        int rowIndex = 0;
        for (DynamicObject row : entryRows) {
            String varNum = row.getString("varitem.number");
            if (AnalyseRptGenUtil.getInstance().isOffsetYearVar(varNum)) {
                if (varMap.isEmpty()) {
                    if (updateView) {
                        dataModel.setValue("varvaltext", null, rowIndex);
                    } else {
                        row.set("varvalid", null);
                        row.set("varvaltext", null);
                    }
                } else {
                    String memberName;
                    String realMembNum = ReportVarUtil.getVarValueNoError((Long)modelId, (String)varNum, varMap, (String)SysDimensionEnum.BudgetPeriod.getNumber());
                    member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, realMembNum);
                    Long memberId = member == null ? null : member.getId();
                    String string = memberName = member == null ? null : member.getName();
                    if (updateView) {
                        dataModel.setValue("varvaltext", (Object)memberName, rowIndex);
                        dataModel.setValue("varvalid", (Object)memberId, rowIndex);
                    } else {
                        row.set("varvalid", (Object)memberId);
                        row.set("varvaltext", (Object)memberName);
                    }
                }
            }
            ++rowIndex;
        }
    }

    default public boolean loadUserRecord() {
        return true;
    }
}

